--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

ALTER TABLE ONLY public.quotas_tracking DROP CONSTRAINT quotas_tracking_quotaslimitsid_fkey;
ALTER TABLE ONLY public.quotas DROP CONSTRAINT quotas_policyid_fkey;
ALTER TABLE ONLY public.quotas_limits DROP CONSTRAINT quotas_limits_quotasid_fkey;
ALTER TABLE ONLY public.quotas_hits DROP CONSTRAINT quotas_hits_quotasid_fkey;
ALTER TABLE ONLY public.policy_members DROP CONSTRAINT policy_members_policyid_fkey;
ALTER TABLE ONLY public.policy_group_members DROP CONSTRAINT policy_group_members_policygroupid_fkey;
DROP INDEX public.quotas_tracking_idx1;
ALTER TABLE ONLY public.quotas_tracking DROP CONSTRAINT quotas_tracking_quotaslimitsid_trackkey_key;
ALTER TABLE ONLY public.quotas DROP CONSTRAINT quotas_pkey;
ALTER TABLE ONLY public.quotas_limits DROP CONSTRAINT quotas_limits_pkey;
ALTER TABLE ONLY public.quotas_hits DROP CONSTRAINT quotas_hits_pkey;
ALTER TABLE ONLY public.policy_members DROP CONSTRAINT policy_members_pkey;
ALTER TABLE ONLY public.policy_groups DROP CONSTRAINT policy_groups_pkey;
ALTER TABLE ONLY public.policy_groups DROP CONSTRAINT policy_groups_name_key;
ALTER TABLE ONLY public.policy_group_members DROP CONSTRAINT policy_group_members_pkey;
ALTER TABLE ONLY public.policies DROP CONSTRAINT policies_pkey;
ALTER TABLE public.quotas_limits ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.quotas_hits ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.quotas ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.policy_members ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.policy_groups ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.policy_group_members ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.policies ALTER COLUMN id DROP DEFAULT;
DROP TABLE public.quotas_tracking;
DROP SEQUENCE public.quotas_limits_id_seq;
DROP TABLE public.quotas_limits;
DROP SEQUENCE public.quotas_id_seq;
DROP SEQUENCE public.quotas_hits_id_seq;
DROP TABLE public.quotas_hits;
DROP TABLE public.quotas;
DROP SEQUENCE public.policy_members_id_seq;
DROP TABLE public.policy_members;
DROP SEQUENCE public.policy_groups_id_seq;
DROP TABLE public.policy_groups;
DROP SEQUENCE public.policy_group_members_id_seq;
DROP TABLE public.policy_group_members;
DROP SEQUENCE public.policies_id_seq;
DROP TABLE public.policies;
SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: policies; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE policies (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    priority smallint NOT NULL,
    description text,
    disabled smallint DEFAULT 0::smallint NOT NULL
);


ALTER TABLE public.policies OWNER TO pgsql;

--
-- Name: policies_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE policies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.policies_id_seq OWNER TO pgsql;

--
-- Name: policies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE policies_id_seq OWNED BY policies.id;


--
-- Name: policies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('policies_id_seq', 2, true);


--
-- Name: policy_group_members; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE policy_group_members (
    id integer NOT NULL,
    policygroupid bigint,
    member character varying(255) NOT NULL,
    disabled smallint DEFAULT 0::smallint NOT NULL,
    comment character varying(1024)
);


ALTER TABLE public.policy_group_members OWNER TO pgsql;

--
-- Name: policy_group_members_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE policy_group_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.policy_group_members_id_seq OWNER TO pgsql;

--
-- Name: policy_group_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE policy_group_members_id_seq OWNED BY policy_group_members.id;


--
-- Name: policy_group_members_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('policy_group_members_id_seq', 9, true);


--
-- Name: policy_groups; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE policy_groups (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    disabled smallint DEFAULT 0::smallint NOT NULL,
    comment character varying(1024)
);


ALTER TABLE public.policy_groups OWNER TO pgsql;

--
-- Name: policy_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE policy_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.policy_groups_id_seq OWNER TO pgsql;

--
-- Name: policy_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE policy_groups_id_seq OWNED BY policy_groups.id;


--
-- Name: policy_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('policy_groups_id_seq', 1, true);


--
-- Name: policy_members; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE policy_members (
    id integer NOT NULL,
    policyid bigint,
    source text,
    destination text,
    comment character varying(1024),
    disabled smallint DEFAULT 0::smallint NOT NULL
);


ALTER TABLE public.policy_members OWNER TO pgsql;

--
-- Name: policy_members_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE policy_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.policy_members_id_seq OWNER TO pgsql;

--
-- Name: policy_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE policy_members_id_seq OWNED BY policy_members.id;


--
-- Name: policy_members_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('policy_members_id_seq', 2, true);


--
-- Name: quotas; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE quotas (
    id integer NOT NULL,
    policyid bigint,
    name character varying(255) NOT NULL,
    track character varying(255) NOT NULL,
    period bigint,
    verdict character varying(255),
    data text,
    lastquota smallint DEFAULT 0::smallint NOT NULL,
    comment character varying(1024),
    notify text DEFAULT ''::text NOT NULL,
    disabled smallint DEFAULT 0::smallint NOT NULL
);


ALTER TABLE public.quotas OWNER TO pgsql;

--
-- Name: quotas_hits; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE quotas_hits (
    id integer NOT NULL,
    quotasid bigint,
    hits bigint
);


ALTER TABLE public.quotas_hits OWNER TO pgsql;

--
-- Name: quotas_hits_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE quotas_hits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotas_hits_id_seq OWNER TO pgsql;

--
-- Name: quotas_hits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE quotas_hits_id_seq OWNED BY quotas_hits.id;


--
-- Name: quotas_hits_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('quotas_hits_id_seq', 1, false);


--
-- Name: quotas_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE quotas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotas_id_seq OWNER TO pgsql;

--
-- Name: quotas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE quotas_id_seq OWNED BY quotas.id;


--
-- Name: quotas_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('quotas_id_seq', 2, true);


--
-- Name: quotas_limits; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE quotas_limits (
    id integer NOT NULL,
    quotasid bigint,
    type character varying(255),
    counterlimit bigint,
    comment character varying(1024),
    disabled smallint DEFAULT 0::smallint NOT NULL
);


ALTER TABLE public.quotas_limits OWNER TO pgsql;

--
-- Name: quotas_limits_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE quotas_limits_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotas_limits_id_seq OWNER TO pgsql;

--
-- Name: quotas_limits_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE quotas_limits_id_seq OWNED BY quotas_limits.id;


--
-- Name: quotas_limits_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('quotas_limits_id_seq', 2, true);


--
-- Name: quotas_tracking; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE quotas_tracking (
    quotaslimitsid bigint,
    trackkey character varying(512),
    lastupdate bigint,
    counter numeric(10,4)
);


ALTER TABLE public.quotas_tracking OWNER TO pgsql;

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policies ALTER COLUMN id SET DEFAULT nextval('policies_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policy_group_members ALTER COLUMN id SET DEFAULT nextval('policy_group_members_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policy_groups ALTER COLUMN id SET DEFAULT nextval('policy_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policy_members ALTER COLUMN id SET DEFAULT nextval('policy_members_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas ALTER COLUMN id SET DEFAULT nextval('quotas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas_hits ALTER COLUMN id SET DEFAULT nextval('quotas_hits_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas_limits ALTER COLUMN id SET DEFAULT nextval('quotas_limits_id_seq'::regclass);


--
-- Data for Name: policies; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY policies (id, name, priority, description, disabled) FROM stdin;
1	SpamTitan Outbound	1	SpamTitan Outbound Policy	0
2	SpamTitan Inbound	2	SpamTitan Inbound Policy	0
\.


--
-- Data for Name: policy_group_members; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY policy_group_members (id, policygroupid, member, disabled, comment) FROM stdin;
1	1	127.0.0.0/8	0	\N
2	1	10.0.0.0/8	0	\N
3	1	192.168.0.0/16	0	\N
4	1	172.16.0.0/12	0	\N
5	1	192.0.0.3/32	0	\N
6	1	192.168.25.196/32	0	\N
7	1	192.168.22.51/32	0	\N
8	1	192.168.28.51/32	0	\N
9	1	192.0.0.151/32	0	\N
\.


--
-- Data for Name: policy_groups; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY policy_groups (id, name, disabled, comment) FROM stdin;
1	internal_ips	0	\N
\.


--
-- Data for Name: policy_members; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY policy_members (id, policyid, source, destination, comment, disabled) FROM stdin;
1	1	%internal_ips	any	\N	0
2	2	!%internal_ips	any	\N	0
\.


--
-- Data for Name: quotas; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY quotas (id, policyid, name, track, period, verdict, data, lastquota, comment, notify, disabled) FROM stdin;
1	1	Outbound: Sender quotas	Sender:user@domain	1800	REJECT	Policyd: Policy rejection; Message count quota exceeded	1	Sample policy to rate limit all internal senders by email address		1
2	2	Inbound: Recipient quotas	Recipient:@domain	1800	DEFER	Policyd: Policy rejection; Message count quota exceeded	1	Sample policy to track/rate limit messages to each internal domain		1
\.


--
-- Data for Name: quotas_hits; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY quotas_hits (id, quotasid, hits) FROM stdin;
\.


--
-- Data for Name: quotas_limits; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY quotas_limits (id, quotasid, type, counterlimit, comment, disabled) FROM stdin;
1	1	MessageCount	50	\N	0
2	2	MessageCount	50	\N	0
\.


--
-- Data for Name: quotas_tracking; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY quotas_tracking (quotaslimitsid, trackkey, lastupdate, counter) FROM stdin;
\.


--
-- Name: policies_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policies
    ADD CONSTRAINT policies_pkey PRIMARY KEY (id);


--
-- Name: policy_group_members_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policy_group_members
    ADD CONSTRAINT policy_group_members_pkey PRIMARY KEY (id);


--
-- Name: policy_groups_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policy_groups
    ADD CONSTRAINT policy_groups_name_key UNIQUE (name);


--
-- Name: policy_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policy_groups
    ADD CONSTRAINT policy_groups_pkey PRIMARY KEY (id);


--
-- Name: policy_members_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policy_members
    ADD CONSTRAINT policy_members_pkey PRIMARY KEY (id);


--
-- Name: quotas_hits_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY quotas_hits
    ADD CONSTRAINT quotas_hits_pkey PRIMARY KEY (id);


--
-- Name: quotas_limits_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY quotas_limits
    ADD CONSTRAINT quotas_limits_pkey PRIMARY KEY (id);


--
-- Name: quotas_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY quotas
    ADD CONSTRAINT quotas_pkey PRIMARY KEY (id);


--
-- Name: quotas_tracking_quotaslimitsid_trackkey_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY quotas_tracking
    ADD CONSTRAINT quotas_tracking_quotaslimitsid_trackkey_key UNIQUE (quotaslimitsid, trackkey);


--
-- Name: quotas_tracking_idx1; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX quotas_tracking_idx1 ON quotas_tracking USING btree (lastupdate);


--
-- Name: policy_group_members_policygroupid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policy_group_members
    ADD CONSTRAINT policy_group_members_policygroupid_fkey FOREIGN KEY (policygroupid) REFERENCES policy_groups(id);


--
-- Name: policy_members_policyid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policy_members
    ADD CONSTRAINT policy_members_policyid_fkey FOREIGN KEY (policyid) REFERENCES policies(id);


--
-- Name: quotas_hits_quotasid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas_hits
    ADD CONSTRAINT quotas_hits_quotasid_fkey FOREIGN KEY (quotasid) REFERENCES quotas(id);


--
-- Name: quotas_limits_quotasid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas_limits
    ADD CONSTRAINT quotas_limits_quotasid_fkey FOREIGN KEY (quotasid) REFERENCES quotas(id);


--
-- Name: quotas_policyid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas
    ADD CONSTRAINT quotas_policyid_fkey FOREIGN KEY (policyid) REFERENCES policies(id);


--
-- Name: quotas_tracking_quotaslimitsid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY quotas_tracking
    ADD CONSTRAINT quotas_tracking_quotaslimitsid_fkey FOREIGN KEY (quotaslimitsid) REFERENCES quotas_limits(id);


--
-- Name: policies; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE policies FROM PUBLIC;
REVOKE ALL ON TABLE policies FROM pgsql;
GRANT ALL ON TABLE policies TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE policies TO cbpolicyd;


--
-- Name: policies_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE policies_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE policies_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE policies_id_seq TO pgsql;
GRANT ALL ON SEQUENCE policies_id_seq TO cbpolicyd;


--
-- Name: policy_group_members; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE policy_group_members FROM PUBLIC;
REVOKE ALL ON TABLE policy_group_members FROM pgsql;
GRANT ALL ON TABLE policy_group_members TO pgsql;
GRANT SELECT,INSERT,DELETE,TRUNCATE,UPDATE ON TABLE policy_group_members TO cbpolicyd;


--
-- Name: policy_group_members_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE policy_group_members_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE policy_group_members_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE policy_group_members_id_seq TO pgsql;
GRANT ALL ON SEQUENCE policy_group_members_id_seq TO cbpolicyd;


--
-- Name: policy_groups; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE policy_groups FROM PUBLIC;
REVOKE ALL ON TABLE policy_groups FROM pgsql;
GRANT ALL ON TABLE policy_groups TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE policy_groups TO cbpolicyd;


--
-- Name: policy_groups_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE policy_groups_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE policy_groups_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE policy_groups_id_seq TO pgsql;
GRANT ALL ON SEQUENCE policy_groups_id_seq TO cbpolicyd;


--
-- Name: policy_members; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE policy_members FROM PUBLIC;
REVOKE ALL ON TABLE policy_members FROM pgsql;
GRANT ALL ON TABLE policy_members TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE policy_members TO cbpolicyd;


--
-- Name: policy_members_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE policy_members_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE policy_members_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE policy_members_id_seq TO pgsql;
GRANT ALL ON SEQUENCE policy_members_id_seq TO cbpolicyd;


--
-- Name: quotas; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE quotas FROM PUBLIC;
REVOKE ALL ON TABLE quotas FROM pgsql;
GRANT ALL ON TABLE quotas TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE quotas TO cbpolicyd;


--
-- Name: quotas_hits; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE quotas_hits FROM PUBLIC;
REVOKE ALL ON TABLE quotas_hits FROM pgsql;
GRANT ALL ON TABLE quotas_hits TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE quotas_hits TO cbpolicyd;


--
-- Name: quotas_hits_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE quotas_hits_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE quotas_hits_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE quotas_hits_id_seq TO pgsql;
GRANT ALL ON SEQUENCE quotas_hits_id_seq TO cbpolicyd;


--
-- Name: quotas_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE quotas_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE quotas_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE quotas_id_seq TO pgsql;
GRANT ALL ON SEQUENCE quotas_id_seq TO cbpolicyd;


--
-- Name: quotas_limits; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE quotas_limits FROM PUBLIC;
REVOKE ALL ON TABLE quotas_limits FROM pgsql;
GRANT ALL ON TABLE quotas_limits TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE quotas_limits TO cbpolicyd;


--
-- Name: quotas_limits_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE quotas_limits_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE quotas_limits_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE quotas_limits_id_seq TO pgsql;
GRANT ALL ON SEQUENCE quotas_limits_id_seq TO cbpolicyd;


--
-- Name: quotas_tracking; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE quotas_tracking FROM PUBLIC;
REVOKE ALL ON TABLE quotas_tracking FROM pgsql;
GRANT ALL ON TABLE quotas_tracking TO pgsql;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE quotas_tracking TO cbpolicyd;


--
-- PostgreSQL database dump complete
--

TRUNCATE quotas_tracking;
TRUNCATE session_tracking;
