--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'SQL_ASCII';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

ALTER TABLE ONLY public.users DROP CONSTRAINT users_policy_id_fkey;
ALTER TABLE ONLY public.user_roles DROP CONSTRAINT user_roles_user_id_fkey;
ALTER TABLE ONLY public.user_roles DROP CONSTRAINT user_roles_role_id_fkey;
ALTER TABLE ONLY public.transport DROP CONSTRAINT transport_realm_id_fkey;
ALTER TABLE ONLY public.sender_transport DROP CONSTRAINT sender_transport_poolid_fkey;
ALTER TABLE ONLY public.roles DROP CONSTRAINT roles_owner_id_fkey;
ALTER TABLE ONLY public.role_perms DROP CONSTRAINT role_perms_role_id_fkey;
ALTER TABLE ONLY public.role_perms DROP CONSTRAINT role_perms_perm_id_fkey;
ALTER TABLE ONLY public.realm_admins DROP CONSTRAINT realm_admins_user_id_fkey;
ALTER TABLE ONLY public.realm_admins DROP CONSTRAINT realm_admins_role_id_fkey;
ALTER TABLE ONLY public.realm_admins DROP CONSTRAINT realm_admins_realm_id_fkey;
ALTER TABLE ONLY public.ippool_members DROP CONSTRAINT ippool_members_poolname_fkey;
ALTER TABLE ONLY public.domain_admins DROP CONSTRAINT domain_admins_role_id_fkey;
ALTER TABLE ONLY public.domain_admins DROP CONSTRAINT domain_admins_domain_id_fkey;
ALTER TABLE ONLY public.domain_admins DROP CONSTRAINT domain_admins_admin_id_fkey;
DROP INDEX public.virus_name;
DROP INDEX public.users_idx_email;
DROP INDEX public.users_domain_idx;
DROP INDEX public.transport_idx_domain;
DROP INDEX public.sender_transport_domain_idx;
DROP INDEX public.roles_type_idx;
DROP INDEX public.reverse_domain_idx;
DROP INDEX public.recipients_idx_domain;
DROP INDEX public.rbl_name;
DROP INDEX public.policy_name;
DROP INDEX public.logdate_idx;
DROP INDEX public.id;
DROP INDEX public.email;
ALTER TABLE ONLY public.wblist DROP CONSTRAINT wblist_pkey;
ALTER TABLE ONLY public.viruses DROP CONSTRAINT viruses_pkey;
ALTER TABLE ONLY public.virus_scanners DROP CONSTRAINT virus_scanners_pkey;
ALTER TABLE ONLY public.users DROP CONSTRAINT users_pkey;
ALTER TABLE ONLY public.user_roles DROP CONSTRAINT user_roles_pkey;
ALTER TABLE ONLY public.transport DROP CONSTRAINT transport_pkey;
ALTER TABLE ONLY public.tls DROP CONSTRAINT tls_domain_key;
ALTER TABLE ONLY public.stats DROP CONSTRAINT stats_pkey;
ALTER TABLE ONLY public.staticroutes DROP CONSTRAINT staticroutes_ipnetwork_gateway_key;
ALTER TABLE ONLY public.spamstats DROP CONSTRAINT spamstats_pkey;
ALTER TABLE ONLY public.spamstats DROP CONSTRAINT spamstats_node_id_logdate_key;
ALTER TABLE ONLY public.smarthosts DROP CONSTRAINT smarthosts_sender_key;
ALTER TABLE ONLY public.sender_transport DROP CONSTRAINT sender_transport_pkey;
ALTER TABLE ONLY public.scrubber_config DROP CONSTRAINT scrubber_config_pkey;
ALTER TABLE ONLY public.rulesets DROP CONSTRAINT rulesets_pkey;
ALTER TABLE ONLY public.rulesets DROP CONSTRAINT rulesets_name_key;
ALTER TABLE ONLY public.roles DROP CONSTRAINT roles_pkey;
ALTER TABLE ONLY public.roles DROP CONSTRAINT roles_name_key;
ALTER TABLE ONLY public.role_perms DROP CONSTRAINT role_perms_pkey;
ALTER TABLE ONLY public.reports DROP CONSTRAINT reports_pkey;
ALTER TABLE ONLY public.recipients DROP CONSTRAINT recipients_email_key;
ALTER TABLE ONLY public.realms DROP CONSTRAINT realms_pkey;
ALTER TABLE ONLY public.realms DROP CONSTRAINT realms_name_key;
ALTER TABLE ONLY public.realm_admins DROP CONSTRAINT realm_admins_pkey;
ALTER TABLE ONLY public.rbls DROP CONSTRAINT rbls_pkey;
ALTER TABLE ONLY public.policy DROP CONSTRAINT policy_policy_name_key;
ALTER TABLE ONLY public.policy DROP CONSTRAINT policy_pkey;
ALTER TABLE ONLY public.permissions DROP CONSTRAINT permissions_pkey;
ALTER TABLE ONLY public.permissions DROP CONSTRAINT permissions_menu_url_key;
ALTER TABLE ONLY public.netip DROP CONSTRAINT netip_cidr_section_key;
ALTER TABLE ONLY public.mynetworks DROP CONSTRAINT mynetworks_cidr_key;
ALTER TABLE ONLY public.mailaddr DROP CONSTRAINT mailaddr_pkey;
ALTER TABLE ONLY public.mailaddr DROP CONSTRAINT mailaddr_email_key;
ALTER TABLE ONLY public.ippools DROP CONSTRAINT ippools_pkey;
ALTER TABLE ONLY public.ippools DROP CONSTRAINT ippools_name_key;
ALTER TABLE ONLY public.ippool_members DROP CONSTRAINT ippool_members_pkey;
ALTER TABLE ONLY public.ipaliases DROP CONSTRAINT ipaliases_ipnetwork_key;
ALTER TABLE ONLY public.helo_access DROP CONSTRAINT helo_access_hostname_key;
ALTER TABLE ONLY public.domain_stats DROP CONSTRAINT domain_stats_pkey;
ALTER TABLE ONLY public.domain_admins DROP CONSTRAINT domain_admins_pkey;
ALTER TABLE ONLY public.contentfilters DROP CONSTRAINT contentfilters_name_key;
ALTER TABLE ONLY public.auth DROP CONSTRAINT auth_pkey;
ALTER TABLE ONLY public.attachment_filters DROP CONSTRAINT attachment_filters_name_type_key;
ALTER TABLE public.wblist ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.viruses ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.users ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.userrules ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.transport ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.tls ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.stats ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.staticroutes ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.spamstats ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.smarthosts ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.sender_transport ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.scrubber_config ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.rulesets ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.roles ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.reports ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.realms ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.rbls ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.policy ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.permissions ALTER COLUMN weight DROP DEFAULT;
ALTER TABLE public.permissions ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.netip ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.mynetworks ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.mailaddr ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.ippools ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.ippool_members ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.ipaliases ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.helo_access ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.domain_stats ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.contentfilters ALTER COLUMN id DROP DEFAULT;
ALTER TABLE public.attachment_filters ALTER COLUMN id DROP DEFAULT;
DROP SEQUENCE public.wblist_id_seq;
DROP TABLE public.wblist;
DROP SEQUENCE public.viruses_id_seq;
DROP TABLE public.viruses;
DROP TABLE public.virus_scanners;
DROP SEQUENCE public.users_id_seq;
DROP TABLE public.users;
DROP SEQUENCE public.userrules_id_seq;
DROP TABLE public.userrules;
DROP TABLE public.user_roles;
DROP SEQUENCE public.transport_id_seq;
DROP TABLE public.transport;
DROP SEQUENCE public.tls_id_seq;
DROP TABLE public.tls;
DROP SEQUENCE public.stats_id_seq;
DROP TABLE public.stats;
DROP SEQUENCE public.staticroutes_id_seq;
DROP TABLE public.staticroutes;
DROP SEQUENCE public.spamstats_id_seq;
DROP TABLE public.spamstats;
DROP SEQUENCE public.smarthosts_id_seq;
DROP TABLE public.smarthosts;
DROP SEQUENCE public.sender_transport_id_seq;
DROP TABLE public.sender_transport;
DROP SEQUENCE public.scrubber_config_id_seq;
DROP TABLE public.scrubber_config;
DROP TABLE public.saslauth;
DROP SEQUENCE public.rulesets_id_seq;
DROP TABLE public.rulesets;
DROP SEQUENCE public.roles_id_seq;
DROP TABLE public.roles;
DROP TABLE public.role_perms;
DROP SEQUENCE public.reports_id_seq;
DROP TABLE public.reports;
DROP TABLE public.recipients;
DROP SEQUENCE public.realms_id_seq;
DROP TABLE public.realms;
DROP TABLE public.realm_admins;
DROP SEQUENCE public.rbls_id_seq;
DROP TABLE public.rbls;
DROP SEQUENCE public.policy_id_seq;
DROP TABLE public.policy;
DROP SEQUENCE public.permissions_id_seq;
DROP TABLE public.permissions;
DROP SEQUENCE public.netip_id_seq;
DROP TABLE public.netip;
DROP SEQUENCE public.mynetworks_id_seq;
DROP TABLE public.mynetworks;
DROP SEQUENCE public.mailaddr_id_seq;
DROP TABLE public.mailaddr;
DROP SEQUENCE public.ippools_id_seq;
DROP TABLE public.ippools;
DROP SEQUENCE public.ippool_members_id_seq;
DROP TABLE public.ippool_members;
DROP SEQUENCE public.ipaliases_id_seq;
DROP TABLE public.ipaliases;
DROP SEQUENCE public.helo_access_id_seq;
DROP TABLE public.helo_access;
DROP SEQUENCE public.domain_stats_id_seq;
DROP TABLE public.domain_stats;
DROP TABLE public.domain_admins;
DROP SEQUENCE public.contentfilters_id_seq;
DROP TABLE public.contentfilters;
DROP TABLE public.auth;
DROP SEQUENCE public.attachment_filters_id_seq;
DROP TABLE public.attachment_filters;
SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: attachment_filters; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE attachment_filters (
    id integer NOT NULL,
    name text DEFAULT ''::text NOT NULL,
    type enum_attachment_type DEFAULT 'filename'::enum_attachment_type NOT NULL,
    inbound enum_attachment_action DEFAULT 'allow'::enum_attachment_action NOT NULL,
    outbound enum_attachment_action DEFAULT 'allow'::enum_attachment_action NOT NULL,
    scan_archive boolean DEFAULT true NOT NULL,
    scan_double boolean DEFAULT true NOT NULL,
    comment text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.attachment_filters OWNER TO pgsql;

--
-- Name: attachment_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE attachment_filters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.attachment_filters_id_seq OWNER TO pgsql;

--
-- Name: attachment_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE attachment_filters_id_seq OWNED BY attachment_filters.id;


--
-- Name: attachment_filters_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('attachment_filters_id_seq', 34, true);


--
-- Name: auth; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE auth (
    domain character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(255) DEFAULT 'internal'::character varying NOT NULL,
    ldap_server character varying(255) DEFAULT NULL::character varying,
    ldap_port integer DEFAULT 389 NOT NULL,
    ldap_username character varying(255) DEFAULT NULL::character varying,
    ldap_password character varying(255) DEFAULT NULL::character varying,
    ldap_query character varying(255) DEFAULT 'mail=%%EMAIL%%'::character varying NOT NULL,
    ldap_bind_dn character varying(255) DEFAULT 'cn=company, dc=domain, dc=tld'::character varying,
    ldap_base_dn character varying(255) DEFAULT '%%defaultNamingContext%%'::character varying NOT NULL,
    ldap_attribute character varying(255) DEFAULT 'mailroutingaddress'::character varying,
    ldap_anonymous character(1) DEFAULT 'N'::bpchar,
    sql_database character varying(32) DEFAULT 'mysql'::character varying NOT NULL,
    sql_username character varying(255) DEFAULT NULL::character varying,
    sql_password character varying(255) DEFAULT NULL::character varying,
    sql_server character varying(255) DEFAULT NULL::character varying,
    sql_port integer DEFAULT 3303,
    sql_dbname character varying(255) DEFAULT NULL::character varying,
    sql_table character varying(255) DEFAULT ''::character varying NOT NULL,
    sql_email_column character varying(255) DEFAULT ''::character varying NOT NULL,
    sql_pass_column character varying(255) DEFAULT ''::character varying NOT NULL,
    sql_pass_type character varying(32) DEFAULT 'plaintext'::character varying NOT NULL,
    pop3_server character varying(255) DEFAULT ''::character varying NOT NULL,
    pop3_port integer DEFAULT 110,
    pop3_type integer DEFAULT 1 NOT NULL,
    imap_server character varying(255) DEFAULT ''::character varying NOT NULL,
    imap_port integer DEFAULT 143 NOT NULL,
    imap_type integer DEFAULT 0 NOT NULL,
    secure_auth integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.auth OWNER TO pgsql;

--
-- Name: contentfilters; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE contentfilters (
    id integer NOT NULL,
    readonly boolean DEFAULT false NOT NULL,
    name text,
    status boolean DEFAULT true NOT NULL,
    filtertype enum_filtertype DEFAULT 'starts_with'::enum_filtertype NOT NULL,
    pattern text DEFAULT ''::text NOT NULL,
    apply_body boolean DEFAULT false NOT NULL,
    apply_headers boolean DEFAULT false NOT NULL,
    headers text DEFAULT ''::text NOT NULL,
    inbound enum_action DEFAULT 'DUNNO'::enum_action NOT NULL,
    inbound_relay text DEFAULT ''::text NOT NULL,
    inbound_email text DEFAULT ''::text NOT NULL,
    outbound enum_action DEFAULT 'DUNNO'::enum_action NOT NULL,
    outbound_relay text DEFAULT ''::text NOT NULL,
    outbound_email text DEFAULT ''::text NOT NULL,
    comment text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.contentfilters OWNER TO pgsql;

--
-- Name: contentfilters_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE contentfilters_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contentfilters_id_seq OWNER TO pgsql;

--
-- Name: contentfilters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE contentfilters_id_seq OWNED BY contentfilters.id;


--
-- Name: contentfilters_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('contentfilters_id_seq', 2, true);


--
-- Name: domain_admins; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE domain_admins (
    domain_id integer NOT NULL,
    admin_id integer NOT NULL,
    role_id integer NOT NULL
);


ALTER TABLE public.domain_admins OWNER TO pgsql;

--
-- Name: domain_stats; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE domain_stats (
    id integer NOT NULL,
    did integer NOT NULL,
    node_id integer DEFAULT 0 NOT NULL,
    logdate date,
    total_spam integer DEFAULT 0 NOT NULL,
    total_clean integer DEFAULT 0 NOT NULL,
    total_inv_rcpt integer DEFAULT 0 NOT NULL,
    total_viruses integer DEFAULT 0 NOT NULL,
    total_rbl_reject integer DEFAULT 0 NOT NULL,
    total_helo_reject integer DEFAULT 0 NOT NULL,
    total_banned integer DEFAULT 0 NOT NULL,
    total_sender_baddom integer DEFAULT 0 NOT NULL,
    total_sender_fqdn integer DEFAULT 0 NOT NULL,
    "timestamp" timestamp without time zone,
    licensecount integer DEFAULT 0 NOT NULL,
    license_list_count integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.domain_stats OWNER TO pgsql;

--
-- Name: domain_stats_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE domain_stats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.domain_stats_id_seq OWNER TO pgsql;

--
-- Name: domain_stats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE domain_stats_id_seq OWNED BY domain_stats.id;


--
-- Name: domain_stats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('domain_stats_id_seq', 484, true);


--
-- Name: helo_access; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE helo_access (
    id integer NOT NULL,
    hostname text,
    access text DEFAULT 'REJECT'::text NOT NULL
);


ALTER TABLE public.helo_access OWNER TO pgsql;

--
-- Name: helo_access_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE helo_access_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.helo_access_id_seq OWNER TO pgsql;

--
-- Name: helo_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE helo_access_id_seq OWNED BY helo_access.id;


--
-- Name: helo_access_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('helo_access_id_seq', 1, false);


--
-- Name: ipaliases; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE ipaliases (
    id integer NOT NULL,
    ipnetwork inet,
    interface character varying(32) DEFAULT ''::character varying NOT NULL,
    comment character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.ipaliases OWNER TO pgsql;

--
-- Name: ipaliases_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE ipaliases_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ipaliases_id_seq OWNER TO pgsql;

--
-- Name: ipaliases_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE ipaliases_id_seq OWNED BY ipaliases.id;


--
-- Name: ipaliases_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('ipaliases_id_seq', 1, false);


--
-- Name: ippool_members; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE ippool_members (
    id integer NOT NULL,
    poolname text NOT NULL,
    ip character varying(32),
    helo character varying(255)
);


ALTER TABLE public.ippool_members OWNER TO pgsql;

--
-- Name: ippool_members_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE ippool_members_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ippool_members_id_seq OWNER TO pgsql;

--
-- Name: ippool_members_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE ippool_members_id_seq OWNED BY ippool_members.id;


--
-- Name: ippool_members_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('ippool_members_id_seq', 1, false);


--
-- Name: ippools; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE ippools (
    id integer NOT NULL,
    name text,
    ismain boolean DEFAULT false NOT NULL,
    comment text
);


ALTER TABLE public.ippools OWNER TO pgsql;

--
-- Name: ippools_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE ippools_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ippools_id_seq OWNER TO pgsql;

--
-- Name: ippools_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE ippools_id_seq OWNED BY ippools.id;


--
-- Name: ippools_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('ippools_id_seq', 1, true);


--
-- Name: mailaddr; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE mailaddr (
    id integer NOT NULL,
    priority integer DEFAULT 7 NOT NULL,
    email character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.mailaddr OWNER TO pgsql;

--
-- Name: mailaddr_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE mailaddr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mailaddr_id_seq OWNER TO pgsql;

--
-- Name: mailaddr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE mailaddr_id_seq OWNED BY mailaddr.id;


--
-- Name: mailaddr_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('mailaddr_id_seq', 75, true);


--
-- Name: mynetworks; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE mynetworks (
    id integer NOT NULL,
    cidr cidr,
    comment text,
    lastmodified timestamp(0) without time zone
);


ALTER TABLE public.mynetworks OWNER TO pgsql;

--
-- Name: mynetworks_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE mynetworks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mynetworks_id_seq OWNER TO pgsql;

--
-- Name: mynetworks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE mynetworks_id_seq OWNED BY mynetworks.id;


--
-- Name: mynetworks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('mynetworks_id_seq', 6, true);


--
-- Name: netip; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE netip (
    id integer NOT NULL,
    cidr cidr,
    comment text,
    lastmodified timestamp(0) without time zone,
    section text,
    access text DEFAULT 'REJECT Client IP address rejected'::text NOT NULL,
    tld text
);


ALTER TABLE public.netip OWNER TO pgsql;

--
-- Name: netip_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE netip_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.netip_id_seq OWNER TO pgsql;

--
-- Name: netip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE netip_id_seq OWNED BY netip.id;


--
-- Name: netip_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('netip_id_seq', 1, true);


--
-- Name: permissions; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE permissions (
    id integer NOT NULL,
    parent_id integer,
    menu boolean DEFAULT false NOT NULL,
    url character varying(255) NOT NULL,
    weight smallint NOT NULL
);


ALTER TABLE public.permissions OWNER TO pgsql;

--
-- Name: permissions_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE permissions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permissions_id_seq OWNER TO pgsql;

--
-- Name: permissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE permissions_id_seq OWNED BY permissions.id;


--
-- Name: permissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('permissions_id_seq', 55, true);


--
-- Name: policy; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE policy (
    id integer NOT NULL,
    policy_name character varying(255) DEFAULT NULL::character varying,
    virus_lover character(1) DEFAULT 'N'::bpchar,
    spam_lover character(1) DEFAULT 'N'::bpchar,
    banned_files_lover character(1) DEFAULT 'N'::bpchar,
    bad_header_lover character(1) DEFAULT 'N'::bpchar,
    bypass_virus_checks character(1) DEFAULT 'N'::bpchar,
    bypass_spam_checks character(1) DEFAULT 'N'::bpchar,
    bypass_banned_checks character(1) DEFAULT 'N'::bpchar,
    bypass_header_checks character(1) DEFAULT 'N'::bpchar,
    spam_modifies_subj character(1) DEFAULT 'N'::bpchar,
    spam_subject_tag2 character varying(64) DEFAULT '[ ** SPAM ** ]'::character varying,
    spam_quarantine_to character varying(64) DEFAULT 'spam-quarantine'::character varying,
    virus_quarantine_to character varying(64) DEFAULT 'virus-quarantine'::character varying,
    banned_quarantine_to character varying(64) DEFAULT 'banned-quarantine'::character varying,
    clean_quarantine_to character varying(64) DEFAULT ''::character varying,
    bad_header_quarantine_to character varying(64) DEFAULT ''::character varying,
    spam_tag_level double precision DEFAULT (-999)::double precision,
    spam_tag2_level double precision DEFAULT 5::double precision,
    spam_kill_level double precision DEFAULT 5::double precision,
    locked character(1) DEFAULT 'N'::bpchar,
    digest character(2) DEFAULT 'N'::bpchar,
    report_type character(1) DEFAULT 'N'::bpchar,
    report_kill_level double precision DEFAULT 999::double precision NOT NULL,
    spam_dsn_cutoff_level double precision DEFAULT 0::double precision,
    spam_quarantine_cutoff_level double precision DEFAULT 999::double precision NOT NULL,
    digest_language character varying(8) DEFAULT 'en_US'::character varying NOT NULL
);


ALTER TABLE public.policy OWNER TO pgsql;

--
-- Name: policy_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE policy_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.policy_id_seq OWNER TO pgsql;

--
-- Name: policy_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE policy_id_seq OWNED BY policy.id;


--
-- Name: policy_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('policy_id_seq', 11, true);


--
-- Name: rbls; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE rbls (
    id integer NOT NULL,
    rbl_name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.rbls OWNER TO pgsql;

--
-- Name: rbls_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE rbls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rbls_id_seq OWNER TO pgsql;

--
-- Name: rbls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE rbls_id_seq OWNED BY rbls.id;


--
-- Name: rbls_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('rbls_id_seq', 3, true);


--
-- Name: realm_admins; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE realm_admins (
    realm_id integer NOT NULL,
    user_id integer NOT NULL,
    role_id integer NOT NULL
);


ALTER TABLE public.realm_admins OWNER TO pgsql;

--
-- Name: realms; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE realms (
    id integer NOT NULL,
    name character varying(50) NOT NULL,
    timezone character varying(50),
    description text DEFAULT ''::text NOT NULL,
    suspended boolean DEFAULT false NOT NULL,
    lockedout boolean DEFAULT false NOT NULL
);


ALTER TABLE public.realms OWNER TO pgsql;

--
-- Name: realms_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE realms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.realms_id_seq OWNER TO pgsql;

--
-- Name: realms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE realms_id_seq OWNED BY realms.id;


--
-- Name: realms_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('realms_id_seq', 1, false);


--
-- Name: recipients; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE recipients (
    email text NOT NULL,
    domain text NOT NULL
);


ALTER TABLE public.recipients OWNER TO pgsql;

--
-- Name: reports; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE reports (
    id integer NOT NULL,
    email character varying(255) DEFAULT ''::character varying NOT NULL,
    subject character varying(255) DEFAULT 'SpamTitan Report'::character varying NOT NULL,
    type character varying(32) DEFAULT 'summary'::character varying NOT NULL,
    frequency character(1) DEFAULT 'D'::bpchar NOT NULL,
    maxitem integer DEFAULT 10 NOT NULL,
    created timestamp without time zone,
    format character varying(32) DEFAULT 'pdf'::character varying NOT NULL,
    archive character(1) DEFAULT 'N'::bpchar NOT NULL,
    domain_id integer DEFAULT 0 NOT NULL,
    domain text,
    node_id integer DEFAULT 0 NOT NULL,
    flags integer DEFAULT 0 NOT NULL,
    realm_id integer
);


ALTER TABLE public.reports OWNER TO pgsql;

--
-- Name: reports_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE reports_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reports_id_seq OWNER TO pgsql;

--
-- Name: reports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE reports_id_seq OWNED BY reports.id;


--
-- Name: reports_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('reports_id_seq', 1, false);


--
-- Name: role_perms; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE role_perms (
    role_id integer NOT NULL,
    perm_id integer NOT NULL
);


ALTER TABLE public.role_perms OWNER TO pgsql;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE roles (
    id integer NOT NULL,
    name character varying(50) NOT NULL,
    type character varying(50) NOT NULL,
    is_template boolean DEFAULT false NOT NULL,
    is_default boolean DEFAULT false NOT NULL,
    owner_id integer
);


ALTER TABLE public.roles OWNER TO pgsql;

--
-- Name: COLUMN roles.type; Type: COMMENT; Schema: public; Owner: pgsql
--

COMMENT ON COLUMN roles.type IS 'must be: admin, realm, domain, or user';


--
-- Name: roles_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE roles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.roles_id_seq OWNER TO pgsql;

--
-- Name: roles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE roles_id_seq OWNED BY roles.id;


--
-- Name: roles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('roles_id_seq', 7, true);


--
-- Name: rulesets; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE rulesets (
    id integer NOT NULL,
    name character varying(128) DEFAULT ''::character varying NOT NULL,
    version character varying(128) DEFAULT ''::character varying NOT NULL,
    description character varying(255) DEFAULT ''::character varying NOT NULL,
    url character varying(128) DEFAULT ''::character varying NOT NULL,
    filename character varying(128) DEFAULT ''::character varying NOT NULL,
    active character(1) DEFAULT 'Y'::bpchar,
    lastupdate timestamp without time zone
);


ALTER TABLE public.rulesets OWNER TO pgsql;

--
-- Name: rulesets_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE rulesets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.rulesets_id_seq OWNER TO pgsql;

--
-- Name: rulesets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE rulesets_id_seq OWNED BY rulesets.id;


--
-- Name: rulesets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('rulesets_id_seq', 1, false);


--
-- Name: saslauth; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE saslauth (
    ldap_server character varying(255) DEFAULT NULL::character varying,
    ldap_port integer DEFAULT 389 NOT NULL,
    ldap_anonymous character(1) DEFAULT 'N'::bpchar NOT NULL,
    ldap_username character varying(255) DEFAULT NULL::character varying,
    ldap_password character varying(255) DEFAULT NULL::character varying,
    ldap_filter character varying(255) DEFAULT 'uid=%u'::character varying NOT NULL,
    ldap_search_base character varying(255) DEFAULT 'dc=example,dc=com'::character varying NOT NULL,
    method enum_sasl_method DEFAULT 'ldap'::enum_sasl_method NOT NULL,
    tls_auth_only character(1) DEFAULT 'N'::bpchar NOT NULL,
    imap_server character varying(255) DEFAULT NULL::character varying
);


ALTER TABLE public.saslauth OWNER TO pgsql;

--
-- Name: scrubber_config; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE scrubber_config (
    id integer NOT NULL,
    version numeric(8,2) DEFAULT 5.00 NOT NULL,
    version_date timestamp without time zone,
    update_server character varying(255) DEFAULT 'rules.spamtitan.com'::character varying NOT NULL,
    www_timeout integer DEFAULT 1800 NOT NULL,
    auth_method character varying(255) DEFAULT 'pop3'::character varying,
    showaliases character(1) DEFAULT 'N'::bpchar NOT NULL,
    expiry_period integer DEFAULT 21,
    learn_bayes integer DEFAULT 1,
    report_name character varying(255) DEFAULT 'SpamTitan'::character varying NOT NULL,
    report_from character varying(255) DEFAULT 'report@spamtitan.com'::character varying NOT NULL,
    report_subject character varying(255) DEFAULT 'Spam Quarantine Report'::character varying NOT NULL,
    report_contact character varying(255) DEFAULT NULL::character varying,
    report_contact_misc character varying(255) DEFAULT NULL::character varying,
    report_logo character varying(255) DEFAULT '/imgs/spam-report.jpg'::character varying NOT NULL,
    report_logo_inc character(1) DEFAULT 'Y'::bpchar NOT NULL,
    ui_logo character varying(255) DEFAULT '/imgs/logo.gif'::character varying NOT NULL,
    proxy character varying(255) DEFAULT NULL::character varying,
    proxyport integer,
    proxyuser character varying(255) DEFAULT NULL::character varying,
    proxypass character varying(255) DEFAULT NULL::character varying,
    server_url character varying(255),
    http_protocol character varying(12) DEFAULT 'http://'::character varying,
    logs_expiry_period integer DEFAULT 31 NOT NULL,
    logs_msgs_page integer DEFAULT 100 NOT NULL,
    logs_msgs_sort character varying(4) DEFAULT 'DESC'::character varying,
    logs_subject character(1) DEFAULT 'N'::bpchar NOT NULL,
    logs_cleanscore character(1) DEFAULT 'N'::bpchar NOT NULL,
    logs_spamscore character(1) DEFAULT 'N'::bpchar NOT NULL,
    logs_period integer DEFAULT 3 NOT NULL,
    report_inc_type character(1) DEFAULT 'Y'::bpchar NOT NULL,
    report_inc_freq character(1) DEFAULT 'Y'::bpchar NOT NULL,
    report_inc_login character(1) DEFAULT 'Y'::bpchar NOT NULL,
    report_inc_ondemand character(1) DEFAULT 'N'::bpchar NOT NULL,
    report_use_from_header character(1) DEFAULT 'N'::bpchar NOT NULL,
    report_footer character varying(255) DEFAULT 'Spam/Virus Protection by Copperfasten Technologies'::character varying NOT NULL,
    login_showhelp character(1) DEFAULT 'N'::bpchar NOT NULL,
    login_helpurl character varying(255) DEFAULT NULL::character varying,
    login_showpwlink character(1) DEFAULT 'Y'::bpchar NOT NULL,
    chart_maxsize integer DEFAULT 25 NOT NULL,
    logs_vscanner character(1) DEFAULT 'N'::bpchar NOT NULL,
    logs_vname character(1) DEFAULT 'N'::bpchar NOT NULL,
    dnscache character(1) DEFAULT 'N'::bpchar NOT NULL,
    license_decay integer DEFAULT 10 NOT NULL,
    license_usage integer DEFAULT 0 NOT NULL,
    license_reset integer DEFAULT 0 NOT NULL,
    db_maxsize integer DEFAULT 1200000,
    quarantine_admin character varying(255) DEFAULT ''::character varying,
    auto_domain_discover character(1) DEFAULT 'N'::bpchar NOT NULL,
    log_invl_rcpt character(1) DEFAULT 'Y'::bpchar NOT NULL,
    log_helo_reject character(1) DEFAULT 'Y'::bpchar NOT NULL,
    log_spf_reject character(1) DEFAULT 'Y'::bpchar NOT NULL,
    log_relay_denied character(1) DEFAULT 'Y'::bpchar NOT NULL,
    log_sender_reject character(1) DEFAULT 'Y'::bpchar NOT NULL,
    log_sender_reject2 character(1) DEFAULT 'Y'::bpchar NOT NULL,
    log_rbl_reject character(1) DEFAULT 'Y'::bpchar NOT NULL,
    stpurge_date timestamp without time zone,
    smtp_rcpt_before_rbl character(1) DEFAULT 'Y'::bpchar NOT NULL,
    ui_title character varying(255) DEFAULT 'SpamTitan'::character varying NOT NULL,
    ui_footer character varying(255) DEFAULT '&copy;2006-2014 Copperfasten Technologies'::character varying NOT NULL,
    engine_name character varying(64) DEFAULT 'SpamTitan'::character varying NOT NULL,
    license_from character varying(255) DEFAULT 'licensing@spamtitan.com'::character varying NOT NULL,
    tunnel_address character varying(255) DEFAULT 'copper@support.spamtitan.com'::character varying NOT NULL,
    st_helpdesk character varying(255) DEFAULT 'helpdesk@spamtitan.com'::character varying NOT NULL,
    fp_from character varying(255) DEFAULT 'spam-portal@spamtitan.com'::character varying NOT NULL,
    fp_subject character varying(255) DEFAULT 'SpamTitan Anti-Spam appliance - Password'::character varying NOT NULL,
    fp_body text DEFAULT 'Your password for the SpamTitan Anti-Spam appliance is: %%PASSWORD%%'::text NOT NULL,
    pdf_text text DEFAULT 'SpamTitan Mail Firewall Report'::text NOT NULL,
    pdf_logo character varying(255) DEFAULT '/imgs/logo2.png'::character varying NOT NULL,
    notify_flags integer DEFAULT 0,
    usealiases integer DEFAULT 0,
    wb_from_header integer DEFAULT 0,
    grey_count integer DEFAULT 5,
    grey_delay integer DEFAULT 300,
    virus_scanners character varying[] DEFAULT ARRAY['clamav'::text, 'kaspersky'::text] NOT NULL,
    digest_load_default integer DEFAULT 1,
    ssh_host text DEFAULT 'support.spamtitan.com'::text NOT NULL,
    ssh_key text DEFAULT 'copper'::text NOT NULL,
    demo boolean DEFAULT false NOT NULL,
    update_subject text DEFAULT 'SpamTitan System Update(s) Available'::text NOT NULL,
    report_license_count character(1) DEFAULT 'N'::bpchar NOT NULL,
    timezone text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.scrubber_config OWNER TO pgsql;

--
-- Name: scrubber_config_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE scrubber_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.scrubber_config_id_seq OWNER TO pgsql;

--
-- Name: scrubber_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE scrubber_config_id_seq OWNED BY scrubber_config.id;


--
-- Name: scrubber_config_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('scrubber_config_id_seq', 1, false);


--
-- Name: sender_transport; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE sender_transport (
    id integer NOT NULL,
    domain text,
    poolid integer
);


ALTER TABLE public.sender_transport OWNER TO pgsql;

--
-- Name: sender_transport_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE sender_transport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sender_transport_id_seq OWNER TO pgsql;

--
-- Name: sender_transport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE sender_transport_id_seq OWNED BY sender_transport.id;


--
-- Name: sender_transport_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('sender_transport_id_seq', 1, false);


--
-- Name: smarthosts; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE smarthosts (
    id integer NOT NULL,
    sender text,
    relayhost text,
    comment text,
    needauth boolean DEFAULT false NOT NULL,
    auth_user text DEFAULT ''::text NOT NULL,
    auth_pass text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.smarthosts OWNER TO pgsql;

--
-- Name: smarthosts_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE smarthosts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.smarthosts_id_seq OWNER TO pgsql;

--
-- Name: smarthosts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE smarthosts_id_seq OWNED BY smarthosts.id;


--
-- Name: smarthosts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('smarthosts_id_seq', 1, false);


--
-- Name: spamstats; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE spamstats (
    id integer NOT NULL,
    node_id integer DEFAULT 0 NOT NULL,
    logdate date,
    total integer DEFAULT 0 NOT NULL,
    spam integer DEFAULT 0 NOT NULL,
    clean integer DEFAULT 0 NOT NULL,
    inv_rcpt integer DEFAULT 0 NOT NULL,
    viruses integer DEFAULT 0 NOT NULL,
    banned integer DEFAULT 0 NOT NULL,
    relay_denied integer DEFAULT 0 NOT NULL,
    rbl_reject integer DEFAULT 0 NOT NULL,
    helo_reject integer DEFAULT 0 NOT NULL,
    spf_fail integer DEFAULT 0 NOT NULL,
    sender_baddom integer DEFAULT 0 NOT NULL,
    sender_fqdn integer DEFAULT 0 NOT NULL,
    blackip integer DEFAULT 0 NOT NULL,
    "timestamp" timestamp without time zone
);


ALTER TABLE public.spamstats OWNER TO pgsql;

--
-- Name: spamstats_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE spamstats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.spamstats_id_seq OWNER TO pgsql;

--
-- Name: spamstats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE spamstats_id_seq OWNED BY spamstats.id;


--
-- Name: spamstats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('spamstats_id_seq', 470, true);


--
-- Name: staticroutes; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE staticroutes (
    id integer NOT NULL,
    ipnetwork inet,
    gateway character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(8) DEFAULT 'NET'::character varying NOT NULL,
    active character varying(8) DEFAULT 'FALSE'::character varying NOT NULL,
    comment character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.staticroutes OWNER TO pgsql;

--
-- Name: staticroutes_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE staticroutes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.staticroutes_id_seq OWNER TO pgsql;

--
-- Name: staticroutes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE staticroutes_id_seq OWNED BY staticroutes.id;


--
-- Name: staticroutes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('staticroutes_id_seq', 1, false);


--
-- Name: stats; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE stats (
    id integer NOT NULL,
    type character(1) DEFAULT 'S'::bpchar NOT NULL,
    date timestamp without time zone,
    ok character(1) DEFAULT 'N'::bpchar NOT NULL,
    info character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.stats OWNER TO pgsql;

--
-- Name: stats_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE stats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stats_id_seq OWNER TO pgsql;

--
-- Name: stats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE stats_id_seq OWNED BY stats.id;


--
-- Name: stats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('stats_id_seq', 4377, true);


--
-- Name: tls; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE tls (
    id integer NOT NULL,
    domain text,
    comment text,
    lastmodified timestamp(0) without time zone,
    policy text DEFAULT 'may'::text NOT NULL
);


ALTER TABLE public.tls OWNER TO pgsql;

--
-- Name: tls_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE tls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tls_id_seq OWNER TO pgsql;

--
-- Name: tls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE tls_id_seq OWNED BY tls.id;


--
-- Name: tls_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('tls_id_seq', 1, false);


--
-- Name: transport; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE transport (
    id integer NOT NULL,
    domain character varying(255) DEFAULT ''::character varying NOT NULL,
    transport character varying(255) DEFAULT NULL::character varying,
    ldap_server character varying(255) DEFAULT NULL::character varying,
    ldap_port integer DEFAULT 379,
    ldap_anon character(1) DEFAULT 'N'::bpchar,
    ldap_username character varying(255) DEFAULT NULL::character varying,
    ldap_password character varying(255) DEFAULT NULL::character varying,
    ldap_filter character varying(255) DEFAULT NULL::character varying,
    ldap_attribute character varying(255) DEFAULT NULL::character varying,
    ldap_sb character varying(255) DEFAULT NULL::character varying,
    vrfy_action character varying(255) DEFAULT ''::character varying,
    vrfy_host character varying(255) DEFAULT ''::character varying,
    vrfy_alias character(1) DEFAULT 'N'::bpchar NOT NULL,
    regex_rcpt boolean DEFAULT false NOT NULL,
    destination text DEFAULT ''::text NOT NULL,
    realm_id integer,
    reverse_domain character varying(255),
    rbl_checks enum_rbl_checks DEFAULT 'rbl_checks'::enum_rbl_checks NOT NULL
);


ALTER TABLE public.transport OWNER TO pgsql;

--
-- Name: transport_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE transport_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transport_id_seq OWNER TO pgsql;

--
-- Name: transport_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE transport_id_seq OWNED BY transport.id;


--
-- Name: transport_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('transport_id_seq', 1, true);


--
-- Name: user_roles; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE user_roles (
    user_id integer NOT NULL,
    role_id integer NOT NULL
);


ALTER TABLE public.user_roles OWNER TO pgsql;

--
-- Name: userrules; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE userrules (
    id integer NOT NULL,
    pattern text,
    comment text,
    type integer DEFAULT 0 NOT NULL,
    lastmodified timestamp(0) without time zone,
    score integer,
    active boolean DEFAULT true NOT NULL
);


ALTER TABLE public.userrules OWNER TO pgsql;

--
-- Name: userrules_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE userrules_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.userrules_id_seq OWNER TO pgsql;

--
-- Name: userrules_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE userrules_id_seq OWNED BY userrules.id;


--
-- Name: userrules_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('userrules_id_seq', 2, true);


--
-- Name: users; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE users (
    id integer NOT NULL,
    mailbox_id integer DEFAULT 0 NOT NULL,
    priority integer DEFAULT 1 NOT NULL,
    policy_id integer DEFAULT 1 NOT NULL,
    email character varying(255) DEFAULT ''::character varying NOT NULL,
    fullname character varying(255) DEFAULT ''::character varying NOT NULL,
    user_name character varying(255) DEFAULT ''::character varying NOT NULL,
    user_level character(1) DEFAULT 'U'::bpchar,
    report_date timestamp without time zone DEFAULT '1970-01-01 01:00:00'::timestamp without time zone,
    password character varying(32),
    domain character varying(255)
);


ALTER TABLE public.users OWNER TO pgsql;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO pgsql;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE users_id_seq OWNED BY users.id;


--
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('users_id_seq', 13, true);


--
-- Name: virus_scanners; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE virus_scanners (
    id integer DEFAULT 0 NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    shortname character varying(32) DEFAULT NULL::character varying
);


ALTER TABLE public.virus_scanners OWNER TO pgsql;

--
-- Name: viruses; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE viruses (
    id integer NOT NULL,
    virus_name character varying(255) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public.viruses OWNER TO pgsql;

--
-- Name: viruses_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE viruses_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.viruses_id_seq OWNER TO pgsql;

--
-- Name: viruses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE viruses_id_seq OWNED BY viruses.id;


--
-- Name: viruses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('viruses_id_seq', 20, true);


--
-- Name: wblist; Type: TABLE; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE TABLE wblist (
    rid integer DEFAULT 0 NOT NULL,
    sid integer DEFAULT 0 NOT NULL,
    wb character(1) DEFAULT ''::bpchar NOT NULL,
    comment text DEFAULT ''::text NOT NULL,
    lastmodified timestamp(0) without time zone,
    id integer NOT NULL
);


ALTER TABLE public.wblist OWNER TO pgsql;

--
-- Name: wblist_id_seq; Type: SEQUENCE; Schema: public; Owner: pgsql
--

CREATE SEQUENCE wblist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.wblist_id_seq OWNER TO pgsql;

--
-- Name: wblist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pgsql
--

ALTER SEQUENCE wblist_id_seq OWNED BY wblist.id;


--
-- Name: wblist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pgsql
--

SELECT pg_catalog.setval('wblist_id_seq', 83, true);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY attachment_filters ALTER COLUMN id SET DEFAULT nextval('attachment_filters_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY contentfilters ALTER COLUMN id SET DEFAULT nextval('contentfilters_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY domain_stats ALTER COLUMN id SET DEFAULT nextval('domain_stats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY helo_access ALTER COLUMN id SET DEFAULT nextval('helo_access_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY ipaliases ALTER COLUMN id SET DEFAULT nextval('ipaliases_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY ippool_members ALTER COLUMN id SET DEFAULT nextval('ippool_members_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY ippools ALTER COLUMN id SET DEFAULT nextval('ippools_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY mailaddr ALTER COLUMN id SET DEFAULT nextval('mailaddr_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY mynetworks ALTER COLUMN id SET DEFAULT nextval('mynetworks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY netip ALTER COLUMN id SET DEFAULT nextval('netip_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY permissions ALTER COLUMN id SET DEFAULT nextval('permissions_id_seq'::regclass);


--
-- Name: weight; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY permissions ALTER COLUMN weight SET DEFAULT nextval('permissions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY policy ALTER COLUMN id SET DEFAULT nextval('policy_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY rbls ALTER COLUMN id SET DEFAULT nextval('rbls_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY realms ALTER COLUMN id SET DEFAULT nextval('realms_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY reports ALTER COLUMN id SET DEFAULT nextval('reports_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY roles ALTER COLUMN id SET DEFAULT nextval('roles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY rulesets ALTER COLUMN id SET DEFAULT nextval('rulesets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY scrubber_config ALTER COLUMN id SET DEFAULT nextval('scrubber_config_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY sender_transport ALTER COLUMN id SET DEFAULT nextval('sender_transport_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY smarthosts ALTER COLUMN id SET DEFAULT nextval('smarthosts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY spamstats ALTER COLUMN id SET DEFAULT nextval('spamstats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY staticroutes ALTER COLUMN id SET DEFAULT nextval('staticroutes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY stats ALTER COLUMN id SET DEFAULT nextval('stats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY tls ALTER COLUMN id SET DEFAULT nextval('tls_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY transport ALTER COLUMN id SET DEFAULT nextval('transport_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY userrules ALTER COLUMN id SET DEFAULT nextval('userrules_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY users ALTER COLUMN id SET DEFAULT nextval('users_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY viruses ALTER COLUMN id SET DEFAULT nextval('viruses_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY wblist ALTER COLUMN id SET DEFAULT nextval('wblist_id_seq'::regclass);


--
-- Data for Name: attachment_filters; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY attachment_filters (id, name, type, inbound, outbound, scan_archive, scan_double, comment) FROM stdin;
1	exe	extension	block	block	t	t	
2	vbs	extension	block	block	t	t	
3	pif	extension	block	block	t	t	
4	scr	extension	block	block	t	t	
5	bat	extension	block	block	t	t	
6	cmd	extension	block	block	t	t	
7	com	extension	block	block	t	t	
8	dll	extension	block	block	t	t	
9	exe	filetype	block	block	t	t	All executables
10	exe-ms	filetype	block	block	t	t	MS Windows executables
11	application/x-msdownload	mimetype	block	block	t	t	MS Windows DLL and EXE files
12	application/x-msdos-program	mimetype	block	block	t	t	MS DOS application/executable
13	F	archive	allow	allow	t	t	
14	Z	archive	allow	allow	t	t	
15	gz	archive	allow	allow	t	t	
16	bz2	archive	allow	allow	t	t	
17	xz	archive	allow	allow	t	t	
18	lzma	archive	allow	allow	t	t	
19	lzo	archive	allow	allow	t	t	
20	rpm	archive	allow	allow	t	t	
21	cpio	archive	allow	allow	t	t	
22	tar	archive	allow	allow	t	t	
23	deb	archive	allow	allow	t	t	
24	zip	archive	allow	allow	t	t	
25	kmz	archive	allow	allow	t	t	
26	7z	archive	allow	allow	t	t	
27	rar	archive	allow	allow	t	t	
28	arj	archive	allow	allow	t	t	
29	arc	archive	allow	allow	t	t	
30	zoo	archive	allow	allow	t	t	
31	lha	archive	allow	allow	t	t	
32	cab	archive	allow	allow	t	t	
33	tnef	archive	allow	allow	t	t	
34	***UNCHECKED*** 	ppa	allow	allow	t	t	
\.


--
-- Data for Name: auth; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY auth (domain, type, ldap_server, ldap_port, ldap_username, ldap_password, ldap_query, ldap_bind_dn, ldap_base_dn, ldap_attribute, ldap_anonymous, sql_database, sql_username, sql_password, sql_server, sql_port, sql_dbname, sql_table, sql_email_column, sql_pass_column, sql_pass_type, pop3_server, pop3_port, pop3_type, imap_server, imap_port, imap_type, secure_auth) FROM stdin;
14demarzo.fin.ec	internal	\N	389	\N	\N	mail=%%EMAIL%%	cn=company, dc=domain, dc=tld	%%defaultNamingContext%%	mailroutingaddress	N	mysql	\N	\N	\N	3303	\N				plaintext		110	1		143	0	0
\.


--
-- Data for Name: contentfilters; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY contentfilters (id, readonly, name, status, filtertype, pattern, apply_body, apply_headers, headers, inbound, inbound_relay, inbound_email, outbound, outbound_relay, outbound_email, comment) FROM stdin;
1	t	Credit Card Numbers	f	match_regex	\\b(4\\d{3}(\\s|-)?\\d{4}(\\s|-)?\\d{4}(\\s|-)?\\d{4}|5[1-5]\\d{2}(\\s|-)?\\d{4}(\\s|-)?\\d{4}(\\s|-)?\\d{4}|6(011|5\\d{2})(\\s|-)?\\d{4}(\\s|-)?\\d{4}(\\s|-)?\\d{4}|3(4|7)\\d{2}(\\s|-)?\\d{6}(\\s|-)?\\d{5}|3(0[0-5]\\d|(6|8)\\d{2})(\\s|-)?\\d{6}(\\s|-)?\\d{4})\\b	t	t	Subject:	DUNNO			DUNNO			Data leak prevention for credit card numbers
2	t	Social Security Numbers	f	match_regex	\\b(?!(000|666|9))\\d{3}-(?!00)\\d{2}-(?!0000)\\d{4}\\b	t	t	Subject:	DUNNO			DUNNO			Data leak prevention for social security numbers 
\.


--
-- Data for Name: domain_admins; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY domain_admins (domain_id, admin_id, role_id) FROM stdin;
\.


--
-- Data for Name: domain_stats; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY domain_stats (id, did, node_id, logdate, total_spam, total_clean, total_inv_rcpt, total_viruses, total_rbl_reject, total_helo_reject, total_banned, total_sender_baddom, total_sender_fqdn, "timestamp", licensecount, license_list_count) FROM stdin;
1	1	0	2014-11-20	0	0	0	0	0	0	0	0	0	\N	0	0
2	1	0	2014-11-21	0	0	0	0	0	0	0	0	0	\N	0	0
3	1	0	2014-11-22	0	0	0	0	0	0	0	0	0	\N	0	0
4	1	0	2014-11-23	0	0	0	0	0	0	0	0	0	\N	0	0
5	1	0	2014-11-24	0	0	0	0	0	0	0	0	0	\N	0	0
6	1	0	2014-11-25	0	0	0	0	0	0	0	0	0	\N	0	0
7	1	0	2014-11-26	0	0	0	0	0	0	0	0	0	\N	0	0
8	1	0	2014-11-27	0	0	0	0	0	0	0	0	0	\N	0	0
9	1	0	2014-11-28	0	0	0	0	0	0	0	0	0	\N	0	0
10	1	0	2014-11-29	0	0	0	0	0	0	0	0	0	\N	0	0
11	1	0	2014-11-30	0	0	0	0	0	0	0	0	0	\N	0	0
12	1	0	2014-12-01	0	0	0	0	0	0	0	0	0	\N	0	0
13	1	0	2014-12-02	0	0	0	0	0	0	0	0	0	\N	0	0
63	1	0	2015-01-22	37	124	0	0	94	7	0	0	0	2015-01-22 23:45:01	21	0
17	1	0	2014-12-06	47	40	0	0	88	0	0	2	0	2014-12-06 23:50:01	6	0
29	1	0	2014-12-19	23	97	0	0	100	6	0	2	0	2014-12-19 23:55:01	21	0
23	1	0	2014-12-12	41	76	0	0	88	0	0	4	0	2014-12-12 23:45:01	22	0
28	1	0	2014-12-18	7	55	0	0	104	6	1	2	0	2014-12-18 23:40:01	18	0
27	1	0	2014-12-17	29	92	0	0	156	1	0	0	0	2014-12-17 23:55:01	24	0
19	1	0	2014-12-08	31	119	0	0	174	0	0	1	0	2014-12-09 00:00:01	17	0
30	1	0	2014-12-20	5	15	0	0	34	7	0	0	0	2014-12-21 00:00:01	11	0
20	1	0	2014-12-09	33	105	0	0	195	0	0	6	0	2014-12-10 00:00:01	22	0
18	1	0	2014-12-07	3	19	0	0	45	0	0	0	0	2014-12-07 23:55:01	5	0
14	1	0	2014-12-03	15	75	0	0	94	0	0	2	0	2014-12-04 00:00:01	23	0
16	1	0	2014-12-05	84	96	0	0	258	0	0	3	0	2014-12-05 23:55:02	16	0
25	1	0	2014-12-15	31	96	0	0	20	0	0	1	0	2014-12-16 00:00:02	22	0
31	1	0	2014-12-21	1	9	0	0	37	9	0	0	0	2014-12-21 22:55:01	5	0
15	1	0	2014-12-04	82	123	0	0	294	0	0	3	0	2014-12-05 00:00:01	23	0
21	1	0	2014-12-10	24	178	0	0	107	0	0	1	0	2014-12-11 00:00:01	69	0
34	1	0	2014-12-24	22	67	0	0	74	11	0	135	0	2014-12-24 23:55:01	23	0
22	1	0	2014-12-11	52	174	0	0	115	0	0	0	0	2014-12-11 23:55:01	63	0
26	1	0	2014-12-16	36	181	0	0	72	0	0	9	0	2014-12-16 23:40:01	72	0
38	1	0	2014-12-28	10	4	0	0	8	10	0	146	0	2014-12-28 23:50:02	3	0
32	1	0	2014-12-22	0	95	0	0	69	5	0	1	0	2014-12-22 23:55:01	27	0
35	1	0	2014-12-25	15	16	0	0	21	13	0	102	0	2014-12-25 23:30:01	7	0
36	1	0	2014-12-26	10	18	0	0	13	11	0	126	0	2014-12-27 00:00:01	10	0
54	1	0	2015-01-13	32	101	0	0	88	16	1	120	0	2015-01-14 00:00:01	21	0
37	1	0	2014-12-27	4	4	0	0	6	7	0	122	0	2014-12-28 00:00:01	3	0
39	1	0	2014-12-29	10	79	0	0	26	10	0	118	0	2014-12-29 23:55:01	21	0
41	1	0	2014-12-31	10	48	0	0	32	10	0	148	0	2014-12-31 23:35:01	19	0
44	1	0	2015-01-03	2	6	0	0	64	11	0	124	0	2015-01-03 23:50:01	4	0
24	1	0	2014-12-13	13	8	0	0	17	0	0	1	0	2014-12-13 16:35:01	0	0
42	1	0	2015-01-01	4	7	0	0	1	6	0	168	0	2015-01-02 00:00:02	6	0
33	1	0	2014-12-23	16	101	0	0	99	9	0	45	1	2014-12-23 23:55:02	23	0
40	1	0	2014-12-30	16	75	0	0	32	8	0	62	0	2014-12-30 23:50:01	19	0
60	1	0	2015-01-19	42	102	0	0	41	9	1	357	0	2015-01-19 23:55:01	22	0
46	1	0	2015-01-05	19	73	0	0	73	8	0	43	0	2015-01-05 23:50:01	20	0
43	1	0	2015-01-02	2	13	0	0	8	8	0	150	0	2015-01-03 00:00:01	7	0
56	1	0	2015-01-15	35	73	0	0	76	10	0	98	0	2015-01-15 23:40:02	21	0
47	1	0	2015-01-06	34	97	0	0	233	14	0	10	0	2015-01-06 23:55:01	26	0
52	1	0	2015-01-11	5	7	0	0	38	10	1	134	0	2015-01-11 23:05:01	5	0
48	1	0	2015-01-07	48	123	0	0	185	6	0	19	0	2015-01-07 23:50:01	26	0
49	1	0	2015-01-08	42	130	0	0	102	8	0	12	0	2015-01-09 00:00:01	23	0
45	1	0	2015-01-04	2	15	0	0	32	8	0	174	0	2015-01-05 00:00:01	4	0
59	1	0	2015-01-18	17	10	0	0	12	9	0	261	0	2015-01-19 00:00:01	7	0
62	1	0	2015-01-21	54	76	0	0	102	8	0	4	0	2015-01-21 23:55:01	17	0
50	1	0	2015-01-09	43	94	0	0	57	8	0	196	0	2015-01-10 00:00:01	26	0
53	1	0	2015-01-12	11	129	0	0	41	12	0	84	0	2015-01-13 00:00:02	21	0
51	1	0	2015-01-10	23	27	0	0	16	9	0	462	0	2015-01-10 23:55:01	10	0
55	1	0	2015-01-14	41	126	0	0	83	13	0	342	0	2015-01-14 23:55:01	27	0
61	1	0	2015-01-20	58	152	0	0	78	7	1	174	0	2015-01-21 00:00:01	31	0
57	1	0	2015-01-16	43	74	0	0	100	12	0	122	0	2015-01-16 23:45:01	19	0
66	1	0	2015-01-25	22	7	0	0	20	9	0	99	0	2015-01-25 23:40:01	4	0
58	1	0	2015-01-17	27	10	0	0	28	8	0	272	0	2015-01-17 23:55:01	6	0
67	1	0	2015-01-26	65	97	0	0	66	3	0	422	0	2015-01-27 00:00:01	18	0
65	1	0	2015-01-24	36	14	0	0	28	7	0	74	0	2015-01-24 23:50:01	8	0
64	1	0	2015-01-23	60	102	0	0	78	9	0	70	0	2015-01-24 00:00:01	20	0
69	1	0	2015-01-28	78	134	0	0	58	7	0	215	0	2015-01-29 00:00:01	26	0
68	1	0	2015-01-27	51	111	0	0	55	14	0	342	0	2015-01-28 00:00:01	22	0
70	1	0	2015-01-29	68	103	0	0	75	3	0	150	0	2015-01-30 00:00:01	23	0
71	1	0	2015-01-30	61	97	0	0	93	9	0	95	0	2015-01-30 23:45:01	24	0
72	1	0	2015-01-31	40	12	0	0	18	9	0	132	0	2015-01-31 23:45:01	8	0
73	1	0	2015-02-01	9	12	0	0	40	6	0	145	0	2015-02-01 23:50:02	7	0
74	1	0	2015-02-02	60	165	0	0	52	10	0	104	0	2015-02-02 23:35:01	26	0
75	1	0	2015-02-03	46	124	0	0	77	16	1	151	0	2015-02-03 23:45:01	25	0
76	1	0	2015-02-04	50	125	0	0	82	13	3	130	0	2015-02-04 23:55:01	25	0
79	1	0	2015-02-07	29	11	0	0	38	18	0	225	0	2015-02-08 00:00:01	8	0
77	1	0	2015-02-05	49	110	0	0	75	17	1	92	0	2015-02-05 23:55:01	26	0
78	1	0	2015-02-06	29	111	0	0	72	12	0	176	0	2015-02-07 00:00:02	23	0
80	1	0	2015-02-08	6	8	0	0	29	16	0	2	0	2015-02-08 23:45:01	6	0
91	1	0	2015-02-19	55	123	0	0	57	18	1	9	0	2015-02-20 00:00:01	21	0
89	1	0	2015-02-17	20	22	0	0	122	21	0	15	0	2015-02-17 23:55:01	11	0
88	1	0	2015-02-16	11	5	0	0	148	36	0	38	0	2015-02-16 23:55:01	3	0
87	1	0	2015-02-15	10	5	0	0	28	27	0	71	0	2015-02-15 23:40:01	3	0
99	1	0	2015-02-27	31	77	0	0	46	24	0	202	0	2015-02-27 23:55:01	22	0
81	1	0	2015-02-09	69	113	0	0	224	14	0	0	0	2015-02-10 00:00:01	22	0
82	1	0	2015-02-10	86	121	0	0	113	10	0	27	0	2015-02-11 00:00:02	26	0
83	1	0	2015-02-11	30	137	0	0	51	15	0	22	0	2015-02-11 23:55:01	24	0
92	1	0	2015-02-20	24	70	0	0	110	17	0	10	0	2015-02-20 23:10:01	21	0
85	1	0	2015-02-13	46	115	0	0	132	13	0	168	0	2015-02-14 00:00:01	25	0
96	1	0	2015-02-24	56	135	0	0	98	12	0	350	0	2015-02-25 00:05:01	23	0
84	1	0	2015-02-12	52	135	0	0	144	17	0	46	0	2015-02-13 00:00:01	25	0
86	1	0	2015-02-14	24	11	0	0	29	23	0	255	0	2015-02-14 23:55:02	6	0
98	1	0	2015-02-26	69	112	0	0	37	19	0	205	0	2015-02-27 00:00:02	23	0
93	1	0	2015-02-21	31	22	0	0	23	16	0	2	0	2015-02-22 00:00:01	13	0
100	1	0	2015-02-28	11	15	0	0	35	20	0	24	0	2015-02-28 23:50:02	9	0
94	1	0	2015-02-22	14	10	0	0	24	17	0	1	0	2015-02-23 00:00:01	5	0
107	1	0	2015-03-07	14	8	0	0	27	11	0	44	0	2015-03-08 00:00:01	4	0
90	1	0	2015-02-18	35	149	0	0	64	23	0	0	0	2015-02-18 23:50:01	23	0
106	1	0	2015-03-06	46	99	0	0	110	22	0	55	0	2015-03-07 00:00:01	28	0
114	1	0	2015-03-14	49	25	0	0	27	11	0	34	0	2015-03-14 23:35:01	9	0
97	1	0	2015-02-25	60	146	0	0	47	23	0	16	0	2015-02-25 23:45:02	25	0
109	1	0	2015-03-09	31	126	0	0	83	23	0	8	0	2015-03-09 23:45:01	24	0
101	1	0	2015-03-01	17	13	0	0	22	16	0	16	0	2015-03-01 23:55:01	6	0
104	1	0	2015-03-04	51	107	0	0	70	22	0	293	0	2015-03-04 23:50:01	24	0
112	1	0	2015-03-12	84	111	0	0	64	8	0	65	0	2015-03-12 23:50:01	28	0
108	1	0	2015-03-08	8	8	0	0	17	10	0	42	0	2015-03-08 23:30:01	6	0
95	1	0	2015-02-23	64	153	0	0	38	24	0	120	0	2015-02-24 00:00:01	29	0
102	1	0	2015-03-02	83	154	0	0	37	17	0	14	0	2015-03-02 23:55:01	27	0
105	1	0	2015-03-05	69	109	0	0	97	15	0	68	0	2015-03-06 00:00:01	27	0
113	1	0	2015-03-13	66	96	0	0	42	14	0	48	0	2015-03-14 00:00:01	23	0
110	1	0	2015-03-10	64	153	0	0	53	13	0	88	0	2015-03-11 00:00:01	28	0
115	1	0	2015-03-15	20	10	0	0	62	9	0	12	0	2015-03-15 23:55:01	6	0
103	1	0	2015-03-03	94	116	0	0	95	12	0	90	0	2015-03-04 00:00:02	25	0
111	1	0	2015-03-11	72	154	0	0	129	7	0	54	0	2015-03-11 23:55:01	28	0
117	1	0	2014-03-16	0	0	0	0	0	0	0	4	0	2015-03-16 16:10:02	0	0
119	1	0	2015-03-18	58	120	0	0	59	8	0	40	0	2015-03-18 23:55:01	29	0
120	1	0	2015-03-19	53	87	0	0	56	9	0	30	0	2015-03-19 23:30:02	24	0
122	1	0	2015-03-21	28	12	0	0	54	11	0	25	0	2015-03-21 23:15:01	8	0
118	1	0	2015-03-17	39	164	0	0	118	14	0	28	0	2015-03-18 00:00:02	29	0
126	1	0	2015-03-25	62	103	0	0	63	10	0	81	0	2015-03-26 00:00:01	25	0
123	1	0	2015-03-22	9	10	0	0	9	5	0	24	0	2015-03-22 23:45:02	7	0
121	1	0	2015-03-20	36	100	0	0	44	1	0	22	0	2015-03-20 23:40:01	22	0
116	1	0	2015-03-16	54	146	0	0	103	17	0	247	0	2015-03-16 23:55:01	27	0
128	1	0	2015-03-27	50	140	0	4	69	22	0	26	0	2015-03-27 23:45:01	23	0
127	1	0	2015-03-26	28	116	0	0	84	20	0	1	0	2015-03-26 23:55:01	29	0
124	1	0	2015-03-23	33	124	0	0	62	7	0	24	0	2015-03-23 23:15:01	26	0
129	1	0	2015-03-28	17	9	0	0	23	11	0	43	0	2015-03-29 00:00:01	7	0
131	1	0	2015-03-30	44	138	0	0	76	20	0	42	0	2015-03-31 00:00:01	24	0
125	1	0	2015-03-24	60	118	0	0	58	15	0	318	0	2015-03-25 00:00:01	21	0
139	1	0	2015-04-07	56	105	0	0	99	5	0	47	0	2015-04-08 00:00:01	26	0
136	1	0	2015-04-04	8	13	0	0	28	12	0	68	0	2015-04-04 23:45:01	9	0
130	1	0	2015-03-29	9	9	0	0	49	15	0	42	0	2015-03-29 23:45:01	4	0
133	1	0	2015-04-01	52	108	0	0	103	18	0	42	0	2015-04-01 23:55:02	25	0
147	1	0	2015-04-15	64	143	0	0	134	12	5	6	0	2015-04-15 23:50:01	25	0
135	1	0	2015-04-03	19	11	0	0	39	11	0	68	0	2015-04-04 00:00:01	7	0
134	1	0	2015-04-02	61	109	0	0	133	22	0	40	0	2015-04-03 00:00:01	26	0
137	1	0	2015-04-05	11	4	0	0	24	12	0	30	0	2015-04-06 00:00:02	4	0
141	1	0	2015-04-09	46	108	0	0	121	28	2	141	0	2015-04-10 00:00:01	23	0
138	1	0	2015-04-06	52	109	0	0	91	5	0	34	0	2015-04-06 23:55:02	26	0
132	1	0	2015-03-31	59	219	0	0	82	30	0	62	1	2015-04-01 00:00:01	25	0
140	1	0	2015-04-08	32	124	0	0	265	34	1	88	0	2015-04-08 23:55:01	25	0
143	1	0	2015-04-11	13	18	0	0	50	9	0	20	0	2015-04-12 00:00:02	7	0
142	1	0	2015-04-10	60	94	0	0	99	5	2	183	0	2015-04-10 23:50:02	21	0
144	1	0	2015-04-12	6	10	0	0	37	6	0	0	0	2015-04-12 23:45:01	7	0
149	1	0	2015-04-17	41	90	0	0	123	34	0	28	0	2015-04-17 23:10:02	22	0
146	1	0	2015-04-14	65	116	0	0	209	49	0	4	0	2015-04-14 23:55:02	26	0
145	1	0	2015-04-13	62	96	0	0	116	8	0	0	0	2015-04-13 23:40:01	25	0
150	1	0	2015-04-18	22	16	0	0	11	4	0	42	0	2015-04-18 23:45:01	9	0
148	1	0	2015-04-16	52	103	0	0	75	28	3	4	0	2015-04-16 23:55:01	30	0
151	1	0	2015-04-19	12	5	0	0	14	11	0	40	0	2015-04-19 23:15:01	4	0
152	1	0	2015-04-20	68	98	0	0	40	10	0	45	0	2015-04-20 23:55:01	22	0
153	1	0	2015-04-21	77	101	0	0	220	5	2	63	0	2015-04-22 00:00:01	25	0
154	1	0	2015-04-22	59	94	0	0	67	1	6	143	0	2015-04-23 00:00:01	23	0
155	1	0	2015-04-23	59	101	0	0	55	5	0	281	0	2015-04-24 00:00:01	22	0
156	1	0	2015-04-24	47	106	0	0	106	6	0	376	0	2015-04-25 00:00:02	27	0
157	1	0	2015-04-25	25	15	0	0	8	5	0	174	0	2015-04-25 23:50:01	9	0
192	1	0	2015-05-30	0	0	0	0	0	0	0	0	0	\N	0	0
159	1	0	2015-04-27	57	110	0	0	47	13	2	45	0	2015-04-27 23:55:01	23	0
158	1	0	2015-04-26	11	10	0	0	7	8	0	74	0	2015-04-26 23:25:01	9	0
164	1	0	2015-05-02	22	11	0	0	7	8	0	38	0	2015-05-03 00:00:01	9	0
178	1	0	2015-05-16	12	19	0	0	17	2	0	0	0	2015-05-16 23:50:01	10	0
163	1	0	2015-05-01	23	15	0	0	9	4	0	98	0	2015-05-01 23:55:01	7	0
170	1	0	2015-05-08	58	123	0	0	21	8	0	81	0	2015-05-08 23:35:01	24	0
161	1	0	2015-04-29	48	126	0	0	72	7	9	51	0	2015-04-29 23:45:02	21	0
172	1	0	2015-05-10	28	19	0	0	22	10	0	1	0	2015-05-10 23:35:01	9	0
162	1	0	2015-04-30	35	152	0	0	51	14	0	76	0	2015-04-30 23:45:01	26	0
175	1	0	2015-05-13	55	136	0	0	86	13	0	0	0	2015-05-13 23:20:02	26	0
171	1	0	2015-05-09	21	20	0	0	27	2	0	0	0	2015-05-09 23:40:01	8	0
179	1	0	2015-05-17	15	11	0	0	33	16	0	0	0	2015-05-17 23:55:01	5	0
168	1	0	2015-05-06	47	104	0	0	97	8	0	60	0	2015-05-06 23:50:01	20	0
167	1	0	2015-05-05	32	132	0	0	106	5	0	83	0	2015-05-06 00:00:01	30	0
160	1	0	2015-04-28	73	111	0	0	113	28	3	45	0	2015-04-28 23:50:01	25	0
165	1	0	2015-05-03	6	12	0	0	12	6	0	10	0	2015-05-03 23:55:01	6	0
176	1	0	2015-05-14	38	143	0	0	42	15	0	1	0	2015-05-14 23:55:01	22	0
177	1	0	2015-05-15	41	141	0	0	101	13	0	2	0	2015-05-16 00:00:02	27	0
191	1	0	2015-05-29	31	88	0	0	66	6	0	35	0	2015-05-29 15:15:01	20	0
174	1	0	2015-05-12	50	187	0	0	79	17	0	21	0	2015-05-12 23:55:01	33	0
193	1	0	2015-05-31	0	0	0	0	0	0	0	0	0	\N	0	0
166	1	0	2015-05-04	31	136	0	0	69	4	0	50	0	2015-05-04 23:50:01	23	0
173	1	0	2015-05-11	63	152	0	0	55	6	0	28	0	2015-05-12 00:00:01	24	0
207	1	0	2015-06-13	16	14	0	0	31	5	0	0	0	2015-06-14 00:00:01	8	0
195	1	0	2014-06-01	0	0	0	0	2	0	0	0	0	2015-06-01 11:45:01	0	0
169	1	0	2015-05-07	39	125	0	0	82	9	0	331	0	2015-05-08 00:00:01	27	0
182	1	0	2015-05-20	62	123	0	0	115	30	0	2	0	2015-05-20 23:55:01	27	0
181	1	0	2015-05-19	93	163	0	0	75	41	0	187	0	2015-05-20 00:00:01	23	0
185	1	0	2015-05-23	11	13	0	0	15	7	0	154	0	2015-05-23 23:50:01	7	0
199	1	0	2015-06-05	62	121	0	0	59	9	0	0	0	2015-06-05 23:50:02	27	0
215	1	0	2015-06-21	9	17	0	0	30	8	1	0	0	2015-06-21 21:50:02	10	0
184	1	0	2015-05-22	61	101	0	0	65	14	0	276	0	2015-05-22 23:50:01	20	0
194	1	0	2015-06-01	61	169	0	0	62	6	0	5	0	2015-06-01 23:55:01	26	0
214	1	0	2015-06-20	16	12	0	0	43	9	0	6	0	2015-06-20 23:15:02	7	0
188	1	0	2015-05-26	28	143	0	0	133	9	0	170	0	2015-05-26 23:50:01	22	0
196	1	0	2015-06-02	59	117	0	0	57	8	0	0	0	2015-06-03 00:00:01	24	0
198	1	0	2015-06-04	55	141	0	0	51	4	0	5	0	2015-06-04 23:55:01	28	0
186	1	0	2015-05-24	18	8	0	0	7	4	0	244	0	2015-05-25 00:00:01	5	0
183	1	0	2015-05-21	47	133	0	0	89	10	0	173	0	2015-05-22 00:00:01	28	0
190	1	0	2015-05-28	44	122	0	0	143	16	0	339	0	2015-05-29 00:00:01	21	0
180	1	0	2015-05-18	49	151	0	0	97	23	0	104	0	2015-05-19 00:00:01	23	0
187	1	0	2015-05-25	48	132	0	0	95	5	0	319	0	2015-05-25 23:55:01	22	0
197	1	0	2015-06-03	58	136	0	1	68	6	0	0	0	2015-06-04 00:05:01	27	0
211	1	0	2015-06-17	74	132	0	0	37	10	0	0	0	2015-06-18 00:00:01	31	0
201	1	0	2015-06-07	13	21	0	0	33	10	0	2	0	2015-06-08 00:00:01	8	0
189	1	0	2015-05-27	77	175	0	0	169	3	0	108	0	2015-05-28 00:00:01	30	0
200	1	0	2015-06-06	25	31	0	0	35	4	0	0	0	2015-06-06 23:10:01	9	0
206	1	0	2015-06-12	48	111	0	0	33	4	0	131	0	2015-06-12 23:35:01	24	0
228	1	0	2015-07-04	14	22	0	0	22	11	0	56	0	2015-07-04 23:50:01	8	0
202	1	0	2015-06-08	83	154	0	0	38	8	0	92	0	2015-06-09 00:00:01	26	0
203	1	0	2015-06-09	51	151	0	0	87	6	0	63	0	2015-06-09 23:55:01	29	0
209	1	0	2015-06-15	87	146	0	0	51	9	0	11	0	2015-06-15 23:55:01	24	0
204	1	0	2015-06-10	93	169	0	1	94	7	0	14	0	2015-06-10 23:55:01	23	0
208	1	0	2015-06-14	9	15	0	0	21	6	0	0	0	2015-06-14 23:55:01	8	0
205	1	0	2015-06-11	55	117	0	0	64	6	0	57	0	2015-06-12 00:00:02	24	0
213	1	0	2015-06-19	38	120	0	0	45	4	0	0	0	2015-06-20 00:00:01	24	0
210	1	0	2015-06-16	99	140	0	0	69	7	0	6	1	2015-06-16 23:55:01	22	0
217	1	0	2015-06-23	66	123	0	0	41	5	0	1	0	2015-06-23 23:20:01	23	0
212	1	0	2015-06-18	63	130	0	0	63	6	0	0	0	2015-06-18 23:50:02	21	0
220	1	0	2015-06-26	57	124	0	0	13	12	0	48	0	2015-06-26 23:00:01	22	0
216	1	0	2015-06-22	69	114	0	0	9	5	0	0	0	2015-06-22 23:55:01	23	0
218	1	0	2015-06-24	65	131	0	0	31	8	0	0	0	2015-06-25 00:00:01	22	0
224	1	0	2015-06-30	102	148	0	0	49	5	0	293	0	2015-07-01 00:00:02	25	0
229	1	0	2015-07-05	25	18	0	0	16	9	0	136	0	2015-07-05 23:35:02	10	0
219	1	0	2015-06-25	72	91	0	0	39	9	0	42	0	2015-06-26 00:00:01	20	0
221	1	0	2015-06-27	26	12	0	0	20	8	0	42	0	2015-06-27 23:35:01	8	0
223	1	0	2015-06-29	73	145	0	0	27	12	0	56	0	2015-06-29 23:55:01	23	0
222	1	0	2015-06-28	30	18	0	0	14	11	0	54	0	2015-06-29 00:00:01	8	0
226	1	0	2015-07-02	42	115	0	0	59	12	0	8	0	2015-07-03 00:00:01	23	0
225	1	0	2015-07-01	75	106	0	0	56	7	0	31	0	2015-07-01 23:45:01	19	0
227	1	0	2015-07-03	58	91	0	0	43	8	0	8	0	2015-07-03 23:35:02	24	0
230	1	0	2015-07-06	37	82	0	0	24	12	0	96	0	2015-07-07 00:00:01	19	0
231	1	0	2015-07-07	35	71	0	0	54	13	0	4	0	2015-07-07 23:55:01	20	0
232	1	0	2015-07-08	55	153	0	0	35	22	0	28	0	2015-07-09 00:00:02	33	0
233	1	0	2015-07-09	41	148	0	0	30	5	0	35	0	2015-07-09 23:45:02	29	0
234	1	0	2015-07-10	48	129	0	0	49	0	0	6	0	2015-07-11 00:00:01	23	0
235	1	0	2015-07-11	19	25	0	0	34	1	0	10	0	2015-07-11 23:50:02	11	0
237	1	0	2015-07-13	46	137	0	0	21	14	0	66	0	2015-07-13 23:55:01	28	0
236	1	0	2015-07-12	27	18	0	0	19	8	3	0	0	2015-07-12 23:15:01	9	0
249	1	0	2015-07-25	20	12	0	0	23	11	0	0	0	2015-07-25 23:40:01	7	0
243	1	0	2015-07-19	10	18	0	0	14	5	0	0	0	2015-07-19 23:55:01	9	0
250	1	0	2015-07-26	8	13	0	0	10	8	1	0	0	2015-07-26 23:55:01	6	0
245	1	0	2015-07-21	61	117	0	0	30	18	0	32	0	2015-07-21 23:35:01	21	0
242	1	0	2015-07-18	29	18	0	0	22	6	0	11	0	2015-07-18 22:50:01	11	0
241	1	0	2015-07-17	51	91	0	0	39	8	0	144	0	2015-07-18 00:00:01	22	0
244	1	0	2015-07-20	71	111	0	0	18	21	0	14	0	2015-07-20 23:55:01	21	0
263	1	0	2015-08-08	21	10	0	0	24	13	0	0	0	2015-08-08 23:55:01	7	0
240	1	0	2015-07-16	40	140	0	0	38	12	0	191	0	2015-07-17 00:00:01	24	0
247	1	0	2015-07-23	53	126	0	0	24	8	0	34	0	2015-07-23 23:25:01	23	0
259	1	0	2015-08-04	68	135	0	0	54	7	0	0	0	2015-08-04 23:30:01	28	0
256	1	0	2015-08-01	22	29	0	0	50	11	0	42	0	2015-08-01 23:45:01	20	0
248	1	0	2015-07-24	45	115	0	0	32	13	0	36	0	2015-07-24 23:55:01	25	0
264	1	0	2015-08-09	15	9	0	0	11	2	0	0	0	2015-08-09 23:50:01	5	0
239	1	0	2015-07-15	90	157	0	0	29	7	0	160	0	2015-07-15 23:50:01	29	0
246	1	0	2015-07-22	63	120	0	0	30	13	0	100	0	2015-07-22 23:55:01	27	0
238	1	0	2015-07-14	36	128	0	0	42	5	0	121	0	2015-07-14 23:50:01	22	0
255	1	0	2015-07-31	34	116	0	0	31	17	0	53	0	2015-07-31 23:15:01	25	0
261	1	0	2015-08-06	60	144	0	0	43	8	0	2	0	2015-08-06 23:50:01	24	0
251	1	0	2015-07-27	49	91	0	0	26	8	0	0	0	2015-07-27 23:50:01	22	0
252	1	0	2015-07-28	83	122	0	0	33	10	0	0	0	2015-07-29 00:00:01	27	0
254	1	0	2015-07-30	64	181	0	0	32	7	0	13	0	2015-07-30 23:15:02	22	0
274	1	0	2015-08-19	86	97	0	0	46	5	0	0	0	2015-08-19 23:35:01	21	0
253	1	0	2015-07-29	68	144	0	0	30	16	0	13	0	2015-07-29 23:25:01	22	0
270	1	0	2015-08-15	23	12	0	0	33	3	0	0	0	2015-08-15 23:55:01	7	0
257	1	0	2015-08-02	10	19	0	0	8	10	0	40	0	2015-08-02 23:40:01	11	0
260	1	0	2015-08-05	49	142	0	0	44	15	1	7	0	2015-08-06 00:00:02	25	0
265	1	0	2015-08-10	24	29	0	0	18	4	0	12	0	2015-08-10 23:55:01	10	0
271	1	0	2015-08-16	9	11	0	0	8	2	0	0	0	2015-08-16 23:55:01	6	0
268	1	0	2015-08-13	66	112	0	0	48	6	0	3	0	2015-08-14 00:00:01	23	0
262	1	0	2015-08-07	74	90	0	0	20	8	0	0	0	2015-08-08 00:00:01	22	0
258	1	0	2015-08-03	44	108	0	0	37	10	0	28	0	2015-08-03 23:40:01	26	0
267	1	0	2015-08-12	44	126	0	0	79	4	0	0	0	2015-08-12 23:40:01	20	0
269	1	0	2015-08-14	63	104	0	0	37	3	0	0	0	2015-08-15 00:00:01	22	0
276	1	0	2015-08-21	66	111	0	0	23	11	0	0	0	2015-08-21 23:20:01	20	0
273	1	0	2015-08-18	63	124	0	0	52	6	0	0	0	2015-08-19 00:00:02	24	0
266	1	0	2015-08-11	52	142	0	0	60	14	1	0	0	2015-08-11 23:50:01	19	0
272	1	0	2015-08-17	87	111	0	0	22	4	0	0	0	2015-08-18 00:00:01	21	0
275	1	0	2015-08-20	62	87	0	0	45	12	0	0	0	2015-08-20 23:45:01	20	0
305	1	0	2015-09-19	25	16	0	0	17	9	0	0	0	2015-09-19 22:55:01	8	0
280	1	0	2015-08-25	97	117	0	0	43	13	0	6	0	2015-08-26 00:00:01	26	0
278	1	0	2015-08-23	20	11	0	0	19	7	0	0	0	2015-08-23 23:20:01	5	0
284	1	0	2015-08-29	15	19	0	0	25	15	0	0	0	2015-08-29 23:55:01	7	0
279	1	0	2015-08-24	58	101	0	0	32	17	0	2	0	2015-08-24 23:55:01	23	0
277	1	0	2015-08-22	23	21	0	0	32	11	0	5	0	2015-08-22 23:20:01	19	0
283	1	0	2015-08-28	84	105	0	0	43	3	0	0	0	2015-08-28 23:50:01	21	0
290	1	0	2015-09-04	34	102	0	0	30	15	0	0	0	2015-09-05 00:00:02	18	0
281	1	0	2015-08-26	84	128	0	0	41	7	0	5	0	2015-08-27 00:00:01	22	0
282	1	0	2015-08-27	69	122	0	0	31	13	0	0	0	2015-08-27 23:55:01	22	0
291	1	0	2015-09-05	13	18	0	0	18	9	0	8	0	2015-09-05 23:20:01	10	0
289	1	0	2015-09-03	102	102	0	0	44	9	0	0	0	2015-09-04 00:00:01	25	0
285	1	0	2015-08-30	39	13	0	0	35	10	0	1	0	2015-08-30 23:45:01	9	0
286	1	0	2015-08-31	65	124	0	0	39	8	0	1	0	2015-09-01 00:00:01	23	0
294	1	0	2015-09-08	101	146	0	0	51	28	0	69	0	2015-09-09 00:00:01	25	0
288	1	0	2015-09-02	61	123	0	0	61	4	0	1	0	2015-09-03 00:00:01	22	0
287	1	0	2015-09-01	103	111	0	0	45	17	0	1	0	2015-09-01 23:55:01	24	0
297	1	0	2015-09-11	77	100	0	0	36	1	0	23	0	2015-09-11 23:55:01	24	0
293	1	0	2015-09-07	68	116	0	0	28	18	0	5	0	2015-09-08 00:00:01	26	0
292	1	0	2015-09-06	24	12	0	0	11	10	0	4	0	2015-09-06 23:55:01	7	0
298	1	0	2015-09-12	24	38	0	0	11	6	0	25	0	2015-09-12 23:45:01	12	0
300	1	0	2015-09-14	88	114	0	0	33	7	0	25	0	2015-09-15 00:00:02	24	0
303	1	0	2015-09-17	69	123	0	0	30	24	0	0	0	2015-09-18 00:00:01	24	0
295	1	0	2015-09-09	52	90	0	0	17	16	0	40	0	2015-09-10 00:00:01	22	0
307	1	0	2015-09-21	64	138	0	0	14	18	0	0	0	2015-09-21 23:55:01	26	0
296	1	0	2015-09-10	116	123	0	0	43	13	0	8	0	2015-09-11 00:00:01	21	0
301	1	0	2015-09-15	76	127	0	0	30	14	0	21	0	2015-09-16 00:00:01	24	0
299	1	0	2015-09-13	23	12	0	0	5	6	0	24	0	2015-09-13 23:55:01	6	0
302	1	0	2015-09-16	98	128	0	0	35	31	0	1	0	2015-09-16 23:55:01	24	0
312	1	0	2015-09-26	17	14	0	0	14	0	0	10	0	2015-09-26 22:30:01	7	0
304	1	0	2015-09-18	88	95	0	0	29	7	0	0	0	2015-09-18 23:50:01	23	0
306	1	0	2015-09-20	18	7	0	0	23	12	0	0	0	2015-09-21 00:00:01	4	0
308	1	0	2015-09-22	61	150	0	0	29	11	0	0	0	2015-09-22 23:40:01	23	0
309	1	0	2015-09-23	105	127	0	0	37	3	0	0	0	2015-09-23 23:55:01	26	0
310	1	0	2015-09-24	84	135	0	0	21	1	0	0	0	2015-09-24 23:55:01	24	0
311	1	0	2015-09-25	67	100	0	0	28	7	0	0	0	2015-09-25 23:45:01	19	0
313	1	0	2015-09-27	37	21	0	0	7	0	0	0	0	2015-09-27 23:50:01	8	0
314	1	0	2015-09-28	88	147	0	0	36	7	0	2	0	2015-09-28 23:50:01	32	0
324	1	0	2015-10-08	106	148	0	1	23	1	1	3	0	2015-10-09 00:00:01	25	0
317	1	0	2015-10-01	59	131	0	0	27	6	0	0	0	2015-10-01 23:50:01	25	0
315	1	0	2015-09-29	109	199	0	0	52	11	0	2	0	2015-09-29 23:50:01	27	0
316	1	0	2015-09-30	115	179	0	0	38	4	0	0	0	2015-09-30 23:50:01	26	0
318	1	0	2015-10-02	64	98	0	0	44	0	0	0	0	2015-10-03 00:00:01	19	0
320	1	0	2015-10-04	73	15	0	0	8	15	0	8	0	2015-10-04 23:55:01	10	0
323	1	0	2015-10-07	134	166	0	0	36	2	0	2	0	2015-10-08 00:00:01	27	0
322	1	0	2015-10-06	123	156	0	0	69	0	0	12	0	2015-10-06 23:55:01	24	0
326	1	0	2015-10-10	37	11	0	0	18	2	0	1	0	2015-10-10 23:35:01	7	0
349	1	0	2015-11-02	28	8	0	0	1	0	0	1	0	2015-11-02 22:30:01	5	0
332	1	0	2015-10-16	104	109	0	0	26	2	0	4	0	2015-10-16 23:30:01	19	0
319	1	0	2015-10-03	39	18	0	0	25	6	0	3	0	2015-10-04 00:00:01	9	0
325	1	0	2015-10-09	43	15	0	0	22	5	0	0	0	2015-10-10 00:00:01	11	0
330	1	0	2015-10-14	78	157	0	0	48	0	0	7	0	2015-10-15 00:00:01	22	0
329	1	0	2015-10-13	85	144	0	0	68	0	0	3	0	2015-10-13 23:55:01	30	0
327	1	0	2015-10-11	26	16	0	0	16	1	0	0	0	2015-10-11 23:50:01	10	0
321	1	0	2015-10-05	111	185	0	0	39	6	0	0	0	2015-10-05 23:55:01	26	0
331	1	0	2015-10-15	91	115	0	0	65	2	0	1	0	2015-10-16 00:00:01	24	0
328	1	0	2015-10-12	125	148	0	0	27	2	0	14	0	2015-10-12 23:55:01	27	0
334	1	0	2015-10-18	31	15	0	0	13	5	0	0	0	2015-10-18 23:35:01	10	0
340	1	0	2015-10-24	31	10	0	0	27	0	0	9	0	2015-10-25 00:00:01	7	0
333	1	0	2015-10-17	26	19	0	0	23	9	0	3	0	2015-10-17 23:10:01	10	0
348	1	0	2015-11-01	58	12	0	0	1	1	0	3	0	2015-11-02 00:00:01	5	0
382	1	0	2015-12-05	54	17	0	0	2	18	0	0	0	2015-12-05 23:25:01	8	0
361	1	0	2015-11-14	61	21	0	0	2	0	0	2	0	2015-11-14 23:40:01	11	0
339	1	0	2015-10-23	94	91	0	0	41	1	0	11	0	2015-10-23 23:40:01	20	0
338	1	0	2015-10-22	143	130	0	0	40	0	0	0	0	2015-10-23 00:00:01	25	0
341	1	0	2015-10-25	35	15	0	0	17	0	0	5	0	2015-10-25 23:55:01	7	0
335	1	0	2015-10-19	98	152	0	0	50	1	0	1	0	2015-10-19 23:50:01	23	0
342	1	0	2015-10-26	140	117	0	0	5	0	0	4	0	2015-10-27 00:00:01	21	0
336	1	0	2015-10-20	86	142	0	0	32	2	0	3	0	2015-10-20 23:55:01	21	0
337	1	0	2015-10-21	90	117	0	0	31	0	0	4	0	2015-10-22 00:00:01	21	0
354	1	0	2015-11-07	59	9	0	0	2	1	0	0	0	2015-11-07 23:40:01	7	0
369	1	0	2015-11-22	78	17	0	0	1	0	0	387	0	2015-11-22 23:45:02	8	0
343	1	0	2015-10-27	108	133	0	0	2	0	0	0	0	2015-10-27 23:50:01	24	0
347	1	0	2015-10-31	65	27	0	0	1	1	0	9	0	2015-10-31 23:45:01	12	0
346	1	0	2015-10-30	135	102	0	0	6	0	0	5	0	2015-10-31 00:00:01	23	0
355	1	0	2015-11-08	52	5	0	0	0	4	0	0	0	2015-11-08 22:50:01	4	0
344	1	0	2015-10-28	155	155	0	0	5	0	0	0	0	2015-10-29 00:00:01	22	0
353	1	0	2015-11-06	107	115	0	0	2	0	0	0	0	2015-11-07 00:00:01	22	0
345	1	0	2015-10-29	145	161	0	0	3	1	0	0	0	2015-10-30 00:00:01	23	0
352	1	0	2015-11-05	108	146	0	0	2	0	0	0	0	2015-11-05 23:55:01	25	0
350	1	0	2015-11-03	65	19	0	0	0	0	0	0	0	2015-11-04 00:00:01	7	0
351	1	0	2015-11-04	147	146	0	0	1	0	0	0	0	2015-11-05 00:00:01	29	0
365	1	0	2015-11-18	127	166	0	0	5	0	0	0	0	2015-11-18 23:55:01	30	0
359	1	0	2015-11-12	150	134	0	0	11	0	0	0	0	2015-11-12 23:55:01	25	0
384	1	0	2015-12-07	86	118	0	0	10	10	0	28	0	2015-12-07 23:55:02	21	0
356	1	0	2015-11-09	98	168	0	0	5	0	0	0	0	2015-11-09 23:55:01	24	0
364	1	0	2015-11-17	110	135	0	0	5	0	0	0	0	2015-11-17 23:55:01	24	0
362	1	0	2015-11-15	37	20	0	0	0	0	0	0	0	2015-11-15 23:50:01	6	0
358	1	0	2015-11-11	158	129	0	1	5	1	0	1	0	2015-11-11 23:35:01	25	0
357	1	0	2015-11-10	143	159	0	0	4	0	0	0	0	2015-11-11 00:00:01	24	0
360	1	0	2015-11-13	118	203	0	0	7	3	0	0	0	2015-11-14 00:00:01	25	0
366	1	0	2015-11-19	137	142	0	0	7	0	0	0	0	2015-11-20 00:00:01	24	0
370	1	0	2015-11-23	105	133	0	0	0	0	0	653	0	2015-11-24 00:00:02	28	0
363	1	0	2015-11-16	154	165	0	0	1	0	0	0	0	2015-11-17 00:00:01	25	0
367	1	0	2015-11-20	95	129	0	0	1	3	0	4	0	2015-11-20 23:50:01	23	0
371	1	0	2015-11-24	146	126	0	0	4	1	0	501	0	2015-11-25 00:00:01	22	0
376	1	0	2015-11-29	40	12	0	0	2	9	0	111	0	2015-11-29 23:55:01	5	0
368	1	0	2015-11-21	69	20	0	0	5	2	0	263	0	2015-11-21 23:50:01	10	0
375	1	0	2015-11-28	31	30	0	0	1	3	0	114	0	2015-11-29 00:00:01	11	0
372	1	0	2015-11-25	167	125	0	0	2	0	0	527	0	2015-11-25 23:55:01	30	0
373	1	0	2015-11-26	126	135	0	0	0	3	0	313	0	2015-11-27 00:00:02	22	0
379	1	0	2015-12-02	205	164	0	0	2	18	0	1	0	2015-12-02 23:55:01	26	0
378	1	0	2015-12-01	192	116	0	0	1	12	0	0	0	2015-12-01 23:50:01	24	0
374	1	0	2015-11-27	159	173	0	0	1	0	0	164	0	2015-11-28 00:00:01	28	0
377	1	0	2015-11-30	124	166	0	0	7	24	0	41	0	2015-11-30 23:55:01	26	0
380	1	0	2015-12-03	175	119	0	0	7	13	0	0	0	2015-12-04 00:00:01	23	0
381	1	0	2015-12-04	93	103	0	0	5	18	0	0	0	2015-12-05 00:00:01	24	0
385	1	0	2015-12-08	139	135	0	0	8	3	0	220	0	2015-12-08 23:55:01	24	0
383	1	0	2015-12-06	55	9	0	0	0	12	0	18	0	2015-12-06 23:45:01	6	0
386	1	0	2015-12-09	145	141	0	0	0	2	0	0	0	2015-12-09 23:50:01	27	0
388	1	0	2015-12-11	164	110	0	0	6	0	0	4	0	2015-12-12 00:00:02	24	0
391	1	0	2015-12-14	155	100	0	0	2	3	0	420	0	2015-12-15 00:00:01	23	0
387	1	0	2015-12-10	159	125	0	0	10	4	0	0	0	2015-12-11 00:00:01	21	0
389	1	0	2015-12-12	70	22	0	0	2	3	0	205	0	2015-12-13 00:00:01	11	0
390	1	0	2015-12-13	38	13	0	0	0	1	0	404	0	2015-12-14 00:00:01	11	0
399	1	0	2015-12-22	111	67	0	0	7	0	0	0	0	2015-12-22 18:10:01	18	0
393	1	0	2015-12-16	147	114	0	0	11	1	0	7	0	2015-12-16 23:55:01	27	0
395	1	0	2015-12-18	136	109	0	0	3	0	0	0	0	2015-12-18 23:40:01	24	0
401	1	0	2015-12-24	72	107	0	2	2	2	1	0	0	2015-12-24 23:15:01	27	0
394	1	0	2015-12-17	153	109	0	0	1	0	0	0	0	2015-12-18 00:00:01	28	0
396	1	0	2015-12-19	68	18	0	0	1	0	1	0	0	2015-12-19 23:55:01	8	0
397	1	0	2015-12-20	56	18	0	0	0	0	0	0	0	2015-12-20 23:40:01	11	0
398	1	0	2015-12-21	123	98	0	3	0	1	0	0	0	2015-12-22 00:00:01	21	0
392	1	0	2015-12-15	160	98	0	0	2	0	0	333	0	2015-12-16 00:00:01	22	0
400	1	0	2015-12-23	78	134	0	0	2	1	0	0	0	2015-12-23 23:55:01	29	0
402	1	0	2015-12-25	32	14	0	0	2	4	0	0	0	2015-12-25 23:25:01	10	0
410	1	0	2016-01-02	20	10	0	1	1	1	0	0	0	2016-01-03 00:00:01	5	0
403	1	0	2015-12-26	31	14	0	0	0	2	0	0	0	2015-12-27 00:00:01	10	0
405	1	0	2015-12-28	127	117	0	1	0	2	0	56	0	2015-12-29 00:00:01	24	0
407	1	0	2015-12-30	127	109	0	0	0	1	0	0	0	2015-12-31 00:00:01	24	0
408	1	0	2015-12-31	57	46	0	0	0	1	0	0	0	2015-12-31 23:50:01	15	0
409	1	0	2016-01-01	11	11	0	2	0	0	0	0	0	2016-01-01 23:20:01	5	0
424	1	0	2016-01-16	49	24	0	0	1	5	0	0	0	2016-01-16 23:40:01	10	0
404	1	0	2015-12-27	30	6	0	0	3	0	0	4	0	2015-12-28 00:00:01	4	0
423	1	0	2016-01-15	148	119	0	0	2	0	2	22	0	2016-01-15 23:55:01	30	0
406	1	0	2015-12-29	92	100	0	2	1	3	0	13	0	2015-12-30 00:00:01	21	0
421	1	0	2016-01-13	112	102	0	0	6	6	0	18	0	2016-01-13 23:25:01	26	0
416	1	0	2016-01-08	98	98	0	0	2	0	0	0	0	2016-01-08 23:55:01	23	0
415	1	0	2016-01-07	134	104	0	2	2	8	2	0	0	2016-01-07 23:35:01	23	0
411	1	0	2016-01-03	44	16	0	0	0	1	0	0	0	2016-01-04 00:00:01	8	0
413	1	0	2016-01-05	137	139	0	0	2	4	2	61	0	2016-01-05 23:35:01	23	0
419	1	0	2016-01-11	136	115	0	0	3	0	1	61	0	2016-01-11 23:55:01	26	0
412	1	0	2016-01-04	112	130	0	1	1	7	0	0	0	2016-01-04 23:45:01	29	0
417	1	0	2016-01-09	68	22	0	2	0	1	0	10	0	2016-01-09 23:30:01	10	0
422	1	0	2016-01-14	158	152	0	0	5	5	0	0	0	2016-01-14 23:45:02	30	0
414	1	0	2016-01-06	139	112	0	0	3	4	0	0	0	2016-01-06 23:50:01	26	0
420	1	0	2016-01-12	151	138	0	0	7	0	0	53	0	2016-01-13 00:00:01	25	0
431	1	0	2016-01-23	76	22	0	0	0	0	0	0	0	2016-01-23 23:30:01	12	0
432	1	0	2016-01-24	35	13	0	0	0	0	0	0	0	2016-01-25 00:00:02	7	0
429	1	0	2016-01-21	154	144	0	0	7	0	0	22	0	2016-01-21 23:40:01	28	0
425	1	0	2016-01-17	58	17	0	0	0	0	0	0	0	2016-01-17 23:35:01	9	0
418	1	0	2016-01-10	33	17	0	0	3	4	0	34	0	2016-01-10 23:20:01	9	0
441	1	0	2016-02-02	153	199	0	0	5	4	1	269	0	2016-02-03 00:00:01	27	0
430	1	0	2016-01-22	138	131	0	0	17	1	0	0	0	2016-01-22 23:45:01	26	0
452	1	0	2016-02-13	41	51	0	0	4	0	0	135	0	2016-02-13 23:50:01	21	0
447	1	0	2016-02-08	25	31	0	0	4	0	0	401	0	2016-02-09 00:00:01	14	0
426	1	0	2016-01-18	151	196	0	1	6	1	0	0	0	2016-01-18 23:50:01	30	0
428	1	0	2016-01-20	143	146	0	0	2	0	0	0	0	2016-01-20 23:55:01	35	0
427	1	0	2016-01-19	158	181	0	1	7	0	0	0	0	2016-01-19 23:40:01	28	0
436	1	0	2016-01-28	130	153	0	1	5	7	0	0	0	2016-01-28 23:55:01	27	0
457	1	0	2016-02-18	131	164	0	0	18	2	0	998	0	2016-02-19 00:00:01	33	0
442	1	0	2016-02-03	144	173	0	0	5	0	0	1582	0	2016-02-03 23:50:01	31	0
443	1	0	2016-02-04	191	214	0	0	12	8	0	252	0	2016-02-05 00:00:01	46	0
437	1	0	2016-01-29	108	164	0	0	3	1	0	0	0	2016-01-29 23:55:01	39	0
435	1	0	2016-01-27	162	156	0	0	2	0	0	0	0	2016-01-27 23:30:01	25	0
446	1	0	2016-02-07	42	11	0	0	0	0	0	207	0	2016-02-08 00:00:01	7	0
434	1	0	2016-01-26	151	160	0	1	23	0	0	0	0	2016-01-27 00:00:01	26	0
448	1	0	2016-02-09	49	23	0	0	3	0	0	722	0	2016-02-10 00:00:01	11	0
444	1	0	2016-02-05	138	184	0	0	3	1	0	314	0	2016-02-06 00:00:01	29	0
433	1	0	2016-01-25	124	170	0	1	18	1	0	0	0	2016-01-26 00:00:01	28	0
440	1	0	2016-02-01	117	181	0	0	13	3	0	60	0	2016-02-01 23:50:01	33	0
453	1	0	2016-02-14	20	13	0	0	3	2	0	6	0	2016-02-15 00:00:01	6	0
451	1	0	2016-02-12	106	156	0	0	18	0	0	321	0	2016-02-13 00:00:01	24	0
439	1	0	2016-01-31	61	31	0	0	1	1	0	465	0	2016-02-01 00:00:01	11	0
449	1	0	2016-02-10	122	190	0	0	19	1	0	3215	0	2016-02-11 00:00:03	34	0
438	1	0	2016-01-30	56	35	0	0	0	0	0	94	0	2016-01-31 00:00:01	13	0
454	1	0	2016-02-15	150	221	0	0	9	1	0	218	0	2016-02-16 00:00:01	29	0
450	1	0	2016-02-11	115	167	0	0	19	3	0	317	0	2016-02-11 23:55:02	35	0
463	1	0	2016-02-24	179	152	0	0	14	10	0	383	0	2016-02-25 00:00:01	20	0
445	1	0	2016-02-06	49	23	0	0	0	0	0	501	0	2016-02-06 23:50:01	7	0
455	1	0	2016-02-16	157	191	0	0	10	2	0	3529	0	2016-02-17 00:00:02	26	0
456	1	0	2016-02-17	169	149	0	0	20	4	0	346	0	2016-02-18 00:00:01	23	0
458	1	0	2016-02-19	123	169	0	0	13	6	0	2373	0	2016-02-20 00:00:01	29	0
459	1	0	2016-02-20	64	28	0	0	0	0	0	168	0	2016-02-20 23:35:01	13	0
460	1	0	2016-02-21	39	10	0	0	1	1	0	74	0	2016-02-21 23:55:01	6	0
461	1	0	2016-02-22	163	220	0	0	6	4	0	40	0	2016-02-23 00:00:01	31	0
462	1	0	2016-02-23	162	185	0	0	17	14	0	1731	0	2016-02-24 00:00:02	31	0
465	1	0	2016-02-26	85	135	0	0	18	7	0	2539	0	2016-02-27 00:00:02	25	0
464	1	0	2016-02-25	95	176	0	0	11	6	0	457	0	2016-02-26 00:00:01	27	0
468	1	0	2016-02-29	103	183	0	0	9	9	0	22	0	2016-02-29 23:55:01	30	0
466	1	0	2016-02-27	54	26	0	0	8	4	0	1060	0	2016-02-27 23:45:01	13	0
467	1	0	2016-02-28	78	19	0	0	3	1	0	291	0	2016-02-28 23:45:01	8	0
472	1	0	2016-03-04	104	137	0	0	5	0	0	333	0	2016-03-05 00:00:01	25	0
481	1	0	2016-03-13	68	39	0	0	10	2	0	65	0	2016-03-13 23:50:01	17	0
474	1	0	2016-03-06	37	19	0	0	0	0	0	323	0	2016-03-06 23:50:06	11	0
469	1	0	2016-03-01	128	175	0	0	14	11	0	52	0	2016-03-02 00:00:01	27	0
482	1	0	2016-03-14	85	213	0	0	15	4	0	58	0	2016-03-14 23:55:01	30	0
470	1	0	2016-03-02	129	182	0	0	19	9	1	164	0	2016-03-03 00:00:01	25	0
477	1	0	2016-03-09	107	173	0	0	8	9	0	1732	0	2016-03-10 00:00:01	31	0
479	1	0	2016-03-11	102	139	0	0	17	0	0	189	0	2016-03-11 23:55:01	26	0
473	1	0	2016-03-05	43	27	0	0	3	0	0	52	0	2016-03-05 23:55:02	9	0
480	1	0	2016-03-12	52	30	0	0	11	0	0	69	0	2016-03-13 00:00:01	14	0
475	1	0	2016-03-07	133	205	0	0	25	7	0	166	0	2016-03-07 23:55:01	30	0
471	1	0	2016-03-03	135	189	0	0	16	11	0	2855	0	2016-03-03 23:50:01	37	0
478	1	0	2016-03-10	91	160	0	0	7	1	0	179	0	2016-03-11 00:00:01	26	0
476	1	0	2016-03-08	119	181	0	0	18	15	0	1751	0	2016-03-09 00:00:02	28	0
483	1	0	2016-03-15	128	195	0	0	13	0	3	1937	0	2016-03-16 00:00:02	26	0
484	1	0	2016-03-16	70	103	0	0	14	0	0	2184	0	2016-03-16 15:50:04	0	0
\.


--
-- Data for Name: helo_access; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY helo_access (id, hostname, access) FROM stdin;
\.


--
-- Data for Name: ipaliases; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY ipaliases (id, ipnetwork, interface, comment) FROM stdin;
\.


--
-- Data for Name: ippool_members; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY ippool_members (id, poolname, ip, helo) FROM stdin;
\.


--
-- Data for Name: ippools; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY ippools (id, name, ismain, comment) FROM stdin;
1	Main Pool	t	Default Pool
\.


--
-- Data for Name: mailaddr; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY mailaddr (id, priority, email) FROM stdin;
1	12	pafreire@bce.ec
2	2	@bce.ec
3	4	@aeroseguros.com.ec
4	12	easalgad@pichincha.com
5	12	dibrafi@gmail.com
6	12	carvajal72@hotmail.com
7	2	@switchorm.com
10	4	@14demarzo.fin.ec
9	12	greis_maybe@hotmail.com
11	12	marthamaria7010@yahoo.es
12	4	@cosede.gob.ec
13	4	@uaf.gob.ec
14	12	sharon_gongora@hotmail.com
15	2	@maildirecto.org
16	12	beto1711@hotmail.com
17	14	jespinosa@14demarzo.fin.ec
18	14	dominiqueferrin@dominiqueferri.onmicrosoft.com
19	12	webmaster@ecuafituri.com
20	2	@ecuafituri.com
21	12	paolaximenapch03@gmail.com
22	2	@elcomercio.com
23	12	webmaster@maildirecto.info
24	14	revision@polygraph.com.ec
25	4	@polygraph.com.ec
26	4	@ferrindominique1.onmicrosoft.com
27	14	dominiqueferrin@ferrindominique1.onmicrosoft.com
28	12	domreg@nic.ec
29	12	webmaster@mailingecuador.org
30	2	@mailingecuador.org
31	12	news@mailingecuador.net
32	2	@mailingecuador.net
33	14	ventas@sendmenow.com.ec
34	4	@sendmenow.com.ec
35	16	performiaec@multi235.postfix.bmsend.com
36	6	@multi235.postfix.bmsend.com
37	14	marketing@kruger.com.ec
38	4	@kruger.com.ec
39	16	performiaec@multi241.postfix.bmsend.com
40	6	@multi241.postfix.bmsend.com
41	2	@maildirecto.info
42	12	news@maildirecto.info
43	2	@masmail.info
44	12	webmaster@masmail.info
45	2	@mailingecuador.info
46	16	d.ferrin16@doferrin.onmicrosoft.com
47	4	@doferrin.onmicrosoft.com
48	12	noreplay@maildirecto.net
49	2	@maildirecto.net
50	16	jerome.belcourt@don697.onmicrosoft.com
51	4	@don697.onmicrosoft.com
52	12	gerencia@revistamail.com
53	12	noreply@twoomail.com
54	2	@twoomail.com
55	12	acct@madsender.info
56	2	@madsender.info
57	2	@mad-sender.com
58	12	acct@mad-sender.com
59	2	@madsender.net
60	12	acct@madsender.net
61	14	christophe.belcourt02@gmail.com
62	2	@infotrillonario.com
63	12	gerencia@infotrillonario.com
64	2	@inter-chat.com
65	2	@empresasec.com
66	2	@ecuadornoticias.net
67	2	@news-trillonario.com
68	2	@gruporamosyasociados.com
69	2	@datos-ec.com
70	4	@bbm.com.ec
71	2	@seminarios-talleres.com
72	2	@matrizclara.com
73	2	@infoplazaecuador.club
74	2	@mercomailing.com
75	2	@acitus.com
\.


--
-- Data for Name: mynetworks; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY mynetworks (id, cidr, comment, lastmodified) FROM stdin;
1	127.0.0.0/8	\N	2014-11-20 08:41:49
2	192.0.0.3/32	ZIMBRA	2014-12-08 09:47:47
3	192.168.25.196/32	COPIADORA STO. DOMINGO	2015-01-28 17:17:04
4	192.168.22.51/32	COPIADORA AMAGUA&Ntilde;A	2015-01-28 17:17:39
5	192.168.28.51/32	COPIADORA GUAMANI	2015-01-28 17:18:02
6	192.0.0.151/32	COPIADORA MATRIZ	2015-01-28 17:18:36
\.


--
-- Data for Name: netip; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY netip (id, cidr, comment, lastmodified, section, access, tld) FROM stdin;
1	192.0.0.3/32	ZIMBRA	2014-12-08 10:51:31	whiteip	FILTER smtp-amavis:[127.0.0.1]:10027	\N
\.


--
-- Data for Name: permissions; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY permissions (id, parent_id, menu, url, weight) FROM stdin;
1	\N	t	license.php	1
2	\N	t	viruses.php	2
3	\N	t	sa-settings.php	3
4	\N	t	passwd.php	4
5	\N	t	gwblist.php?wbtype=B	5
6	\N	t	manage-quarantine.php	6
7	\N	t	syscmds.php	7
8	\N	t	logs.php	8
9	\N	t	cluster.php	9
10	1	f	license.php	1
11	1	f	setup-network.php	2
12	1	f	setup-time.php	3
13	1	f	setup-relay.php	4
14	1	f	ratecontrol.php	5
15	1	f	updates.php	6
16	1	f	setup-shutdown.php	7
17	2	f	viruses.php	1
18	2	f	spamfilter.php	2
19	2	f	banned.php	3
20	2	f	contentfilter.php	4
21	3	f	sa-settings.php	1
22	3	f	sa-policies.php	2
23	3	f	sa-userpolicies.php	3
24	3	f	roles.php	4
25	3	f	admins.php	5
26	3	f	realms.php	6
27	4	f	passwd.php	1
28	4	f	ui.php	2
29	4	f	certs.php	3
30	4	f	tls.php	4
31	4	f	auth-settings.php	5
32	4	f	backup.php	6
33	4	f	templates.php	7
34	4	f	recipient-verification.php	7
35	4	f	syslog.php	8
36	4	f	sa-policy.php	8
37	4	f	disclaimers.php	9
38	4	f	snmp.php	10
39	4	f	quarantine-settings.php	11
40	5	f	gwblist.php?wbtype=B	1
41	5	f	gwblist.php?wbtype=W	2
42	5	f	keywords.php	3
43	6	f	manage-quarantine.php	1
44	6	f	quarantine-misc.php	2
45	6	f	aliases.php	3
46	7	f	syscmds.php	1
47	7	f	stats-graphs.php	2
48	7	f	admin-stats.php	3
49	7	f	history.php	4
50	7	f	reports.php	5
51	7	f	reports-out.php	6
52	7	f	report-schedule.php	7
53	7	f	report-archive.php	8
54	8	f	logs.php	1
55	9	f	cluster.php	1
\.


--
-- Data for Name: policy; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY policy (id, policy_name, virus_lover, spam_lover, banned_files_lover, bad_header_lover, bypass_virus_checks, bypass_spam_checks, bypass_banned_checks, bypass_header_checks, spam_modifies_subj, spam_subject_tag2, spam_quarantine_to, virus_quarantine_to, banned_quarantine_to, clean_quarantine_to, bad_header_quarantine_to, spam_tag_level, spam_tag2_level, spam_kill_level, locked, digest, report_type, report_kill_level, spam_dsn_cutoff_level, spam_quarantine_cutoff_level, digest_language) FROM stdin;
1	@.	N	N	N	N	N	N	Y	N	N							-999	5	5	N	N 	N	999	0	999	en_US
2	@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
3	vsuquillo@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
4	coactextil@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
5	jllumiquinga@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
6	dcorrea@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
7	ecarrera@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
8	mandrade@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
9	respin@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
10	hgongora@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
11	jespinosa@14demarzo.fin.ec	N	N	N	N	N	N	N	N	N	[ ** SPAM ** ]	spam-quarantine	virus-quarantine	banned-quarantine			-999	5	5	N	N 	N	999	0	999	en_US
\.


--
-- Data for Name: rbls; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY rbls (id, rbl_name) FROM stdin;
1	zen.spamhaus.org
2	bl.spamcop.net
3	cbl.abuseat.org
\.


--
-- Data for Name: realm_admins; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY realm_admins (realm_id, user_id, role_id) FROM stdin;
\.


--
-- Data for Name: realms; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY realms (id, name, timezone, description, suspended, lockedout) FROM stdin;
\.


--
-- Data for Name: recipients; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY recipients (email, domain) FROM stdin;
\.


--
-- Data for Name: reports; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY reports (id, email, subject, type, frequency, maxitem, created, format, archive, domain_id, domain, node_id, flags, realm_id) FROM stdin;
\.


--
-- Data for Name: role_perms; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY role_perms (role_id, perm_id) FROM stdin;
1	1
1	2
1	3
1	4
1	5
1	6
1	7
1	8
1	9
1	10
1	11
1	12
1	13
1	14
1	15
1	16
1	17
1	18
1	19
1	20
1	21
1	22
1	23
1	24
1	25
1	26
1	27
1	28
1	29
1	30
1	31
1	32
1	33
1	35
1	37
1	38
1	40
1	41
1	42
1	43
1	44
1	45
1	46
1	47
1	48
1	49
1	50
1	51
1	52
1	53
1	54
1	55
2	3
2	4
2	6
2	7
2	22
2	23
2	24
2	25
2	26
2	27
2	34
2	37
2	43
2	49
2	50
2	51
2	52
2	53
5	3
5	4
5	6
5	7
5	22
5	23
5	24
5	25
5	26
5	27
5	34
5	37
5	43
5	49
5	50
5	51
5	52
5	53
3	5
3	6
3	7
3	40
3	41
3	43
3	49
3	50
3	51
3	52
3	53
6	5
6	6
6	7
6	40
6	41
6	43
6	49
6	50
6	51
6	52
6	53
3	3
3	4
3	23
3	24
3	34
3	36
3	37
4	4
4	5
4	6
4	27
4	39
4	40
4	41
4	43
7	4
7	5
7	6
7	27
7	39
7	40
7	41
7	43
4	7
4	36
4	49
\.


--
-- Data for Name: roles; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY roles (id, name, type, is_template, is_default, owner_id) FROM stdin;
1	Administrator	admin	t	t	\N
2	Domain Group Administrator Template	realm	t	f	\N
3	Domain Administrator Template	domain	t	f	\N
4	User Template	user	t	f	\N
5	Domain Group Administrator	realm	f	t	\N
6	Domain Administrator	domain	f	t	\N
7	User	user	f	t	\N
\.


--
-- Data for Name: rulesets; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY rulesets (id, name, version, description, url, filename, active, lastupdate) FROM stdin;
1	BigEvil	200407201616	BigEvil looks for known spammer URLs in the spam.	http://rules.spamtitan.com/bigevil.cf	bigevil.cf	N	2005-03-20 03:00:00
2	EvilNumbers	1.12p	Addresses and phone numbers harvested from spam.	http://rules.spamtitan.com/evilnumbers.cf	evilnumbers.cf	X	2005-03-20 03:01:19
7	Ratware	01.01.01	Detects Ratware software that spammers use to automate spam campaigns, coordinate spam services, and generate, send and track spam messages.	http://rules.spamtitan.com/70_sare_ratware.cf	70_sare_ratware.cf	X	2004-11-23 15:18:20
13	OEM	1.05.04	Tries to detect people selling OEM software to consumers.	http://rules.spamtitan.com/70_sare_oem.cf	70_sare_oem.cf	X	2006-08-16 15:01:27
15	AntiDrug	0.52	Detects common pill spams. Note: This ruleset may not be appropriate for a medical or pharmecutical environment.	http://rules.spamtitan.com/antidrug.cf	antidrug.cf	X	2005-11-22 03:16:39
25	PumpAndDump	1.0	Detect image only pump-and-dump stocks.	http://rules.spamtitan.com/70_imageinfo.cf	70_imageinfo.cf	N	2006-08-09 18:40:38
3	Bayes Poison	1.00	Detects bayes poison using lists of words with equal length.	http://rules.spamtitan.com/70_sare_bayes_poison_nxm.cf	70_sare_bayes_poison_nxm.cf	Y	2014-12-04 03:01:09.671149
4	HTML Coding	01.02.06	Contains HTML coding rules that detect various spammer tricks applied through HTML coding within messages.	http://rules.spamtitan.com/70_sare_html.cf	70_sare_html.cf	Y	2014-12-04 03:01:13.593462
5	Headers	01.02.00	Mail header rules not found in SpamAssassin.	http://rules.spamtitan.com/70_sare_header.cf	70_sare_header.cf	Y	2014-12-04 03:01:16.524539
6	Specific	01.00.01	This rule set is intended to catch the M.O. of specific spammers and/or specific spam that might otherwise elude more general purpose rules.	http://rules.spamtitan.com/70_sare_specific.cf	70_sare_specific.cf	Y	2014-12-04 03:01:19.145393
8	Adult	01.02.03	Rules designed to catch spam with Adult material.	http://rules.spamtitan.com/70_sare_adult.cf	70_sare_adult.cf	Y	2014-12-04 03:01:21.1916
10	Fraud	01.03.02	Rules designed to catch Nigerian 419, International Lotto, etc type fraud scams. Note that this ruleset may overlap with pre-existing SpamAssassin rules.	http://rules.spamtitan.com/99_sare_fraud_post25x.cf	99_sare_fraud_post25x.cf	Y	2014-12-04 03:01:24.626494
11	Spoof	01.06.05	Tries to detect common spoofing attempts by spammers. Many use a Message-ID of one provider but the message was never passed through the suggested system.	http://rules.spamtitan.com/70_sare_spoof.cf	70_sare_spoof.cf	Y	2014-12-04 03:01:29.878784
12	Random	1.30.09	Tries to detect common mis-fires on bulk mail software (ratware). Many signs are found like: %RND_NUMBER, etc.	http://rules.spamtitan.com/70_sare_random.cf	70_sare_random.cf	Y	2014-12-04 03:01:31.631897
14	General Subject	1.01.03	Subject header rules that are not found in other rulesets.	http://rules.spamtitan.com/70_sare_genlsubj0.cf	70_sare_genlsubj0.cf	Y	2014-12-04 03:01:34.232012
16	Bogus Virus Warnings	1.118	Tries to detect bogus virus warnings. To reduce the risk of false positives, some rules have checks to make sure that the message is a bounce (as all legitmate virus warnings should be).	http://rules.spamtitan.com/bogus-virus-warnings.cf	bogus-virus-warnings.cf	Y	2014-12-04 03:01:37.086869
17	Tripwire	1.18	Rules that searches for 3 characters that shouldn't be together. This is based on the English language.	http://rules.spamtitan.com/tripwire.cf	tripwire.cf	Y	2014-12-04 03:01:42.477897
9	Marketing	01.02.02	Rules designed to catch business, marketing and educational spam.	http://rules.spamtitan.com/72_sare_bml_post25x.cf	72_sare_bml_post25x.cf	Y	2015-02-14 03:01:37.54367
19	Redirect	2.0	Detect commonly abused redirectors and uri obfuscation techniques.	http://rules.spamtitan.com/72_sare_redirect_post3.0.0.cf	72_sare_redirect_post3.0.0.cf	Y	2014-12-04 03:01:45.91768
20	Sare Evilnumbers	0.1	Contains rules which flag emails that contain URI links to spammer web sites.	http://rules.spamtitan.com/70_sare_evilnum0.cf	70_sare_evilnum0.cf	Y	2014-12-04 03:01:47.602021
21	Sober-P	1.0	Detect the German spams from the Sober.P virus.	http://rules.spamtitan.com/sober-p.cf	sober-p.cf	Y	2014-12-04 03:01:49.114717
22	Surbl-New	1.0	SURBLs that are not in the SpamAssassin distro.	http://rules.spamtitan.com/surbl.cf	surbl.cf	Y	2014-12-04 03:01:50.202843
18	Unsubscribe	0.8	Looks for common unsubscribe phrases and codes in spam.	http://rules.spamtitan.com/70_sare_unsub.cf	70_sare_unsub.cf	Y	2015-02-03 03:01:26.856798
24	Stocks	1.0	Detect pump-and-dump stocks.	http://rules.spamtitan.com/70_sare_stocks.cf	70_sare_stocks.cf	Y	2014-12-04 03:01:53.651119
23	CF-misc	1.0	SpamTitan Miscellaneous rules.	http://rules.spamtitan.com/cfmisc.cf	cfmisc.cf	Y	2015-07-15 03:01:24.394634
\.


--
-- Data for Name: saslauth; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY saslauth (ldap_server, ldap_port, ldap_anonymous, ldap_username, ldap_password, ldap_filter, ldap_search_base, method, tls_auth_only, imap_server) FROM stdin;
\N	389	N	\N	\N	uid=%u	dc=example,dc=com	ldap	N	\N
\.


--
-- Data for Name: scrubber_config; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY scrubber_config (id, version, version_date, update_server, www_timeout, auth_method, showaliases, expiry_period, learn_bayes, report_name, report_from, report_subject, report_contact, report_contact_misc, report_logo, report_logo_inc, ui_logo, proxy, proxyport, proxyuser, proxypass, server_url, http_protocol, logs_expiry_period, logs_msgs_page, logs_msgs_sort, logs_subject, logs_cleanscore, logs_spamscore, logs_period, report_inc_type, report_inc_freq, report_inc_login, report_inc_ondemand, report_use_from_header, report_footer, login_showhelp, login_helpurl, login_showpwlink, chart_maxsize, logs_vscanner, logs_vname, dnscache, license_decay, license_usage, license_reset, db_maxsize, quarantine_admin, auto_domain_discover, log_invl_rcpt, log_helo_reject, log_spf_reject, log_relay_denied, log_sender_reject, log_sender_reject2, log_rbl_reject, stpurge_date, smtp_rcpt_before_rbl, ui_title, ui_footer, engine_name, license_from, tunnel_address, st_helpdesk, fp_from, fp_subject, fp_body, pdf_text, pdf_logo, notify_flags, usealiases, wb_from_header, grey_count, grey_delay, virus_scanners, digest_load_default, ssh_host, ssh_key, demo, update_subject, report_license_count, timezone) FROM stdin;
0	6.11	2015-12-17 04:43:37	rules.spamtitan.com	1800	pop3	N	21	1	SpamTitan	report@spamtitan.com	Spam Quarantine Report	\N	\N	/imgs/spam-report.jpg	Y	/imgs/_logo_cooperativa 14 de Marzo_1.png	\N	\N	\N	\N	\N	http://	31	500	DESC	N	N	N	3	Y	Y	Y	N	N	Spam/Virus Protection by Copperfasten Technologies	N	\N	Y	25	N	N	Y	10	28	0	1200000		N	Y	Y	Y	Y	Y	Y	Y	\N	Y	SpamTitan	&copy;2006-2015 Copperfasten Technologies	SpamTitan	licensing@spamtitan.com	copper@support.spamtitan.com	helpdesk@spamtitan.com	spam-portal@spamtitan.com	SpamTitan Anti-Spam appliance - Password	Your password for the SpamTitan Anti-Spam appliance is: %%PASSWORD%%	SpamTitan Mail Firewall Report	/imgs/logo2.png	0	0	0	5	300	{clamav,kaspersky}	1	support.spamtitan.com	copper	f	SpamTitan System Update(s) Available	N	
\.


--
-- Data for Name: sender_transport; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY sender_transport (id, domain, poolid) FROM stdin;
\.


--
-- Data for Name: smarthosts; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY smarthosts (id, sender, relayhost, comment, needauth, auth_user, auth_pass) FROM stdin;
\.


--
-- Data for Name: spamstats; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY spamstats (id, node_id, logdate, total, spam, clean, inv_rcpt, viruses, banned, relay_denied, rbl_reject, helo_reject, spf_fail, sender_baddom, sender_fqdn, blackip, "timestamp") FROM stdin;
29	0	2015-01-01	186	4	7	0	0	0	0	1	6	0	168	0	0	2015-01-02 00:00:01.649216
18	0	2014-12-21	58	1	9	0	0	0	0	37	9	2	0	0	0	2014-12-21 22:52:43.821899
30	0	2015-01-02	182	2	13	0	0	0	0	8	9	0	150	0	0	2015-01-03 00:00:00.906253
17	0	2014-12-20	63	5	15	0	0	0	0	34	7	2	0	0	0	2014-12-20 23:55:20.989914
3	0	2014-12-05	443	84	97	0	0	0	1	258	0	0	3	0	0	2014-12-05 23:55:01.551367
10	0	2014-12-12	285	41	105	0	0	0	0	88	46	1	4	0	0	2014-12-13 00:00:01.452523
11	0	2014-12-13	68	13	8	0	0	0	0	17	28	1	1	0	0	2014-12-13 16:35:01.369816
2	0	2014-12-04	505	82	123	0	0	0	1	294	0	1	3	0	0	2014-12-05 00:00:01.12367
6	0	2014-12-08	351	32	138	0	0	0	1	174	0	5	1	0	0	2014-12-09 00:00:01.044371
33	0	2015-01-05	250	19	105	0	0	0	0	73	9	1	43	0	0	2015-01-05 23:46:35.096041
1	0	2014-12-03	187	15	75	0	0	0	1	94	0	0	2	0	0	2014-12-04 00:00:01.223125
22	0	2014-12-25	168	15	16	0	0	0	0	21	13	1	102	0	0	2014-12-25 23:30:01.17348
52	0	2015-01-24	288	36	14	0	0	0	62	28	7	2	139	0	0	2015-01-24 23:50:00.927467
26	0	2014-12-29	257	10	92	0	0	0	0	26	10	1	118	0	0	2014-12-29 23:55:01.040238
47	0	2015-01-19	586	42	135	0	0	1	0	41	9	1	357	0	0	2015-01-19 23:55:01.164434
28	0	2014-12-31	253	10	51	0	0	0	0	32	10	2	148	0	0	2014-12-31 23:30:34.312457
27	0	2014-12-30	220	16	90	0	0	0	0	32	19	1	62	0	0	2014-12-30 23:48:09.642202
5	0	2014-12-07	86	3	19	0	0	0	10	45	0	1	0	0	0	2014-12-07 23:55:00.720666
20	0	2014-12-23	293	16	121	0	0	0	1	99	9	1	45	1	0	2014-12-23 23:55:01.450086
9	0	2014-12-11	358	52	190	0	0	0	0	115	0	1	0	0	0	2014-12-11 23:50:30.572469
19	0	2014-12-22	190	0	112	0	0	0	0	69	5	3	1	0	0	2014-12-22 23:53:52.964352
16	0	2014-12-19	253	23	115	0	0	0	0	100	6	7	2	0	0	2014-12-19 23:54:08.890619
7	0	2014-12-09	367	33	127	0	0	0	2	195	0	4	6	0	0	2014-12-10 00:00:01.040952
50	0	2015-01-22	436	37	165	0	0	0	117	94	7	6	10	0	0	2015-01-22 23:55:01.263079
23	0	2014-12-26	184	10	18	0	0	0	5	13	11	1	126	0	0	2014-12-27 00:00:01.40676
4	0	2014-12-06	241	47	40	0	0	0	62	88	0	2	2	0	0	2014-12-06 23:50:00.898844
36	0	2015-01-08	350	42	178	0	0	0	0	102	10	6	12	0	0	2015-01-09 00:00:01.082957
32	0	2015-01-04	233	2	15	0	0	0	0	32	8	2	174	0	0	2015-01-05 00:00:00.916619
13	0	2014-12-16	382	36	218	0	0	0	5	72	42	0	9	0	0	2014-12-16 23:40:00.722218
12	0	2014-12-15	207	31	117	0	0	0	0	20	22	16	1	0	0	2014-12-16 00:00:01.546903
55	0	2015-01-27	685	51	144	0	0	0	0	55	14	0	421	0	0	2015-01-28 00:00:00.9992
8	0	2014-12-10	327	24	193	0	0	0	1	107	0	1	1	0	0	2014-12-11 00:00:01.178294
38	0	2015-01-10	539	23	27	0	0	0	0	16	10	1	462	0	0	2015-01-10 23:55:00.921327
25	0	2014-12-28	180	10	4	0	0	0	0	8	10	2	146	0	0	2014-12-28 23:50:01.689109
14	0	2014-12-17	329	29	121	0	0	0	5	156	7	11	0	0	0	2014-12-17 23:55:00.62027
67	0	2015-02-08	61	6	8	0	0	0	0	29	16	0	2	0	0	2015-02-08 23:45:01.172116
42	0	2015-01-14	642	41	163	0	0	0	0	83	13	0	342	0	0	2015-01-14 23:55:00.607402
15	0	2014-12-18	217	7	85	0	0	1	0	104	6	12	2	0	0	2014-12-18 23:40:00.893719
43	0	2015-01-15	309	35	87	0	0	0	0	76	11	2	98	0	0	2015-01-15 23:40:01.478154
21	0	2014-12-24	332	22	90	0	0	0	0	74	11	0	135	0	0	2014-12-24 23:55:01.304887
40	0	2015-01-12	311	11	155	0	0	0	0	41	15	5	84	0	0	2015-01-13 00:00:01.450403
24	0	2014-12-27	143	4	4	0	0	0	0	6	7	0	122	0	0	2014-12-28 00:00:01.098588
39	0	2015-01-11	195	5	7	0	0	1	0	38	10	0	134	0	0	2015-01-11 23:00:14.73688
31	0	2015-01-03	210	2	6	0	0	0	0	64	13	1	124	0	0	2015-01-03 23:50:01.147645
58	0	2015-01-30	577	61	122	0	0	0	0	93	160	2	139	0	0	2015-01-30 23:42:21.107777
57	0	2015-01-29	452	68	132	0	0	0	5	75	3	3	166	0	0	2015-01-30 00:00:01.307387
45	0	2015-01-17	345	27	10	0	0	0	0	28	8	0	272	0	0	2015-01-17 23:55:01.279036
48	0	2015-01-20	525	58	199	0	0	1	0	78	7	8	174	0	0	2015-01-20 23:55:31.968925
46	0	2015-01-18	310	17	11	0	0	0	0	12	9	0	261	0	0	2015-01-19 00:00:01.157721
34	0	2015-01-06	412	34	116	0	0	0	0	233	14	5	10	0	0	2015-01-06 23:55:01.017602
41	0	2015-01-13	404	32	138	0	0	1	0	88	20	5	120	0	0	2015-01-14 00:00:01.200503
37	0	2015-01-09	425	43	119	0	0	0	0	57	8	2	196	0	0	2015-01-10 00:00:00.870793
44	0	2015-01-16	376	43	96	0	0	0	0	100	12	2	122	0	0	2015-01-16 23:45:00.823319
35	0	2015-01-07	425	48	157	0	0	0	5	185	7	4	19	0	0	2015-01-07 23:47:11.502721
54	0	2015-01-26	758	65	132	0	0	0	0	66	4	1	490	0	0	2015-01-26 23:58:07.019725
49	0	2015-01-21	296	54	93	0	0	0	33	102	8	2	4	0	0	2015-01-21 23:55:00.979141
51	0	2015-01-23	574	60	141	0	0	0	167	78	9	1	118	0	0	2015-01-23 23:59:22.047619
59	0	2015-01-31	259	40	15	0	0	0	0	18	9	1	176	0	0	2015-02-01 00:00:01.432847
56	0	2015-01-28	585	78	199	0	0	0	0	58	7	1	242	0	0	2015-01-28 23:58:39.453269
68	0	2015-02-09	453	69	143	0	0	0	0	224	16	1	0	0	0	2015-02-09 23:59:32.05101
63	0	2015-02-04	475	50	177	0	0	3	5	82	17	11	130	0	0	2015-02-04 23:55:01.341523
53	0	2015-01-25	225	22	7	0	0	0	0	20	9	1	166	0	0	2015-01-25 23:45:01.341097
64	0	2015-02-05	369	49	128	0	0	1	0	75	22	2	92	0	0	2015-02-05 23:55:00.980136
62	0	2015-02-03	596	46	152	0	0	1	0	77	166	3	151	0	0	2015-02-03 23:45:01.380482
61	0	2015-02-02	430	60	200	0	0	0	0	52	11	3	104	0	0	2015-02-02 23:35:01.105169
60	0	2015-02-01	219	9	13	0	0	0	0	40	7	4	146	0	0	2015-02-01 23:50:01.45924
66	0	2015-02-07	352	29	12	0	0	0	0	38	44	4	225	0	0	2015-02-08 00:00:01.200011
65	0	2015-02-06	433	29	143	0	0	0	0	72	12	1	176	0	0	2015-02-07 00:00:01.681032
69	0	2015-02-10	523	86	146	0	0	0	141	113	10	0	27	0	0	2015-02-11 00:00:01.652049
70	0	2015-02-11	528	30	158	0	0	0	250	51	16	1	22	0	0	2015-02-12 00:00:00.78335
71	0	2015-02-12	744	52	166	0	0	0	302	144	32	2	46	0	0	2015-02-13 00:00:01.070302
72	0	2015-02-13	819	46	142	0	0	0	285	132	28	1	185	0	0	2015-02-14 00:00:01.318704
73	0	2015-02-14	438	24	12	0	0	0	50	29	38	2	283	0	0	2015-02-14 23:55:01.454558
74	0	2015-02-15	187	10	5	0	0	0	0	28	27	0	117	0	0	2015-02-15 23:40:01.23687
75	0	2015-02-16	314	11	7	0	0	0	0	148	36	0	112	0	0	2015-02-16 23:55:01.33208
76	0	2015-02-17	279	20	24	0	0	0	0	122	21	0	92	0	0	2015-02-17 23:53:20.103248
80	0	2015-02-21	97	31	22	0	0	0	0	23	17	2	2	0	0	2015-02-21 23:55:09.424077
85	0	2015-02-26	680	69	150	0	0	0	197	37	20	2	205	0	0	2015-02-27 00:00:01.745294
137	0	2015-04-18	99	22	17	0	0	0	0	11	4	3	42	0	0	2015-04-18 23:45:01.323134
122	0	2015-04-03	148	19	11	0	0	0	0	39	11	0	68	0	0	2015-04-04 00:00:00.845225
120	0	2015-04-01	355	52	132	1	0	0	5	103	18	2	42	0	0	2015-04-01 23:55:01.464343
118	0	2015-03-30	344	44	161	0	0	0	0	76	20	1	42	0	0	2015-03-31 00:00:00.800749
111	0	2015-03-23	293	33	166	0	0	0	0	62	7	1	24	0	0	2015-03-23 23:10:30.256992
98	0	2015-03-10	843	64	195	0	0	0	339	53	104	0	88	0	0	2015-03-11 00:00:00.652004
94	0	2015-03-06	380	46	122	0	0	0	0	110	46	1	55	0	0	2015-03-07 00:00:01.422261
104	0	2015-03-16	625	54	197	0	0	0	0	103	18	2	251	0	0	2015-03-16 23:55:01.13918
82	0	2015-02-23	437	64	191	0	0	0	0	38	24	0	120	0	0	2015-02-23 23:59:04.124787
78	0	2015-02-19	300	55	151	0	0	1	0	57	18	5	13	0	0	2015-02-19 23:57:40.028741
86	0	2015-02-27	696	31	99	0	0	0	258	46	25	1	236	0	0	2015-02-27 23:55:01.008773
141	0	2015-04-22	434	59	153	0	0	6	0	67	2	4	143	0	0	2015-04-23 00:00:00.911049
128	0	2015-04-09	470	46	130	0	0	2	1	121	28	1	141	0	0	2015-04-10 00:00:00.91824
113	0	2015-03-25	348	62	129	0	0	0	0	63	13	0	81	0	0	2015-03-25 23:59:45.258082
110	0	2015-03-22	58	9	10	0	0	0	1	9	5	0	24	0	0	2015-03-22 23:45:01.485864
88	0	2015-03-01	154	17	14	0	0	0	0	22	16	0	85	0	0	2015-03-01 23:50:10.151034
105	0	2015-03-17	408	39	209	0	0	0	0	118	14	0	28	0	0	2015-03-18 00:00:01.581724
87	0	2015-02-28	163	11	18	0	0	0	0	35	20	0	79	0	0	2015-02-28 23:50:01.460977
99	0	2015-03-11	477	72	191	0	0	0	22	129	7	2	54	0	0	2015-03-11 23:55:00.775571
138	0	2015-04-19	90	12	11	0	0	0	0	14	12	1	40	0	0	2015-04-19 23:15:00.90732
132	0	2015-04-13	314	62	127	0	0	0	0	116	8	1	0	0	0	2015-04-13 23:40:00.835087
95	0	2015-03-07	257	14	10	0	0	0	0	27	162	0	44	0	0	2015-03-08 00:00:00.836599
89	0	2015-03-02	412	83	197	0	0	0	0	37	17	0	78	0	0	2015-03-02 23:53:12.813639
91	0	2015-03-03	534	94	153	0	0	0	0	95	44	2	146	0	0	2015-03-04 00:00:01.621921
84	0	2015-02-25	522	60	172	0	0	0	203	47	24	0	16	0	0	2015-02-25 23:45:01.476255
127	0	2015-04-08	596	32	175	0	0	1	0	265	35	0	88	0	0	2015-04-08 23:55:00.776085
114	0	2015-03-26	281	28	139	0	0	0	0	84	24	5	1	0	0	2015-03-26 23:50:31.753146
103	0	2015-03-15	130	20	11	0	0	0	0	62	24	1	12	0	0	2015-03-15 23:55:01.116067
83	0	2015-02-24	757	56	170	0	0	0	67	98	12	4	350	0	0	2015-02-24 23:55:48.602827
77	0	2015-02-18	350	35	167	0	0	0	0	64	23	4	57	0	0	2015-02-18 23:50:00.857235
79	0	2015-02-20	259	24	92	0	0	0	5	110	17	1	10	0	0	2015-02-20 23:35:01.310999
96	0	2015-03-08	204	8	10	0	0	0	115	17	10	2	42	0	0	2015-03-08 23:55:00.822161
97	0	2015-03-09	623	31	154	0	0	0	323	83	23	1	8	0	0	2015-03-10 00:00:01.142892
124	0	2015-04-05	92	11	4	0	0	0	0	24	23	0	30	0	0	2015-04-06 00:00:01.426566
123	0	2015-04-04	131	8	14	0	0	0	0	28	13	0	68	0	0	2015-04-04 23:45:00.771501
93	0	2015-03-05	413	69	161	0	0	0	0	97	15	3	68	0	0	2015-03-06 00:00:00.613783
109	0	2015-03-21	131	28	12	0	0	0	0	54	12	0	25	0	0	2015-03-21 23:15:01.193129
81	0	2015-02-22	68	14	10	0	0	0	0	24	18	1	1	0	0	2015-02-22 23:55:13.583897
100	0	2015-03-12	363	84	141	0	0	0	0	64	8	1	65	0	0	2015-03-12 23:50:00.637411
92	0	2015-03-04	624	51	144	0	0	0	0	70	22	1	336	0	0	2015-03-04 23:50:00.655994
112	0	2015-03-24	614	60	155	0	0	0	0	58	18	5	318	0	0	2015-03-25 00:00:01.381719
119	0	2015-03-31	643	59	256	0	0	0	0	82	181	2	62	1	0	2015-04-01 00:00:00.580243
108	0	2015-03-20	842	36	115	0	0	0	605	44	16	4	22	0	0	2015-03-20 23:40:01.026023
107	0	2015-03-19	565	53	106	0	0	0	303	56	14	3	30	0	0	2015-03-19 23:55:01.286237
106	0	2015-03-18	312	58	145	0	0	0	0	59	8	2	40	0	0	2015-03-18 23:55:01.236552
101	0	2015-03-13	302	66	112	0	0	0	0	42	14	0	68	0	0	2015-03-14 00:00:01.092899
102	0	2015-03-14	206	49	28	0	0	0	0	27	26	1	75	0	0	2015-03-15 00:00:00.811048
130	0	2015-04-11	112	13	18	0	0	0	0	50	9	2	20	0	0	2015-04-12 00:00:01.491892
117	0	2015-03-29	126	9	10	0	0	0	0	49	15	1	42	0	0	2015-03-29 23:45:00.7662
129	0	2015-04-10	557	60	116	0	0	2	0	99	95	2	183	0	0	2015-04-10 23:50:01.520054
125	0	2015-04-06	491	52	152	0	0	0	5	91	157	0	34	0	0	2015-04-06 23:50:12.788964
116	0	2015-03-28	103	17	9	0	0	0	0	23	11	0	43	0	0	2015-03-29 00:00:01.083928
115	0	2015-03-27	496	50	172	0	4	0	0	69	173	2	26	0	0	2015-03-27 23:45:01.021617
126	0	2015-04-07	360	56	153	0	0	0	0	99	5	0	47	0	0	2015-04-07 23:56:09.397325
135	0	2015-04-16	288	52	124	0	0	3	0	75	28	2	4	0	0	2015-04-16 23:55:00.90331
121	0	2015-04-02	408	61	151	0	0	0	0	133	22	1	40	0	0	2015-04-02 23:57:37.871482
133	0	2015-04-14	613	65	167	0	0	0	0	209	51	117	4	0	0	2015-04-14 23:55:01.508141
136	0	2015-04-17	340	41	109	0	0	0	0	123	35	4	28	0	0	2015-04-17 23:10:01.505135
143	0	2015-04-24	671	47	135	0	0	0	0	106	6	1	376	0	0	2015-04-25 00:00:01.556753
131	0	2015-04-12	60	6	10	0	0	0	0	37	6	1	0	0	0	2015-04-12 23:45:00.59855
134	0	2015-04-15	411	64	186	0	0	5	0	134	12	4	6	0	0	2015-04-15 23:49:35.834346
142	0	2015-04-23	530	59	127	0	0	0	0	55	7	1	281	0	0	2015-04-24 00:00:01.402339
140	0	2015-04-21	504	77	130	0	0	2	0	220	8	4	63	0	0	2015-04-21 23:59:36.896465
139	0	2015-04-20	302	68	135	0	0	0	0	40	11	3	45	0	0	2015-04-20 23:52:15.920255
145	0	2015-04-26	111	11	11	0	0	0	0	7	8	0	74	0	0	2015-04-26 23:25:00.682966
144	0	2015-04-25	229	25	16	0	0	0	0	8	5	1	174	0	0	2015-04-25 23:50:01.001367
147	0	2015-04-28	400	73	138	0	0	3	0	113	28	0	45	0	0	2015-04-28 23:46:03.968928
146	0	2015-04-27	318	57	151	0	0	2	0	47	14	2	45	0	0	2015-04-27 23:55:00.978537
148	0	2015-04-29	360	48	172	0	0	9	0	72	7	1	51	0	0	2015-04-29 23:45:01.558771
149	0	2015-04-30	367	35	189	0	0	0	0	51	16	0	76	0	0	2015-04-30 23:45:00.959758
150	0	2015-05-01	175	23	15	0	0	0	1	9	4	1	122	0	0	2015-05-01 23:55:01.330425
151	0	2015-05-02	136	22	11	0	0	0	0	7	8	0	88	0	0	2015-05-02 23:56:04.736034
152	0	2015-05-03	118	6	12	0	0	0	0	12	6	0	82	0	0	2015-05-03 23:55:00.846011
153	0	2015-05-04	400	31	184	0	0	0	0	69	4	1	111	0	0	2015-05-04 23:47:26.274685
156	0	2015-05-07	630	39	158	0	0	0	0	82	15	1	335	0	0	2015-05-08 00:00:01.173767
159	0	2015-05-10	80	28	19	0	0	0	0	22	10	0	1	0	0	2015-05-10 23:35:00.906737
164	0	2015-05-15	334	41	176	0	0	0	0	101	14	0	2	0	0	2015-05-15 23:57:51.383077
162	0	2015-05-13	344	55	189	0	0	0	0	86	13	1	0	0	0	2015-05-13 23:20:01.571228
171	0	2015-05-22	543	61	124	0	0	0	0	65	14	3	276	0	0	2015-05-22 23:50:00.903779
163	0	2015-05-14	280	38	182	0	0	0	0	42	16	1	1	0	0	2015-05-14 23:55:01.058945
208	0	2015-06-29	346	73	169	0	0	0	0	27	19	2	56	0	0	2015-06-29 23:55:01.387072
170	0	2015-05-21	481	47	156	0	0	0	0	89	13	3	173	0	0	2015-05-22 00:00:01.13457
166	0	2015-05-17	76	15	11	0	0	0	0	33	16	1	0	0	0	2015-05-17 23:55:00.910487
168	0	2015-05-19	609	93	209	0	0	0	0	75	41	4	187	0	0	2015-05-19 23:55:49.908581
167	0	2015-05-18	471	49	192	0	0	0	0	97	23	6	104	0	0	2015-05-18 23:57:26.603398
154	0	2015-05-05	451	32	156	0	0	0	0	106	5	4	148	0	0	2015-05-06 00:00:01.307539
182	0	2015-06-04	286	55	168	0	0	0	0	51	4	3	5	0	0	2015-06-04 23:51:56.087026
169	0	2015-05-20	374	62	155	0	0	0	0	115	30	10	2	0	0	2015-05-20 23:55:00.880166
184	0	2015-06-06	103	25	31	0	0	0	0	35	5	0	7	0	0	2015-06-06 23:35:01.529325
189	0	2015-06-11	362	55	154	0	0	0	0	64	6	4	79	0	0	2015-06-12 00:00:01.477776
179	0	2015-06-01	356	61	208	0	0	0	1	64	7	10	5	0	0	2015-06-01 23:51:36.556044
176	0	2015-05-27	595	77	223	0	0	0	0	169	4	4	118	0	0	2015-05-28 00:00:01.016487
190	0	2015-06-12	354	48	137	0	0	0	0	33	4	1	131	0	0	2015-06-12 23:35:01.416226
216	0	2015-07-07	223	35	75	0	0	0	0	54	13	0	46	0	0	2015-07-07 23:55:01.227586
157	0	2015-05-08	351	58	153	0	0	0	0	21	38	0	81	0	0	2015-05-08 23:32:14.420235
205	0	2015-06-26	302	57	171	0	0	0	0	13	12	1	48	0	0	2015-06-26 23:00:01.364378
181	0	2015-06-03	301	58	165	0	1	0	0	68	6	3	0	0	0	2015-06-03 23:56:03.230741
187	0	2015-06-09	427	51	182	0	0	0	0	87	6	13	88	0	0	2015-06-09 23:55:00.762168
160	0	2015-05-11	347	63	192	0	0	0	0	55	6	3	28	0	0	2015-05-12 00:00:00.798185
185	0	2015-06-07	104	13	21	0	0	0	0	33	11	1	25	0	0	2015-06-07 23:57:45.557331
172	0	2015-05-23	213	11	14	0	0	0	0	15	7	1	165	0	0	2015-05-23 23:45:39.584333
173	0	2015-05-24	304	18	8	0	0	0	0	7	4	1	266	0	0	2015-05-25 00:00:00.877999
201	0	2015-06-22	307	69	147	0	0	0	0	9	5	1	76	0	0	2015-06-22 23:50:28.31415
207	0	2015-06-28	134	30	19	0	0	0	0	14	17	0	54	0	0	2015-06-29 00:00:00.638434
196	0	2015-06-17	341	74	159	0	0	0	0	37	10	5	56	0	0	2015-06-18 00:00:00.97294
165	0	2015-05-16	52	12	19	0	0	0	0	17	2	2	0	0	0	2015-05-16 23:50:01.076958
161	0	2015-05-12	408	50	234	0	0	0	0	79	23	1	21	0	0	2015-05-12 23:55:00.648563
186	0	2015-06-08	446	83	196	0	0	0	0	38	8	14	107	0	0	2015-06-09 00:00:00.957739
183	0	2015-06-05	299	62	165	0	0	0	0	59	9	4	0	0	0	2015-06-05 23:46:51.141168
177	0	2015-05-28	771	44	173	0	0	0	0	143	67	5	339	0	0	2015-05-29 00:00:00.736604
175	0	2015-05-26	540	28	180	0	0	0	0	133	9	2	188	0	0	2015-05-26 23:50:00.798186
158	0	2015-05-09	70	21	20	0	0	0	0	27	2	0	0	0	0	2015-05-09 23:35:39.812686
155	0	2015-05-06	391	47	126	0	0	0	0	97	10	0	111	0	0	2015-05-06 23:49:03.152033
178	0	2015-05-29	258	31	114	0	0	0	5	66	6	1	35	0	0	2015-05-29 15:15:00.919482
192	0	2015-06-14	53	9	16	0	0	0	0	21	6	1	0	0	0	2015-06-14 23:50:08.50324
197	0	2015-06-18	396	63	174	0	0	0	0	63	6	4	86	0	0	2015-06-18 23:50:01.716733
180	0	2015-06-02	283	59	151	0	0	0	0	57	8	8	0	0	0	2015-06-02 23:59:37.263078
204	0	2015-06-25	279	72	112	0	0	0	0	39	11	3	42	0	0	2015-06-25 23:55:51.961961
202	0	2015-06-23	304	66	152	0	0	0	0	41	5	0	40	0	0	2015-06-23 23:16:19.893161
199	0	2015-06-20	198	16	12	0	0	0	0	43	9	2	116	0	0	2015-06-20 23:35:01.159665
174	0	2015-05-25	663	48	175	0	0	0	0	95	6	6	333	0	0	2015-05-25 23:55:00.913229
211	0	2015-07-02	281	42	152	0	0	0	0	59	16	4	8	0	0	2015-07-03 00:00:00.948855
191	0	2015-06-13	66	16	14	0	0	0	0	31	5	0	0	0	0	2015-06-14 00:00:01.039332
198	0	2015-06-19	335	38	145	0	0	0	0	45	4	3	100	0	0	2015-06-19 23:56:21.735012
193	0	2015-06-15	345	87	173	0	0	0	0	51	10	4	20	0	0	2015-06-15 23:55:01.235819
188	0	2015-06-10	480	93	220	0	1	0	0	94	32	7	33	0	0	2015-06-10 23:55:01.41447
222	0	2015-07-13	313	46	164	0	0	0	0	21	15	1	66	0	0	2015-07-13 23:55:00.788173
212	0	2015-07-03	236	58	108	0	0	0	0	43	15	4	8	0	0	2015-07-03 23:35:01.615881
195	0	2015-06-16	401	99	184	0	0	0	0	69	7	7	34	1	0	2015-06-16 23:54:33.642857
218	0	2015-07-09	598	41	184	0	0	0	0	30	5	10	328	0	0	2015-07-09 23:45:01.51311
200	0	2015-06-21	173	9	17	0	0	1	0	30	34	0	82	0	0	2015-06-22 00:00:01.53824
209	0	2015-06-30	619	102	170	0	0	0	0	49	5	0	293	0	0	2015-07-01 00:00:01.687793
206	0	2015-06-27	112	26	12	0	0	0	0	20	12	0	42	0	0	2015-06-27 23:35:00.817777
213	0	2015-07-04	146	14	22	0	0	0	0	22	12	4	72	0	0	2015-07-04 23:50:01.113974
203	0	2015-06-24	284	65	149	0	0	0	1	31	9	1	28	0	0	2015-06-25 00:00:01.158604
223	0	2015-07-14	397	36	183	0	0	0	0	42	7	8	121	0	0	2015-07-14 23:50:01.047054
219	0	2015-07-10	288	48	154	0	0	0	0	49	25	6	6	0	0	2015-07-11 00:00:00.992569
215	0	2015-07-06	350	37	116	0	0	0	0	24	37	0	136	0	0	2015-07-07 00:00:00.952668
210	0	2015-07-01	304	75	129	0	0	0	0	56	12	1	31	0	0	2015-07-01 23:41:46.470528
214	0	2015-07-05	361	25	18	0	0	0	0	16	124	0	178	0	0	2015-07-05 23:55:00.723801
221	0	2015-07-12	79	27	18	0	0	3	0	19	8	4	0	0	0	2015-07-12 23:10:41.321735
217	0	2015-07-08	373	55	190	0	0	0	0	35	23	2	68	0	0	2015-07-09 00:00:01.46744
220	0	2015-07-11	95	19	25	0	0	0	0	34	1	6	10	0	0	2015-07-11 23:50:01.453483
224	0	2015-07-15	487	90	195	0	0	0	0	29	7	6	160	0	0	2015-07-15 23:50:00.593804
225	0	2015-07-16	462	40	171	0	0	0	0	38	12	10	191	0	0	2015-07-16 23:56:14.940321
226	0	2015-07-17	369	51	110	0	0	0	0	39	9	16	144	0	0	2015-07-18 00:00:01.091515
227	0	2015-07-18	93	29	18	0	0	0	0	22	7	6	11	0	0	2015-07-18 22:47:10.777328
228	0	2015-07-19	52	10	18	0	0	0	0	14	5	5	0	0	0	2015-07-19 23:54:24.899025
229	0	2015-07-20	260	71	132	0	0	0	0	18	21	4	14	0	0	2015-07-20 23:55:01.092097
230	0	2015-07-21	300	61	152	0	0	0	0	30	18	7	32	0	0	2015-07-21 23:35:01.324514
231	0	2015-07-22	395	63	150	0	0	0	0	30	47	5	100	0	0	2015-07-22 23:55:00.875438
232	0	2015-07-23	299	53	171	0	0	0	0	24	8	9	34	0	0	2015-07-23 23:22:44.803195
233	0	2015-07-24	295	45	141	0	0	0	0	32	38	3	36	0	0	2015-07-24 23:54:09.459496
239	0	2015-07-30	350	64	208	0	0	0	0	32	33	0	13	0	0	2015-07-30 23:15:01.563687
245	0	2015-08-05	374	49	155	0	0	1	22	44	96	0	7	0	0	2015-08-06 00:00:01.448561
238	0	2015-07-29	297	68	169	0	0	0	0	30	16	1	13	0	0	2015-07-29 23:25:11.951095
262	0	2015-08-22	96	23	21	0	0	0	0	32	13	2	5	0	0	2015-08-22 23:20:00.698717
257	0	2015-08-17	256	87	141	0	0	0	0	22	4	2	0	0	0	2015-08-17 23:59:05.122534
241	0	2015-08-01	157	22	29	0	0	0	0	50	12	2	42	0	0	2015-08-01 23:45:01.348086
242	0	2015-08-02	87	10	19	0	0	0	0	8	10	0	40	0	0	2015-08-02 23:40:00.973533
261	0	2015-08-21	240	66	139	0	0	0	0	23	11	1	0	0	0	2015-08-21 23:18:02.155112
263	0	2015-08-23	62	20	12	0	0	0	0	19	8	3	0	0	0	2015-08-23 23:15:21.07765
276	0	2015-09-05	95	13	19	0	0	0	0	18	37	0	8	0	0	2015-09-05 23:20:00.892782
251	0	2015-08-11	303	52	174	0	0	1	0	60	15	1	0	0	0	2015-08-11 23:48:34.377318
292	0	2015-09-21	279	64	155	0	0	0	0	14	44	2	0	0	0	2015-09-21 23:54:23.451781
279	0	2015-09-08	454	101	173	0	0	0	1	51	56	3	69	0	0	2015-09-08 23:56:52.64355
264	0	2015-08-24	228	58	119	0	0	0	0	32	17	0	2	0	0	2015-08-24 23:55:00.739476
250	0	2015-08-10	90	24	29	0	0	0	0	18	6	1	12	0	0	2015-08-10 23:54:16.44762
240	0	2015-07-31	512	34	134	0	0	0	21	31	238	1	53	0	0	2015-07-31 23:15:01.304233
291	0	2015-09-20	62	18	9	0	0	0	0	23	12	0	0	0	0	2015-09-20 23:56:57.205957
247	0	2015-08-07	214	74	109	0	0	0	0	20	10	1	0	0	0	2015-08-07 23:56:02.122279
235	0	2015-07-26	51	8	13	0	0	1	0	10	18	1	0	0	0	2015-07-26 23:55:01.166263
246	0	2015-08-06	411	60	160	0	0	0	133	43	10	3	2	0	0	2015-08-06 23:50:00.730931
286	0	2015-09-15	433	76	148	0	0	0	0	30	148	10	21	0	0	2015-09-16 00:00:01.23687
256	0	2015-08-16	31	9	11	0	0	0	0	8	3	0	0	0	0	2015-08-16 23:52:09.02742
244	0	2015-08-04	296	68	165	0	0	0	0	54	7	2	0	0	0	2015-08-04 23:29:29.260468
254	0	2015-08-14	243	63	135	1	0	0	0	37	4	3	0	0	0	2015-08-15 00:00:01.360455
249	0	2015-08-09	41	15	12	0	0	0	0	11	3	0	0	0	0	2015-08-09 23:50:00.751757
234	0	2015-07-25	67	20	13	0	0	0	0	23	11	0	0	0	0	2015-07-25 23:36:51.019787
237	0	2015-07-28	272	83	146	0	0	0	0	33	10	0	0	0	0	2015-07-28 23:55:29.85294
243	0	2015-08-03	245	44	123	0	0	0	0	37	11	2	28	0	0	2015-08-03 23:40:01.213212
236	0	2015-07-27	203	49	114	0	0	0	0	26	11	3	0	0	0	2015-07-27 23:50:00.655767
267	0	2015-08-27	255	69	138	0	0	0	0	31	13	4	0	0	0	2015-08-27 23:53:10.56151
280	0	2015-09-09	240	52	113	0	0	0	0	17	17	1	40	0	0	2015-09-09 23:57:31.702944
253	0	2015-08-13	295	66	127	0	0	0	0	48	47	4	3	0	0	2015-08-13 23:55:31.375131
259	0	2015-08-19	295	86	128	0	0	0	0	46	32	3	0	0	0	2015-08-19 23:35:00.823399
289	0	2015-09-18	247	88	117	0	0	0	0	29	9	4	0	0	0	2015-09-18 23:49:10.303159
278	0	2015-09-07	262	68	131	0	0	0	0	28	18	12	5	0	0	2015-09-08 00:00:00.943808
271	0	2015-08-31	264	65	148	0	0	0	0	39	10	1	1	0	0	2015-08-31 23:58:36.590056
255	0	2015-08-15	303	23	13	0	0	0	0	33	234	0	0	0	0	2015-08-15 23:51:44.951477
260	0	2015-08-20	231	62	108	0	0	0	0	45	13	3	0	0	0	2015-08-20 23:40:42.265624
258	0	2015-08-18	434	63	161	0	0	0	1	52	157	0	0	0	0	2015-08-19 00:00:01.422272
252	0	2015-08-12	280	44	151	0	0	0	0	79	4	2	0	0	0	2015-08-12 23:39:29.027506
248	0	2015-08-08	298	21	10	0	0	0	0	24	243	0	0	0	0	2015-08-08 23:51:18.371702
270	0	2015-08-30	99	39	13	0	0	0	0	35	10	1	1	0	0	2015-08-30 23:43:33.629723
268	0	2015-08-28	259	84	125	0	0	0	0	43	5	2	0	0	0	2015-08-28 23:50:00.659109
274	0	2015-09-03	277	102	120	0	0	0	0	44	9	2	0	0	0	2015-09-03 23:58:20.877767
290	0	2015-09-19	70	25	17	0	0	0	0	17	10	1	0	0	0	2015-09-19 22:54:03.524624
284	0	2015-09-13	99	23	16	0	0	0	0	5	27	4	24	0	0	2015-09-14 00:00:01.404281
269	0	2015-08-29	74	15	19	0	0	0	0	25	15	0	0	0	0	2015-08-29 23:55:01.113185
265	0	2015-08-25	330	97	143	0	0	0	0	43	40	1	6	0	0	2015-08-25 23:56:45.72258
266	0	2015-08-26	283	84	139	0	0	0	5	41	8	1	5	0	0	2015-08-26 23:58:29.735631
283	0	2015-09-12	158	24	41	0	0	0	0	11	53	4	25	0	0	2015-09-13 00:00:00.683884
275	0	2015-09-04	211	34	122	0	0	0	0	30	16	9	0	0	0	2015-09-05 00:00:01.4204
287	0	2015-09-16	383	98	157	0	0	0	5	35	81	6	1	0	0	2015-09-16 23:55:14.876617
272	0	2015-09-01	303	103	134	0	0	0	1	45	19	0	1	0	0	2015-09-01 23:54:22.4407
294	0	2015-09-23	313	105	164	0	0	0	0	37	5	2	0	0	0	2015-09-23 23:52:15.039334
273	0	2015-09-02	303	61	148	0	0	0	1	61	30	1	1	0	0	2015-09-03 00:00:00.801223
277	0	2015-09-06	283	24	12	0	0	0	0	11	232	0	4	0	0	2015-09-06 23:55:01.402235
285	0	2015-09-14	540	88	130	0	0	0	0	33	250	14	25	0	0	2015-09-15 00:00:01.456108
282	0	2015-09-11	304	77	139	0	0	0	0	36	27	2	23	0	0	2015-09-11 23:52:37.38737
281	0	2015-09-10	340	116	144	0	0	0	0	43	14	15	8	0	0	2015-09-10 23:56:37.04139
296	0	2015-09-25	239	67	134	0	0	0	0	28	7	3	0	0	0	2015-09-25 23:40:24.364678
299	0	2015-09-28	302	88	169	0	0	0	0	36	7	0	2	0	0	2015-09-28 23:50:01.013236
298	0	2015-09-27	70	37	25	0	0	0	0	7	1	0	0	0	0	2015-09-27 23:47:58.090066
293	0	2015-09-22	292	61	181	0	0	0	0	29	11	10	0	0	0	2015-09-22 23:39:09.607852
288	0	2015-09-17	396	69	153	0	0	0	0	30	141	3	0	0	0	2015-09-17 23:59:17.275235
297	0	2015-09-26	64	17	19	0	0	0	3	14	1	0	10	0	0	2015-09-26 22:25:12.507021
295	0	2015-09-24	270	84	163	0	0	0	0	21	1	1	0	0	0	2015-09-24 23:54:03.221323
300	0	2015-09-29	409	109	233	0	0	0	0	53	11	1	2	0	0	2015-09-29 23:47:51.977061
302	0	2015-10-01	266	59	173	0	0	0	0	27	6	1	0	0	0	2015-10-01 23:46:18.725612
306	0	2015-10-05	390	111	234	0	0	0	0	39	6	0	0	0	0	2015-10-05 23:55:00.748475
301	0	2015-09-30	367	115	206	0	0	0	0	38	5	3	0	0	0	2015-09-30 23:48:33.892694
303	0	2015-10-02	242	64	129	0	0	0	0	44	1	4	0	0	0	2015-10-02 23:59:18.416879
304	0	2015-10-03	120	39	19	0	0	0	0	25	33	1	3	0	0	2015-10-03 23:59:40.139396
305	0	2015-10-04	119	73	15	0	0	0	0	8	15	0	8	0	0	2015-10-04 23:53:54.740947
308	0	2015-10-07	373	134	197	0	0	0	0	36	3	1	2	0	0	2015-10-08 00:00:00.786998
307	0	2015-10-06	409	123	202	0	0	0	0	69	2	1	12	0	0	2015-10-06 23:58:52.987735
309	0	2015-10-08	318	106	181	0	1	1	0	23	1	2	3	0	0	2015-10-08 23:55:32.160119
310	0	2015-10-09	88	43	15	0	0	0	0	22	6	2	0	0	0	2015-10-10 00:00:00.684993
320	0	2015-10-19	333	98	178	0	0	0	0	50	3	3	1	0	0	2015-10-19 23:47:26.321211
327	0	2015-10-26	290	140	131	0	0	0	0	5	0	10	4	0	0	2015-10-26 23:59:40.415176
317	0	2015-10-16	287	104	148	0	0	0	0	26	2	3	4	0	0	2015-10-16 23:27:31.049254
331	0	2015-10-30	274	135	125	0	0	0	0	6	0	3	5	0	0	2015-10-30 23:57:00.813685
325	0	2015-10-24	77	31	10	0	0	0	0	27	0	0	9	0	0	2015-10-24 23:57:40.762832
356	0	2015-11-24	815	146	150	0	0	0	0	4	1	13	501	0	0	2015-11-25 00:00:00.892293
336	0	2015-11-04	342	147	166	0	0	0	0	1	25	3	0	0	0	2015-11-04 23:55:46.048913
326	0	2015-10-25	79	35	16	0	0	0	0	17	0	6	5	0	0	2015-10-25 23:52:22.431629
353	0	2015-11-21	359	69	20	0	0	0	0	5	2	0	263	0	0	2015-11-21 23:45:26.966143
348	0	2015-11-16	352	154	194	0	0	0	0	1	2	1	0	0	0	2015-11-16 23:59:42.57601
316	0	2015-10-15	308	91	145	0	0	0	0	65	2	4	1	0	0	2015-10-15 23:56:24.10555
324	0	2015-10-23	267	94	117	0	0	0	0	41	1	3	11	0	0	2015-10-23 23:39:59.741222
314	0	2015-10-13	324	85	167	0	0	0	0	68	0	1	3	0	0	2015-10-13 23:53:34.531197
330	0	2015-10-29	340	145	191	0	0	0	0	3	1	0	0	0	0	2015-10-29 23:56:06.777403
354	0	2015-11-22	483	78	17	0	0	0	0	1	0	0	387	0	0	2015-11-22 23:45:01.582008
346	0	2015-11-14	91	61	23	0	0	0	0	2	3	0	2	0	0	2015-11-14 23:35:56.58653
359	0	2015-11-27	543	159	200	0	0	0	15	1	1	3	164	0	0	2015-11-27 23:57:23.602933
337	0	2015-11-05	299	108	187	0	0	0	0	2	1	1	0	0	0	2015-11-05 23:55:00.783597
318	0	2015-10-17	109	26	19	0	0	0	0	23	34	4	3	0	0	2015-10-17 23:05:36.662971
323	0	2015-10-22	342	143	155	0	0	0	0	40	0	4	0	0	0	2015-10-22 23:59:39.281928
340	0	2015-11-08	63	52	6	0	0	0	0	0	4	1	0	0	0	2015-11-08 22:48:53.014963
315	0	2015-10-14	332	78	197	0	0	0	0	48	1	1	7	0	0	2015-10-14 23:58:53.978369
312	0	2015-10-11	60	26	16	0	0	0	0	16	2	0	0	0	0	2015-10-11 23:48:12.37646
361	0	2015-11-29	177	40	13	0	0	0	0	2	10	1	111	0	0	2015-11-29 23:55:00.933332
358	0	2015-11-26	614	126	160	0	0	0	0	0	8	7	313	0	0	2015-11-27 00:00:01.641981
333	0	2015-11-01	84	58	12	0	0	0	0	1	10	0	3	0	0	2015-11-01 23:56:07.199067
352	0	2015-11-20	261	95	158	0	0	0	0	1	3	0	4	0	0	2015-11-20 23:47:41.915427
347	0	2015-11-15	59	37	21	0	0	0	0	0	1	0	0	0	0	2015-11-15 23:48:09.287564
322	0	2015-10-21	300	90	144	0	0	0	0	31	26	5	4	0	0	2015-10-22 00:00:00.615928
339	0	2015-11-07	75	59	10	0	0	0	0	2	4	0	0	0	0	2015-11-07 23:37:25.654777
321	0	2015-10-20	304	86	177	0	0	0	0	32	2	4	3	0	0	2015-10-20 23:54:16.299218
313	0	2015-10-12	355	125	183	0	0	0	0	27	3	3	14	0	0	2015-10-12 23:55:01.280571
350	0	2015-11-18	342	127	209	0	0	0	0	5	0	1	0	0	0	2015-11-18 23:54:04.693497
329	0	2015-10-28	639	155	173	0	0	0	0	5	300	6	0	0	0	2015-10-28 23:57:11.756749
311	0	2015-10-10	99	37	13	0	0	0	0	18	28	2	1	0	0	2015-10-10 23:32:03.75551
334	0	2015-11-02	41	28	8	0	0	0	0	1	3	0	1	0	0	2015-11-02 22:29:15.001771
335	0	2015-11-03	84	65	19	0	0	0	0	0	0	0	0	0	0	2015-11-03 23:57:57.941964
319	0	2015-10-18	69	31	15	0	0	0	0	13	6	4	0	0	0	2015-10-18 23:30:17.671784
357	0	2015-11-25	1149	167	132	0	0	0	16	2	301	4	527	0	0	2015-11-25 23:53:32.071609
338	0	2015-11-06	261	107	150	0	0	0	0	2	1	1	0	0	0	2015-11-06 23:56:05.826096
366	0	2015-12-04	425	93	138	0	0	0	0	5	188	1	0	0	0	2015-12-04 23:56:19.855274
375	0	2015-12-13	481	38	13	0	0	0	0	0	26	0	404	0	0	2015-12-14 00:00:01.008481
328	0	2015-10-27	280	108	163	0	0	0	5	2	1	1	0	0	0	2015-10-27 23:48:41.996919
349	0	2015-11-17	296	110	165	0	0	0	0	5	4	12	0	0	0	2015-11-17 23:50:43.095154
343	0	2015-11-11	318	158	151	0	1	0	0	5	1	1	1	0	0	2015-11-11 23:32:26.867981
345	0	2015-11-13	380	118	236	0	0	0	0	7	4	15	0	0	0	2015-11-13 23:59:11.222093
332	0	2015-10-31	109	65	28	0	0	0	0	1	3	3	9	0	0	2015-10-31 23:42:35.386064
344	0	2015-11-12	322	150	147	0	0	0	0	11	0	14	0	0	0	2015-11-12 23:54:39.688278
341	0	2015-11-09	298	98	194	0	0	0	0	5	0	1	0	0	0	2015-11-09 23:54:54.471031
374	0	2015-12-12	326	70	22	0	0	0	0	2	24	3	205	0	0	2015-12-13 00:00:01.199133
342	0	2015-11-10	331	143	183	0	0	0	0	4	0	1	0	0	0	2015-11-10 23:58:26.929323
372	0	2015-12-10	339	159	150	0	0	0	1	10	18	1	0	0	0	2015-12-10 23:57:58.968446
370	0	2015-12-08	539	139	167	0	0	0	0	8	3	2	220	0	0	2015-12-08 23:50:33.111194
351	0	2015-11-19	312	137	167	0	0	0	0	7	0	1	0	0	0	2015-11-19 23:55:58.794544
368	0	2015-12-06	100	55	13	0	0	0	0	0	13	1	18	0	0	2015-12-06 23:42:13.288661
363	0	2015-12-01	367	192	152	0	0	0	2	1	13	7	0	0	0	2015-12-01 23:47:03.621722
362	0	2015-11-30	410	124	203	0	0	0	2	7	24	9	41	0	0	2015-11-30 23:53:06.806989
355	0	2015-11-23	1219	105	159	0	0	0	0	0	300	2	653	0	0	2015-11-24 00:00:01.750163
369	0	2015-12-07	406	86	168	0	0	0	0	10	100	14	28	0	0	2015-12-07 23:55:01.430317
360	0	2015-11-28	180	31	30	0	0	0	0	1	3	1	114	0	0	2015-11-28 23:55:49.245207
365	0	2015-12-03	348	175	144	0	0	0	1	7	13	8	0	0	0	2015-12-03 23:57:46.586902
364	0	2015-12-02	420	205	186	0	0	0	2	2	18	6	1	0	0	2015-12-02 23:54:39.218932
367	0	2015-12-05	94	54	20	0	0	0	0	2	18	0	0	0	0	2015-12-05 23:25:01.031449
371	0	2015-12-09	415	145	167	0	0	0	0	0	102	1	0	0	0	2015-12-09 23:49:55.771154
380	0	2015-12-18	287	135	148	0	0	0	0	3	0	1	0	0	0	2015-12-18 23:35:15.884481
377	0	2015-12-15	625	160	112	0	0	0	0	2	12	6	333	0	0	2015-12-16 00:00:00.743761
373	0	2015-12-11	348	164	146	0	0	0	0	6	20	8	4	0	0	2015-12-12 00:00:01.454622
378	0	2015-12-16	325	147	151	0	0	0	0	11	1	8	7	0	0	2015-12-16 23:54:08.693554
376	0	2015-12-14	746	155	125	0	0	0	3	2	25	16	420	0	0	2015-12-15 00:00:00.748429
379	0	2015-12-17	307	154	139	0	0	0	0	1	0	13	0	0	0	2015-12-18 00:00:01.68716
381	0	2015-12-19	94	68	22	0	0	1	0	1	2	0	0	0	0	2015-12-19 23:52:48.49042
382	0	2015-12-20	76	56	18	0	0	0	0	0	2	0	0	0	0	2015-12-20 23:36:21.4172
383	0	2015-12-21	251	123	112	0	3	0	0	0	6	7	0	0	0	2015-12-21 23:56:19.675433
384	0	2015-12-22	212	111	89	0	0	0	0	7	2	3	0	0	0	2015-12-22 18:07:37.866925
385	0	2015-12-23	248	78	158	0	0	0	0	2	1	9	0	0	0	2015-12-23 23:52:52.252193
387	0	2015-12-24	353	72	124	0	2	1	0	2	152	0	0	0	0	2015-12-24 23:12:11.625074
388	0	2015-12-25	52	32	14	0	0	0	0	2	4	0	0	0	0	2015-12-25 23:23:02.12155
406	0	2016-01-12	396	151	176	0	0	0	0	7	2	7	53	0	0	2016-01-12 23:57:53.125658
398	0	2016-01-04	282	112	154	0	1	0	0	1	10	4	0	0	0	2016-01-04 23:50:01.526358
421	0	2016-01-27	367	162	191	0	0	0	5	2	0	7	0	0	0	2016-01-27 23:29:27.332637
416	0	2016-01-22	642	138	165	0	0	0	0	17	322	0	0	0	0	2016-01-22 23:45:00.682878
389	0	2015-12-26	52	31	18	0	0	0	0	0	3	0	0	0	0	2015-12-26 23:56:08.034542
412	0	2016-01-18	406	151	240	0	1	0	0	6	1	7	0	0	0	2016-01-18 23:46:23.831511
414	0	2016-01-20	341	143	177	0	0	0	0	2	15	4	0	0	0	2016-01-20 23:54:09.416437
395	0	2016-01-01	29	11	12	0	2	0	0	0	0	4	0	0	0	2016-01-01 23:17:46.015484
391	0	2015-12-28	318	127	132	0	1	0	0	0	2	0	56	0	0	2015-12-28 23:55:39.472422
413	0	2016-01-19	689	158	220	0	1	0	0	7	301	2	0	0	0	2016-01-19 23:39:15.46731
392	0	2015-12-29	245	92	133	0	2	0	0	1	4	0	13	0	0	2015-12-29 23:55:45.356459
451	0	2016-02-26	3126	85	170	0	0	0	0	18	307	7	2539	0	0	2016-02-27 00:00:01.799096
437	0	2016-02-12	638	106	183	0	0	0	0	18	0	10	321	0	0	2016-02-13 00:00:01.24382
449	0	2016-02-24	777	179	188	0	0	0	0	14	11	2	383	0	0	2016-02-25 00:00:01.077935
420	0	2016-01-26	673	151	192	0	1	0	0	23	302	4	0	0	0	2016-01-26 23:58:25.25655
390	0	2015-12-27	43	30	6	0	0	0	0	3	0	0	4	0	0	2015-12-28 00:00:01.255918
441	0	2016-02-16	3918	157	215	0	0	0	0	10	5	2	3529	0	0	2016-02-17 00:00:01.583895
423	0	2016-01-29	354	108	222	0	0	0	0	3	21	0	0	0	0	2016-01-29 23:54:21.289229
411	0	2016-01-17	82	58	24	0	0	0	0	0	0	0	0	0	0	2016-01-17 23:34:02.059253
410	0	2016-01-16	83	49	26	0	0	0	0	1	5	2	0	0	0	2016-01-16 23:37:58.339265
394	0	2015-12-31	114	57	53	0	0	0	0	0	1	3	0	0	0	2015-12-31 23:49:08.663896
430	0	2016-02-05	683	138	227	0	0	0	0	3	1	0	314	0	0	2016-02-06 00:00:01.095674
408	0	2016-01-14	358	158	188	0	0	0	0	5	5	2	0	0	0	2016-01-14 23:42:22.202432
396	0	2016-01-02	47	20	13	0	1	0	5	1	2	5	0	0	0	2016-01-02 23:57:06.007594
401	0	2016-01-07	582	135	119	0	2	2	0	2	310	12	0	0	0	2016-01-07 23:34:11.403155
426	0	2016-02-01	505	117	209	0	0	0	0	13	100	6	60	0	0	2016-02-01 23:47:04.697435
404	0	2016-01-10	99	33	22	0	0	0	0	3	6	1	34	0	0	2016-01-10 23:16:26.764064
402	0	2016-01-08	341	98	126	0	0	0	0	2	111	4	0	0	0	2016-01-08 23:52:21.455507
393	0	2015-12-30	671	127	115	0	0	0	0	0	425	4	0	0	0	2015-12-30 23:57:49.556891
425	0	2016-01-31	588	61	31	0	0	0	0	1	30	0	465	0	0	2016-01-31 23:57:28.083119
399	0	2016-01-05	371	137	157	0	0	2	0	2	5	7	61	0	0	2016-01-05 23:35:00.838822
445	0	2016-02-20	295	64	30	0	0	0	32	0	1	0	168	0	0	2016-02-20 23:32:34.291684
419	0	2016-01-25	362	124	202	0	1	0	0	18	12	5	0	0	0	2016-01-25 23:56:27.950921
424	0	2016-01-30	207	56	35	0	0	0	0	0	22	0	94	0	0	2016-01-31 00:00:01.207629
397	0	2016-01-03	61	44	16	0	0	0	0	0	1	0	0	0	0	2016-01-03 23:59:02.237622
405	0	2016-01-11	394	136	145	0	0	1	0	3	47	1	61	0	0	2016-01-11 23:52:13.828688
438	0	2016-02-13	242	41	58	0	0	0	0	4	1	3	135	0	0	2016-02-13 23:50:01.162716
400	0	2016-01-06	308	139	149	0	0	0	0	3	6	11	0	0	0	2016-01-06 23:46:14.862143
407	0	2016-01-13	269	112	119	0	0	0	0	6	6	8	18	0	0	2016-01-13 23:20:20.294939
422	0	2016-01-28	343	130	185	0	1	0	0	5	16	6	0	0	0	2016-01-28 23:55:00.575364
417	0	2016-01-23	126	76	25	0	0	0	0	0	25	0	0	0	0	2016-01-23 23:28:36.110392
409	0	2016-01-15	318	148	142	0	0	2	0	2	0	2	22	0	0	2016-01-15 23:52:34.839903
444	0	2016-02-19	2757	123	195	0	0	0	5	13	46	2	2373	0	0	2016-02-20 00:00:00.969253
403	0	2016-01-09	416	68	26	0	2	0	5	0	301	4	10	0	0	2016-01-09 23:29:36.210899
440	0	2016-02-15	698	150	241	0	0	0	0	9	78	2	218	0	0	2016-02-16 00:00:01.226407
439	0	2016-02-14	63	20	13	0	0	0	0	3	20	1	6	0	0	2016-02-14 23:58:01.756396
418	0	2016-01-24	470	35	14	0	0	0	0	0	421	0	0	0	0	2016-01-24 23:56:31.331041
415	0	2016-01-21	373	154	165	0	0	0	0	7	21	4	22	0	0	2016-01-21 23:37:01.466945
434	0	2016-02-09	798	49	24	0	0	0	0	3	0	0	722	0	0	2016-02-10 00:00:00.76633
433	0	2016-02-08	464	25	32	0	0	0	0	4	2	0	401	0	0	2016-02-09 00:00:01.304899
429	0	2016-02-04	874	191	256	0	0	0	0	12	159	4	252	0	0	2016-02-05 00:00:01.065088
432	0	2016-02-07	261	42	11	0	0	0	0	0	0	1	207	0	0	2016-02-08 00:00:01.331434
442	0	2016-02-17	720	169	174	0	0	0	0	20	5	6	346	0	0	2016-02-18 00:00:01.040572
428	0	2016-02-03	1950	144	215	0	0	0	0	5	1	3	1582	0	0	2016-02-03 23:45:14.449133
427	0	2016-02-02	714	153	247	0	0	1	0	5	30	9	269	0	0	2016-02-03 00:00:01.281526
436	0	2016-02-11	657	115	195	0	0	0	0	19	4	7	317	0	0	2016-02-11 23:55:01.536684
431	0	2016-02-06	575	49	25	0	0	0	0	0	0	0	501	0	0	2016-02-06 23:50:00.952843
435	0	2016-02-10	3584	122	221	0	0	0	0	19	1	6	3215	0	0	2016-02-11 00:00:02.78975
447	0	2016-02-22	598	163	266	0	0	0	0	6	120	3	40	0	0	2016-02-22 23:58:22.180511
453	0	2016-02-28	545	78	22	0	0	0	0	3	151	0	291	0	0	2016-02-28 23:43:53.906936
454	0	2016-02-29	473	103	235	0	0	0	0	9	102	2	22	0	0	2016-02-29 23:52:46.031921
443	0	2016-02-18	1345	131	191	0	0	0	0	18	5	2	998	0	0	2016-02-19 00:00:01.445217
446	0	2016-02-21	129	39	13	0	0	0	0	1	2	0	74	0	0	2016-02-21 23:55:00.832398
452	0	2016-02-27	1163	54	30	0	0	0	0	8	4	7	1060	0	0	2016-02-27 23:44:22.756213
450	0	2016-02-25	784	95	204	0	0	0	5	11	7	5	457	0	0	2016-02-26 00:00:01.035415
448	0	2016-02-23	2156	162	226	0	0	0	0	17	16	4	1731	0	0	2016-02-24 00:00:01.557274
459	0	2016-03-05	125	43	27	0	0	0	0	3	0	0	52	0	0	2016-03-05 23:55:01.4689
456	0	2016-03-02	672	129	235	0	0	1	0	19	123	1	164	0	0	2016-03-03 00:00:01.012048
455	0	2016-03-01	414	128	205	0	0	0	0	14	13	2	52	0	0	2016-03-01 23:56:50.426545
457	0	2016-03-03	3273	136	220	0	0	0	0	16	44	2	2855	0	0	2016-03-04 00:00:06.099955
458	0	2016-03-04	700	103	166	0	0	0	0	5	93	0	333	0	0	2016-03-04 23:56:56.454689
461	0	2016-03-07	578	133	242	0	0	0	0	25	9	3	166	0	0	2016-03-07 23:53:17.228627
460	0	2016-03-06	532	37	20	0	0	0	2	0	150	0	323	0	0	2016-03-06 23:50:06.069915
463	0	2016-03-09	2061	107	201	0	0	0	0	8	11	2	1732	0	0	2016-03-10 00:00:00.997344
462	0	2016-03-08	2122	119	209	0	0	0	5	18	15	5	1751	0	0	2016-03-09 00:00:01.52681
464	0	2016-03-10	484	91	205	0	0	0	0	7	1	1	179	0	0	2016-03-11 00:00:00.770922
465	0	2016-03-11	532	102	162	0	0	0	1	17	60	1	189	0	0	2016-03-11 23:54:58.858843
466	0	2016-03-12	168	52	36	0	0	0	0	11	0	0	69	0	0	2016-03-12 23:56:22.310925
469	0	2016-03-15	2321	128	240	0	0	3	0	13	0	0	1937	0	0	2016-03-16 00:00:01.716178
467	0	2016-03-13	336	68	41	0	0	0	0	10	152	0	65	0	0	2016-03-13 23:50:01.155404
468	0	2016-03-14	555	85	240	0	0	0	0	15	154	3	58	0	0	2016-03-14 23:53:15.672096
470	0	2016-03-16	2393	70	124	0	0	0	0	14	1	0	2184	0	0	2016-03-16 15:53:42.612932
\.


--
-- Data for Name: staticroutes; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY staticroutes (id, ipnetwork, gateway, type, active, comment) FROM stdin;
\.


--
-- Data for Name: stats; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY stats (id, type, date, ok, info) FROM stdin;
1	L	2014-11-20 08:52:15.275651	Y	admin
2	L	2014-11-20 08:59:55.670356	Y	admin
3	L	2014-11-20 09:00:35.70382	Y	admin
4	L	2014-11-20 09:03:08.283367	Y	admin
5	L	2014-11-20 09:18:21.637419	Y	admin
6	V	2014-11-20 09:30:48.091054	N	freshclam error:  52
7	L	2014-11-20 09:45:49.514972	Y	admin
8	V	2014-11-20 10:10:46.031164	N	freshclam error:  52
9	L	2014-11-20 10:31:13.347536	Y	admin
10	V	2014-11-20 11:10:49.513449	N	freshclam error:  52
11	V	2014-11-20 12:10:39.484452	N	freshclam error:  52
12	V	2014-11-20 13:10:34.343425	N	freshclam error:  52
13	V	2014-11-20 14:10:35.963415	N	freshclam error:  52
14	V	2014-11-20 15:10:37.493553	N	freshclam error:  52
15	V	2014-11-20 16:10:39.51332	N	freshclam error:  52
16	V	2014-11-20 17:10:43.50403	N	freshclam error:  52
17	L	2014-11-20 17:23:33.674036	N	admin
18	V	2014-11-20 18:10:39.558538	N	freshclam error:  52
19	V	2014-11-20 19:10:43.628928	N	freshclam error:  52
20	V	2014-11-20 20:10:34.144242	N	freshclam error:  52
21	V	2014-11-20 21:10:40.38426	N	freshclam error:  52
22	V	2014-11-20 22:10:43.073619	N	freshclam error:  52
23	V	2014-11-20 23:10:51.793155	N	freshclam error:  52
24	V	2014-11-21 00:10:42.553812	N	freshclam error:  52
25	V	2014-11-21 01:10:40.368605	N	freshclam error:  52
26	V	2014-11-21 02:10:36.578638	N	freshclam error:  52
27	R	2014-11-21 03:05:00.485404	Y	0
28	V	2014-11-21 03:10:33.913574	N	freshclam error:  52
29	S	2014-11-21 03:31:19.247658	N	Cannot contact server
30	F	2014-11-21 03:32:34.736918	N	Cannot contact ANY update server
31	V	2014-11-21 04:10:39.678579	N	freshclam error:  52
32	V	2014-11-21 05:10:37.004427	N	freshclam error:  52
33	V	2014-11-21 06:10:33.794088	N	freshclam error:  52
34	V	2014-11-21 07:10:44.009274	N	freshclam error:  52
35	V	2014-11-21 08:10:42.544222	N	freshclam error:  52
36	V	2014-11-21 09:10:15.13346	N	freshclam error:  52
37	V	2014-11-21 10:10:42.838886	N	freshclam error:  52
38	V	2014-11-21 11:10:48.533652	N	freshclam error:  52
39	V	2014-11-21 12:10:28.478977	N	freshclam error:  52
40	V	2014-11-21 13:10:37.164785	N	freshclam error:  52
41	V	2014-11-21 14:10:45.93901	N	freshclam error:  52
42	V	2014-11-21 15:10:39.763737	N	freshclam error:  52
43	V	2014-11-21 16:10:46.034432	N	freshclam error:  52
44	V	2014-11-21 17:10:30.938798	N	freshclam error:  52
45	V	2014-11-21 18:10:40.139259	N	freshclam error:  52
46	V	2014-11-21 19:10:43.333829	N	freshclam error:  52
47	V	2014-11-21 20:10:43.449732	N	freshclam error:  52
48	V	2014-11-21 21:10:54.683904	N	freshclam error:  52
49	V	2014-11-21 22:10:39.418393	N	freshclam error:  52
50	V	2014-11-21 23:10:48.488603	N	freshclam error:  52
51	V	2014-11-22 00:10:42.973973	N	freshclam error:  52
52	V	2014-11-22 01:10:33.714049	N	freshclam error:  52
53	V	2014-11-22 02:10:36.898767	N	freshclam error:  52
54	S	2014-11-22 03:03:39.1725	N	Cannot contact server
55	F	2014-11-22 03:04:54.692065	N	Cannot contact ANY update server
56	R	2014-11-22 03:05:01.024377	Y	0
57	V	2014-11-22 03:10:34.219625	N	freshclam error:  52
58	V	2014-11-22 04:10:42.769264	N	freshclam error:  52
59	V	2014-11-22 05:10:37.008924	N	freshclam error:  52
60	V	2014-11-22 06:10:46.298747	N	freshclam error:  52
61	V	2014-11-22 07:10:58.573795	N	freshclam error:  52
62	V	2014-11-22 08:10:48.974314	N	freshclam error:  52
63	V	2014-11-22 09:10:39.798696	N	freshclam error:  52
64	V	2014-11-22 10:10:45.629284	N	freshclam error:  52
65	V	2014-11-22 11:10:33.044238	N	freshclam error:  52
66	V	2014-11-22 12:10:46.133556	N	freshclam error:  52
67	V	2014-11-22 13:10:39.764476	N	freshclam error:  52
68	V	2014-11-22 14:10:37.033973	N	freshclam error:  52
69	V	2014-11-22 15:10:49.00902	N	freshclam error:  52
70	V	2014-11-22 16:10:43.049565	N	freshclam error:  52
71	V	2014-11-22 17:10:45.594696	N	freshclam error:  52
72	V	2014-11-22 18:10:47.549065	N	freshclam error:  52
73	V	2014-11-22 19:10:40.819009	N	freshclam error:  52
74	V	2014-11-22 20:10:43.368447	N	freshclam error:  52
75	V	2014-11-22 21:10:30.409342	N	freshclam error:  52
76	V	2014-11-22 22:10:45.954223	N	freshclam error:  52
77	V	2014-11-22 23:10:48.734188	N	freshclam error:  52
78	V	2014-11-23 00:10:43.069692	N	freshclam error:  52
79	V	2014-11-23 01:10:30.7989	N	freshclam error:  52
80	V	2014-11-23 02:10:28.488905	N	freshclam error:  52
81	S	2014-11-23 03:03:42.124476	N	Cannot contact server
82	F	2014-11-23 03:04:57.627191	N	Cannot contact ANY update server
83	R	2014-11-23 03:05:00.792585	Y	0
84	V	2014-11-23 03:10:31.073511	N	freshclam error:  52
85	V	2014-11-23 04:10:46.603817	N	freshclam error:  52
86	V	2014-11-23 05:10:39.669094	N	freshclam error:  52
87	V	2014-11-23 06:10:40.663588	N	freshclam error:  52
88	V	2014-11-23 07:10:40.133942	N	freshclam error:  52
89	V	2014-11-23 08:10:40.648839	N	freshclam error:  52
90	V	2014-11-23 09:10:40.33896	N	freshclam error:  52
91	V	2014-11-23 10:10:37.169005	N	freshclam error:  52
92	V	2014-11-23 11:10:54.819484	N	freshclam error:  52
93	V	2014-11-23 12:10:37.543848	N	freshclam error:  52
94	V	2014-11-23 13:10:48.859136	N	freshclam error:  52
95	V	2014-11-23 14:10:30.928913	N	freshclam error:  52
96	V	2014-11-23 15:10:34.208896	N	freshclam error:  52
97	V	2014-11-23 16:10:42.428628	N	freshclam error:  52
98	V	2014-11-23 17:10:34.153862	N	freshclam error:  52
99	V	2014-11-23 18:10:37.634044	N	freshclam error:  52
100	V	2014-11-23 19:10:55.29975	N	freshclam error:  52
101	V	2014-11-23 20:10:40.1991	N	freshclam error:  52
102	V	2014-11-23 21:10:49.498682	N	freshclam error:  52
103	V	2014-11-23 22:10:39.38934	N	freshclam error:  52
104	V	2014-11-23 23:10:34.905239	N	freshclam error:  52
105	V	2014-11-24 00:10:48.469574	N	freshclam error:  52
106	V	2014-11-24 01:10:46.34355	N	freshclam error:  52
107	V	2014-11-24 02:10:49.329572	N	freshclam error:  52
108	S	2014-11-24 03:03:41.378532	N	Cannot contact server
109	F	2014-11-24 03:04:56.917369	N	Cannot contact ANY update server
110	R	2014-11-24 03:05:00.521848	Y	0
111	V	2014-11-24 03:10:45.994444	N	freshclam error:  52
112	V	2014-11-24 04:10:36.529077	N	freshclam error:  52
113	V	2014-11-24 05:10:43.379102	N	freshclam error:  52
114	V	2014-11-24 06:10:45.7438	N	freshclam error:  52
115	V	2014-11-24 07:10:37.338651	N	freshclam error:  52
116	V	2014-11-24 08:10:45.719285	N	freshclam error:  52
117	V	2014-11-24 09:10:37.349529	N	freshclam error:  52
118	V	2014-11-24 10:12:05.495067	N	freshclam error:  58
119	V	2014-11-24 11:06:17.038913	N	freshclam error:  58
120	V	2014-11-24 12:06:17.189037	N	freshclam error:  58
121	V	2014-11-24 13:06:17.46862	N	freshclam error:  58
122	V	2014-11-24 14:06:17.72345	N	freshclam error:  58
123	V	2014-11-24 15:06:17.793827	N	freshclam error:  58
124	V	2014-11-24 16:06:16.904745	N	freshclam error:  58
125	V	2014-11-24 17:06:17.643946	N	freshclam error:  58
126	V	2014-11-24 18:06:17.443907	N	freshclam error:  58
127	V	2014-11-24 19:06:19.08387	N	freshclam error:  58
128	V	2014-11-24 20:06:17.553745	N	freshclam error:  58
129	V	2014-11-24 21:06:17.27839	N	freshclam error:  58
130	V	2014-11-24 22:06:16.899434	N	freshclam error:  58
131	V	2014-11-24 23:06:17.599519	N	freshclam error:  58
132	V	2014-11-25 00:06:16.888623	N	freshclam error:  58
133	V	2014-11-25 01:06:17.584166	N	freshclam error:  58
134	V	2014-11-25 02:06:17.159483	N	freshclam error:  58
135	S	2014-11-25 03:03:20.127138	N	Cannot contact server
136	F	2014-11-25 03:03:35.631674	N	Cannot contact ANY update server
137	R	2014-11-25 03:05:00.511223	Y	0
138	V	2014-11-25 03:06:23.973681	N	freshclam error:  58
139	V	2014-11-25 04:06:17.259034	N	freshclam error:  58
140	V	2014-11-25 05:06:17.029619	N	freshclam error:  58
141	V	2014-11-25 06:06:17.599024	N	freshclam error:  58
142	V	2014-11-25 07:06:17.149578	N	freshclam error:  58
143	V	2014-11-25 08:06:17.753742	N	freshclam error:  58
144	V	2014-11-25 09:06:17.398756	N	freshclam error:  58
145	V	2014-11-25 10:06:17.063982	N	freshclam error:  58
146	V	2014-11-25 11:06:16.908684	N	freshclam error:  58
147	V	2014-11-25 12:06:17.598585	N	freshclam error:  58
148	V	2014-11-25 13:06:17.168792	N	freshclam error:  58
149	V	2014-11-25 14:06:17.273723	N	freshclam error:  58
150	V	2014-11-25 15:06:16.903845	N	freshclam error:  58
151	V	2014-11-25 16:06:17.394063	N	freshclam error:  58
152	V	2014-11-25 17:06:17.003404	N	freshclam error:  58
153	V	2014-11-25 18:06:17.543662	N	freshclam error:  58
154	V	2014-11-25 19:06:17.028671	N	freshclam error:  58
155	V	2014-11-25 20:06:17.573597	N	freshclam error:  58
156	V	2014-11-25 21:06:17.173969	N	freshclam error:  58
157	V	2014-11-25 22:06:17.753743	N	freshclam error:  58
158	V	2014-11-25 23:06:17.428736	N	freshclam error:  58
159	V	2014-11-26 00:06:17.668895	N	freshclam error:  58
160	V	2014-11-26 01:06:17.380243	N	freshclam error:  58
161	V	2014-11-26 02:06:17.033708	N	freshclam error:  58
162	S	2014-11-26 03:03:16.702046	N	Cannot contact server
163	F	2014-11-26 03:03:32.216808	N	Cannot contact ANY update server
164	R	2014-11-26 03:05:01.083381	Y	0
165	V	2014-11-26 03:06:26.54907	N	freshclam error:  58
166	V	2014-11-26 04:06:16.89419	N	freshclam error:  58
167	V	2014-11-26 05:06:17.283652	N	freshclam error:  58
168	V	2014-11-26 06:06:17.758662	N	freshclam error:  58
169	V	2014-11-26 07:06:17.323769	N	freshclam error:  58
170	V	2014-11-26 08:06:16.983772	N	freshclam error:  58
171	V	2014-11-26 09:06:17.668949	N	freshclam error:  58
172	V	2014-11-26 10:06:17.484836	N	freshclam error:  58
173	V	2014-11-26 11:06:17.144128	N	freshclam error:  58
174	V	2014-11-26 12:06:17.7548	N	freshclam error:  58
175	V	2014-11-26 13:06:17.489046	N	freshclam error:  58
176	V	2014-11-26 14:13:43.214293	N	freshclam error:  52
177	V	2014-11-26 15:10:39.708873	N	freshclam error:  52
178	V	2014-11-26 16:10:31.073717	N	freshclam error:  52
179	V	2014-11-26 17:10:47.514017	N	freshclam error:  52
180	V	2014-11-26 18:10:43.073654	N	freshclam error:  52
181	V	2014-11-26 19:10:41.934275	N	freshclam error:  52
182	V	2014-11-26 20:10:34.150207	N	freshclam error:  52
183	V	2014-11-26 21:10:42.233718	N	freshclam error:  52
184	V	2014-11-26 22:10:48.938681	N	freshclam error:  52
185	V	2014-11-26 23:10:40.128779	N	freshclam error:  52
186	V	2014-11-27 00:10:40.183929	N	freshclam error:  52
187	V	2014-11-27 01:10:37.008743	N	freshclam error:  52
188	V	2014-11-27 02:10:48.664536	N	freshclam error:  52
189	S	2014-11-27 03:03:48.302942	N	Cannot contact server
190	R	2014-11-27 03:05:00.735428	Y	0
191	F	2014-11-27 03:05:03.821812	N	Cannot contact ANY update server
192	V	2014-11-27 03:10:36.773624	N	freshclam error:  52
193	V	2014-11-27 04:10:49.473902	N	freshclam error:  52
194	V	2014-11-27 05:10:42.769585	N	freshclam error:  52
195	V	2014-11-27 06:10:43.008486	N	freshclam error:  52
196	V	2014-11-27 07:10:39.784203	N	freshclam error:  52
197	V	2014-11-27 08:10:39.195409	N	freshclam error:  52
198	V	2014-11-27 09:10:49.09383	N	freshclam error:  52
199	V	2014-11-27 10:10:48.248997	N	freshclam error:  52
200	V	2014-11-27 11:10:34.299081	N	freshclam error:  52
201	V	2014-11-27 12:10:36.804533	N	freshclam error:  52
202	V	2014-11-27 13:10:55.009316	N	freshclam error:  52
203	V	2014-11-27 14:10:42.385753	N	freshclam error:  52
204	V	2014-11-27 15:10:37.229001	N	freshclam error:  52
205	V	2014-11-27 16:10:45.583708	N	freshclam error:  52
206	V	2014-11-27 17:10:40.108702	N	freshclam error:  52
207	V	2014-11-27 18:10:36.818942	N	freshclam error:  52
208	V	2014-11-27 19:10:45.063977	N	freshclam error:  52
209	V	2014-11-27 20:10:36.529238	N	freshclam error:  52
210	V	2014-11-27 21:10:42.809011	N	freshclam error:  52
211	V	2014-11-27 22:10:39.884372	N	freshclam error:  52
212	V	2014-11-27 23:10:42.904998	N	freshclam error:  52
213	V	2014-11-28 00:10:39.918338	N	freshclam error:  52
214	V	2014-11-28 01:10:46.773811	N	freshclam error:  52
215	V	2014-11-28 02:10:36.309121	N	freshclam error:  52
216	S	2014-11-28 03:03:38.527316	N	Cannot contact server
217	F	2014-11-28 03:04:54.016975	N	Cannot contact ANY update server
218	R	2014-11-28 03:05:00.435326	Y	0
219	V	2014-11-28 03:10:46.473802	N	freshclam error:  52
220	V	2014-11-28 04:10:43.454136	N	freshclam error:  52
221	V	2014-11-28 05:10:43.073693	N	freshclam error:  52
222	V	2014-11-28 06:10:33.878917	N	freshclam error:  52
223	V	2014-11-28 07:10:33.70958	N	freshclam error:  52
224	V	2014-11-28 08:10:37.619111	N	freshclam error:  52
225	V	2014-11-28 09:10:40.724792	N	freshclam error:  52
226	V	2014-11-28 10:10:40.398959	N	freshclam error:  52
227	V	2014-11-28 11:10:28.599449	N	freshclam error:  52
228	L	2014-11-28 11:14:08.939244	Y	admin
229	L	2014-11-28 11:48:00.821286	N	admin
230	L	2014-11-28 11:48:07.372236	Y	admin
231	V	2014-11-28 12:10:37.788607	N	freshclam error:  52
232	L	2014-11-28 12:22:09.643233	Y	admin
233	V	2014-11-28 13:10:37.363681	N	freshclam error:  52
234	L	2014-11-28 13:11:36.369464	Y	admin
235	L	2014-11-28 13:22:52.147885	Y	admin
236	V	2014-11-28 14:10:40.373426	N	freshclam error:  52
237	V	2014-11-28 15:10:49.268512	N	freshclam error:  52
238	V	2014-11-28 16:10:37.149752	N	freshclam error:  52
239	L	2014-11-28 16:26:03.089607	Y	admin
240	V	2014-11-28 17:10:40.354339	N	freshclam error:  52
241	V	2014-11-28 18:10:21.614037	N	freshclam error:  52
242	V	2014-11-28 19:10:49.33453	N	freshclam error:  52
243	V	2014-11-28 20:10:30.419383	N	freshclam error:  52
244	V	2014-11-28 21:10:49.150765	N	freshclam error:  52
245	V	2014-11-28 22:10:45.763638	N	freshclam error:  52
246	V	2014-11-28 23:10:37.673447	N	freshclam error:  52
247	V	2014-11-29 00:10:49.358541	N	freshclam error:  52
248	V	2014-11-29 01:10:34.04936	N	freshclam error:  52
249	V	2014-11-29 02:10:33.328621	N	freshclam error:  52
250	R	2014-11-29 03:05:00.474212	Y	0
251	V	2014-11-29 03:10:46.024278	N	freshclam error:  52
252	S	2014-11-29 03:31:09.797319	N	Cannot contact server
253	F	2014-11-29 03:32:25.307778	N	Cannot contact ANY update server
254	V	2014-11-29 04:10:39.583898	N	freshclam error:  52
255	V	2014-11-29 05:10:31.304651	N	freshclam error:  52
256	V	2014-11-29 06:10:51.575009	N	freshclam error:  52
257	V	2014-11-29 07:10:52.460144	N	freshclam error:  52
258	V	2014-11-29 08:10:42.924009	N	freshclam error:  52
259	V	2014-11-29 09:10:38.618796	N	freshclam error:  52
260	V	2014-11-29 10:10:43.939192	N	freshclam error:  52
261	V	2014-11-29 11:10:43.718656	N	freshclam error:  52
262	V	2014-11-29 12:06:16.889279	N	freshclam error:  58
263	V	2014-11-29 13:06:16.954299	N	freshclam error:  58
264	V	2014-11-29 14:06:16.938434	N	freshclam error:  58
265	V	2014-11-29 15:06:17.094802	N	freshclam error:  58
266	V	2014-11-29 16:06:17.289379	N	freshclam error:  58
267	V	2014-11-29 17:06:16.918456	N	freshclam error:  58
268	V	2014-11-29 18:06:17.594124	N	freshclam error:  58
269	V	2014-11-29 19:06:17.109353	N	freshclam error:  58
270	V	2014-11-29 20:06:16.958635	N	freshclam error:  58
271	V	2014-11-29 21:06:17.41903	N	freshclam error:  58
272	V	2014-11-29 22:06:17.059427	N	freshclam error:  58
273	V	2014-11-29 23:06:17.69457	N	freshclam error:  58
274	V	2014-11-30 00:06:19.093616	N	freshclam error:  58
275	V	2014-11-30 01:06:17.718412	N	freshclam error:  58
276	V	2014-11-30 02:06:17.464428	N	freshclam error:  58
277	S	2014-11-30 03:03:20.102107	N	Cannot contact server
278	F	2014-11-30 03:03:35.621561	N	Cannot contact ANY update server
279	R	2014-11-30 03:05:00.483847	Y	0
280	V	2014-11-30 03:06:25.954802	N	freshclam error:  58
281	V	2014-11-30 04:06:17.178654	N	freshclam error:  58
282	V	2014-11-30 05:06:16.989298	N	freshclam error:  58
283	V	2014-11-30 06:06:17.519838	N	freshclam error:  58
284	V	2014-11-30 07:06:17.194681	N	freshclam error:  58
285	V	2014-11-30 08:06:16.743973	N	freshclam error:  58
286	V	2014-11-30 09:06:17.364346	N	freshclam error:  58
287	V	2014-11-30 10:06:17.013979	N	freshclam error:  58
288	V	2014-11-30 11:06:17.603723	N	freshclam error:  58
289	V	2014-11-30 12:06:17.054288	N	freshclam error:  58
290	V	2014-11-30 13:06:17.529188	N	freshclam error:  58
291	V	2014-11-30 14:06:17.253627	N	freshclam error:  58
292	V	2014-11-30 15:06:16.713561	N	freshclam error:  58
293	V	2014-11-30 16:06:17.249359	N	freshclam error:  58
294	V	2014-11-30 17:06:16.913702	N	freshclam error:  58
295	V	2014-11-30 18:06:17.085229	N	freshclam error:  58
296	V	2014-11-30 19:06:16.74444	N	freshclam error:  58
297	V	2014-11-30 20:06:17.374309	N	freshclam error:  58
298	V	2014-11-30 21:06:17.019682	N	freshclam error:  58
299	V	2014-11-30 22:06:17.738627	N	freshclam error:  58
300	V	2014-11-30 23:06:17.343877	N	freshclam error:  58
301	V	2014-12-01 00:06:17.56906	N	freshclam error:  58
302	V	2014-12-01 01:06:17.393596	N	freshclam error:  58
303	V	2014-12-01 02:06:17.069489	N	freshclam error:  58
304	S	2014-12-01 03:03:16.957302	N	Cannot contact server
305	F	2014-12-01 03:03:32.496498	N	Cannot contact ANY update server
306	R	2014-12-01 03:05:01.121407	Y	0
307	V	2014-12-01 03:06:26.553565	N	freshclam error:  58
308	V	2014-12-01 04:06:16.764216	N	freshclam error:  58
309	V	2014-12-01 05:06:17.560018	N	freshclam error:  58
310	V	2014-12-01 06:06:17.15423	N	freshclam error:  58
311	V	2014-12-01 07:06:17.798813	N	freshclam error:  58
312	V	2014-12-01 08:06:17.763994	N	freshclam error:  58
313	V	2014-12-01 09:06:17.304227	N	freshclam error:  58
314	V	2014-12-01 10:06:16.813622	N	freshclam error:  58
315	V	2014-12-01 11:06:17.343454	N	freshclam error:  58
316	V	2014-12-01 12:06:16.933802	N	freshclam error:  58
317	V	2014-12-01 13:06:17.484951	N	freshclam error:  58
318	V	2014-12-01 14:06:17.059944	N	freshclam error:  58
319	V	2014-12-01 15:06:17.684546	N	freshclam error:  58
320	V	2014-12-01 16:06:17.394233	N	freshclam error:  58
321	V	2014-12-01 17:06:17.134357	N	freshclam error:  58
322	V	2014-12-01 18:06:16.87911	N	freshclam error:  58
323	V	2014-12-01 19:06:17.653357	N	freshclam error:  58
324	V	2014-12-01 20:06:17.414267	N	freshclam error:  58
325	V	2014-12-01 21:06:16.938911	N	freshclam error:  58
326	V	2014-12-01 22:06:17.73366	N	freshclam error:  58
327	V	2014-12-01 23:06:17.50425	N	freshclam error:  58
328	V	2014-12-02 00:06:17.714411	N	freshclam error:  58
329	V	2014-12-02 01:06:16.913805	N	freshclam error:  58
330	V	2014-12-02 02:06:17.489496	N	freshclam error:  58
331	S	2014-12-02 03:03:19.977193	N	Cannot contact server
332	F	2014-12-02 03:03:35.491529	N	Cannot contact ANY update server
333	R	2014-12-02 03:05:00.576819	Y	0
334	V	2014-12-02 03:06:26.028706	N	freshclam error:  58
335	V	2014-12-02 04:06:17.329459	N	freshclam error:  58
336	V	2014-12-02 05:06:16.954285	N	freshclam error:  58
337	V	2014-12-02 06:06:17.659115	N	freshclam error:  58
338	V	2014-12-02 07:06:17.219645	N	freshclam error:  58
339	V	2014-12-02 08:06:17.664346	N	freshclam error:  58
340	V	2014-12-02 09:06:17.544668	N	freshclam error:  58
341	V	2014-12-02 10:06:17.093829	N	freshclam error:  58
342	V	2014-12-02 11:06:16.834921	N	freshclam error:  58
343	V	2014-12-02 12:06:17.469662	N	freshclam error:  58
344	V	2014-12-02 13:06:17.023393	N	freshclam error:  58
345	V	2014-12-02 14:06:17.604093	N	freshclam error:  58
346	V	2014-12-02 15:06:17.144011	N	freshclam error:  58
347	V	2014-12-02 16:06:16.92935	N	freshclam error:  58
348	V	2014-12-02 17:06:17.473664	N	freshclam error:  58
349	V	2014-12-02 18:06:17.019226	N	freshclam error:  58
350	V	2014-12-02 19:06:17.668669	N	freshclam error:  58
351	V	2014-12-02 20:06:17.243769	N	freshclam error:  58
352	V	2014-12-02 21:06:16.924047	N	freshclam error:  58
353	V	2014-12-02 22:06:17.593629	N	freshclam error:  58
354	V	2014-12-02 23:06:17.154161	N	freshclam error:  58
355	V	2014-12-03 00:06:17.36359	N	freshclam error:  58
356	V	2014-12-03 01:06:17.344029	N	freshclam error:  58
357	V	2014-12-03 02:06:16.938331	N	freshclam error:  58
358	S	2014-12-03 03:03:16.90715	N	Cannot contact server
359	F	2014-12-03 03:03:32.40158	N	Cannot contact ANY update server
360	R	2014-12-03 03:05:00.962907	Y	0
361	V	2014-12-03 03:06:22.478792	N	freshclam error:  58
362	V	2014-12-03 04:06:17.68898	N	freshclam error:  58
363	V	2014-12-03 05:06:17.429161	N	freshclam error:  58
364	V	2014-12-03 06:06:17.08469	N	freshclam error:  58
365	V	2014-12-03 07:06:17.713848	N	freshclam error:  58
366	V	2014-12-03 08:06:17.74436	N	freshclam error:  58
367	V	2014-12-03 09:06:17.497953	N	freshclam error:  58
368	V	2014-12-03 10:06:17.134338	N	freshclam error:  58
369	V	2014-12-03 11:06:17.77863	N	freshclam error:  58
370	V	2014-12-03 12:06:17.413572	N	freshclam error:  58
371	V	2014-12-03 13:13:59.039396	N	freshclam error:  52
372	V	2014-12-03 14:10:44.918913	N	freshclam error:  52
373	V	2014-12-03 15:10:45.778629	N	freshclam error:  52
374	L	2014-12-03 15:17:50.621178	Y	admin
375	V	2014-12-03 16:07:42.904114	Y	Virus rules updated
376	L	2014-12-03 16:24:28.916324	Y	admin
377	L	2014-12-03 16:24:33.152715	Y	admin
378	L	2014-12-03 16:24:34.529052	Y	admin
379	L	2014-12-03 16:24:36.179497	Y	admin
380	V	2014-12-03 18:01:20.850502	Y	Virus rules updated
381	L	2014-12-03 19:20:58.536223	N	wpaucar
382	V	2014-12-03 20:01:28.537273	Y	Virus rules updated
383	L	2014-12-03 20:32:08.497717	N	wpaucar
384	V	2014-12-04 02:01:28.700734	Y	Virus rules updated
385	S	2014-12-04 03:04:47.874492	Y	
386	R	2014-12-04 03:05:00.224773	Y	0
387	F	2014-12-04 03:07:41.900167	Y	Updates have been retrieved
388	V	2014-12-04 08:01:43.954445	Y	Virus rules updated
389	V	2014-12-04 12:01:20.646148	Y	Virus rules updated
390	V	2014-12-04 14:01:13.573327	Y	Virus rules updated
391	L	2014-12-04 15:12:20.786003	N	mzarabia@14demarzo.fin.ec
392	L	2014-12-04 15:12:37.978228	N	mzarabia
393	L	2014-12-04 15:19:59.913675	N	mzarabia@14demarzo.fin.ec
394	L	2014-12-04 16:58:14.148228	N	carterasfashions@hotmail.com
395	V	2014-12-04 18:01:52.584927	Y	Virus rules updated
396	V	2014-12-04 20:01:27.145517	Y	Virus rules updated
397	L	2014-12-04 20:05:32.310832	N	evera
398	L	2014-12-04 20:06:00.17035	N	evera
399	L	2014-12-05 01:56:44.923373	N	evera
400	V	2014-12-05 02:01:13.788023	Y	Virus rules updated
401	R	2014-12-05 03:05:01.072845	Y	0
402	V	2014-12-05 08:01:46.889084	Y	Virus rules updated
403	V	2014-12-05 11:01:34.503203	Y	Virus rules updated
404	V	2014-12-05 12:01:13.111151	Y	Virus rules updated
405	V	2014-12-05 14:01:22.473132	Y	Virus rules updated
406	L	2014-12-05 14:39:08.806636	N	evera@14demarzo.fin.ec
407	L	2014-12-05 14:43:01.263905	N	evera
408	L	2014-12-05 15:09:00.653552	N	mzarabia@14demarzo.fin.ec
409	L	2014-12-05 15:10:17.661017	N	mzarabia
410	L	2014-12-05 15:11:07.807678	N	mzarabia@14demarzo.fin.ec
411	L	2014-12-05 15:26:22.711606	N	mzarabia@14demarzo.fin.ec
412	L	2014-12-05 15:26:30.405807	N	mzarabia@14demarzo.fin.ec
413	L	2014-12-05 15:26:38.195268	N	mzarabia@14demarzo.fin.ec
414	L	2014-12-05 16:49:12.384867	N	mzarabia@hotmail.com
415	L	2014-12-05 16:49:28.448573	N	mzarabia
416	L	2014-12-05 16:49:41.039791	N	mzarabia
417	V	2014-12-05 17:01:29.48383	Y	Virus rules updated
418	V	2014-12-05 20:01:14.612257	Y	Virus rules updated
419	L	2014-12-05 20:14:32.409033	N	liza
420	L	2014-12-05 20:14:44.196743	N	zo123liza
421	L	2014-12-05 20:14:55.555314	N	liza
422	L	2014-12-05 20:16:33.265888	N	liza
423	L	2014-12-05 20:18:06.519836	N	liza
424	L	2014-12-05 20:18:16.47604	N	liza
425	L	2014-12-05 20:20:28.755714	N	liza
426	L	2014-12-05 20:23:04.47982	N	liza
427	L	2014-12-05 22:39:32.307433	N	gcanchig
428	L	2014-12-05 22:40:00.264166	N	gcanchig
429	V	2014-12-06 01:01:15.992184	Y	Virus rules updated
430	S	2014-12-06 03:03:27.545121	Y	
431	R	2014-12-06 03:05:00.920626	Y	0
432	V	2014-12-06 08:01:15.202091	Y	Virus rules updated
433	V	2014-12-06 13:01:13.855972	Y	Virus rules updated
434	V	2014-12-06 20:01:16.620254	Y	Virus rules updated
435	V	2014-12-07 01:01:30.52769	Y	Virus rules updated
436	S	2014-12-07 03:03:58.71567	Y	
437	R	2014-12-07 03:05:00.842579	Y	0
438	V	2014-12-07 07:01:14.300399	Y	Virus rules updated
439	V	2014-12-07 13:01:13.134439	Y	Virus rules updated
440	V	2014-12-07 20:01:17.235398	Y	Virus rules updated
441	L	2014-12-07 21:14:57.464507	N	liza
442	V	2014-12-08 01:01:12.903171	Y	Virus rules updated
443	L	2014-12-08 01:47:35.025379	N	jcruz
444	L	2014-12-08 01:48:54.866322	N	jcruz@14demarzo.fin.ec
445	L	2014-12-08 01:50:32.953808	N	jcruz@14demarzo.fin.ec
446	L	2014-12-08 01:53:29.717645	N	
447	L	2014-12-08 02:11:19.93633	N	jcruz
448	L	2014-12-08 02:11:27.607967	N	jcruz
449	S	2014-12-08 03:03:22.681976	Y	
450	R	2014-12-08 03:05:00.571597	Y	0
451	L	2014-12-08 06:14:35.092694	N	varmijo
452	L	2014-12-08 06:14:54.138907	N	varmijo
453	V	2014-12-08 07:01:13.901542	Y	Virus rules updated
454	L	2014-12-08 08:10:47.668118	N	jtoaquiza@14demarzo.fin.ec
455	L	2014-12-08 08:18:01.903356	N	root
456	L	2014-12-08 08:18:10.91389	N	vsuquillo
457	L	2014-12-08 08:18:36.867083	N	admin
458	L	2014-12-08 08:18:49.106052	N	jtoaquiza@14demarzo.fin.ec
459	L	2014-12-08 08:20:37.491925	Y	admin
460	L	2014-12-08 09:04:08.564769	Y	admin
461	L	2014-12-08 09:43:48.342072	Y	admin
462	L	2014-12-08 11:23:48.174375	Y	admin
463	L	2014-12-08 11:31:40.436272	Y	admin
464	V	2014-12-08 13:01:15.080081	Y	Virus rules updated
465	L	2014-12-08 15:27:44.037018	N	mzarabia@14demarzo.fin.ec
466	L	2014-12-08 15:28:10.48933	N	mzarabia
467	L	2014-12-08 16:57:58.798795	N	admin
468	L	2014-12-08 16:58:10.242886	Y	admin
469	L	2014-12-08 17:51:25.93739	N	jtoaquiza@14demarzo.fin.ec
470	L	2014-12-08 17:52:20.925346	N	jtoaquiza@14demarzo.fin.ec
471	L	2014-12-08 18:13:29.617001	Y	admin
472	V	2014-12-08 19:01:22.453343	Y	Virus rules updated
473	L	2014-12-08 21:12:55.601562	N	evera
474	V	2014-12-09 01:01:14.100401	Y	Virus rules updated
475	S	2014-12-09 03:03:34.679886	Y	
476	R	2014-12-09 03:05:00.783152	Y	0
477	V	2014-12-09 07:01:14.106121	Y	Virus rules updated
478	L	2014-12-09 07:20:33.657781	Y	admin
479	L	2014-12-09 08:25:25.373438	Y	admin
480	L	2014-12-09 09:47:38.728956	Y	admin
481	L	2014-12-09 10:44:32.88106	Y	admin
482	V	2014-12-09 13:01:48.457862	Y	Virus rules updated
483	L	2014-12-09 16:11:20.168564	Y	admin
484	V	2014-12-09 18:01:16.043178	Y	Virus rules updated
485	V	2014-12-09 20:01:15.019697	Y	Virus rules updated
486	L	2014-12-09 23:20:46.803819	N	jcruz@14demarzo.fin.ec
487	V	2014-12-10 01:01:14.598259	Y	Virus rules updated
488	S	2014-12-10 03:03:34.620453	Y	
489	R	2014-12-10 03:05:00.74731	Y	0
490	V	2014-12-10 07:01:42.835592	Y	Virus rules updated
491	V	2014-12-10 10:01:16.902294	Y	Virus rules updated
492	V	2014-12-10 12:01:20.986325	Y	Virus rules updated
493	V	2014-12-10 13:01:15.02426	Y	Virus rules updated
494	L	2014-12-10 15:30:57.964644	N	ploor
495	L	2014-12-10 15:31:14.438725	N	ploor
496	V	2014-12-10 20:01:13.517741	Y	Virus rules updated
497	L	2014-12-10 20:15:55.024962	N	mandrade@14demarzo.fin.ec
498	L	2014-12-10 20:16:11.426205	N	mandrade@14demarzo.fin.ec
499	L	2014-12-10 20:17:26.549787	N	mandrade@14demarzo.fin.ec
500	V	2014-12-11 01:01:14.157394	Y	Virus rules updated
501	S	2014-12-11 03:03:30.742282	Y	
502	R	2014-12-11 03:05:00.769536	Y	0
503	V	2014-12-11 07:01:44.413888	Y	Virus rules updated
504	L	2014-12-11 11:34:25.544693	Y	admin
505	V	2014-12-11 13:02:36.303172	Y	Virus rules updated
506	L	2014-12-11 15:20:05.454043	Y	admin
507	L	2014-12-11 16:34:05.292301	Y	admin
508	V	2014-12-11 19:01:29.572945	Y	Virus rules updated
509	V	2014-12-11 21:01:13.412255	Y	Virus rules updated
510	V	2014-12-12 01:01:13.262752	Y	Virus rules updated
511	S	2014-12-12 03:03:23.252535	Y	
512	R	2014-12-12 03:05:00.332214	Y	0
513	V	2014-12-12 07:01:13.011278	Y	Virus rules updated
514	V	2014-12-12 11:01:28.041343	Y	Virus rules updated
515	L	2014-12-12 12:10:38.44672	Y	admin
516	L	2014-12-12 12:45:42.602009	N	mjandrade@14demarzo.fin.ec
517	L	2014-12-12 12:45:59.341242	N	mjandrade
518	V	2014-12-12 13:01:30.057788	Y	Virus rules updated
519	L	2014-12-12 14:52:01.809054	N	vsimba@14demarzo.fin.ec
520	L	2014-12-12 14:52:19.945771	N	vsimba@14demarzo.fin.ec
521	L	2014-12-12 14:52:48.624604	N	vsimba@14demarzo.fin.ec
522	L	2014-12-12 14:53:38.295949	N	vsimba@14demarzo.fin.ec
523	L	2014-12-12 14:54:30.050848	N	vsimba@14demarzo.fin.ec
524	L	2014-12-12 14:55:03.099868	N	vsimba@14demarzo.fin.ec
525	L	2014-12-12 14:55:20.269579	N	vsimba@14demarzo.fin.ec
526	L	2014-12-12 14:55:34.439298	N	vsimba@14demarzo.fin.ec
527	L	2014-12-12 14:55:41.529738	N	vsimba@14demarzo.fin.ec
528	L	2014-12-12 14:55:50.685991	N	vsimba@14demarzo.fin.ec
529	L	2014-12-12 14:56:06.569707	N	vsimba@14demarzo.fin.ec
530	L	2014-12-12 14:57:55.338277	N	vsimba@14demarzo.fin.ec
531	L	2014-12-12 15:05:48.659973	Y	admin
532	L	2014-12-12 15:30:09.99519	N	aespinel
533	L	2014-12-12 15:30:48.161951	N	aespinel
534	L	2014-12-12 15:31:41.325185	N	aespinel@14demarzo.fin.ec
535	L	2014-12-12 17:13:40.875028	Y	admin
536	L	2014-12-12 18:28:17.895755	N	liza
537	L	2014-12-12 18:30:28.188138	N	aespinel
538	L	2014-12-12 18:30:29.638628	N	aespinel
539	S	2014-12-13 03:03:22.675457	Y	
540	R	2014-12-13 03:05:00.627868	Y	0
541	V	2014-12-13 10:01:13.30696	Y	Virus rules updated
542	L	2014-12-13 12:57:49.377895	N	wpaucar
543	L	2014-12-15 10:00:54.18788	Y	admin
544	V	2014-12-15 10:01:52.373473	Y	Virus rules updated
545	L	2014-12-15 12:27:20.823189	Y	admin
546	V	2014-12-15 14:01:30.598463	Y	Virus rules updated
547	V	2014-12-15 15:01:13.961716	Y	Virus rules updated
548	L	2014-12-15 15:51:19.370509	Y	admin
549	V	2014-12-15 16:01:15.887172	Y	Virus rules updated
550	V	2014-12-15 17:01:13.414853	Y	Virus rules updated
551	V	2014-12-15 18:01:14.635561	Y	Virus rules updated
552	L	2014-12-15 18:20:07.973215	N	jtoaquiza@14demarzo.fin.ec
553	L	2014-12-15 18:20:37.747815	N	jtoaquiza@14demarzo.fin.ec
554	L	2014-12-15 18:20:49.30059	N	jtoaquiza@14demarzo.fin.ec
555	L	2014-12-15 18:26:19.928771	N	ebalseca
556	L	2014-12-15 18:26:30.006142	N	ebalseca
557	L	2014-12-15 18:26:47.871853	N	ebalseca
558	L	2014-12-15 18:27:02.085792	N	jtoaquiza@14demarzo.fin.ec
559	L	2014-12-15 18:28:08.842241	N	ebalseca@14demarzo.fin.ec
560	V	2014-12-15 21:01:13.783335	Y	Virus rules updated
561	L	2014-12-15 23:54:05.463451	N	dcantuna
562	L	2014-12-15 23:54:31.536282	N	dcantuna
563	L	2014-12-15 23:55:43.238602	N	dcantuna
564	L	2014-12-15 23:55:59.264568	N	dcantuna
565	L	2014-12-15 23:57:45.046632	N	dcantuna
566	L	2014-12-15 23:58:28.212394	N	dcantuna@14demarzo.fin.ec
567	V	2014-12-16 02:01:13.924636	Y	Virus rules updated
568	S	2014-12-16 03:03:39.023565	Y	
569	R	2014-12-16 03:05:00.980662	Y	0
570	V	2014-12-16 09:01:13.407716	Y	Virus rules updated
571	L	2014-12-16 11:11:58.542755	Y	admin
572	V	2014-12-16 14:01:16.566173	Y	Virus rules updated
573	V	2014-12-16 16:01:43.016678	Y	Virus rules updated
574	L	2014-12-16 16:49:23.679763	N	wcacpata
575	L	2014-12-16 16:54:00.604568	Y	admin
576	L	2014-12-16 17:03:19.597997	N	wcacpata
577	V	2014-12-16 18:01:13.821878	Y	Virus rules updated
578	V	2014-12-16 20:01:14.924233	Y	Virus rules updated
579	V	2014-12-17 02:01:58.41142	Y	Virus rules updated
580	S	2014-12-17 03:03:28.093087	Y	
581	R	2014-12-17 03:05:00.241804	Y	0
582	V	2014-12-17 08:01:13.699493	Y	Virus rules updated
583	L	2014-12-17 09:29:25.733883	Y	admin
584	L	2014-12-17 10:54:36.808368	Y	admin
585	L	2014-12-17 13:12:07.126388	N	mdavila
586	L	2014-12-17 13:12:26.540692	N	mdavila
587	L	2014-12-17 13:12:29.370788	N	mdavila
588	L	2014-12-17 13:12:30.346171	N	mdavila
589	L	2014-12-17 13:12:58.392382	N	mdavila@fin.ec
590	L	2014-12-17 13:13:04.819179	N	mdavila@fin.ec
591	L	2014-12-17 13:45:08.069031	Y	admin
592	V	2014-12-17 14:01:14.457224	Y	Virus rules updated
593	L	2014-12-17 15:51:20.553292	Y	admin
594	L	2014-12-17 17:32:25.779284	N	aperez
595	V	2014-12-17 20:01:13.851282	Y	Virus rules updated
596	V	2014-12-17 21:01:44.107995	Y	Virus rules updated
597	L	2014-12-17 21:46:03.849452	N	maferzarabia@hotmil.com
598	V	2014-12-18 02:01:14.417263	Y	Virus rules updated
599	S	2014-12-18 03:03:25.29163	Y	
600	R	2014-12-18 03:05:00.202105	Y	0
601	V	2014-12-18 08:01:13.945695	Y	Virus rules updated
602	L	2014-12-18 08:38:11.109028	Y	admin
603	L	2014-12-18 09:12:40.324978	N	admin
604	L	2014-12-18 09:12:54.237575	N	admin
605	L	2014-12-18 09:13:31.709558	N	admin
606	L	2014-12-18 09:13:51.359613	Y	admin
607	V	2014-12-18 10:01:14.638788	Y	Virus rules updated
608	V	2014-12-18 12:01:14.292552	Y	Virus rules updated
609	L	2014-12-18 13:12:45.929269	N	mdavila@14demarzo.fin.ec
610	L	2014-12-18 13:12:50.711429	N	mdavila@14demarzo.fin.ec
611	L	2014-12-18 13:12:59.635216	N	mdavila@14demarzo.fin.ec
612	L	2014-12-18 13:15:00.09456	N	mdavila@14demarzo.fin.ec
613	L	2014-12-18 13:17:04.588345	N	mdavila@14demarzo.fin.ec
614	L	2014-12-18 13:17:13.564722	N	mdavila@14demarzo.fin.ec
615	V	2014-12-18 14:01:14.130229	Y	Virus rules updated
616	L	2014-12-18 15:47:37.956446	Y	admin
617	L	2014-12-18 16:36:39.27254	Y	admin
618	L	2014-12-18 16:56:06.902965	N	vmorales@14demarzo.fin.ec
619	L	2014-12-18 16:58:06.087398	N	vmorales@14demarzo.fin.ec
620	V	2014-12-18 17:01:30.182155	Y	Virus rules updated
621	L	2014-12-18 19:24:02.60849	N	jtoaquiza@14demarzo.fin.ec
622	L	2014-12-18 19:28:05.05805	N	
623	L	2014-12-18 19:28:06.34934	N	
624	V	2014-12-18 21:01:27.303455	Y	Virus rules updated
625	V	2014-12-19 02:01:40.178239	Y	Virus rules updated
626	S	2014-12-19 03:03:23.72309	Y	
627	R	2014-12-19 03:05:00.719256	Y	0
628	V	2014-12-19 08:01:14.333928	Y	Virus rules updated
629	V	2014-12-19 13:01:14.643689	Y	Virus rules updated
630	L	2014-12-19 13:58:35.12474	N	mdavila@14demarzo.fin.ec
631	L	2014-12-19 13:58:41.3461	N	mdavila@14demarzo.fin.ec
632	L	2014-12-19 13:58:59.308385	N	mdavila@14demarzo.fin.ec
633	L	2014-12-19 13:59:07.548119	N	mdavila@14demarzo.fin.ec
634	L	2014-12-19 13:59:13.809663	N	mdavila@14demarzo.fin.ec
635	L	2014-12-19 13:59:37.960518	N	mdavila@14demarzo.fin.ec
636	L	2014-12-19 14:00:55.578909	N	mdavila@14demarzo.fin.ec
637	L	2014-12-19 14:01:02.134902	N	mdavila@14demarzo.fin.ec
638	L	2014-12-19 14:01:13.478644	N	mdavila@14demarzo.fin.ec
639	V	2014-12-19 14:01:18.418492	Y	Virus rules updated
640	L	2014-12-19 14:11:32.419275	Y	admin
641	L	2014-12-19 16:03:04.96504	Y	admin
642	V	2014-12-19 20:01:13.914826	Y	Virus rules updated
643	V	2014-12-20 02:01:13.652375	Y	Virus rules updated
644	S	2014-12-20 03:03:25.082793	Y	
645	R	2014-12-20 03:05:00.190399	Y	0
646	V	2014-12-20 08:01:44.616479	Y	Virus rules updated
647	L	2014-12-20 10:15:50.078823	N	ellumiquinga@14demarzo.fin.ec
648	L	2014-12-20 10:16:11.529684	N	ellumiquinga@14demarzo.fin.ec
649	L	2014-12-20 10:18:59.12534	N	ellumiquinga@14demarzo.fin.ec
650	L	2014-12-20 10:24:51.982472	N	ellumiquinga@14demarzo.fin.ec
651	V	2014-12-20 14:01:13.628552	Y	Virus rules updated
652	V	2014-12-20 21:01:13.104544	Y	Virus rules updated
653	L	2014-12-22 09:28:11.7099	Y	admin
654	L	2014-12-22 16:33:58.404661	Y	admin
655	L	2014-12-22 18:02:44.218787	Y	admin
656	L	2014-12-22 23:34:31.760211	N	mvelez
657	L	2014-12-22 23:34:57.253454	N	mvelez
658	L	2014-12-22 23:36:35.950208	N	mvelez
659	L	2014-12-22 23:36:54.411259	N	mvelez
660	L	2014-12-22 23:37:11.463964	N	mvelez
661	L	2014-12-23 10:18:38.016318	Y	admin
662	L	2014-12-23 11:48:46.498204	Y	admin
663	V	2014-12-23 13:01:36.831382	Y	Virus rules updated
664	L	2014-12-23 13:45:11.742942	Y	admin
665	V	2014-12-23 14:01:27.909232	Y	Virus rules updated
666	V	2014-12-23 15:01:45.169763	Y	Virus rules updated
667	L	2014-12-23 16:14:54.584073	Y	admin
668	L	2014-12-23 16:19:21.98188	Y	admin
669	V	2014-12-23 20:01:13.021907	Y	Virus rules updated
670	V	2014-12-24 02:01:13.351234	Y	Virus rules updated
671	S	2014-12-24 03:03:20.977536	Y	
672	R	2014-12-24 03:05:01.028777	Y	0
673	V	2014-12-24 08:01:13.435359	Y	Virus rules updated
674	V	2014-12-24 14:01:43.740638	Y	Virus rules updated
675	V	2014-12-24 20:01:13.049823	Y	Virus rules updated
676	V	2014-12-25 02:01:12.941173	Y	Virus rules updated
677	S	2014-12-25 03:03:16.510758	Y	
678	R	2014-12-25 03:05:00.389629	Y	0
679	V	2014-12-25 08:01:26.639808	Y	Virus rules updated
680	V	2014-12-25 14:01:12.463742	Y	Virus rules updated
681	V	2014-12-25 20:01:13.170671	Y	Virus rules updated
682	V	2014-12-26 02:01:41.942565	Y	Virus rules updated
683	S	2014-12-26 03:03:16.402262	Y	
684	R	2014-12-26 03:05:00.6393	Y	0
685	V	2014-12-26 08:01:13.621719	Y	Virus rules updated
686	V	2014-12-26 14:01:13.091406	Y	Virus rules updated
687	V	2014-12-26 21:01:26.425916	Y	Virus rules updated
688	V	2014-12-27 02:01:14.233116	Y	Virus rules updated
689	S	2014-12-27 03:03:17.994524	Y	
690	R	2014-12-27 03:05:01.066819	Y	0
691	V	2014-12-27 08:01:15.561155	Y	Virus rules updated
692	V	2014-12-27 14:01:45.36123	Y	Virus rules updated
693	V	2014-12-27 21:01:13.569688	Y	Virus rules updated
694	V	2014-12-28 02:01:13.51748	Y	Virus rules updated
695	S	2014-12-28 03:03:18.81938	Y	
696	R	2014-12-28 03:05:00.746914	Y	0
697	V	2014-12-28 08:01:43.709901	Y	Virus rules updated
698	V	2014-12-28 14:01:12.917405	Y	Virus rules updated
699	V	2014-12-28 21:01:12.655976	Y	Virus rules updated
700	V	2014-12-29 02:01:44.046606	Y	Virus rules updated
701	S	2014-12-29 03:04:17.994552	Y	
702	R	2014-12-29 03:05:01.00515	Y	0
703	V	2014-12-29 08:01:12.703947	Y	Virus rules updated
704	V	2014-12-29 14:01:28.257913	Y	Virus rules updated
705	L	2014-12-29 16:41:00.354706	Y	admin
706	V	2014-12-29 21:01:47.061297	Y	Virus rules updated
707	V	2014-12-30 02:01:13.763323	Y	Virus rules updated
708	S	2014-12-30 03:03:19.73435	Y	
709	R	2014-12-30 03:05:00.725216	Y	0
710	V	2014-12-30 08:01:45.239549	Y	Virus rules updated
711	V	2014-12-30 14:01:14.412358	Y	Virus rules updated
712	V	2014-12-30 20:01:43.961951	Y	Virus rules updated
713	V	2014-12-31 02:01:13.212675	Y	Virus rules updated
714	S	2014-12-31 03:03:14.83194	Y	
715	R	2014-12-31 03:05:00.909239	Y	0
716	V	2014-12-31 08:01:14.689845	Y	Virus rules updated
717	V	2014-12-31 14:01:45.188424	Y	Virus rules updated
718	V	2014-12-31 20:01:12.717565	Y	Virus rules updated
719	V	2015-01-01 02:01:43.695069	Y	Virus rules updated
720	S	2015-01-01 03:03:22.797683	Y	
721	R	2015-01-01 03:05:00.650197	Y	0
722	V	2015-01-01 08:01:13.377369	Y	Virus rules updated
723	V	2015-01-01 14:01:12.876087	Y	Virus rules updated
724	V	2015-01-01 20:01:13.5601	Y	Virus rules updated
725	V	2015-01-02 02:01:13.774677	Y	Virus rules updated
726	S	2015-01-02 03:03:18.385956	Y	
727	R	2015-01-02 03:05:00.302885	Y	0
728	V	2015-01-02 08:01:12.992922	Y	Virus rules updated
729	V	2015-01-02 14:01:27.25768	Y	Virus rules updated
730	V	2015-01-02 21:01:25.152173	Y	Virus rules updated
731	V	2015-01-03 02:01:14.182047	Y	Virus rules updated
732	S	2015-01-03 03:03:24.573807	Y	
733	R	2015-01-03 03:05:00.492704	Y	0
734	V	2015-01-03 08:01:46.356191	Y	Virus rules updated
735	V	2015-01-03 14:01:43.243975	Y	Virus rules updated
736	V	2015-01-03 21:01:14.392055	Y	Virus rules updated
737	V	2015-01-04 02:01:13.058867	Y	Virus rules updated
738	S	2015-01-04 03:03:17.369221	Y	
739	R	2015-01-04 03:05:00.347959	Y	0
740	V	2015-01-04 08:01:12.9812	Y	Virus rules updated
741	V	2015-01-04 14:01:13.748796	Y	Virus rules updated
742	V	2015-01-04 21:01:13.417159	Y	Virus rules updated
743	V	2015-01-05 02:01:57.502938	Y	Virus rules updated
744	S	2015-01-05 03:03:17.899681	Y	
745	R	2015-01-05 03:05:00.925129	Y	0
746	V	2015-01-05 08:01:12.38634	Y	Virus rules updated
747	V	2015-01-05 10:01:15.017972	Y	Virus rules updated
748	V	2015-01-05 14:01:48.745975	Y	Virus rules updated
749	V	2015-01-05 16:01:07.723545	Y	Virus rules updated
750	V	2015-01-05 19:01:14.164764	Y	Virus rules updated
751	V	2015-01-05 21:01:14.222903	Y	Virus rules updated
752	V	2015-01-06 02:01:13.801172	Y	Virus rules updated
753	S	2015-01-06 03:03:16.950761	Y	
754	R	2015-01-06 03:05:01.003053	Y	0
755	V	2015-01-06 08:01:13.409423	Y	Virus rules updated
756	L	2015-01-06 10:16:12.546549	Y	admin
757	L	2015-01-06 13:17:08.018805	Y	admin
758	V	2015-01-06 14:01:13.139927	Y	Virus rules updated
759	V	2015-01-06 20:01:14.127632	Y	Virus rules updated
760	V	2015-01-07 02:02:17.271546	Y	Virus rules updated
761	R	2015-01-07 03:05:00.614302	Y	0
762	L	2015-01-07 12:25:02.554316	Y	admin
763	L	2015-01-07 12:25:39.647243	Y	admin
764	R	2015-01-08 03:05:01.064048	Y	0
765	L	2015-01-08 17:16:28.65244	Y	admin
766	R	2015-01-09 03:05:00.549501	Y	0
767	R	2015-01-10 03:05:01.179851	Y	0
768	R	2015-01-11 03:05:00.951537	Y	0
769	R	2015-01-12 03:05:00.891078	Y	0
770	L	2015-01-12 10:16:00.032352	Y	admin
771	R	2015-01-13 03:05:00.975573	Y	0
772	R	2015-01-14 03:05:00.478581	Y	0
773	R	2015-01-15 03:05:00.919555	Y	0
774	R	2015-01-16 03:05:00.501965	Y	0
775	R	2015-01-17 03:05:00.328841	Y	0
776	R	2015-01-18 03:05:00.430801	Y	0
777	R	2015-01-19 03:05:00.451324	Y	0
778	R	2015-01-20 03:05:00.546155	Y	0
779	L	2015-01-20 16:04:49.857177	Y	admin
780	L	2015-01-20 17:49:31.078322	Y	admin
781	R	2015-01-21 03:05:00.259092	Y	0
782	R	2015-01-22 03:05:01.161158	Y	0
783	L	2015-01-22 08:44:55.410675	Y	admin
784	R	2015-01-23 03:05:00.491696	Y	0
785	L	2015-01-23 13:24:46.380204	Y	admin
786	R	2015-01-24 03:05:01.151808	Y	0
787	R	2015-01-25 03:05:01.008553	Y	0
788	R	2015-01-26 03:05:00.992562	Y	0
789	R	2015-01-27 03:05:00.833222	Y	0
790	L	2015-01-27 08:23:05.48376	Y	admin
791	R	2015-01-28 03:05:00.485699	Y	0
792	L	2015-01-28 17:04:04.268278	Y	admin
793	L	2015-01-28 17:09:20.718286	Y	admin
794	V	2015-01-28 17:17:12.550102	Y	Virus rules updated
795	V	2015-01-28 18:01:30.609867	Y	Virus rules updated
796	V	2015-01-28 20:01:44.260752	Y	Virus rules updated
797	V	2015-01-29 02:01:43.1912	Y	Virus rules updated
798	S	2015-01-29 03:03:19.494378	Y	
799	R	2015-01-29 03:05:00.458984	Y	0
800	V	2015-01-29 08:01:27.365865	Y	Virus rules updated
801	V	2015-01-29 14:02:14.670966	Y	Virus rules updated
802	V	2015-01-29 17:01:14.195968	Y	Virus rules updated
803	V	2015-01-29 18:01:14.44704	Y	Virus rules updated
804	V	2015-01-29 20:01:13.830363	Y	Virus rules updated
805	V	2015-01-30 02:01:12.859921	Y	Virus rules updated
806	S	2015-01-30 03:03:21.734635	Y	
807	R	2015-01-30 03:05:00.632587	Y	0
808	V	2015-01-30 08:01:14.493815	Y	Virus rules updated
809	V	2015-01-30 14:01:14.963788	Y	Virus rules updated
810	V	2015-01-30 16:02:20.384207	Y	Virus rules updated
811	V	2015-01-30 18:01:59.235544	Y	Virus rules updated
812	V	2015-01-30 21:01:13.490246	Y	Virus rules updated
813	V	2015-01-31 02:01:12.751725	Y	Virus rules updated
814	S	2015-01-31 03:03:19.967155	Y	
815	R	2015-01-31 03:05:00.824534	Y	0
816	V	2015-01-31 08:01:26.086578	Y	Virus rules updated
817	V	2015-01-31 14:01:13.469424	Y	Virus rules updated
818	V	2015-01-31 21:01:13.27315	Y	Virus rules updated
819	V	2015-02-01 02:01:12.983991	Y	Virus rules updated
820	R	2015-02-01 03:05:00.734434	Y	0
821	V	2015-02-01 08:01:13.347302	Y	Virus rules updated
822	V	2015-02-01 14:01:14.099877	Y	Virus rules updated
823	V	2015-02-01 20:01:13.500105	Y	Virus rules updated
824	V	2015-02-02 02:01:13.462999	Y	Virus rules updated
825	R	2015-02-02 03:05:00.866208	Y	0
826	V	2015-02-02 08:01:13.667615	Y	Virus rules updated
827	V	2015-02-02 14:01:15.749343	Y	Virus rules updated
828	V	2015-02-02 15:01:12.890282	Y	Virus rules updated
829	L	2015-02-02 16:39:51.21406	Y	admin
830	V	2015-02-02 18:01:14.047546	Y	Virus rules updated
831	V	2015-02-02 21:01:26.008341	Y	Virus rules updated
832	V	2015-02-03 02:01:45.332496	Y	Virus rules updated
833	S	2015-02-03 03:03:18.963841	Y	
834	R	2015-02-03 03:05:00.945972	Y	0
835	V	2015-02-03 08:01:13.101346	Y	Virus rules updated
836	L	2015-02-03 13:02:55.644091	Y	admin
837	V	2015-02-03 14:01:12.98262	Y	Virus rules updated
838	V	2015-02-03 17:01:45.592325	Y	Virus rules updated
839	V	2015-02-04 02:01:45.622859	Y	Virus rules updated
840	R	2015-02-04 03:05:00.262622	Y	0
841	V	2015-02-04 08:01:13.022046	Y	Virus rules updated
842	V	2015-02-04 14:01:46.643274	Y	Virus rules updated
843	L	2015-02-04 18:01:51.643432	Y	admin
844	V	2015-02-04 20:04:56.647842	N	freshclam error:  58
845	V	2015-02-04 21:04:56.17795	N	freshclam error:  58
846	V	2015-02-04 22:01:27.234028	Y	Virus rules updated
847	V	2015-02-05 02:01:13.213464	Y	Virus rules updated
848	R	2015-02-05 03:05:00.529953	Y	0
849	V	2015-02-05 08:01:14.114485	Y	Virus rules updated
850	V	2015-02-05 14:01:26.619296	Y	Virus rules updated
851	V	2015-02-05 17:01:15.423004	Y	Virus rules updated
852	V	2015-02-06 02:01:13.768622	Y	Virus rules updated
853	R	2015-02-06 03:05:00.844558	Y	0
854	V	2015-02-06 08:01:12.895588	Y	Virus rules updated
855	V	2015-02-06 14:01:16.284958	Y	Virus rules updated
856	V	2015-02-06 17:01:45.284016	Y	Virus rules updated
857	V	2015-02-07 02:01:14.096797	Y	Virus rules updated
858	R	2015-02-07 03:05:00.685068	Y	0
859	V	2015-02-07 08:01:13.544049	Y	Virus rules updated
860	V	2015-02-07 14:01:13.844811	Y	Virus rules updated
861	V	2015-02-07 17:01:13.814433	Y	Virus rules updated
862	V	2015-02-08 02:01:13.228681	Y	Virus rules updated
863	R	2015-02-08 03:05:00.920672	Y	0
864	V	2015-02-08 08:01:13.597961	Y	Virus rules updated
865	V	2015-02-08 14:01:13.853192	Y	Virus rules updated
866	V	2015-02-08 17:01:42.716306	Y	Virus rules updated
867	V	2015-02-09 02:01:14.097483	Y	Virus rules updated
868	S	2015-02-09 03:03:21.856592	Y	
869	R	2015-02-09 03:05:00.653422	Y	0
870	V	2015-02-09 08:01:13.242099	Y	Virus rules updated
871	V	2015-02-09 13:01:13.68512	Y	Virus rules updated
872	V	2015-02-09 14:01:12.961282	Y	Virus rules updated
873	S	2015-02-10 03:03:20.010216	Y	
874	F	2015-02-10 03:03:42.565936	Y	Updates have been retrieved
875	R	2015-02-10 03:05:01.22124	Y	0
876	V	2015-02-10 15:01:43.603417	Y	Virus rules updated
877	V	2015-02-10 19:01:44.725313	Y	Virus rules updated
878	V	2015-02-10 20:01:14.776276	Y	Virus rules updated
879	V	2015-02-11 02:01:13.014748	Y	Virus rules updated
880	S	2015-02-11 03:03:19.696415	Y	
881	R	2015-02-11 03:05:00.535204	Y	0
882	V	2015-02-11 08:01:43.182611	Y	Virus rules updated
883	V	2015-02-11 14:01:30.069818	Y	Virus rules updated
884	V	2015-02-11 17:01:14.553685	Y	Virus rules updated
885	V	2015-02-12 02:01:14.063926	Y	Virus rules updated
886	S	2015-02-12 03:03:15.114852	Y	
887	R	2015-02-12 03:05:01.07268	Y	0
888	V	2015-02-12 09:01:43.188439	Y	Virus rules updated
889	V	2015-02-12 14:01:13.927874	Y	Virus rules updated
890	V	2015-02-12 18:01:20.779782	Y	Virus rules updated
891	V	2015-02-12 19:01:13.517183	Y	Virus rules updated
892	S	2015-02-13 03:03:16.962976	Y	
893	R	2015-02-13 03:05:00.691624	Y	0
894	V	2015-02-13 14:01:14.13636	Y	Virus rules updated
895	S	2015-02-14 03:03:39.317001	Y	
896	R	2015-02-14 03:05:01.1307	Y	0
897	V	2015-02-15 02:01:14.343568	Y	Virus rules updated
898	R	2015-02-15 03:05:00.476617	Y	0
899	V	2015-02-15 21:01:13.051284	Y	Virus rules updated
900	V	2015-02-16 01:01:15.872291	Y	Virus rules updated
901	S	2015-02-16 03:03:16.212519	Y	
902	R	2015-02-16 03:05:01.146485	Y	0
903	V	2015-02-16 11:01:12.893084	Y	Virus rules updated
904	V	2015-02-16 13:01:13.288084	Y	Virus rules updated
905	V	2015-02-16 15:01:13.136994	Y	Virus rules updated
906	S	2015-02-17 03:03:17.07029	Y	
907	R	2015-02-17 03:05:00.943039	Y	0
908	V	2015-02-17 16:01:27.607205	Y	Virus rules updated
909	V	2015-02-17 18:01:13.5304	Y	Virus rules updated
910	V	2015-02-18 02:01:13.691418	Y	Virus rules updated
911	S	2015-02-18 03:03:16.395231	Y	
912	R	2015-02-18 03:05:00.47222	Y	0
913	V	2015-02-18 08:01:14.208532	Y	Virus rules updated
914	L	2015-02-18 11:50:59.160723	Y	admin
915	V	2015-02-18 12:01:14.727278	Y	Virus rules updated
916	V	2015-02-18 14:01:14.679216	Y	Virus rules updated
917	V	2015-02-18 16:01:17.450526	Y	Virus rules updated
918	V	2015-02-18 17:02:11.086254	Y	Virus rules updated
919	V	2015-02-19 02:02:49.49385	Y	Virus rules updated
920	S	2015-02-19 03:03:13.639385	Y	
921	R	2015-02-19 03:05:00.602949	Y	0
922	V	2015-02-19 08:01:14.023152	Y	Virus rules updated
923	V	2015-02-19 14:01:14.110642	Y	Virus rules updated
924	V	2015-02-19 17:01:14.909678	Y	Virus rules updated
925	V	2015-02-20 02:01:13.97176	Y	Virus rules updated
926	S	2015-02-20 03:03:17.075412	Y	
927	R	2015-02-20 03:05:00.942427	Y	0
928	V	2015-02-20 08:01:14.052603	Y	Virus rules updated
929	V	2015-02-20 14:01:14.124832	Y	Virus rules updated
930	V	2015-02-20 17:01:28.453881	Y	Virus rules updated
931	V	2015-02-21 02:01:14.426076	Y	Virus rules updated
932	S	2015-02-21 03:03:16.820062	Y	
933	R	2015-02-21 03:05:00.835705	Y	0
934	V	2015-02-21 08:01:14.232013	Y	Virus rules updated
935	V	2015-02-21 14:01:13.809785	Y	Virus rules updated
936	V	2015-02-21 17:01:13.650409	Y	Virus rules updated
937	V	2015-02-22 02:01:12.767309	Y	Virus rules updated
938	R	2015-02-22 03:05:00.960162	Y	0
939	V	2015-02-22 08:01:38.219862	Y	Virus rules updated
940	V	2015-02-22 14:01:42.854719	Y	Virus rules updated
941	V	2015-02-22 20:01:14.721068	Y	Virus rules updated
942	V	2015-02-23 02:01:14.069096	Y	Virus rules updated
943	S	2015-02-23 03:03:14.909046	Y	
944	R	2015-02-23 03:05:00.683912	Y	0
945	V	2015-02-23 08:01:28.634653	Y	Virus rules updated
946	V	2015-02-23 09:01:12.570279	Y	Virus rules updated
947	V	2015-02-23 12:01:15.298319	Y	Virus rules updated
948	V	2015-02-23 14:01:13.464359	Y	Virus rules updated
949	V	2015-02-23 20:01:28.585642	Y	Virus rules updated
950	V	2015-02-24 02:01:13.08262	Y	Virus rules updated
951	S	2015-02-24 03:03:15.778359	Y	
952	R	2015-02-24 03:05:00.774032	Y	0
953	V	2015-02-24 08:02:03.847433	Y	Virus rules updated
954	L	2015-02-24 11:44:25.685752	Y	admin
955	V	2015-02-24 12:02:12.8958	Y	Virus rules updated
956	V	2015-02-24 14:01:28.652404	Y	Virus rules updated
957	V	2015-02-24 17:01:15.831244	Y	Virus rules updated
958	L	2015-02-24 18:12:19.829026	Y	admin
959	V	2015-02-25 02:01:16.224862	Y	Virus rules updated
960	S	2015-02-25 03:03:27.481227	Y	
961	R	2015-02-25 03:05:00.697793	Y	0
962	V	2015-02-25 08:01:28.068416	Y	Virus rules updated
963	V	2015-02-25 11:01:14.615807	Y	Virus rules updated
964	V	2015-02-25 14:01:30.251406	Y	Virus rules updated
965	V	2015-02-25 21:01:15.526919	Y	Virus rules updated
966	V	2015-02-26 02:01:14.902967	Y	Virus rules updated
967	S	2015-02-26 03:03:18.165325	Y	
968	R	2015-02-26 03:05:01.123773	Y	0
969	V	2015-02-26 08:01:14.85223	Y	Virus rules updated
970	V	2015-02-26 11:01:13.81986	Y	Virus rules updated
971	V	2015-02-26 13:01:13.777156	Y	Virus rules updated
972	V	2015-02-26 14:01:13.960845	Y	Virus rules updated
973	V	2015-02-26 18:01:15.682063	Y	Virus rules updated
974	V	2015-02-26 21:01:28.565684	Y	Virus rules updated
975	V	2015-02-27 02:01:28.91953	Y	Virus rules updated
976	S	2015-02-27 03:03:23.60047	Y	
977	R	2015-02-27 03:05:00.315538	Y	0
978	V	2015-02-27 08:01:14.569099	Y	Virus rules updated
979	L	2015-02-27 12:57:32.175502	Y	admin
980	V	2015-02-27 14:01:14.098442	Y	Virus rules updated
981	V	2015-02-27 16:01:14.938065	Y	Virus rules updated
982	V	2015-02-27 17:01:30.830105	Y	Virus rules updated
983	V	2015-02-28 03:01:12.949947	Y	Virus rules updated
984	S	2015-02-28 03:03:21.131769	Y	
985	R	2015-02-28 03:05:01.11725	Y	0
986	V	2015-02-28 08:01:28.794892	Y	Virus rules updated
987	V	2015-02-28 12:01:29.470876	Y	Virus rules updated
988	V	2015-02-28 14:01:13.41255	Y	Virus rules updated
989	V	2015-02-28 20:01:13.701255	Y	Virus rules updated
990	V	2015-03-01 02:01:13.961095	Y	Virus rules updated
991	S	2015-03-01 03:03:26.903	Y	
992	R	2015-03-01 03:05:00.650236	Y	0
993	V	2015-03-01 08:01:14.103635	Y	Virus rules updated
994	V	2015-03-01 14:01:14.060691	Y	Virus rules updated
995	V	2015-03-01 21:01:29.55156	Y	Virus rules updated
996	V	2015-03-02 03:01:14.246603	Y	Virus rules updated
997	S	2015-03-02 03:03:16.697231	Y	
998	R	2015-03-02 03:05:00.602571	Y	0
999	V	2015-03-02 09:01:14.16193	Y	Virus rules updated
1000	V	2015-03-02 14:01:13.715033	Y	Virus rules updated
1001	V	2015-03-02 20:01:16.456285	Y	Virus rules updated
1002	V	2015-03-03 03:01:13.109479	Y	Virus rules updated
1003	S	2015-03-03 03:03:14.187258	Y	
1004	R	2015-03-03 03:05:00.251206	Y	0
1005	V	2015-03-03 08:01:14.189539	Y	Virus rules updated
1006	V	2015-03-03 14:01:14.229881	Y	Virus rules updated
1007	V	2015-03-03 18:01:13.836844	Y	Virus rules updated
1008	V	2015-03-03 21:01:28.439162	Y	Virus rules updated
1009	V	2015-03-04 02:01:14.647517	Y	Virus rules updated
1010	S	2015-03-04 03:03:15.642691	Y	
1011	R	2015-03-04 03:05:00.525901	Y	0
1012	V	2015-03-04 08:01:38.359628	Y	Virus rules updated
1013	V	2015-03-04 10:01:13.612329	Y	Virus rules updated
1014	V	2015-03-04 14:01:13.453422	Y	Virus rules updated
1015	V	2015-03-04 17:01:15.445744	Y	Virus rules updated
1016	V	2015-03-05 02:01:54.324429	Y	Virus rules updated
1017	S	2015-03-05 03:03:17.520654	Y	
1018	R	2015-03-05 03:05:00.47165	Y	0
1019	V	2015-03-05 08:01:13.825747	Y	Virus rules updated
1020	V	2015-03-05 14:01:14.399084	Y	Virus rules updated
1021	V	2015-03-05 17:01:14.899106	Y	Virus rules updated
1022	V	2015-03-05 18:01:13.86295	Y	Virus rules updated
1023	V	2015-03-06 02:01:13.328615	Y	Virus rules updated
1024	S	2015-03-06 03:03:15.408378	Y	
1025	R	2015-03-06 03:05:00.258197	Y	0
1026	V	2015-03-06 08:01:13.77596	Y	Virus rules updated
1027	V	2015-03-06 14:01:13.918009	Y	Virus rules updated
1028	V	2015-03-06 17:01:28.996132	Y	Virus rules updated
1029	V	2015-03-07 02:01:15.814127	Y	Virus rules updated
1030	S	2015-03-07 03:03:20.215281	Y	
1031	R	2015-03-07 03:05:01.004858	Y	0
1032	V	2015-03-07 08:01:14.072048	Y	Virus rules updated
1033	V	2015-03-07 14:01:13.724555	Y	Virus rules updated
1034	V	2015-03-07 17:01:15.127502	Y	Virus rules updated
1035	V	2015-03-08 03:01:13.888657	Y	Virus rules updated
1036	R	2015-03-08 03:05:00.222098	Y	0
1037	V	2015-03-08 07:01:14.536902	Y	Virus rules updated
1038	V	2015-03-08 13:01:30.587425	Y	Virus rules updated
1039	V	2015-03-08 16:01:13.903089	Y	Virus rules updated
1040	V	2015-03-09 01:01:14.170922	Y	Virus rules updated
1041	R	2015-03-09 03:05:01.095096	Y	0
1042	V	2015-03-09 07:01:13.610425	Y	Virus rules updated
1043	V	2015-03-09 11:01:29.931074	Y	Virus rules updated
1044	V	2015-03-09 14:01:53.887865	Y	Virus rules updated
1045	V	2015-03-09 17:01:14.055914	Y	Virus rules updated
1046	V	2015-03-10 01:01:14.313572	Y	Virus rules updated
1047	S	2015-03-10 03:03:16.123855	Y	
1048	R	2015-03-10 03:05:00.854173	Y	0
1049	V	2015-03-10 08:01:15.021726	Y	Virus rules updated
1050	V	2015-03-10 13:01:14.358872	Y	Virus rules updated
1051	V	2015-03-10 14:01:13.448933	Y	Virus rules updated
1052	V	2015-03-10 18:01:13.99702	Y	Virus rules updated
1053	V	2015-03-10 19:01:14.026528	Y	Virus rules updated
1054	V	2015-03-11 01:01:15.792416	Y	Virus rules updated
1055	S	2015-03-11 03:03:28.471777	Y	
1056	R	2015-03-11 03:05:00.539319	Y	0
1057	V	2015-03-11 07:01:14.441122	Y	Virus rules updated
1058	V	2015-03-11 11:01:28.989347	Y	Virus rules updated
1059	V	2015-03-11 15:01:13.369762	Y	Virus rules updated
1060	V	2015-03-11 18:01:14.549273	Y	Virus rules updated
1061	V	2015-03-11 19:01:14.109161	Y	Virus rules updated
1062	V	2015-03-12 02:01:28.73534	Y	Virus rules updated
1063	S	2015-03-12 03:03:21.441319	Y	
1064	R	2015-03-12 03:05:00.320591	Y	0
1065	V	2015-03-12 07:01:13.656361	Y	Virus rules updated
1066	V	2015-03-12 13:01:15.676441	Y	Virus rules updated
1067	V	2015-03-12 17:01:14.62343	Y	Virus rules updated
1068	V	2015-03-12 19:01:13.480545	Y	Virus rules updated
1069	V	2015-03-13 01:01:44.720872	Y	Virus rules updated
1070	S	2015-03-13 03:03:21.820774	Y	
1071	R	2015-03-13 03:05:00.900168	Y	0
1072	V	2015-03-13 08:01:14.131281	Y	Virus rules updated
1073	V	2015-03-13 13:01:29.598753	Y	Virus rules updated
1074	V	2015-03-13 17:01:14.304007	Y	Virus rules updated
1075	S	2015-03-14 03:03:30.036899	Y	
1076	R	2015-03-14 03:05:01.1024	Y	0
1077	S	2015-03-15 03:03:38.074568	Y	
1078	R	2015-03-15 03:05:01.154712	Y	0
1079	V	2015-03-15 17:01:14.370404	Y	Virus rules updated
1080	S	2015-03-16 03:03:17.672311	Y	
1081	R	2015-03-16 03:05:00.534983	Y	0
1082	L	2015-03-16 16:50:57.653315	Y	admin
1083	V	2015-03-16 17:01:14.591825	Y	Virus rules updated
1084	S	2015-03-17 03:03:22.448919	Y	
1085	R	2015-03-17 03:05:00.599194	Y	0
1086	V	2015-03-17 12:01:13.319195	Y	Virus rules updated
1087	V	2015-03-17 13:01:12.414925	Y	Virus rules updated
1088	V	2015-03-17 19:01:25.357223	Y	Virus rules updated
1089	V	2015-03-18 01:01:12.560544	Y	Virus rules updated
1090	S	2015-03-18 03:03:13.914425	Y	
1091	R	2015-03-18 03:05:01.000072	Y	0
1092	V	2015-03-18 07:01:25.724763	Y	Virus rules updated
1093	V	2015-03-18 10:01:12.576194	Y	Virus rules updated
1094	V	2015-03-18 11:01:23.830903	Y	Virus rules updated
1095	V	2015-03-18 13:01:12.276301	Y	Virus rules updated
1096	V	2015-03-18 19:01:12.613504	Y	Virus rules updated
1097	V	2015-03-19 01:01:12.517474	Y	Virus rules updated
1098	S	2015-03-19 03:03:10.988633	Y	
1099	R	2015-03-19 03:05:00.875576	Y	0
1100	V	2015-03-19 07:01:13.52161	Y	Virus rules updated
1101	V	2015-03-19 13:01:25.405903	Y	Virus rules updated
1102	V	2015-03-19 19:01:11.915702	Y	Virus rules updated
1103	V	2015-03-20 01:01:12.53674	Y	Virus rules updated
1104	R	2015-03-20 03:05:00.788902	Y	0
1105	V	2015-03-20 07:01:26.211823	Y	Virus rules updated
1106	V	2015-03-20 10:01:13.100353	Y	Virus rules updated
1107	V	2015-03-20 13:01:12.082763	Y	Virus rules updated
1108	V	2015-03-20 16:01:14.281392	Y	Virus rules updated
1109	V	2015-03-21 01:01:26.574706	Y	Virus rules updated
1110	R	2015-03-21 03:05:00.33315	Y	0
1111	V	2015-03-21 07:01:12.573335	Y	Virus rules updated
1112	V	2015-03-21 13:01:12.283217	Y	Virus rules updated
1113	V	2015-03-21 19:01:13.964347	Y	Virus rules updated
1114	V	2015-03-22 01:01:12.71576	Y	Virus rules updated
1115	R	2015-03-22 03:05:01.150208	Y	0
1116	V	2015-03-22 07:01:12.833084	Y	Virus rules updated
1117	V	2015-03-22 13:01:12.569814	Y	Virus rules updated
1118	V	2015-03-22 16:01:12.167486	Y	Virus rules updated
1119	V	2015-03-22 19:01:12.613979	Y	Virus rules updated
1120	V	2015-03-23 01:01:25.111152	Y	Virus rules updated
1121	R	2015-03-23 03:05:00.843355	Y	0
1122	V	2015-03-23 07:01:12.165721	Y	Virus rules updated
1123	V	2015-03-23 11:01:13.400626	Y	Virus rules updated
1124	V	2015-03-23 12:01:13.114083	Y	Virus rules updated
1125	L	2015-03-23 16:34:36.012473	Y	admin
1126	V	2015-03-23 19:02:00.034547	Y	Virus rules updated
1127	V	2015-03-24 00:01:26.099093	Y	Virus rules updated
1128	R	2015-03-24 03:05:00.377229	Y	0
1129	V	2015-03-24 06:01:15.600271	Y	Virus rules updated
1130	V	2015-03-24 12:01:12.638886	Y	Virus rules updated
1131	V	2015-03-24 14:01:12.495476	Y	Virus rules updated
1132	V	2015-03-24 19:01:12.322505	Y	Virus rules updated
1133	V	2015-03-25 00:01:13.43238	Y	Virus rules updated
1134	R	2015-03-25 03:05:01.151007	Y	0
1135	V	2015-03-25 06:01:12.774729	Y	Virus rules updated
1136	V	2015-03-25 09:01:12.00694	Y	Virus rules updated
1137	V	2015-03-25 12:01:12.53756	Y	Virus rules updated
1138	V	2015-03-25 15:01:13.700475	Y	Virus rules updated
1139	V	2015-03-25 16:01:12.251281	Y	Virus rules updated
1140	V	2015-03-25 19:01:12.662213	Y	Virus rules updated
1141	V	2015-03-26 00:01:13.996441	Y	Virus rules updated
1142	R	2015-03-26 03:05:00.592435	Y	0
1143	V	2015-03-26 06:01:12.410154	Y	Virus rules updated
1144	L	2015-03-26 10:53:04.340807	Y	admin
1145	L	2015-03-26 11:09:50.164582	Y	admin
1146	V	2015-03-26 12:01:13.820758	Y	Virus rules updated
1147	V	2015-03-26 15:01:12.799434	Y	Virus rules updated
1148	V	2015-03-27 00:01:34.245685	Y	Virus rules updated
1149	R	2015-03-27 03:05:00.903399	Y	0
1150	V	2015-03-27 06:01:13.430372	Y	Virus rules updated
1151	L	2015-03-27 09:31:44.467934	Y	admin
1152	L	2015-03-27 09:32:01.341015	Y	admin
1153	V	2015-03-27 12:01:14.905971	Y	Virus rules updated
1154	V	2015-03-27 15:01:59.908719	Y	Virus rules updated
1155	V	2015-03-27 17:01:27.054569	Y	Virus rules updated
1156	V	2015-03-27 18:01:12.362986	Y	Virus rules updated
1157	V	2015-03-28 01:01:12.256141	Y	Virus rules updated
1158	R	2015-03-28 03:05:00.569599	Y	0
1159	V	2015-03-28 06:01:12.717406	Y	Virus rules updated
1160	V	2015-03-28 12:01:12.660165	Y	Virus rules updated
1161	V	2015-03-28 18:01:14.326346	Y	Virus rules updated
1162	V	2015-03-29 00:01:13.59313	Y	Virus rules updated
1163	S	2015-03-29 03:03:18.020598	Y	
1164	R	2015-03-29 03:05:00.699423	Y	0
1165	V	2015-03-29 06:01:13.037897	Y	Virus rules updated
1166	V	2015-03-29 13:01:13.471292	Y	Virus rules updated
1167	V	2015-03-29 16:01:13.560717	Y	Virus rules updated
1168	V	2015-03-30 00:01:13.508828	Y	Virus rules updated
1169	S	2015-03-30 03:03:12.291083	Y	
1170	R	2015-03-30 03:05:00.273852	Y	0
1171	V	2015-03-30 07:01:13.017047	Y	Virus rules updated
1172	V	2015-03-30 11:01:26.146492	Y	Virus rules updated
1173	V	2015-03-30 12:01:12.557399	Y	Virus rules updated
1174	V	2015-03-30 14:01:13.082616	Y	Virus rules updated
1175	V	2015-03-30 18:01:12.437669	Y	Virus rules updated
1176	V	2015-03-31 00:01:18.283776	Y	Virus rules updated
1177	S	2015-03-31 03:03:17.142535	Y	
1178	R	2015-03-31 03:05:01.183166	Y	0
1179	V	2015-03-31 07:01:14.633224	Y	Virus rules updated
1180	V	2015-03-31 13:01:12.77219	Y	Virus rules updated
1181	V	2015-03-31 19:01:23.490662	Y	Virus rules updated
1182	V	2015-04-01 01:01:12.427568	Y	Virus rules updated
1183	S	2015-04-01 03:03:22.91421	Y	
1184	R	2015-04-01 03:05:00.778506	Y	0
1185	V	2015-04-01 06:01:17.372708	Y	Virus rules updated
1186	V	2015-04-01 09:01:44.590334	Y	Virus rules updated
1187	V	2015-04-01 12:01:15.018912	Y	Virus rules updated
1188	V	2015-04-01 15:01:13.588846	Y	Virus rules updated
1189	R	2015-04-02 03:05:00.638859	Y	0
1190	V	2015-04-02 13:02:04.813031	Y	Virus rules updated
1191	V	2015-04-02 15:01:16.986211	Y	Virus rules updated
1192	R	2015-04-03 03:05:01.096814	Y	0
1193	V	2015-04-03 14:01:17.118272	Y	Virus rules updated
1194	R	2015-04-04 03:05:00.547653	Y	0
1195	V	2015-04-04 12:01:45.145949	Y	Virus rules updated
1196	V	2015-04-04 15:01:15.389186	Y	Virus rules updated
1197	R	2015-04-05 03:05:01.129129	Y	0
1198	V	2015-04-06 00:01:15.654226	Y	Virus rules updated
1199	R	2015-04-06 03:05:01.046934	Y	0
1200	V	2015-04-06 10:01:16.689008	Y	Virus rules updated
1201	V	2015-04-06 12:01:27.272055	Y	Virus rules updated
1202	L	2015-04-06 12:36:48.92765	N	admin
1203	L	2015-04-06 12:36:54.495673	N	admin
1204	L	2015-04-06 12:37:08.612435	N	admin
1205	L	2015-04-06 12:37:15.205016	Y	admin
1206	L	2015-04-06 12:44:37.823907	Y	admin
1207	V	2015-04-06 17:01:12.664709	Y	Virus rules updated
1208	V	2015-04-06 18:01:15.96661	Y	Virus rules updated
1209	V	2015-04-07 00:01:13.064183	Y	Virus rules updated
1210	R	2015-04-07 03:05:00.766385	Y	0
1211	V	2015-04-07 06:01:25.699729	Y	Virus rules updated
1212	L	2015-04-07 11:13:03.103844	Y	admin
1213	V	2015-04-07 12:01:32.372279	Y	Virus rules updated
1214	V	2015-04-07 18:01:46.810889	Y	Virus rules updated
1215	V	2015-04-08 00:01:27.322142	Y	Virus rules updated
1216	R	2015-04-08 03:05:00.458521	Y	0
1217	V	2015-04-08 06:01:12.884431	Y	Virus rules updated
1218	V	2015-04-08 10:01:27.081717	Y	Virus rules updated
1219	L	2015-04-08 11:55:34.850796	N	admin
1220	L	2015-04-08 11:55:40.986042	Y	admin
1221	V	2015-04-08 15:01:45.421337	Y	Virus rules updated
1222	V	2015-04-08 16:01:06.543899	Y	Virus rules updated
1223	V	2015-04-08 18:01:13.782472	Y	Virus rules updated
1224	R	2015-04-09 03:05:00.303511	Y	0
1225	V	2015-04-09 04:01:12.537233	Y	Virus rules updated
1226	V	2015-04-09 06:01:26.21773	Y	Virus rules updated
1227	V	2015-04-09 12:01:27.786942	Y	Virus rules updated
1228	V	2015-04-09 14:01:06.555226	Y	Virus rules updated
1229	V	2015-04-09 18:01:27.765046	Y	Virus rules updated
1230	V	2015-04-10 00:01:18.491398	Y	Virus rules updated
1231	R	2015-04-10 03:05:01.023508	Y	0
1232	V	2015-04-10 07:01:26.344923	Y	Virus rules updated
1233	V	2015-04-10 10:01:13.624843	Y	Virus rules updated
1234	V	2015-04-10 12:01:16.515307	Y	Virus rules updated
1235	V	2015-04-10 16:01:12.144907	Y	Virus rules updated
1236	R	2015-04-11 03:05:01.010139	Y	0
1237	V	2015-04-11 06:01:15.833684	Y	Virus rules updated
1238	V	2015-04-11 12:02:13.382683	Y	Virus rules updated
1239	V	2015-04-11 18:01:17.74958	Y	Virus rules updated
1240	V	2015-04-12 00:01:17.674364	Y	Virus rules updated
1241	R	2015-04-12 03:05:00.532263	Y	0
1242	V	2015-04-12 06:01:15.561543	Y	Virus rules updated
1243	V	2015-04-12 12:01:12.84591	Y	Virus rules updated
1244	V	2015-04-12 18:01:14.566816	Y	Virus rules updated
1245	V	2015-04-13 00:01:14.446968	Y	Virus rules updated
1246	R	2015-04-13 03:05:00.95006	Y	0
1247	V	2015-04-13 10:01:26.067358	Y	Virus rules updated
1248	L	2015-04-13 11:40:03.201124	Y	admin
1249	V	2015-04-13 12:01:26.827959	Y	Virus rules updated
1250	V	2015-04-13 18:01:13.492959	Y	Virus rules updated
1251	V	2015-04-14 00:01:14.855275	Y	Virus rules updated
1252	F	2015-04-14 03:01:37.63313	Y	Updates have been retrieved
1253	R	2015-04-14 03:05:00.380164	Y	0
1254	V	2015-04-14 06:01:12.458119	Y	Virus rules updated
1255	L	2015-04-14 07:40:22.873203	Y	admin
1256	V	2015-04-14 11:01:17.716215	Y	Virus rules updated
1257	V	2015-04-14 16:01:43.123847	Y	Virus rules updated
1258	V	2015-04-14 18:01:32.659791	Y	Virus rules updated
1259	R	2015-04-15 03:05:00.241166	Y	0
1260	V	2015-04-15 06:01:12.83299	Y	Virus rules updated
1261	V	2015-04-15 12:01:21.087666	Y	Virus rules updated
1262	L	2015-04-15 12:44:16.256628	Y	admin
1263	V	2015-04-15 16:01:27.453304	Y	Virus rules updated
1264	R	2015-04-16 03:05:00.671862	Y	0
1265	V	2015-04-16 12:01:35.759835	Y	Virus rules updated
1266	V	2015-04-16 13:01:11.207829	Y	Virus rules updated
1267	V	2015-04-16 14:01:26.338681	Y	Virus rules updated
1268	V	2015-04-16 15:01:50.707087	Y	Virus rules updated
1269	V	2015-04-16 16:01:11.987147	Y	Virus rules updated
1270	V	2015-04-16 18:01:27.838203	Y	Virus rules updated
1271	V	2015-04-17 00:01:16.991296	Y	Virus rules updated
1272	R	2015-04-17 03:05:00.621923	Y	0
1273	V	2015-04-17 07:01:12.201551	Y	Virus rules updated
1274	V	2015-04-17 10:01:13.141656	Y	Virus rules updated
1275	V	2015-04-17 15:01:23.359972	Y	Virus rules updated
1276	V	2015-04-18 00:01:44.229904	Y	Virus rules updated
1277	R	2015-04-18 03:05:00.471736	Y	0
1278	V	2015-04-18 06:01:12.830359	Y	Virus rules updated
1279	V	2015-04-18 10:01:15.793188	Y	Virus rules updated
1280	V	2015-04-18 18:01:13.565174	Y	Virus rules updated
1281	V	2015-04-19 00:01:21.464707	Y	Virus rules updated
1282	S	2015-04-19 03:03:14.737953	Y	
1283	R	2015-04-19 03:05:00.447125	Y	0
1284	V	2015-04-19 06:01:12.798646	Y	Virus rules updated
1285	V	2015-04-19 18:01:27.756677	Y	Virus rules updated
1286	V	2015-04-20 00:01:19.320749	Y	Virus rules updated
1287	V	2015-04-20 03:01:12.96237	Y	Virus rules updated
1288	S	2015-04-20 03:03:20.148017	Y	
1289	R	2015-04-20 03:05:00.926545	Y	0
1290	V	2015-04-20 06:01:15.441992	Y	Virus rules updated
1291	L	2015-04-20 10:51:00.127309	Y	admin
1292	V	2015-04-20 12:01:15.796077	Y	Virus rules updated
1293	V	2015-04-20 18:01:15.120844	Y	Virus rules updated
1294	V	2015-04-21 00:01:19.361849	Y	Virus rules updated
1295	S	2015-04-21 03:03:17.643389	Y	
1296	R	2015-04-21 03:05:00.416545	Y	0
1297	V	2015-04-21 07:01:13.441267	Y	Virus rules updated
1298	V	2015-04-21 15:01:46.701906	Y	Virus rules updated
1299	V	2015-04-21 18:01:13.80762	Y	Virus rules updated
1300	V	2015-04-22 01:01:22.778238	Y	Virus rules updated
1301	V	2015-04-22 03:01:44.774869	Y	Virus rules updated
1302	S	2015-04-22 03:03:13.561047	Y	
1303	R	2015-04-22 03:05:00.321727	Y	0
1304	V	2015-04-22 06:01:13.016523	Y	Virus rules updated
1305	V	2015-04-22 11:01:11.992329	Y	Virus rules updated
1306	V	2015-04-22 16:01:14.907864	Y	Virus rules updated
1307	V	2015-04-22 18:01:13.831966	Y	Virus rules updated
1308	V	2015-04-23 03:01:40.784834	Y	Virus rules updated
1309	S	2015-04-23 03:03:09.614347	Y	
1310	R	2015-04-23 03:05:01.02865	Y	0
1311	V	2015-04-23 06:01:28.58143	Y	Virus rules updated
1312	V	2015-04-23 11:01:13.860434	Y	Virus rules updated
1313	V	2015-04-23 15:01:15.971602	Y	Virus rules updated
1314	V	2015-04-23 18:01:13.277224	Y	Virus rules updated
1315	V	2015-04-24 03:01:29.373627	Y	Virus rules updated
1316	R	2015-04-24 03:05:00.324867	Y	0
1317	V	2015-04-24 09:01:13.136878	Y	Virus rules updated
1318	V	2015-04-24 11:01:13.388531	Y	Virus rules updated
1319	V	2015-04-24 16:01:44.516284	Y	Virus rules updated
1320	V	2015-04-24 18:01:26.722817	Y	Virus rules updated
1321	V	2015-04-25 00:01:16.931084	Y	Virus rules updated
1322	R	2015-04-25 03:05:00.874608	Y	0
1323	V	2015-04-25 07:01:12.709345	Y	Virus rules updated
1324	V	2015-04-25 16:01:17.170106	Y	Virus rules updated
1325	V	2015-04-25 18:01:43.78497	Y	Virus rules updated
1326	V	2015-04-26 00:01:12.753775	Y	Virus rules updated
1327	R	2015-04-26 03:05:00.325538	Y	0
1328	V	2015-04-26 06:01:12.55198	Y	Virus rules updated
1329	V	2015-04-26 12:01:12.536486	Y	Virus rules updated
1330	V	2015-04-26 18:01:12.74962	Y	Virus rules updated
1331	V	2015-04-27 00:01:13.077098	Y	Virus rules updated
1332	R	2015-04-27 03:05:01.16123	Y	0
1333	V	2015-04-27 06:01:12.538452	Y	Virus rules updated
1334	L	2015-04-27 10:19:13.075313	Y	admin
1335	V	2015-04-27 18:02:00.516117	Y	Virus rules updated
1336	V	2015-04-28 00:01:42.780629	Y	Virus rules updated
1337	V	2015-04-28 03:01:33.668716	Y	Virus rules updated
1338	R	2015-04-28 03:05:00.474544	Y	0
1339	V	2015-04-28 09:01:13.632812	Y	Virus rules updated
1340	V	2015-04-28 12:01:26.81348	Y	Virus rules updated
1341	L	2015-04-28 14:44:17.1334	Y	admin
1342	V	2015-04-28 16:01:12.870393	Y	Virus rules updated
1343	V	2015-04-28 18:01:27.229703	Y	Virus rules updated
1344	R	2015-04-29 03:05:00.935871	Y	0
1345	V	2015-04-29 06:01:13.343206	Y	Virus rules updated
1346	V	2015-04-29 12:01:13.921634	Y	Virus rules updated
1347	V	2015-04-29 18:01:13.246118	Y	Virus rules updated
1348	V	2015-04-30 00:01:13.603122	Y	Virus rules updated
1349	R	2015-04-30 03:05:01.127362	Y	0
1350	V	2015-04-30 06:01:14.873494	Y	Virus rules updated
1351	V	2015-04-30 11:01:12.836373	Y	Virus rules updated
1352	V	2015-04-30 12:01:26.31412	Y	Virus rules updated
1353	V	2015-04-30 15:01:29.147919	Y	Virus rules updated
1354	V	2015-04-30 16:01:09.282385	Y	Virus rules updated
1355	V	2015-04-30 18:01:12.168642	Y	Virus rules updated
1356	V	2015-05-01 03:01:44.220089	Y	Virus rules updated
1357	R	2015-05-01 03:05:00.371893	Y	0
1358	V	2015-05-01 09:01:12.97496	Y	Virus rules updated
1359	V	2015-05-02 00:01:14.306429	Y	Virus rules updated
1360	V	2015-05-02 03:01:16.455767	Y	Virus rules updated
1361	R	2015-05-02 03:05:00.845175	Y	0
1362	V	2015-05-02 06:01:12.598558	Y	Virus rules updated
1363	V	2015-05-02 15:01:42.947209	Y	Virus rules updated
1364	V	2015-05-02 20:01:32.32189	Y	Virus rules updated
1365	V	2015-05-03 01:01:13.688491	Y	Virus rules updated
1366	S	2015-05-03 03:03:39.918221	Y	
1367	R	2015-05-03 03:05:00.866749	Y	0
1368	V	2015-05-03 07:01:13.349303	Y	Virus rules updated
1369	V	2015-05-03 13:01:14.294705	Y	Virus rules updated
1370	V	2015-05-04 01:01:14.786059	Y	Virus rules updated
1371	S	2015-05-04 03:03:22.139448	Y	
1372	R	2015-05-04 03:05:01.029903	Y	0
1373	V	2015-05-04 04:01:14.727927	Y	Virus rules updated
1374	V	2015-05-04 07:01:14.734303	Y	Virus rules updated
1375	L	2015-05-04 08:40:35.71928	Y	admin
1376	V	2015-05-04 10:01:14.496242	Y	Virus rules updated
1377	V	2015-05-04 13:01:15.699474	Y	Virus rules updated
1378	V	2015-05-04 19:01:31.595793	Y	Virus rules updated
1379	V	2015-05-05 01:01:19.669661	Y	Virus rules updated
1380	S	2015-05-05 03:03:25.471495	Y	
1381	R	2015-05-05 03:05:00.334362	Y	0
1382	V	2015-05-05 10:01:29.449006	Y	Virus rules updated
1383	V	2015-05-05 13:01:15.044273	Y	Virus rules updated
1384	V	2015-05-05 19:01:15.355664	Y	Virus rules updated
1385	V	2015-05-06 01:01:15.010017	Y	Virus rules updated
1386	R	2015-05-06 03:05:00.268764	Y	0
1387	S	2015-05-06 03:05:05.01536	Y	
1388	V	2015-05-06 07:01:14.440107	Y	Virus rules updated
1389	V	2015-05-06 13:01:14.122988	Y	Virus rules updated
1390	V	2015-05-06 17:01:14.543178	Y	Virus rules updated
1391	V	2015-05-06 18:01:13.963726	Y	Virus rules updated
1392	V	2015-05-06 19:01:15.108408	Y	Virus rules updated
1393	V	2015-05-07 01:01:45.434615	Y	Virus rules updated
1394	S	2015-05-07 03:03:23.814681	Y	
1395	R	2015-05-07 03:05:00.704699	Y	0
1396	V	2015-05-07 07:01:14.50595	Y	Virus rules updated
1397	V	2015-05-07 13:01:46.093164	Y	Virus rules updated
1398	V	2015-05-07 17:01:14.940786	Y	Virus rules updated
1399	V	2015-05-07 19:01:14.522775	Y	Virus rules updated
1400	S	2015-05-08 03:03:24.348443	Y	
1401	R	2015-05-08 03:05:00.254687	Y	0
1402	V	2015-05-08 04:01:14.544209	Y	Virus rules updated
1403	V	2015-05-08 10:01:14.209716	Y	Virus rules updated
1404	V	2015-05-08 16:01:15.547159	Y	Virus rules updated
1405	V	2015-05-08 19:01:14.649201	Y	Virus rules updated
1406	V	2015-05-08 20:01:14.224337	Y	Virus rules updated
1407	S	2015-05-09 03:03:24.108733	Y	
1408	R	2015-05-09 03:05:00.989	Y	0
1409	V	2015-05-09 04:01:14.709137	Y	Virus rules updated
1410	V	2015-05-09 14:01:44.739823	Y	Virus rules updated
1411	V	2015-05-09 16:01:14.913339	Y	Virus rules updated
1412	V	2015-05-09 20:01:15.48038	Y	Virus rules updated
1413	S	2015-05-10 03:03:28.578791	Y	
1414	R	2015-05-10 03:05:00.498967	Y	0
1415	V	2015-05-10 04:01:31.343424	Y	Virus rules updated
1416	V	2015-05-10 10:01:13.846649	Y	Virus rules updated
1417	V	2015-05-11 01:01:15.168268	Y	Virus rules updated
1418	S	2015-05-11 03:03:22.978651	Y	
1419	R	2015-05-11 03:05:00.879448	Y	0
1420	V	2015-05-11 08:01:15.113543	Y	Virus rules updated
1421	V	2015-05-11 13:01:13.462556	Y	Virus rules updated
1422	V	2015-05-11 22:01:15.62314	Y	Virus rules updated
1423	V	2015-05-12 01:01:13.732346	Y	Virus rules updated
1424	S	2015-05-12 03:03:26.389125	Y	
1425	R	2015-05-12 03:05:00.333357	Y	0
1426	V	2015-05-12 13:01:16.108948	Y	Virus rules updated
1427	V	2015-05-12 19:01:14.861655	Y	Virus rules updated
1428	V	2015-05-13 02:01:14.722923	Y	Virus rules updated
1429	S	2015-05-13 03:03:23.446711	Y	
1430	R	2015-05-13 03:05:00.351597	Y	0
1431	V	2015-05-13 07:01:13.920986	Y	Virus rules updated
1432	V	2015-05-13 13:01:16.196815	Y	Virus rules updated
1433	V	2015-05-13 19:01:13.189809	Y	Virus rules updated
1434	V	2015-05-14 01:01:43.767513	Y	Virus rules updated
1435	S	2015-05-14 03:03:23.031138	Y	
1436	R	2015-05-14 03:05:00.910715	Y	0
1437	V	2015-05-14 04:01:45.139889	Y	Virus rules updated
1438	L	2015-05-14 09:42:36.193086	Y	admin
1439	V	2015-05-14 11:01:48.839727	Y	Virus rules updated
1440	V	2015-05-14 12:01:15.117011	Y	Virus rules updated
1441	V	2015-05-14 13:01:13.247387	Y	Virus rules updated
1442	V	2015-05-14 14:01:15.17301	Y	Virus rules updated
1443	V	2015-05-14 19:01:14.621185	Y	Virus rules updated
1444	S	2015-05-15 03:03:25.581268	Y	
1445	R	2015-05-15 03:05:00.518915	Y	0
1446	V	2015-05-15 07:01:15.227206	Y	Virus rules updated
1447	V	2015-05-15 13:01:14.441509	Y	Virus rules updated
1448	V	2015-05-15 16:01:30.385631	Y	Virus rules updated
1449	V	2015-05-15 17:01:51.545822	Y	Virus rules updated
1450	V	2015-05-15 19:01:15.51772	Y	Virus rules updated
1451	V	2015-05-16 01:01:13.748244	Y	Virus rules updated
1452	S	2015-05-16 03:03:26.778474	Y	
1453	R	2015-05-16 03:05:00.723376	Y	0
1454	V	2015-05-16 07:01:14.517699	Y	Virus rules updated
1455	V	2015-05-16 13:01:14.733541	Y	Virus rules updated
1456	V	2015-05-16 19:01:15.005368	Y	Virus rules updated
1457	S	2015-05-17 03:03:25.023616	Y	
1458	R	2015-05-17 03:05:00.233637	Y	0
1459	V	2015-05-17 04:01:14.503157	Y	Virus rules updated
1460	V	2015-05-17 07:01:14.221948	Y	Virus rules updated
1461	V	2015-05-17 16:01:48.864787	Y	Virus rules updated
1462	V	2015-05-17 19:01:16.181705	Y	Virus rules updated
1463	V	2015-05-18 01:01:15.83567	Y	Virus rules updated
1464	S	2015-05-18 03:03:25.168775	Y	
1465	R	2015-05-18 03:05:01.164909	Y	0
1466	V	2015-05-18 10:01:30.603277	Y	Virus rules updated
1467	V	2015-05-18 11:01:07.190305	Y	Virus rules updated
1468	V	2015-05-18 12:01:14.04859	Y	Virus rules updated
1469	V	2015-05-18 16:01:50.858861	Y	Virus rules updated
1470	V	2015-05-18 17:01:06.404435	Y	Virus rules updated
1471	L	2015-05-18 17:35:53.391091	Y	admin
1472	R	2015-05-19 03:05:00.912761	Y	0
1473	V	2015-05-19 04:01:13.837781	Y	Virus rules updated
1474	V	2015-05-19 10:01:15.669591	Y	Virus rules updated
1475	L	2015-05-19 11:58:56.288863	Y	admin
1476	V	2015-05-19 13:01:14.190718	Y	Virus rules updated
1477	V	2015-05-19 19:01:31.939449	Y	Virus rules updated
1478	S	2015-05-20 03:03:25.56245	Y	
1479	R	2015-05-20 03:05:00.473259	Y	0
1480	V	2015-05-20 04:01:14.052344	Y	Virus rules updated
1481	V	2015-05-20 07:01:14.720621	Y	Virus rules updated
1482	V	2015-05-20 13:01:12.414654	Y	Virus rules updated
1483	V	2015-05-20 19:01:15.187034	Y	Virus rules updated
1484	R	2015-05-21 03:05:00.548138	Y	0
1485	V	2015-05-21 04:01:15.471721	Y	Virus rules updated
1486	V	2015-05-21 09:01:13.665129	Y	Virus rules updated
1487	V	2015-05-21 10:01:14.623361	Y	Virus rules updated
1488	V	2015-05-21 14:01:15.857509	Y	Virus rules updated
1489	V	2015-05-21 16:01:19.282264	Y	Virus rules updated
1490	V	2015-05-22 01:01:31.337258	Y	Virus rules updated
1491	R	2015-05-22 03:05:01.06006	Y	0
1492	V	2015-05-22 04:01:14.613864	Y	Virus rules updated
1493	V	2015-05-22 12:01:14.786063	Y	Virus rules updated
1494	V	2015-05-22 18:01:16.851606	Y	Virus rules updated
1495	V	2015-05-23 01:01:14.160394	Y	Virus rules updated
1496	R	2015-05-23 03:05:00.229775	Y	0
1497	V	2015-05-23 06:01:14.061436	Y	Virus rules updated
1498	V	2015-05-23 16:01:15.993071	Y	Virus rules updated
1499	R	2015-05-24 03:05:01.11607	Y	0
1500	R	2015-05-25 03:05:01.06846	Y	0
1501	V	2015-05-25 08:01:46.979697	Y	Virus rules updated
1502	V	2015-05-25 16:01:14.245601	Y	Virus rules updated
1503	R	2015-05-26 03:05:00.213693	Y	0
1504	V	2015-05-26 15:01:15.992048	Y	Virus rules updated
1505	V	2015-05-26 16:01:13.843846	Y	Virus rules updated
1506	R	2015-05-27 03:05:00.293317	Y	0
1507	V	2015-05-27 10:01:14.132877	Y	Virus rules updated
1508	V	2015-05-27 11:01:13.988054	Y	Virus rules updated
1509	V	2015-05-27 13:01:15.304733	Y	Virus rules updated
1510	V	2015-05-27 18:01:15.96791	Y	Virus rules updated
1511	V	2015-05-27 19:01:13.945102	Y	Virus rules updated
1512	V	2015-05-27 23:01:14.288488	Y	Virus rules updated
1513	V	2015-05-28 01:01:14.816834	Y	Virus rules updated
1514	R	2015-05-28 03:05:01.152016	Y	0
1515	V	2015-05-28 04:01:14.044755	Y	Virus rules updated
1516	V	2015-05-28 08:01:30.496861	Y	Virus rules updated
1517	V	2015-05-28 10:01:14.432413	Y	Virus rules updated
1518	V	2015-05-28 16:01:16.715736	Y	Virus rules updated
1519	V	2015-05-28 19:01:14.362539	Y	Virus rules updated
1520	R	2015-05-29 03:05:00.735525	Y	0
1521	V	2015-05-29 07:01:51.40561	Y	Virus rules updated
1522	V	2015-05-29 10:01:15.210556	Y	Virus rules updated
1523	V	2015-05-29 13:01:30.576695	Y	Virus rules updated
1524	V	2015-05-29 16:06:22.684432	N	freshclam error:  58
1525	V	2015-05-29 17:06:22.646081	N	freshclam error:  58
1526	V	2015-05-29 18:06:22.08934	N	freshclam error:  58
1527	V	2015-05-29 19:06:21.86421	N	freshclam error:  58
1528	V	2015-05-29 20:06:22.209986	N	freshclam error:  58
1529	V	2015-05-29 21:06:22.799269	N	freshclam error:  58
1530	V	2015-05-29 22:06:26.050555	N	freshclam error:  58
1531	V	2015-05-29 23:06:26.385319	N	freshclam error:  58
1532	V	2015-05-30 00:06:26.971442	N	freshclam error:  58
1533	V	2015-05-30 01:06:26.540121	N	freshclam error:  58
1534	V	2015-05-30 02:06:25.898954	N	freshclam error:  58
1535	S	2015-05-30 03:04:55.102044	N	Cannot contact server
1536	R	2015-05-30 03:05:00.817084	Y	0
1537	F	2015-05-30 03:05:10.631665	N	Cannot contact ANY update server
1538	V	2015-05-30 03:06:26.258987	N	freshclam error:  58
1539	V	2015-05-30 04:06:21.855325	N	freshclam error:  58
1540	V	2015-05-30 05:06:21.848901	N	freshclam error:  58
1541	V	2015-05-30 06:06:25.909425	N	freshclam error:  58
1542	V	2015-05-30 07:06:25.794327	N	freshclam error:  58
1543	V	2015-05-30 08:06:26.623969	N	freshclam error:  58
1544	V	2015-05-30 09:06:26.229772	N	freshclam error:  58
1545	V	2015-05-30 10:06:26.024876	N	freshclam error:  58
1546	V	2015-05-30 11:06:26.152268	N	freshclam error:  58
1547	V	2015-05-30 12:06:22.556527	N	freshclam error:  58
1548	V	2015-05-30 13:06:22.958746	N	freshclam error:  58
1549	V	2015-05-30 14:06:26.149386	N	freshclam error:  58
1550	V	2015-05-30 15:06:26.11517	N	freshclam error:  58
1551	V	2015-05-30 16:06:26.145258	N	freshclam error:  58
1552	V	2015-05-30 17:06:26.24013	N	freshclam error:  58
1553	V	2015-05-30 18:06:26.349088	N	freshclam error:  58
1554	V	2015-05-30 19:06:26.285395	N	freshclam error:  58
1555	V	2015-05-30 20:06:22.244407	N	freshclam error:  58
1556	V	2015-05-30 21:06:22.0403	N	freshclam error:  58
1557	V	2015-05-30 22:06:25.884615	N	freshclam error:  58
1558	V	2015-05-30 23:06:25.721419	N	freshclam error:  58
1559	V	2015-05-31 00:06:26.359364	N	freshclam error:  58
1560	V	2015-05-31 01:06:26.744222	N	freshclam error:  58
1561	V	2015-05-31 02:06:26.684002	N	freshclam error:  58
1562	R	2015-05-31 03:05:01.124033	Y	0
1563	V	2015-05-31 03:06:26.573787	N	freshclam error:  58
1564	S	2015-05-31 03:07:57.627164	N	Cannot contact server
1565	F	2015-05-31 03:08:13.152296	N	Cannot contact ANY update server
1566	V	2015-05-31 04:06:22.252079	N	freshclam error:  58
1567	V	2015-05-31 05:06:22.248698	N	freshclam error:  58
1568	V	2015-05-31 06:06:26.414154	N	freshclam error:  58
1569	V	2015-05-31 07:06:26.124193	N	freshclam error:  58
1570	V	2015-05-31 08:06:26.029664	N	freshclam error:  58
1571	V	2015-05-31 09:06:25.902026	N	freshclam error:  58
1572	V	2015-05-31 10:06:25.865217	N	freshclam error:  58
1573	V	2015-05-31 11:06:26.664353	N	freshclam error:  58
1574	V	2015-05-31 12:06:22.679377	N	freshclam error:  58
1575	V	2015-05-31 13:06:22.054878	N	freshclam error:  58
1576	V	2015-05-31 14:06:25.811046	N	freshclam error:  58
1577	V	2015-05-31 15:06:26.730097	N	freshclam error:  58
1578	V	2015-05-31 16:06:26.495763	N	freshclam error:  58
1579	V	2015-05-31 17:06:26.468852	N	freshclam error:  58
1580	V	2015-05-31 18:06:26.388971	N	freshclam error:  58
1581	V	2015-05-31 19:06:26.294461	N	freshclam error:  58
1582	V	2015-05-31 20:06:22.380134	N	freshclam error:  58
1583	V	2015-05-31 21:06:22.454271	N	freshclam error:  58
1584	V	2015-05-31 22:06:26.509092	N	freshclam error:  58
1585	V	2015-05-31 23:06:26.633964	N	freshclam error:  58
1586	V	2015-06-01 00:06:26.159079	N	freshclam error:  58
1587	V	2015-06-01 01:06:26.224878	N	freshclam error:  58
1588	V	2015-06-01 02:06:26.235227	N	freshclam error:  58
1589	R	2015-06-01 03:05:00.697148	Y	0
1590	V	2015-06-01 03:06:26.16409	N	freshclam error:  58
1591	S	2015-06-01 03:07:57.357101	N	Cannot contact server
1592	F	2015-06-01 03:08:12.871588	N	Cannot contact ANY update server
1593	V	2015-06-01 04:06:22.694399	N	freshclam error:  58
1594	V	2015-06-01 05:06:22.699365	N	freshclam error:  58
1595	V	2015-06-01 06:06:25.808938	N	freshclam error:  58
1596	V	2015-06-01 07:06:25.823898	N	freshclam error:  58
1597	V	2015-06-01 08:06:26.490054	N	freshclam error:  58
1598	V	2015-06-01 09:06:26.470618	N	freshclam error:  58
1599	V	2015-06-01 10:06:26.380315	N	freshclam error:  58
1600	V	2015-06-01 11:06:26.344045	N	freshclam error:  58
1601	V	2015-06-01 12:06:22.29449	N	freshclam error:  58
1602	L	2015-06-01 12:19:19.174027	Y	admin
1603	L	2015-06-01 12:28:39.547792	N	admin
1604	L	2015-06-01 12:28:44.692023	Y	admin
1605	L	2015-06-01 12:54:51.475118	Y	admin
1606	L	2015-06-01 12:28:49.640321	Y	admin
1607	V	2015-06-01 13:02:09.257559	Y	Virus rules updated
1608	V	2015-06-02 00:01:34.592326	Y	Virus rules updated
1609	V	2015-06-02 03:01:17.060896	Y	Virus rules updated
1610	R	2015-06-02 03:05:01.151961	Y	0
1611	V	2015-06-02 06:01:19.746208	Y	Virus rules updated
1612	V	2015-06-02 09:01:33.107342	Y	Virus rules updated
1613	V	2015-06-02 12:01:22.864322	Y	Virus rules updated
1614	V	2015-06-02 17:01:35.951184	Y	Virus rules updated
1615	V	2015-06-02 18:01:19.375865	Y	Virus rules updated
1616	V	2015-06-02 21:01:15.829774	Y	Virus rules updated
1617	V	2015-06-03 03:01:14.203478	Y	Virus rules updated
1618	R	2015-06-03 03:05:00.681069	Y	0
1619	V	2015-06-03 09:01:34.317053	Y	Virus rules updated
1620	V	2015-06-03 10:01:28.61179	Y	Virus rules updated
1621	R	2015-06-04 03:05:00.925988	Y	0
1622	V	2015-06-04 12:01:17.883679	Y	Virus rules updated
1623	R	2015-06-05 03:05:00.910357	Y	0
1624	V	2015-06-05 18:01:18.721299	Y	Virus rules updated
1625	R	2015-06-06 03:05:00.616202	Y	0
1626	R	2015-06-07 03:05:01.007735	Y	0
1627	R	2015-06-08 03:05:00.80285	Y	0
1628	V	2015-06-08 07:01:52.141739	Y	Virus rules updated
1629	V	2015-06-08 11:01:16.863958	Y	Virus rules updated
1630	V	2015-06-08 22:01:58.827582	Y	Virus rules updated
1631	V	2015-06-09 00:01:38.117526	Y	Virus rules updated
1632	V	2015-06-09 03:01:14.748255	Y	Virus rules updated
1633	R	2015-06-09 03:05:00.336776	Y	0
1634	V	2015-06-09 12:01:36.548533	Y	Virus rules updated
1635	V	2015-06-09 18:01:16.512718	Y	Virus rules updated
1636	S	2015-06-10 03:03:29.579832	Y	
1637	R	2015-06-10 03:05:00.618223	Y	0
1638	V	2015-06-10 15:01:24.43959	Y	Virus rules updated
1639	V	2015-06-11 01:01:47.493307	Y	Virus rules updated
1640	R	2015-06-11 03:05:00.431117	Y	0
1641	L	2015-06-11 07:57:34.622809	Y	admin
1642	V	2015-06-11 08:01:13.763058	Y	Virus rules updated
1643	V	2015-06-11 09:01:45.569704	Y	Virus rules updated
1644	V	2015-06-11 13:01:08.967175	Y	Virus rules updated
1645	V	2015-06-11 16:01:36.047325	Y	Virus rules updated
1646	R	2015-06-12 03:05:00.919675	Y	0
1647	V	2015-06-12 09:01:08.808201	Y	Virus rules updated
1648	V	2015-06-12 10:01:16.911416	Y	Virus rules updated
1649	L	2015-06-12 10:51:16.463537	Y	admin
1650	L	2015-06-12 15:54:06.50941	Y	admin
1651	V	2015-06-12 18:01:17.495343	Y	Virus rules updated
1652	R	2015-06-13 03:05:00.505254	Y	0
1653	S	2015-06-14 03:04:08.28209	Y	
1654	R	2015-06-14 03:05:00.384998	Y	0
1655	V	2015-06-14 23:01:47.989439	Y	Virus rules updated
1656	S	2015-06-15 03:03:32.243083	Y	
1657	R	2015-06-15 03:05:00.927767	Y	0
1658	V	2015-06-15 16:01:16.940311	Y	Virus rules updated
1659	V	2015-06-15 19:01:21.494288	Y	Virus rules updated
1660	S	2015-06-16 03:03:25.938678	Y	
1661	R	2015-06-16 03:05:00.875668	Y	0
1662	V	2015-06-16 06:01:16.393613	Y	Virus rules updated
1663	V	2015-06-16 09:01:32.975937	Y	Virus rules updated
1664	V	2015-06-16 10:01:15.658331	Y	Virus rules updated
1665	L	2015-06-16 11:12:59.344888	Y	admin
1666	L	2015-06-16 12:21:14.668997	N	admin
1667	L	2015-06-16 12:21:20.767713	Y	admin
1668	L	2015-06-16 13:28:43.189852	Y	admin
1669	L	2015-06-16 14:08:30.901081	Y	admin
1670	L	2015-06-16 15:08:43.87972	N	admin
1671	L	2015-06-16 15:08:48.935789	Y	admin
1672	V	2015-06-16 17:01:19.405907	Y	Virus rules updated
1673	V	2015-06-16 18:01:28.736452	Y	Virus rules updated
1674	V	2015-06-17 02:01:15.701907	Y	Virus rules updated
1675	S	2015-06-17 03:03:30.356351	Y	
1676	R	2015-06-17 03:05:01.012688	Y	0
1677	V	2015-06-17 06:01:20.001253	Y	Virus rules updated
1678	V	2015-06-17 08:01:15.891123	Y	Virus rules updated
1679	V	2015-06-17 17:01:16.229246	Y	Virus rules updated
1680	V	2015-06-17 20:01:16.111051	Y	Virus rules updated
1681	S	2015-06-18 03:03:43.09689	Y	
1682	R	2015-06-18 03:05:01.037471	Y	0
1683	V	2015-06-18 04:01:18.569307	Y	Virus rules updated
1684	V	2015-06-18 08:01:47.456963	Y	Virus rules updated
1685	V	2015-06-18 12:01:16.848454	Y	Virus rules updated
1686	V	2015-06-18 14:01:26.175003	Y	Virus rules updated
1687	V	2015-06-18 17:01:16.465403	Y	Virus rules updated
1688	V	2015-06-18 20:01:18.243077	Y	Virus rules updated
1689	S	2015-06-19 03:04:23.551592	Y	
1690	R	2015-06-19 03:05:00.413724	Y	0
1691	V	2015-06-19 04:01:20.551436	Y	Virus rules updated
1692	V	2015-06-19 09:01:15.128565	Y	Virus rules updated
1693	V	2015-06-19 17:01:23.504946	Y	Virus rules updated
1694	V	2015-06-19 21:01:30.83508	Y	Virus rules updated
1695	V	2015-06-19 22:01:45.877811	Y	Virus rules updated
1696	V	2015-06-20 00:01:49.53571	Y	Virus rules updated
1697	S	2015-06-20 03:03:34.634544	Y	
1698	R	2015-06-20 03:05:00.639438	Y	0
1699	V	2015-06-20 08:01:16.274527	Y	Virus rules updated
1700	V	2015-06-20 17:01:17.394781	Y	Virus rules updated
1701	V	2015-06-20 20:01:28.564994	Y	Virus rules updated
1702	V	2015-06-21 00:01:16.76006	Y	Virus rules updated
1703	S	2015-06-21 03:03:36.762904	Y	
1704	R	2015-06-21 03:05:00.53106	Y	0
1705	V	2015-06-21 08:01:16.240952	Y	Virus rules updated
1706	V	2015-06-21 13:01:47.232	Y	Virus rules updated
1707	V	2015-06-21 16:01:18.650941	Y	Virus rules updated
1708	V	2015-06-21 19:01:18.222781	Y	Virus rules updated
1709	S	2015-06-22 03:03:39.594966	Y	
1710	R	2015-06-22 03:05:00.338573	Y	0
1711	V	2015-06-22 05:01:25.076543	Y	Virus rules updated
1712	V	2015-06-22 09:01:25.789278	Y	Virus rules updated
1713	V	2015-06-22 12:01:19.744955	Y	Virus rules updated
1714	V	2015-06-22 16:01:16.470066	Y	Virus rules updated
1715	V	2015-06-22 21:01:16.629436	Y	Virus rules updated
1716	S	2015-06-23 03:03:47.857588	Y	
1717	R	2015-06-23 03:05:00.530264	Y	0
1718	V	2015-06-23 12:01:34.447962	Y	Virus rules updated
1719	V	2015-06-23 16:01:17.704378	Y	Virus rules updated
1720	V	2015-06-23 20:01:39.529633	Y	Virus rules updated
1721	S	2015-06-24 03:03:36.433138	Y	
1722	R	2015-06-24 03:05:00.26928	Y	0
1723	V	2015-06-24 05:01:48.475659	Y	Virus rules updated
1724	V	2015-06-24 08:01:34.608802	Y	Virus rules updated
1725	V	2015-06-24 13:01:42.799589	Y	Virus rules updated
1726	V	2015-06-24 17:02:09.253256	Y	Virus rules updated
1727	S	2015-06-25 03:03:40.853247	Y	
1728	R	2015-06-25 03:05:00.600502	Y	0
1729	V	2015-06-25 17:01:15.4617	Y	Virus rules updated
1730	V	2015-06-25 18:01:16.592333	Y	Virus rules updated
1731	S	2015-06-26 03:03:42.696464	Y	
1732	R	2015-06-26 03:05:00.699796	Y	0
1733	V	2015-06-26 04:01:17.026702	Y	Virus rules updated
1734	V	2015-06-26 09:02:37.321016	Y	Virus rules updated
1735	V	2015-06-26 15:01:27.18345	Y	Virus rules updated
1736	S	2015-06-27 03:03:35.787834	Y	
1737	R	2015-06-27 03:05:00.789707	Y	0
1738	V	2015-06-28 00:01:17.559206	Y	Virus rules updated
1739	S	2015-06-28 03:03:46.467109	Y	
1740	R	2015-06-28 03:05:00.380456	Y	0
1741	S	2015-06-29 03:03:34.155722	Y	
1742	R	2015-06-29 03:05:00.878469	Y	0
1743	V	2015-06-29 07:01:18.043583	Y	Virus rules updated
1744	V	2015-06-29 08:01:28.514715	Y	Virus rules updated
1745	V	2015-06-29 10:01:56.209804	Y	Virus rules updated
1746	V	2015-06-29 11:01:48.726878	Y	Virus rules updated
1747	V	2015-06-29 16:01:48.21175	Y	Virus rules updated
1748	V	2015-06-29 21:01:17.233772	Y	Virus rules updated
1749	R	2015-06-30 03:05:00.389575	Y	0
1750	V	2015-06-30 04:01:17.908766	Y	Virus rules updated
1751	V	2015-06-30 06:01:35.919271	Y	Virus rules updated
1752	V	2015-06-30 09:01:17.073354	Y	Virus rules updated
1753	L	2015-06-30 16:16:21.038069	Y	admin
1754	V	2015-06-30 17:01:44.215371	Y	Virus rules updated
1755	V	2015-06-30 21:01:47.820986	Y	Virus rules updated
1756	R	2015-07-01 03:05:01.120474	Y	0
1757	V	2015-07-01 04:01:44.141628	Y	Virus rules updated
1758	V	2015-07-01 08:01:17.508685	Y	Virus rules updated
1759	V	2015-07-01 16:01:34.999981	Y	Virus rules updated
1760	V	2015-07-01 21:01:47.396037	Y	Virus rules updated
1761	R	2015-07-02 03:05:00.231371	Y	0
1762	V	2015-07-02 04:01:16.553089	Y	Virus rules updated
1763	V	2015-07-02 09:01:16.255731	Y	Virus rules updated
1764	V	2015-07-02 10:01:16.651424	Y	Virus rules updated
1765	L	2015-07-02 11:50:26.617641	Y	admin
1766	V	2015-07-02 12:01:47.887544	Y	Virus rules updated
1767	V	2015-07-02 16:01:36.407446	Y	Virus rules updated
1768	V	2015-07-02 20:01:15.966762	Y	Virus rules updated
1769	R	2015-07-03 03:05:00.992528	Y	0
1770	V	2015-07-03 05:01:16.909009	Y	Virus rules updated
1771	V	2015-07-03 09:02:21.631624	Y	Virus rules updated
1772	V	2015-07-03 16:01:17.462585	Y	Virus rules updated
1773	V	2015-07-03 20:01:16.931309	Y	Virus rules updated
1774	R	2015-07-04 03:05:01.100757	Y	0
1775	V	2015-07-04 04:01:16.460808	Y	Virus rules updated
1776	V	2015-07-04 08:01:19.90564	Y	Virus rules updated
1777	V	2015-07-04 16:01:22.264028	Y	Virus rules updated
1778	V	2015-07-04 20:01:16.74	Y	Virus rules updated
1779	R	2015-07-05 03:05:00.729806	Y	0
1780	V	2015-07-05 04:01:21.414552	Y	Virus rules updated
1781	V	2015-07-05 08:01:17.687642	Y	Virus rules updated
1782	V	2015-07-05 16:01:16.619396	Y	Virus rules updated
1783	V	2015-07-05 21:01:46.479682	Y	Virus rules updated
1784	S	2015-07-06 03:03:38.045902	Y	
1785	R	2015-07-06 03:05:01.070038	Y	0
1786	V	2015-07-06 05:01:17.222921	Y	Virus rules updated
1787	V	2015-07-06 08:01:16.568669	Y	Virus rules updated
1788	V	2015-07-06 10:01:09.074619	Y	Virus rules updated
1789	V	2015-07-06 16:01:18.651606	Y	Virus rules updated
1790	V	2015-07-06 20:01:52.819726	Y	Virus rules updated
1791	S	2015-07-07 03:04:08.220256	Y	
1792	R	2015-07-07 03:05:01.080571	Y	0
1793	V	2015-07-07 04:01:17.168688	Y	Virus rules updated
1794	V	2015-07-07 08:01:17.021544	Y	Virus rules updated
1795	V	2015-07-07 10:01:44.914582	Y	Virus rules updated
1796	V	2015-07-07 17:01:17.415668	Y	Virus rules updated
1797	V	2015-07-07 20:01:16.386653	Y	Virus rules updated
1798	V	2015-07-08 00:01:17.992037	Y	Virus rules updated
1799	S	2015-07-08 03:03:38.578327	Y	
1800	R	2015-07-08 03:05:00.574499	Y	0
1801	V	2015-07-08 05:01:16.955243	Y	Virus rules updated
1802	L	2015-07-08 07:16:39.71959	Y	admin
1803	V	2015-07-08 13:01:17.613212	Y	Virus rules updated
1804	V	2015-07-08 17:01:36.454441	Y	Virus rules updated
1805	V	2015-07-08 21:01:16.663467	Y	Virus rules updated
1806	S	2015-07-09 03:03:50.273929	Y	
1807	R	2015-07-09 03:05:00.241624	Y	0
1808	V	2015-07-09 05:01:16.284783	Y	Virus rules updated
1809	V	2015-07-09 09:01:36.232698	Y	Virus rules updated
1810	L	2015-07-09 12:16:16.052176	Y	admin
1811	V	2015-07-09 15:01:19.149179	Y	Virus rules updated
1812	V	2015-07-09 17:01:38.145629	Y	Virus rules updated
1813	V	2015-07-09 21:01:16.282801	Y	Virus rules updated
1814	S	2015-07-10 03:03:40.031677	Y	
1815	R	2015-07-10 03:05:00.829596	Y	0
1816	V	2015-07-10 05:02:18.976977	Y	Virus rules updated
1817	V	2015-07-10 09:01:34.425243	Y	Virus rules updated
1818	V	2015-07-10 13:01:35.091114	Y	Virus rules updated
1819	V	2015-07-10 16:01:27.137188	Y	Virus rules updated
1820	V	2015-07-10 17:01:16.894086	Y	Virus rules updated
1821	V	2015-07-10 21:01:40.48839	Y	Virus rules updated
1822	S	2015-07-11 03:03:56.613864	Y	
1823	R	2015-07-11 03:05:00.661321	Y	0
1824	V	2015-07-11 05:01:47.096417	Y	Virus rules updated
1825	V	2015-07-11 09:01:18.36267	Y	Virus rules updated
1826	V	2015-07-11 10:01:35.402967	Y	Virus rules updated
1827	V	2015-07-11 17:01:17.037631	Y	Virus rules updated
1828	V	2015-07-11 21:01:28.275505	Y	Virus rules updated
1829	S	2015-07-12 03:03:38.700782	Y	
1830	R	2015-07-12 03:05:00.546296	Y	0
1831	V	2015-07-12 09:01:16.74888	Y	Virus rules updated
1832	V	2015-07-12 17:01:15.99181	Y	Virus rules updated
1833	V	2015-07-12 21:01:27.788333	Y	Virus rules updated
1834	S	2015-07-13 03:03:59.452993	Y	
1835	R	2015-07-13 03:05:01.137339	Y	0
1836	V	2015-07-13 05:01:21.324907	Y	Virus rules updated
1837	V	2015-07-13 09:04:59.043029	N	freshclam error:  58
1838	L	2015-07-13 09:23:22.077451	Y	admin
1839	V	2015-07-13 11:01:52.278715	Y	Virus rules updated
1840	L	2015-07-13 11:22:20.173597	N	admin
1841	L	2015-07-13 11:22:27.229825	Y	admin
1842	V	2015-07-13 13:06:16.635714	N	freshclam error:  58
1843	L	2015-07-13 13:08:51.496399	Y	admin
1844	V	2015-07-13 14:02:19.639496	Y	Virus rules updated
1845	V	2015-07-13 17:01:25.24198	Y	Virus rules updated
1846	V	2015-07-13 21:01:16.849527	Y	Virus rules updated
1847	S	2015-07-14 03:03:42.147689	Y	
1848	R	2015-07-14 03:05:00.192546	Y	0
1849	V	2015-07-14 05:01:16.416254	Y	Virus rules updated
1850	V	2015-07-14 09:01:38.675076	Y	Virus rules updated
1851	V	2015-07-14 12:06:26.505404	N	freshclam error:  58
1852	V	2015-07-14 13:06:22.541095	N	freshclam error:  58
1853	V	2015-07-14 14:06:22.703195	N	freshclam error:  58
1854	V	2015-07-14 15:06:22.118868	N	freshclam error:  58
1855	V	2015-07-14 16:06:22.530297	N	freshclam error:  58
1856	V	2015-07-14 18:01:17.856007	Y	Virus rules updated
1857	V	2015-07-14 20:01:19.191582	Y	Virus rules updated
1858	V	2015-07-14 21:01:16.475476	Y	Virus rules updated
1859	V	2015-07-14 22:01:18.755597	Y	Virus rules updated
1860	S	2015-07-15 03:03:32.728722	Y	
1861	R	2015-07-15 03:05:00.581361	Y	0
1862	V	2015-07-15 05:01:19.781478	Y	Virus rules updated
1863	V	2015-07-15 09:01:18.685494	Y	Virus rules updated
1864	V	2015-07-15 12:01:34.418897	Y	Virus rules updated
1865	V	2015-07-15 18:01:21.529056	Y	Virus rules updated
1866	S	2015-07-16 03:03:25.4781	Y	
1867	R	2015-07-16 03:05:00.427261	Y	0
1868	V	2015-07-16 13:01:21.639068	Y	Virus rules updated
1869	V	2015-07-16 16:01:21.402156	Y	Virus rules updated
1870	S	2015-07-17 03:04:16.67118	Y	
1871	R	2015-07-17 03:05:00.538947	Y	0
1872	V	2015-07-17 14:01:18.70235	Y	Virus rules updated
1873	S	2015-07-18 03:03:27.724754	Y	
1874	R	2015-07-18 03:05:00.633183	Y	0
1875	R	2015-07-19 03:05:01.054769	Y	0
1876	R	2015-07-20 03:05:00.771752	Y	0
1877	V	2015-07-20 11:01:23.9725	Y	Virus rules updated
1878	R	2015-07-21 03:05:01.163327	Y	0
1879	L	2015-07-21 12:30:47.766956	Y	admin
1880	L	2015-07-21 12:48:26.851829	Y	admin
1881	L	2015-07-21 12:52:14.186427	Y	admin
1882	V	2015-07-21 13:01:41.400709	Y	Virus rules updated
1883	R	2015-07-22 03:05:00.346904	Y	0
1884	V	2015-07-22 18:01:17.320121	Y	Virus rules updated
1885	V	2015-07-23 01:01:16.208039	Y	Virus rules updated
1886	R	2015-07-23 03:05:01.077817	Y	0
1887	V	2015-07-23 05:01:18.394714	Y	Virus rules updated
1888	V	2015-07-23 09:01:48.752876	Y	Virus rules updated
1889	V	2015-07-23 14:01:40.239887	Y	Virus rules updated
1890	V	2015-07-23 18:04:01.039082	Y	Virus rules updated
1891	V	2015-07-24 01:01:17.25975	Y	Virus rules updated
1892	R	2015-07-24 03:05:00.796241	Y	0
1893	V	2015-07-24 05:01:17.583758	Y	Virus rules updated
1894	V	2015-07-24 09:01:20.710463	Y	Virus rules updated
1895	V	2015-07-24 10:01:16.211802	Y	Virus rules updated
1896	V	2015-07-24 12:01:22.165876	Y	Virus rules updated
1897	V	2015-07-24 18:01:59.06601	Y	Virus rules updated
1898	V	2015-07-24 21:01:34.378612	Y	Virus rules updated
1899	V	2015-07-25 01:01:15.983279	Y	Virus rules updated
1900	R	2015-07-25 03:05:00.595607	Y	0
1901	V	2015-07-25 13:01:35.150313	Y	Virus rules updated
1902	V	2015-07-25 17:01:42.801207	Y	Virus rules updated
1903	V	2015-07-25 21:01:24.697624	Y	Virus rules updated
1904	S	2015-07-26 03:03:34.545918	Y	
1905	R	2015-07-26 03:05:00.435372	Y	0
1906	V	2015-07-26 06:01:17.368718	Y	Virus rules updated
1907	V	2015-07-26 09:01:16.767864	Y	Virus rules updated
1908	V	2015-07-26 17:01:18.015478	Y	Virus rules updated
1909	V	2015-07-26 21:01:54.684638	Y	Virus rules updated
1910	S	2015-07-27 03:03:28.266737	Y	
1911	R	2015-07-27 03:05:01.130672	Y	0
1912	V	2015-07-27 05:01:17.672308	Y	Virus rules updated
1913	V	2015-07-27 09:01:19.510912	Y	Virus rules updated
1914	V	2015-07-27 11:01:48.718638	Y	Virus rules updated
1915	V	2015-07-27 18:01:29.102257	Y	Virus rules updated
1916	V	2015-07-27 21:01:16.27419	Y	Virus rules updated
1917	S	2015-07-28 03:03:30.408484	Y	
1918	R	2015-07-28 03:05:00.638622	Y	0
1919	V	2015-07-28 05:01:16.32003	Y	Virus rules updated
1920	V	2015-07-28 12:01:18.405893	Y	Virus rules updated
1921	V	2015-07-28 13:01:35.55807	Y	Virus rules updated
1922	V	2015-07-28 18:01:41.684784	Y	Virus rules updated
1923	L	2015-07-28 18:13:14.371363	N	root
1924	L	2015-07-28 18:13:18.903455	Y	admin
1925	V	2015-07-28 19:01:57.52169	Y	Virus rules updated
1926	S	2015-07-29 03:03:37.489482	Y	
1927	R	2015-07-29 03:05:00.407458	Y	0
1928	V	2015-07-29 13:01:19.416107	Y	Virus rules updated
1929	V	2015-07-29 17:01:30.045657	Y	Virus rules updated
1930	V	2015-07-29 21:01:17.391252	Y	Virus rules updated
1931	R	2015-07-30 03:05:00.639074	Y	0
1932	V	2015-07-30 05:01:47.58633	Y	Virus rules updated
1933	V	2015-07-30 09:01:34.909426	Y	Virus rules updated
1934	V	2015-07-30 14:01:18.168461	Y	Virus rules updated
1935	V	2015-07-30 18:01:36.063065	Y	Virus rules updated
1936	V	2015-07-31 01:01:17.852172	Y	Virus rules updated
1937	S	2015-07-31 03:03:47.882636	Y	
1938	R	2015-07-31 03:05:00.827234	Y	0
1939	V	2015-07-31 05:01:35.463725	Y	Virus rules updated
1940	V	2015-07-31 09:01:19.060596	Y	Virus rules updated
1941	V	2015-07-31 18:01:18.827161	Y	Virus rules updated
1942	V	2015-07-31 21:01:17.37035	Y	Virus rules updated
1943	S	2015-08-01 03:03:33.351694	Y	
1944	R	2015-08-01 03:05:00.70486	Y	0
1945	V	2015-08-01 05:01:17.7631	Y	Virus rules updated
1946	V	2015-08-01 09:01:18.369461	Y	Virus rules updated
1947	V	2015-08-01 17:01:48.76371	Y	Virus rules updated
1948	V	2015-08-01 22:01:17.437868	Y	Virus rules updated
1949	S	2015-08-02 03:03:35.811653	Y	
1950	R	2015-08-02 03:05:00.785969	Y	0
1951	V	2015-08-02 05:01:15.843415	Y	Virus rules updated
1952	V	2015-08-02 09:01:28.510534	Y	Virus rules updated
1953	V	2015-08-02 17:01:24.948858	Y	Virus rules updated
1954	V	2015-08-02 21:02:36.810479	Y	Virus rules updated
1955	S	2015-08-03 03:03:32.795844	Y	
1956	R	2015-08-03 03:05:00.865685	Y	0
1957	V	2015-08-03 05:01:17.623214	Y	Virus rules updated
1958	V	2015-08-03 09:01:47.574346	Y	Virus rules updated
1959	V	2015-08-03 17:01:51.637207	Y	Virus rules updated
1960	V	2015-08-03 19:01:18.113735	Y	Virus rules updated
1961	V	2015-08-04 01:01:17.148528	Y	Virus rules updated
1962	S	2015-08-04 03:04:33.394835	Y	
1963	R	2015-08-04 03:05:00.470666	Y	0
1964	V	2015-08-04 09:01:37.004547	Y	Virus rules updated
1965	L	2015-08-04 10:00:47.493968	Y	admin
1966	V	2015-08-04 17:02:05.229927	Y	Virus rules updated
1967	V	2015-08-04 21:01:17.209502	Y	Virus rules updated
1968	V	2015-08-05 01:01:17.97355	Y	Virus rules updated
1969	S	2015-08-05 03:03:27.483814	Y	
1970	R	2015-08-05 03:05:00.422439	Y	0
1971	R	2015-08-06 03:05:00.529035	Y	0
1972	V	2015-08-06 09:01:47.846725	Y	Virus rules updated
1973	V	2015-08-06 17:01:48.532658	Y	Virus rules updated
1974	S	2015-08-07 03:03:39.42315	Y	
1975	R	2015-08-07 03:05:00.208041	Y	0
1976	S	2015-08-08 03:03:40.145995	Y	
1977	R	2015-08-08 03:05:01.003668	Y	0
1978	V	2015-08-08 08:01:18.235216	Y	Virus rules updated
1979	S	2015-08-09 03:03:46.044308	Y	
1980	R	2015-08-09 03:05:00.715401	Y	0
1981	S	2015-08-10 03:03:37.096627	Y	
1982	R	2015-08-10 03:05:01.100399	Y	0
1983	V	2015-08-10 10:01:17.017335	Y	Virus rules updated
1984	V	2015-08-10 11:01:47.853854	Y	Virus rules updated
1985	V	2015-08-10 18:02:21.768768	Y	Virus rules updated
1986	V	2015-08-10 22:02:12.902974	Y	Virus rules updated
1987	V	2015-08-11 02:01:34.767983	Y	Virus rules updated
1988	S	2015-08-11 03:03:32.630635	Y	
1989	R	2015-08-11 03:05:00.387651	Y	0
1990	V	2015-08-11 13:01:36.71372	Y	Virus rules updated
1991	V	2015-08-11 18:01:17.456217	Y	Virus rules updated
1992	S	2015-08-12 03:03:36.267589	Y	
1993	R	2015-08-12 03:05:01.164735	Y	0
1994	V	2015-08-12 05:01:19.582378	Y	Virus rules updated
1995	V	2015-08-12 10:01:26.443427	Y	Virus rules updated
1996	V	2015-08-12 17:01:16.565134	Y	Virus rules updated
1997	V	2015-08-13 01:01:18.746559	Y	Virus rules updated
1998	R	2015-08-13 03:05:01.003879	Y	0
1999	V	2015-08-13 05:01:34.85354	Y	Virus rules updated
2000	V	2015-08-13 08:01:16.815285	Y	Virus rules updated
2001	V	2015-08-13 09:01:17.410974	Y	Virus rules updated
2002	V	2015-08-13 17:01:16.545342	Y	Virus rules updated
2003	V	2015-08-13 21:01:17.259733	Y	Virus rules updated
2004	S	2015-08-14 03:03:36.907234	Y	
2005	R	2015-08-14 03:05:00.87014	Y	0
2006	V	2015-08-14 05:01:17.688176	Y	Virus rules updated
2007	V	2015-08-14 09:01:17.468331	Y	Virus rules updated
2008	V	2015-08-14 17:01:36.685525	Y	Virus rules updated
2009	V	2015-08-15 01:01:18.165431	Y	Virus rules updated
2010	S	2015-08-15 03:03:30.38172	Y	
2011	R	2015-08-15 03:05:00.333049	Y	0
2012	V	2015-08-15 05:01:34.371627	Y	Virus rules updated
2013	V	2015-08-15 13:01:17.233508	Y	Virus rules updated
2014	V	2015-08-15 17:01:17.236187	Y	Virus rules updated
2015	V	2015-08-15 21:01:17.104565	Y	Virus rules updated
2016	S	2015-08-16 03:03:37.602846	Y	
2017	R	2015-08-16 03:05:00.383771	Y	0
2018	V	2015-08-16 06:01:16.522	Y	Virus rules updated
2019	V	2015-08-16 14:01:17.529927	Y	Virus rules updated
2020	V	2015-08-16 17:01:18.177713	Y	Virus rules updated
2021	V	2015-08-16 21:01:17.502231	Y	Virus rules updated
2022	S	2015-08-17 03:03:35.763113	Y	
2023	R	2015-08-17 03:05:00.632364	Y	0
2024	V	2015-08-17 06:01:17.491404	Y	Virus rules updated
2025	V	2015-08-17 10:01:17.965978	Y	Virus rules updated
2026	V	2015-08-17 21:01:17.390587	Y	Virus rules updated
2027	S	2015-08-18 03:03:40.589468	Y	
2028	R	2015-08-18 03:05:00.311004	Y	0
2029	V	2015-08-18 06:01:37.819984	Y	Virus rules updated
2030	V	2015-08-18 10:01:16.372039	Y	Virus rules updated
2031	V	2015-08-18 11:01:16.793098	Y	Virus rules updated
2032	V	2015-08-18 13:01:18.418241	Y	Virus rules updated
2033	V	2015-08-18 17:01:37.113305	Y	Virus rules updated
2034	V	2015-08-18 21:01:17.402897	Y	Virus rules updated
2035	S	2015-08-19 03:03:35.144607	Y	
2036	R	2015-08-19 03:05:01.034753	Y	0
2037	V	2015-08-19 05:04:56.341346	N	freshclam error:  58
2038	V	2015-08-19 06:01:16.009445	Y	Virus rules updated
2039	V	2015-08-19 09:01:16.572208	Y	Virus rules updated
2040	V	2015-08-19 18:01:36.409271	Y	Virus rules updated
2041	V	2015-08-19 21:01:16.555824	Y	Virus rules updated
2042	S	2015-08-20 03:03:35.640454	Y	
2043	R	2015-08-20 03:05:00.373015	Y	0
2044	V	2015-08-20 05:01:17.760396	Y	Virus rules updated
2045	V	2015-08-20 09:01:16.256468	Y	Virus rules updated
2046	V	2015-08-20 11:01:07.766583	Y	Virus rules updated
2047	V	2015-08-20 17:01:17.063407	Y	Virus rules updated
2048	V	2015-08-20 21:01:17.559458	Y	Virus rules updated
2049	S	2015-08-21 03:03:38.171644	Y	
2050	R	2015-08-21 03:05:01.144197	Y	0
2051	V	2015-08-21 05:01:17.907389	Y	Virus rules updated
2052	V	2015-08-21 10:01:35.732987	Y	Virus rules updated
2053	V	2015-08-21 15:01:35.204006	Y	Virus rules updated
2054	V	2015-08-21 16:01:16.642395	Y	Virus rules updated
2055	V	2015-08-21 17:01:17.327711	Y	Virus rules updated
2056	V	2015-08-21 21:01:16.859466	Y	Virus rules updated
2057	S	2015-08-22 03:03:30.121681	Y	
2058	R	2015-08-22 03:05:01.017874	Y	0
2059	V	2015-08-22 06:01:33.456322	Y	Virus rules updated
2060	V	2015-08-22 09:01:16.87518	Y	Virus rules updated
2061	V	2015-08-22 18:01:17.375417	Y	Virus rules updated
2062	V	2015-08-22 21:01:17.063006	Y	Virus rules updated
2063	S	2015-08-23 03:03:37.35031	Y	
2064	R	2015-08-23 03:05:00.347347	Y	0
2065	V	2015-08-23 05:01:46.93032	Y	Virus rules updated
2066	V	2015-08-23 09:01:16.46037	Y	Virus rules updated
2067	V	2015-08-23 17:01:51.605301	Y	Virus rules updated
2068	V	2015-08-23 21:01:19.325293	Y	Virus rules updated
2069	S	2015-08-24 03:03:24.817796	Y	
2070	R	2015-08-24 03:05:00.786559	Y	0
2071	V	2015-08-24 10:01:48.526501	Y	Virus rules updated
2072	V	2015-08-24 13:01:47.747477	Y	Virus rules updated
2073	V	2015-08-24 18:01:16.970093	Y	Virus rules updated
2074	V	2015-08-24 21:01:17.736848	Y	Virus rules updated
2075	S	2015-08-25 03:03:16.705467	Y	
2076	F	2015-08-25 03:03:27.046839	Y	Updates have been retrieved
2077	R	2015-08-25 03:05:00.553121	Y	0
2078	V	2015-08-25 05:01:18.704513	Y	Virus rules updated
2079	V	2015-08-25 13:01:19.5649	Y	Virus rules updated
2080	L	2015-08-25 16:31:37.582821	N	admin
2081	V	2015-08-25 17:01:17.207014	Y	Virus rules updated
2082	L	2015-08-25 18:38:40.997554	Y	admin
2083	V	2015-08-26 01:01:48.700963	Y	Virus rules updated
2084	S	2015-08-26 03:03:28.712517	Y	
2085	R	2015-08-26 03:05:00.776125	Y	0
2086	V	2015-08-26 09:01:36.425478	Y	Virus rules updated
2087	V	2015-08-26 17:01:20.910297	Y	Virus rules updated
2088	V	2015-08-26 18:01:46.324653	Y	Virus rules updated
2089	V	2015-08-26 21:01:17.5278	Y	Virus rules updated
2090	V	2015-08-27 01:01:19.817105	Y	Virus rules updated
2091	S	2015-08-27 03:03:33.952119	Y	
2092	R	2015-08-27 03:05:00.9245	Y	0
2093	V	2015-08-27 07:01:17.234668	Y	Virus rules updated
2094	V	2015-08-27 15:01:48.338087	Y	Virus rules updated
2095	V	2015-08-27 21:01:19.713047	Y	Virus rules updated
2096	V	2015-08-28 01:01:48.040241	Y	Virus rules updated
2097	S	2015-08-28 03:03:30.45161	Y	
2098	R	2015-08-28 03:05:00.192693	Y	0
2099	V	2015-08-28 09:02:17.983191	Y	Virus rules updated
2100	V	2015-08-28 18:01:36.249197	Y	Virus rules updated
2101	V	2015-08-28 22:01:16.961431	Y	Virus rules updated
2102	V	2015-08-29 01:01:18.38088	Y	Virus rules updated
2103	S	2015-08-29 03:03:35.201349	Y	
2104	R	2015-08-29 03:05:01.081657	Y	0
2105	V	2015-08-29 09:01:16.964605	Y	Virus rules updated
2106	V	2015-08-29 12:01:34.337947	Y	Virus rules updated
2107	V	2015-08-29 13:01:31.051096	Y	Virus rules updated
2108	V	2015-08-29 17:01:26.708467	Y	Virus rules updated
2109	V	2015-08-30 01:01:51.484768	Y	Virus rules updated
2110	S	2015-08-30 03:03:29.271467	Y	
2111	R	2015-08-30 03:05:00.888112	Y	0
2112	V	2015-08-30 10:02:06.588549	Y	Virus rules updated
2113	V	2015-08-30 18:01:35.80339	Y	Virus rules updated
2114	V	2015-08-30 22:01:16.55003	Y	Virus rules updated
2115	V	2015-08-31 02:01:47.26857	Y	Virus rules updated
2116	S	2015-08-31 03:03:41.199734	Y	
2117	R	2015-08-31 03:05:00.874955	Y	0
2118	V	2015-08-31 10:01:46.053843	Y	Virus rules updated
2119	V	2015-08-31 14:01:17.417708	Y	Virus rules updated
2120	V	2015-08-31 17:01:46.697634	Y	Virus rules updated
2121	V	2015-08-31 18:01:17.12606	Y	Virus rules updated
2122	V	2015-09-01 02:01:53.304675	Y	Virus rules updated
2123	S	2015-09-01 03:03:31.020226	Y	
2124	R	2015-09-01 03:05:00.663947	Y	0
2125	V	2015-09-01 10:01:32.850306	Y	Virus rules updated
2126	L	2015-09-01 16:47:29.14691	Y	admin
2127	V	2015-09-01 18:01:18.184708	Y	Virus rules updated
2128	V	2015-09-02 02:01:17.147619	Y	Virus rules updated
2129	S	2015-09-02 03:03:34.051285	Y	
2130	R	2015-09-02 03:05:00.966631	Y	0
2131	V	2015-09-02 10:01:16.968433	Y	Virus rules updated
2132	V	2015-09-02 14:01:52.288926	Y	Virus rules updated
2133	V	2015-09-02 18:01:47.766671	Y	Virus rules updated
2134	V	2015-09-03 02:01:16.280637	Y	Virus rules updated
2135	S	2015-09-03 03:03:37.658656	Y	
2136	R	2015-09-03 03:05:00.361552	Y	0
2137	V	2015-09-03 10:01:17.249458	Y	Virus rules updated
2138	L	2015-09-03 16:22:01.260801	Y	admin
2139	V	2015-09-03 18:01:36.311982	Y	Virus rules updated
2140	V	2015-09-04 02:01:17.068514	Y	Virus rules updated
2141	S	2015-09-04 03:03:34.221668	Y	
2142	R	2015-09-04 03:05:00.938593	Y	0
2143	V	2015-09-04 10:01:17.50474	Y	Virus rules updated
2144	V	2015-09-04 18:02:31.298764	Y	Virus rules updated
2145	V	2015-09-05 02:01:17.796309	Y	Virus rules updated
2146	S	2015-09-05 03:03:34.247639	Y	
2147	R	2015-09-05 03:05:01.142717	Y	0
2148	V	2015-09-05 09:01:17.960338	Y	Virus rules updated
2149	V	2015-09-05 18:01:37.530093	Y	Virus rules updated
2150	V	2015-09-06 02:01:58.98973	Y	Virus rules updated
2151	S	2015-09-06 03:03:31.558232	Y	
2152	R	2015-09-06 03:05:00.456116	Y	0
2153	V	2015-09-06 09:01:47.586638	Y	Virus rules updated
2154	V	2015-09-06 13:01:16.583859	Y	Virus rules updated
2155	V	2015-09-06 21:01:18.076379	Y	Virus rules updated
2156	V	2015-09-07 02:01:18.309676	Y	Virus rules updated
2157	S	2015-09-07 03:03:32.56225	Y	
2158	R	2015-09-07 03:05:00.316489	Y	0
2159	V	2015-09-07 09:01:36.455045	Y	Virus rules updated
2160	V	2015-09-07 12:04:56.525138	N	freshclam error:  58
2161	V	2015-09-07 13:01:17.856648	Y	Virus rules updated
2162	V	2015-09-07 17:01:16.154822	Y	Virus rules updated
2163	V	2015-09-08 01:01:34.093964	Y	Virus rules updated
2164	S	2015-09-08 03:03:33.11199	Y	
2165	R	2015-09-08 03:05:01.080349	Y	0
2166	V	2015-09-08 09:02:45.027532	Y	Virus rules updated
2167	L	2015-09-08 13:37:13.552826	Y	admin
2168	L	2015-09-08 13:38:49.084276	N	admin
2169	L	2015-09-08 13:38:52.40634	Y	admin
2170	V	2015-09-08 14:01:17.396048	Y	Virus rules updated
2171	V	2015-09-08 21:01:16.885796	Y	Virus rules updated
2172	V	2015-09-09 01:01:17.176004	Y	Virus rules updated
2173	S	2015-09-09 03:03:37.724811	Y	
2174	R	2015-09-09 03:05:00.700297	Y	0
2175	V	2015-09-09 09:01:18.829723	Y	Virus rules updated
2176	V	2015-09-09 11:01:49.223356	Y	Virus rules updated
2177	V	2015-09-09 18:01:18.494444	Y	Virus rules updated
2178	V	2015-09-10 01:01:17.917396	Y	Virus rules updated
2179	S	2015-09-10 03:03:34.924123	Y	
2180	R	2015-09-10 03:05:00.632546	Y	0
2181	V	2015-09-10 07:01:47.782527	Y	Virus rules updated
2182	V	2015-09-10 09:01:17.092891	Y	Virus rules updated
2183	V	2015-09-10 13:01:18.03583	Y	Virus rules updated
2184	V	2015-09-10 18:01:19.602051	Y	Virus rules updated
2185	V	2015-09-11 01:01:17.411202	Y	Virus rules updated
2186	R	2015-09-11 03:05:00.955547	Y	0
2187	S	2015-09-11 04:29:05.164064	N	Cannot contact server
2188	V	2015-09-11 09:01:17.804495	Y	Virus rules updated
2189	V	2015-09-11 13:02:11.845382	Y	Virus rules updated
2190	V	2015-09-11 17:01:46.588744	Y	Virus rules updated
2191	V	2015-09-12 01:01:18.075055	Y	Virus rules updated
2192	S	2015-09-12 03:03:33.791418	Y	
2193	R	2015-09-12 03:05:00.448352	Y	0
2194	V	2015-09-12 09:01:54.133178	Y	Virus rules updated
2195	V	2015-09-12 17:01:48.582496	Y	Virus rules updated
2196	V	2015-09-13 01:01:16.983111	Y	Virus rules updated
2197	S	2015-09-13 03:03:27.26661	Y	
2198	R	2015-09-13 03:05:01.139641	Y	0
2199	V	2015-09-13 09:01:18.788065	Y	Virus rules updated
2200	V	2015-09-13 13:01:48.144481	Y	Virus rules updated
2201	V	2015-09-13 21:01:17.470523	Y	Virus rules updated
2202	V	2015-09-14 01:01:17.337439	Y	Virus rules updated
2203	S	2015-09-14 03:03:26.567539	Y	
2204	R	2015-09-14 03:05:00.538308	Y	0
2205	V	2015-09-14 10:01:17.597079	Y	Virus rules updated
2206	V	2015-09-14 17:01:17.818019	Y	Virus rules updated
2207	V	2015-09-15 01:01:17.222292	Y	Virus rules updated
2208	S	2015-09-15 03:03:28.000284	Y	
2209	R	2015-09-15 03:05:00.738342	Y	0
2210	V	2015-09-15 09:01:17.511262	Y	Virus rules updated
2211	V	2015-09-15 17:01:49.839439	Y	Virus rules updated
2212	V	2015-09-16 01:02:04.177256	Y	Virus rules updated
2213	S	2015-09-16 03:03:27.77228	Y	
2214	R	2015-09-16 03:05:00.5902	Y	0
2215	V	2015-09-16 09:01:48.567769	Y	Virus rules updated
2216	V	2015-09-16 17:01:19.383583	Y	Virus rules updated
2217	V	2015-09-16 21:01:18.273767	Y	Virus rules updated
2218	V	2015-09-17 01:01:17.277475	Y	Virus rules updated
2219	S	2015-09-17 03:03:31.235921	Y	
2220	R	2015-09-17 03:05:00.257024	Y	0
2221	V	2015-09-17 09:01:47.688217	Y	Virus rules updated
2222	V	2015-09-17 14:01:17.011994	Y	Virus rules updated
2223	V	2015-09-17 18:01:18.062847	Y	Virus rules updated
2224	S	2015-09-18 03:03:28.370712	Y	
2225	R	2015-09-18 03:05:00.233964	Y	0
2226	V	2015-09-18 13:01:50.531206	Y	Virus rules updated
2227	S	2015-09-19 03:03:26.178136	Y	
2228	R	2015-09-19 03:05:01.086459	Y	0
2229	S	2015-09-20 03:03:24.450678	Y	
2230	R	2015-09-20 03:05:00.229295	Y	0
2231	S	2015-09-21 03:03:26.019559	Y	
2232	R	2015-09-21 03:05:00.913968	Y	0
2233	V	2015-09-21 10:01:38.131545	Y	Virus rules updated
2234	V	2015-09-21 11:01:53.863831	Y	Virus rules updated
2235	V	2015-09-21 13:01:51.852862	Y	Virus rules updated
2236	S	2015-09-22 03:03:27.494817	Y	
2237	R	2015-09-22 03:05:00.217002	Y	0
2238	V	2015-09-22 13:01:49.056983	Y	Virus rules updated
2239	L	2015-09-22 14:40:00.317252	Y	admin
2240	S	2015-09-23 03:03:33.04351	Y	
2241	R	2015-09-23 03:05:00.72587	Y	0
2242	V	2015-09-23 05:01:48.578612	Y	Virus rules updated
2243	V	2015-09-23 09:04:56.221307	N	freshclam error:  58
2244	V	2015-09-23 10:04:56.661083	N	freshclam error:  58
2245	S	2015-09-24 03:03:26.376741	Y	
2246	R	2015-09-24 03:05:00.193603	Y	0
2247	V	2015-09-24 11:01:36.3194	Y	Virus rules updated
2248	S	2015-09-25 03:03:28.803162	Y	
2249	R	2015-09-25 03:05:00.830763	Y	0
2250	V	2015-09-25 17:01:17.437309	Y	Virus rules updated
2251	V	2015-09-26 02:01:20.590724	Y	Virus rules updated
2252	S	2015-09-26 03:03:26.898237	Y	
2253	R	2015-09-26 03:05:00.857484	Y	0
2254	V	2015-09-26 10:01:17.06681	Y	Virus rules updated
2255	V	2015-09-26 14:02:17.153356	Y	Virus rules updated
2256	V	2015-09-26 17:01:17.8068	Y	Virus rules updated
2257	V	2015-09-27 01:02:19.200443	Y	Virus rules updated
2258	S	2015-09-27 03:03:36.160276	Y	
2259	R	2015-09-27 03:05:00.197379	Y	0
2260	V	2015-09-27 10:01:17.360544	Y	Virus rules updated
2261	V	2015-09-27 18:01:18.264956	Y	Virus rules updated
2262	V	2015-09-28 01:01:35.272566	Y	Virus rules updated
2263	S	2015-09-28 03:03:45.016801	Y	
2264	R	2015-09-28 03:05:00.993662	Y	0
2265	V	2015-09-28 11:01:17.926244	Y	Virus rules updated
2266	V	2015-09-28 19:01:23.759824	Y	Virus rules updated
2267	V	2015-09-28 23:01:16.95224	Y	Virus rules updated
2268	V	2015-09-29 03:01:16.641991	Y	Virus rules updated
2269	S	2015-09-29 03:03:20.109204	Y	
2270	F	2015-09-29 03:03:25.627737	Y	Updates have been retrieved
2271	R	2015-09-29 03:05:01.115188	Y	0
2272	V	2015-09-29 12:01:40.20191	Y	Virus rules updated
2273	S	2015-09-30 03:03:29.610223	Y	
2274	R	2015-09-30 03:05:00.239752	Y	0
2275	V	2015-09-30 13:02:18.747708	Y	Virus rules updated
2276	L	2015-09-30 18:17:15.435032	Y	admin
2277	R	2015-10-01 03:05:00.395931	Y	0
2278	L	2015-10-01 09:48:13.555873	Y	admin
2279	V	2015-10-01 15:01:38.601243	Y	Virus rules updated
2280	V	2015-10-01 19:01:18.814768	Y	Virus rules updated
2281	S	2015-10-02 03:03:29.224173	Y	
2282	R	2015-10-02 03:05:00.87252	Y	0
2283	V	2015-10-02 09:01:55.183082	Y	Virus rules updated
2284	S	2015-10-03 03:03:25.311963	Y	
2285	R	2015-10-03 03:05:01.087581	Y	0
2286	R	2015-10-04 03:05:00.43661	Y	0
2287	R	2015-10-05 03:05:01.114657	Y	0
2288	L	2015-10-05 08:48:54.620454	Y	admin
2289	V	2015-10-05 09:01:24.816007	Y	Virus rules updated
2290	V	2015-10-05 22:01:35.300866	Y	Virus rules updated
2291	R	2015-10-06 03:05:00.305407	Y	0
2292	V	2015-10-06 12:01:54.915541	Y	Virus rules updated
2293	R	2015-10-07 03:05:00.740035	Y	0
2294	L	2015-10-07 10:56:07.469095	Y	admin
2295	V	2015-10-07 13:01:38.692425	Y	Virus rules updated
2296	R	2015-10-08 03:05:00.295708	Y	0
2297	V	2015-10-08 20:01:19.46603	Y	Virus rules updated
2298	R	2015-10-09 03:05:00.819942	Y	0
2299	V	2015-10-09 09:01:53.767934	Y	Virus rules updated
2300	R	2015-10-10 03:05:00.216508	Y	0
2301	S	2015-10-11 03:03:27.496637	Y	
2302	R	2015-10-11 03:05:00.515177	Y	0
2303	R	2015-10-12 03:05:00.189121	Y	0
2304	V	2015-10-12 07:01:42.237784	Y	Virus rules updated
2305	F	2015-10-13 03:01:23.296089	N	Cannot contact ANY update server
2306	R	2015-10-13 03:05:00.825949	Y	0
2307	V	2015-10-13 09:01:51.354566	Y	Virus rules updated
2308	V	2015-10-13 11:01:19.159658	Y	Virus rules updated
2309	V	2015-10-13 15:01:50.431798	Y	Virus rules updated
2310	V	2015-10-13 21:01:48.060371	Y	Virus rules updated
2311	V	2015-10-14 01:02:30.524757	Y	Virus rules updated
2312	F	2015-10-14 03:01:22.119401	N	Cannot contact ANY update server
2313	R	2015-10-14 03:05:00.685225	Y	0
2314	L	2015-10-14 08:59:19.333448	Y	admin
2315	V	2015-10-14 12:01:18.388223	Y	Virus rules updated
2316	V	2015-10-14 14:01:19.090696	Y	Virus rules updated
2317	V	2015-10-14 17:01:49.67987	Y	Virus rules updated
2318	V	2015-10-15 01:01:20.217071	Y	Virus rules updated
2319	F	2015-10-15 03:01:25.609695	N	Cannot contact ANY update server
2320	R	2015-10-15 03:05:00.815844	Y	0
2321	V	2015-10-15 09:01:20.080368	Y	Virus rules updated
2322	V	2015-10-15 13:02:06.961957	Y	Virus rules updated
2323	V	2015-10-15 17:01:19.590604	Y	Virus rules updated
2324	V	2015-10-16 01:01:17.371171	Y	Virus rules updated
2325	F	2015-10-16 03:01:21.20115	N	Cannot contact ANY update server
2326	R	2015-10-16 03:05:01.120237	Y	0
2327	V	2015-10-16 09:02:12.392547	Y	Virus rules updated
2328	L	2015-10-16 13:09:26.496257	Y	admin
2329	V	2015-10-16 17:01:17.648452	Y	Virus rules updated
2330	V	2015-10-16 21:01:51.093825	Y	Virus rules updated
2331	V	2015-10-17 01:01:17.432468	Y	Virus rules updated
2332	F	2015-10-17 03:01:24.297214	N	Cannot contact ANY update server
2333	R	2015-10-17 03:05:01.05172	Y	0
2334	V	2015-10-17 09:01:17.371554	Y	Virus rules updated
2335	V	2015-10-17 17:02:18.213818	Y	Virus rules updated
2336	V	2015-10-18 01:01:51.333669	Y	Virus rules updated
2337	S	2015-10-18 03:03:22.911726	Y	
2338	F	2015-10-18 03:03:23.734516	N	Cannot contact ANY update server
2339	R	2015-10-18 03:05:00.646079	Y	0
2340	V	2015-10-18 09:01:16.934515	Y	Virus rules updated
2341	V	2015-10-18 17:01:17.98013	Y	Virus rules updated
2342	V	2015-10-18 21:01:19.04803	Y	Virus rules updated
2343	S	2015-10-19 03:03:26.17222	Y	
2344	F	2015-10-19 03:03:26.983667	N	Cannot contact ANY update server
2345	R	2015-10-19 03:05:00.844954	Y	0
2346	V	2015-10-19 05:01:47.815408	Y	Virus rules updated
2347	V	2015-10-19 10:01:17.960255	Y	Virus rules updated
2348	V	2015-10-19 13:01:55.193864	Y	Virus rules updated
2349	V	2015-10-19 16:01:17.731464	Y	Virus rules updated
2350	V	2015-10-19 17:01:19.354147	Y	Virus rules updated
2351	S	2015-10-20 03:03:21.032259	Y	
2352	F	2015-10-20 03:03:21.905603	N	Cannot contact ANY update server
2353	R	2015-10-20 03:05:00.772435	Y	0
2354	V	2015-10-20 10:02:21.928817	Y	Virus rules updated
2355	V	2015-10-20 17:01:19.113069	Y	Virus rules updated
2356	V	2015-10-20 21:01:17.372169	Y	Virus rules updated
2357	V	2015-10-21 01:01:18.071971	Y	Virus rules updated
2358	S	2015-10-21 03:03:30.092875	Y	
2359	R	2015-10-21 03:05:00.819322	Y	0
2360	V	2015-10-21 09:01:17.142829	Y	Virus rules updated
2361	V	2015-10-21 10:01:17.030937	Y	Virus rules updated
2362	V	2015-10-21 13:01:19.668733	Y	Virus rules updated
2363	V	2015-10-21 17:02:07.6595	Y	Virus rules updated
2364	V	2015-10-22 01:01:36.035451	Y	Virus rules updated
2365	S	2015-10-22 03:03:26.363176	Y	
2366	R	2015-10-22 03:05:00.263245	Y	0
2367	V	2015-10-22 09:01:24.796482	Y	Virus rules updated
2368	V	2015-10-22 13:01:19.239326	Y	Virus rules updated
2369	V	2015-10-22 21:01:36.059156	Y	Virus rules updated
2370	S	2015-10-23 03:03:28.976763	Y	
2371	R	2015-10-23 03:05:00.822851	Y	0
2372	V	2015-10-23 05:01:18.3218	Y	Virus rules updated
2373	V	2015-10-23 09:01:36.332653	Y	Virus rules updated
2374	V	2015-10-23 17:02:26.847859	Y	Virus rules updated
2375	S	2015-10-24 03:03:29.927055	Y	
2376	R	2015-10-24 03:05:00.591911	Y	0
2377	V	2015-10-24 05:01:53.373625	Y	Virus rules updated
2378	V	2015-10-24 09:01:18.666286	Y	Virus rules updated
2379	V	2015-10-24 17:01:21.983404	Y	Virus rules updated
2380	V	2015-10-24 21:01:49.135346	Y	Virus rules updated
2381	V	2015-10-25 01:01:18.399572	Y	Virus rules updated
2382	S	2015-10-25 03:03:39.987537	Y	
2383	R	2015-10-25 03:05:00.752812	Y	0
2384	V	2015-10-25 09:01:19.630255	Y	Virus rules updated
2385	V	2015-10-25 17:01:20.624012	Y	Virus rules updated
2386	V	2015-10-25 21:01:17.594086	Y	Virus rules updated
2387	S	2015-10-26 03:03:25.946144	Y	
2388	R	2015-10-26 03:05:00.853133	Y	0
2389	V	2015-10-26 05:01:18.767274	Y	Virus rules updated
2390	V	2015-10-26 09:02:07.852979	Y	Virus rules updated
2391	L	2015-10-26 09:27:09.943075	Y	admin
2392	L	2015-10-26 13:01:44.969727	Y	admin
2393	L	2015-10-26 13:03:15.108776	Y	admin
2394	V	2015-10-26 17:01:18.649984	Y	Virus rules updated
2395	V	2015-10-26 21:01:41.794949	Y	Virus rules updated
2396	V	2015-10-27 01:01:47.003981	Y	Virus rules updated
2397	S	2015-10-27 03:03:25.578201	Y	
2398	R	2015-10-27 03:05:00.393907	Y	0
2399	V	2015-10-27 09:01:36.601147	Y	Virus rules updated
2400	V	2015-10-27 12:01:19.769353	Y	Virus rules updated
2401	V	2015-10-27 13:01:48.43659	Y	Virus rules updated
2402	V	2015-10-27 17:01:18.425994	Y	Virus rules updated
2403	V	2015-10-28 02:01:17.165813	Y	Virus rules updated
2404	S	2015-10-28 03:03:24.142502	Y	
2405	R	2015-10-28 03:05:00.822364	Y	0
2406	V	2015-10-28 05:01:17.145552	Y	Virus rules updated
2407	V	2015-10-28 09:01:37.4985	Y	Virus rules updated
2408	V	2015-10-28 16:01:18.59377	Y	Virus rules updated
2409	V	2015-10-28 18:01:18.167396	Y	Virus rules updated
2410	V	2015-10-29 01:01:17.529422	Y	Virus rules updated
2411	S	2015-10-29 03:03:26.900277	Y	
2412	R	2015-10-29 03:05:00.847622	Y	0
2413	V	2015-10-29 09:01:17.476995	Y	Virus rules updated
2414	V	2015-10-29 12:01:20.829681	Y	Virus rules updated
2415	V	2015-10-29 22:01:18.016137	Y	Virus rules updated
2416	V	2015-10-30 01:01:17.527816	Y	Virus rules updated
2417	S	2015-10-30 03:03:24.852441	Y	
2418	R	2015-10-30 03:05:00.911938	Y	0
2419	V	2015-10-30 09:01:17.561718	Y	Virus rules updated
2420	V	2015-10-30 11:01:08.174838	Y	Virus rules updated
2421	V	2015-10-30 13:01:17.623614	Y	Virus rules updated
2422	S	2015-10-31 03:03:24.191494	Y	
2423	R	2015-10-31 03:05:00.178821	Y	0
2424	S	2015-11-01 03:03:30.03838	Y	
2425	R	2015-11-01 03:05:00.818541	Y	0
2426	V	2015-11-01 12:01:19.030135	Y	Virus rules updated
2427	S	2015-11-02 03:03:25.112006	Y	
2428	R	2015-11-02 03:05:00.994006	Y	0
2429	V	2015-11-02 15:01:07.73241	Y	Virus rules updated
2430	V	2015-11-02 19:01:18.449397	Y	Virus rules updated
2431	V	2015-11-03 03:02:15.033843	Y	Virus rules updated
2432	R	2015-11-03 03:05:00.807077	Y	0
2433	V	2015-11-03 07:01:17.909027	Y	Virus rules updated
2434	V	2015-11-03 11:01:16.680606	Y	Virus rules updated
2435	V	2015-11-03 18:01:19.341794	Y	Virus rules updated
2436	R	2015-11-04 03:05:00.643242	Y	0
2437	R	2015-11-05 03:05:00.474875	Y	0
2438	R	2015-11-06 03:05:01.118732	Y	0
2439	V	2015-11-06 23:02:28.031141	Y	Virus rules updated
2440	V	2015-11-07 03:01:15.996389	Y	Virus rules updated
2441	R	2015-11-07 03:05:00.27531	Y	0
2442	V	2015-11-07 11:01:17.878009	Y	Virus rules updated
2443	V	2015-11-07 19:02:05.12674	Y	Virus rules updated
2444	V	2015-11-08 03:01:14.861366	Y	Virus rules updated
2445	R	2015-11-08 03:05:00.453695	Y	0
2446	V	2015-11-08 11:01:20.755512	Y	Virus rules updated
2447	V	2015-11-08 15:01:19.185009	Y	Virus rules updated
2448	V	2015-11-08 19:01:16.638816	Y	Virus rules updated
2449	V	2015-11-09 03:01:15.649815	Y	Virus rules updated
2450	S	2015-11-09 03:03:26.385262	Y	
2451	R	2015-11-09 03:05:00.232878	Y	0
2452	V	2015-11-09 11:01:18.766424	Y	Virus rules updated
2453	V	2015-11-09 15:01:20.133462	Y	Virus rules updated
2454	S	2015-11-10 03:03:27.130793	Y	
2455	R	2015-11-10 03:05:00.985601	Y	0
2456	V	2015-11-10 13:01:18.533535	Y	Virus rules updated
2457	V	2015-11-10 23:01:17.937433	Y	Virus rules updated
2458	V	2015-11-11 03:01:16.500926	Y	Virus rules updated
2459	S	2015-11-11 03:03:29.235276	Y	
2460	R	2015-11-11 03:05:00.253627	Y	0
2461	V	2015-11-11 11:01:34.209583	Y	Virus rules updated
2462	V	2015-11-11 15:01:18.298496	Y	Virus rules updated
2463	V	2015-11-11 19:01:16.323241	Y	Virus rules updated
2464	V	2015-11-11 23:01:17.169589	Y	Virus rules updated
2465	V	2015-11-12 03:01:14.979632	Y	Virus rules updated
2466	S	2015-11-12 03:03:28.642709	Y	
2467	R	2015-11-12 03:05:00.721615	Y	0
2468	V	2015-11-12 12:01:53.273873	Y	Virus rules updated
2469	V	2015-11-12 13:02:14.520026	Y	Virus rules updated
2470	V	2015-11-12 15:01:37.934818	Y	Virus rules updated
2471	S	2015-11-13 03:03:24.982299	Y	
2472	R	2015-11-13 03:05:00.787701	Y	0
2473	V	2015-11-13 12:01:16.366667	Y	Virus rules updated
2474	S	2015-11-14 03:03:28.38586	Y	
2475	R	2015-11-14 03:05:00.359215	Y	0
2476	S	2015-11-15 03:03:27.880345	Y	
2477	R	2015-11-15 03:05:00.910473	Y	0
2478	S	2015-11-16 03:03:20.629855	Y	
2479	R	2015-11-16 03:05:00.38492	Y	0
2480	V	2015-11-16 09:01:19.094899	Y	Virus rules updated
2481	S	2015-11-17 03:03:27.597939	Y	
2482	R	2015-11-17 03:05:00.245189	Y	0
2483	V	2015-11-17 12:01:19.759454	Y	Virus rules updated
2484	V	2015-11-17 15:01:21.383709	Y	Virus rules updated
2485	V	2015-11-17 19:01:18.041274	Y	Virus rules updated
2486	V	2015-11-18 03:01:14.949925	Y	Virus rules updated
2487	S	2015-11-18 03:03:26.529961	Y	
2488	R	2015-11-18 03:05:00.179495	Y	0
2489	V	2015-11-18 11:01:17.423916	Y	Virus rules updated
2490	V	2015-11-18 15:02:00.027139	Y	Virus rules updated
2491	V	2015-11-18 19:01:17.950899	Y	Virus rules updated
2492	V	2015-11-19 03:01:15.950424	Y	Virus rules updated
2493	S	2015-11-19 03:03:27.066627	Y	
2494	R	2015-11-19 03:05:00.911973	Y	0
2495	V	2015-11-19 11:01:17.153908	Y	Virus rules updated
2496	V	2015-11-19 14:01:19.073402	Y	Virus rules updated
2497	L	2015-11-19 14:53:43.291533	Y	admin
2498	V	2015-11-19 19:02:24.271878	Y	Virus rules updated
2499	V	2015-11-20 03:01:16.892738	Y	Virus rules updated
2500	R	2015-11-20 03:05:01.022373	Y	0
2501	V	2015-11-20 10:01:17.185192	Y	Virus rules updated
2502	V	2015-11-20 14:01:18.207917	Y	Virus rules updated
2503	V	2015-11-20 19:01:17.631807	Y	Virus rules updated
2504	V	2015-11-21 03:01:31.881148	Y	Virus rules updated
2505	S	2015-11-21 03:03:15.579826	Y	
2506	R	2015-11-21 03:05:00.300881	Y	0
2507	V	2015-11-21 06:01:17.839938	Y	Virus rules updated
2508	V	2015-11-21 15:01:17.131572	Y	Virus rules updated
2509	V	2015-11-21 19:01:50.416574	Y	Virus rules updated
2510	V	2015-11-22 03:02:39.3186	Y	Virus rules updated
2511	S	2015-11-22 03:04:23.711194	Y	
2512	R	2015-11-22 03:05:00.879401	Y	0
2513	V	2015-11-22 11:01:17.201489	Y	Virus rules updated
2514	V	2015-11-22 15:01:18.760596	Y	Virus rules updated
2515	V	2015-11-22 19:01:17.979986	Y	Virus rules updated
2516	V	2015-11-23 03:01:32.815283	Y	Virus rules updated
2517	S	2015-11-23 03:03:14.75948	Y	
2518	R	2015-11-23 03:05:01.022162	Y	0
2519	V	2015-11-23 11:01:17.872271	Y	Virus rules updated
2520	V	2015-11-23 15:01:21.601228	Y	Virus rules updated
2521	V	2015-11-23 19:01:18.184492	Y	Virus rules updated
2522	V	2015-11-24 02:01:17.69384	Y	Virus rules updated
2523	S	2015-11-24 03:03:22.43435	Y	
2524	R	2015-11-24 03:05:00.200083	Y	0
2525	V	2015-11-24 10:01:18.184414	Y	Virus rules updated
2526	V	2015-11-24 15:01:19.8567	Y	Virus rules updated
2527	V	2015-11-24 19:01:19.891269	Y	Virus rules updated
2528	V	2015-11-25 02:01:16.575148	Y	Virus rules updated
2529	R	2015-11-25 03:05:00.895603	Y	0
2530	V	2015-11-25 11:01:49.17959	Y	Virus rules updated
2531	V	2015-11-25 15:02:10.37409	Y	Virus rules updated
2532	V	2015-11-25 19:01:18.749108	Y	Virus rules updated
2533	V	2015-11-26 02:01:17.301131	Y	Virus rules updated
2534	S	2015-11-26 03:03:47.21725	Y	
2535	R	2015-11-26 03:05:00.979409	Y	0
2536	V	2015-11-26 10:02:00.339743	Y	Virus rules updated
2537	V	2015-11-26 14:01:18.269651	Y	Virus rules updated
2538	V	2015-11-26 18:01:18.205546	Y	Virus rules updated
2539	V	2015-11-27 02:01:38.373635	Y	Virus rules updated
2540	S	2015-11-27 03:03:25.274185	Y	
2541	R	2015-11-27 03:05:01.162114	Y	0
2542	V	2015-11-27 10:01:17.054539	Y	Virus rules updated
2543	V	2015-11-27 14:01:18.021255	Y	Virus rules updated
2544	V	2015-11-27 18:01:17.650021	Y	Virus rules updated
2545	V	2015-11-28 02:01:37.047097	Y	Virus rules updated
2546	S	2015-11-28 03:03:25.222199	Y	
2547	R	2015-11-28 03:05:01.119158	Y	0
2548	V	2015-11-28 11:01:18.337651	Y	Virus rules updated
2549	V	2015-11-28 15:01:18.528702	Y	Virus rules updated
2550	V	2015-11-28 19:01:17.873293	Y	Virus rules updated
2551	V	2015-11-29 03:01:16.103755	Y	Virus rules updated
2552	S	2015-11-29 03:03:23.547384	Y	
2553	R	2015-11-29 03:05:00.508087	Y	0
2554	V	2015-11-29 10:01:16.50291	Y	Virus rules updated
2555	V	2015-11-29 15:02:52.007985	Y	Virus rules updated
2556	V	2015-11-29 19:01:17.425119	Y	Virus rules updated
2557	V	2015-11-30 03:01:15.560087	Y	Virus rules updated
2558	R	2015-11-30 03:05:00.325944	Y	0
2559	V	2015-11-30 10:01:17.737232	Y	Virus rules updated
2560	L	2015-11-30 12:23:03.303028	N	
2561	L	2015-11-30 12:23:21.530511	Y	admin
2562	L	2015-11-30 12:24:38.486028	Y	admin
2563	V	2015-11-30 14:01:19.46922	Y	Virus rules updated
2564	V	2015-11-30 17:01:39.647161	Y	Virus rules updated
2565	V	2015-12-01 03:01:15.841536	Y	Virus rules updated
2566	S	2015-12-01 03:03:20.939437	Y	
2567	R	2015-12-01 03:05:00.824125	Y	0
2568	V	2015-12-01 10:01:20.07094	Y	Virus rules updated
2569	V	2015-12-01 14:01:17.159615	Y	Virus rules updated
2570	L	2015-12-01 16:47:14.700502	Y	admin
2571	V	2015-12-01 18:01:39.394499	Y	Virus rules updated
2572	V	2015-12-02 02:01:48.343437	Y	Virus rules updated
2573	S	2015-12-02 03:03:24.842546	Y	
2574	R	2015-12-02 03:05:00.89516	Y	0
2575	V	2015-12-02 10:02:08.522111	Y	Virus rules updated
2576	V	2015-12-02 14:01:18.09588	Y	Virus rules updated
2577	V	2015-12-02 18:01:17.582921	Y	Virus rules updated
2578	V	2015-12-03 02:01:19.592071	Y	Virus rules updated
2579	S	2015-12-03 03:03:36.150733	Y	
2580	R	2015-12-03 03:05:00.836323	Y	0
2581	V	2015-12-03 10:02:22.23465	Y	Virus rules updated
2582	V	2015-12-03 14:01:19.561042	Y	Virus rules updated
2583	V	2015-12-03 18:02:04.322069	Y	Virus rules updated
2584	V	2015-12-04 02:01:16.702783	Y	Virus rules updated
2585	S	2015-12-04 03:03:27.180954	Y	
2586	R	2015-12-04 03:05:00.238071	Y	0
2587	V	2015-12-04 11:01:37.691289	Y	Virus rules updated
2588	V	2015-12-04 14:01:18.498785	Y	Virus rules updated
2589	V	2015-12-04 18:01:20.707335	Y	Virus rules updated
2590	R	2015-12-05 03:05:00.653704	Y	0
2591	R	2015-12-06 03:05:01.066006	Y	0
2592	R	2015-12-07 03:05:00.307138	Y	0
2593	V	2015-12-07 14:01:17.746903	Y	Virus rules updated
2594	V	2015-12-07 15:02:03.170051	Y	Virus rules updated
2595	V	2015-12-07 18:01:19.04874	Y	Virus rules updated
2596	V	2015-12-08 02:01:18.480795	Y	Virus rules updated
2597	R	2015-12-08 03:05:00.908982	Y	0
2598	V	2015-12-08 10:01:17.40301	Y	Virus rules updated
2599	V	2015-12-08 14:02:07.752681	Y	Virus rules updated
2600	V	2015-12-08 18:01:17.759657	Y	Virus rules updated
2601	V	2015-12-09 03:01:16.423824	Y	Virus rules updated
2602	R	2015-12-09 03:05:00.723116	Y	0
2603	V	2015-12-09 10:01:19.9026	Y	Virus rules updated
2604	V	2015-12-09 14:01:18.323555	Y	Virus rules updated
2605	V	2015-12-09 18:01:18.363498	Y	Virus rules updated
2606	V	2015-12-10 02:01:49.529974	Y	Virus rules updated
2607	R	2015-12-10 03:05:00.754362	Y	0
2608	V	2015-12-10 10:01:18.16621	Y	Virus rules updated
2609	V	2015-12-10 14:01:17.150407	Y	Virus rules updated
2610	V	2015-12-10 18:01:18.137581	Y	Virus rules updated
2611	V	2015-12-11 03:01:34.202103	Y	Virus rules updated
2612	R	2015-12-11 03:05:01.141487	Y	0
2613	V	2015-12-11 19:01:17.908609	Y	Virus rules updated
2614	V	2015-12-11 20:04:56.039258	N	freshclam error:  58
2615	V	2015-12-12 03:01:16.827275	Y	Virus rules updated
2616	R	2015-12-12 03:05:00.803007	Y	0
2617	V	2015-12-12 11:01:47.654115	Y	Virus rules updated
2618	V	2015-12-12 14:01:18.528939	Y	Virus rules updated
2619	V	2015-12-12 18:01:18.679136	Y	Virus rules updated
2620	V	2015-12-13 02:01:19.084788	Y	Virus rules updated
2621	R	2015-12-13 03:05:00.862456	Y	0
2622	V	2015-12-13 10:01:17.525683	Y	Virus rules updated
2623	V	2015-12-13 14:01:18.898539	Y	Virus rules updated
2624	V	2015-12-13 18:01:50.067464	Y	Virus rules updated
2625	V	2015-12-14 02:01:38.417755	Y	Virus rules updated
2626	R	2015-12-14 03:05:00.730337	Y	0
2627	V	2015-12-14 10:01:17.329483	Y	Virus rules updated
2628	V	2015-12-14 14:01:19.060316	Y	Virus rules updated
2629	V	2015-12-14 19:01:48.019489	Y	Virus rules updated
2630	V	2015-12-15 02:01:48.637166	Y	Virus rules updated
2631	R	2015-12-15 03:05:00.248509	Y	0
2632	V	2015-12-15 10:01:17.00442	Y	Virus rules updated
2633	V	2015-12-15 14:01:17.529553	Y	Virus rules updated
2634	V	2015-12-15 19:01:39.763333	Y	Virus rules updated
2635	V	2015-12-16 02:01:19.479763	Y	Virus rules updated
2636	R	2015-12-16 03:05:00.320567	Y	0
2637	V	2015-12-16 06:01:18.766791	Y	Virus rules updated
2638	V	2015-12-16 11:01:17.767933	Y	Virus rules updated
2639	V	2015-12-16 15:01:17.563684	Y	Virus rules updated
2640	V	2015-12-16 18:01:39.415081	Y	Virus rules updated
2641	V	2015-12-16 19:01:18.415801	Y	Virus rules updated
2642	V	2015-12-17 02:01:18.348992	Y	Virus rules updated
2643	R	2015-12-17 03:05:00.652389	Y	0
2644	V	2015-12-17 07:01:18.708926	Y	Virus rules updated
2645	V	2015-12-17 12:01:18.660693	Y	Virus rules updated
2646	V	2015-12-17 15:01:17.312275	Y	Virus rules updated
2647	V	2015-12-17 19:01:43.879293	Y	Virus rules updated
2648	F	2015-12-18 03:01:28.940197	Y	Updates have been retrieved
2649	R	2015-12-18 03:05:01.195453	Y	0
2650	R	2015-12-19 03:05:00.60898	Y	0
2651	V	2015-12-19 11:01:17.728511	Y	Virus rules updated
2652	S	2015-12-20 03:03:29.900509	Y	
2653	R	2015-12-20 03:05:00.645282	Y	0
2654	V	2015-12-21 00:04:18.715398	N	freshclam error:  58
2655	S	2015-12-21 03:03:29.985948	Y	
2656	R	2015-12-21 03:05:01.035822	Y	0
2657	V	2015-12-21 19:01:20.43253	Y	Virus rules updated
2658	V	2015-12-22 03:01:48.018248	Y	Virus rules updated
2659	R	2015-12-22 03:05:00.262006	Y	0
2660	V	2015-12-22 11:02:19.63003	Y	Virus rules updated
2661	V	2015-12-22 13:01:40.896517	Y	Virus rules updated
2662	L	2015-12-22 13:09:18.121357	N	admin
2663	L	2015-12-22 13:09:45.995682	Y	admin
2664	V	2015-12-22 19:06:16.824803	N	freshclam error:  58
2665	V	2015-12-22 20:06:22.704119	N	freshclam error:  58
2666	V	2015-12-22 21:06:22.545456	N	freshclam error:  58
2667	V	2015-12-22 22:06:22.664636	N	freshclam error:  58
2668	V	2015-12-22 23:06:21.924772	N	freshclam error:  58
2669	V	2015-12-23 00:06:22.599585	N	freshclam error:  58
2670	V	2015-12-23 01:06:22.324244	N	freshclam error:  58
2671	V	2015-12-23 02:06:22.745365	N	freshclam error:  58
2672	R	2015-12-23 03:05:00.621975	Y	0
2673	V	2015-12-23 03:06:24.059502	N	freshclam error:  58
2674	S	2015-12-23 03:07:57.227063	N	Cannot contact server
2675	F	2015-12-23 03:08:12.751588	N	Cannot contact ANY update server
2676	V	2015-12-23 04:06:21.954116	N	freshclam error:  58
2677	V	2015-12-23 05:06:22.809119	N	freshclam error:  58
2678	V	2015-12-23 06:06:22.330116	N	freshclam error:  58
2679	V	2015-12-23 07:06:21.923944	N	freshclam error:  58
2680	V	2015-12-23 08:06:22.469584	N	freshclam error:  58
2681	V	2015-12-23 09:06:21.864215	N	freshclam error:  58
2682	V	2015-12-23 10:06:22.554024	N	freshclam error:  58
2683	V	2015-12-23 11:06:26.089072	N	freshclam error:  58
2684	V	2015-12-23 12:06:22.389189	N	freshclam error:  58
2685	V	2015-12-23 13:06:21.87459	N	freshclam error:  58
2686	V	2015-12-23 14:06:22.79933	N	freshclam error:  58
2687	V	2015-12-23 15:06:26.025578	N	freshclam error:  58
2688	V	2015-12-23 16:06:26.130436	N	freshclam error:  58
2689	V	2015-12-23 17:04:48.175848	Y	Virus rules updated
2690	V	2015-12-23 19:01:42.476222	Y	Virus rules updated
2691	V	2015-12-24 03:01:17.796933	Y	Virus rules updated
2692	R	2015-12-24 03:05:00.238616	Y	0
2693	V	2015-12-24 11:01:18.273669	Y	Virus rules updated
2694	V	2015-12-24 15:01:17.452464	Y	Virus rules updated
2695	V	2015-12-24 19:01:18.081222	Y	Virus rules updated
2696	V	2015-12-25 02:01:18.474892	Y	Virus rules updated
2697	R	2015-12-25 03:05:01.161165	Y	0
2698	V	2015-12-26 02:01:18.97312	Y	Virus rules updated
2699	R	2015-12-26 03:05:00.745465	Y	0
2700	V	2015-12-26 10:01:17.192876	Y	Virus rules updated
2701	V	2015-12-26 14:01:18.784153	Y	Virus rules updated
2702	V	2015-12-26 18:01:51.757479	Y	Virus rules updated
2703	V	2015-12-27 03:01:36.473361	Y	Virus rules updated
2704	R	2015-12-27 03:05:00.435982	Y	0
2705	V	2015-12-27 10:01:18.381551	Y	Virus rules updated
2706	V	2015-12-27 14:01:18.129339	Y	Virus rules updated
2707	V	2015-12-27 18:01:18.384949	Y	Virus rules updated
2708	V	2015-12-28 02:01:17.870647	Y	Virus rules updated
2709	R	2015-12-28 03:05:00.794025	Y	0
2710	V	2015-12-28 10:01:18.286393	Y	Virus rules updated
2711	V	2015-12-28 14:01:17.881177	Y	Virus rules updated
2712	V	2015-12-28 18:02:40.071003	Y	Virus rules updated
2713	V	2015-12-29 03:01:15.84798	Y	Virus rules updated
2714	R	2015-12-29 03:05:00.427536	Y	0
2715	V	2015-12-29 10:01:17.315975	Y	Virus rules updated
2716	V	2015-12-30 02:01:50.101437	Y	Virus rules updated
2717	R	2015-12-30 03:05:00.629578	Y	0
2718	V	2015-12-30 10:01:48.890933	Y	Virus rules updated
2719	V	2015-12-30 14:01:43.058432	Y	Virus rules updated
2720	V	2015-12-30 18:01:39.06448	Y	Virus rules updated
2721	V	2015-12-31 03:01:17.411668	Y	Virus rules updated
2722	R	2015-12-31 03:05:00.5921	Y	0
2723	V	2015-12-31 11:01:19.093499	Y	Virus rules updated
2724	V	2015-12-31 14:01:19.061694	Y	Virus rules updated
2725	V	2015-12-31 19:01:48.309393	Y	Virus rules updated
2726	V	2016-01-01 03:01:37.480944	Y	Virus rules updated
2727	R	2016-01-01 03:05:00.898762	Y	0
2728	V	2016-01-01 11:01:50.107494	Y	Virus rules updated
2729	V	2016-01-01 15:01:16.901344	Y	Virus rules updated
2730	V	2016-01-01 19:01:21.584573	Y	Virus rules updated
2731	V	2016-01-02 03:01:37.571102	Y	Virus rules updated
2732	R	2016-01-02 03:05:00.398262	Y	0
2733	V	2016-01-02 11:02:17.485612	Y	Virus rules updated
2734	V	2016-01-02 15:01:18.757043	Y	Virus rules updated
2735	V	2016-01-02 19:01:58.270475	Y	Virus rules updated
2736	R	2016-01-03 03:05:01.077748	Y	0
2737	V	2016-01-04 03:02:07.476394	Y	Virus rules updated
2738	R	2016-01-04 03:05:00.34269	Y	0
2739	V	2016-01-04 11:01:18.853037	Y	Virus rules updated
2740	V	2016-01-04 14:01:18.616602	Y	Virus rules updated
2741	V	2016-01-04 18:01:19.440349	Y	Virus rules updated
2742	V	2016-01-05 02:01:41.825873	Y	Virus rules updated
2743	R	2016-01-05 03:05:00.295132	Y	0
2744	V	2016-01-05 07:01:18.291106	Y	Virus rules updated
2745	V	2016-01-05 14:01:18.206309	Y	Virus rules updated
2746	R	2016-01-06 03:05:00.80932	Y	0
2747	V	2016-01-06 11:27:08.46097	Y	Virus rules updated
2748	V	2016-01-06 17:01:20.318062	Y	Virus rules updated
2749	V	2016-01-07 03:01:37.951745	Y	Virus rules updated
2750	R	2016-01-07 03:05:00.815345	Y	0
2751	V	2016-01-07 06:01:47.284324	Y	Virus rules updated
2752	V	2016-01-07 15:01:19.659572	Y	Virus rules updated
2753	V	2016-01-07 19:01:17.782675	Y	Virus rules updated
2754	V	2016-01-08 02:04:56.279594	N	freshclam error:  58
2755	V	2016-01-08 03:01:16.315656	Y	Virus rules updated
2756	R	2016-01-08 03:05:00.947957	Y	0
2757	V	2016-01-08 10:01:18.643082	Y	Virus rules updated
2758	V	2016-01-08 12:01:18.203694	Y	Virus rules updated
2759	V	2016-01-08 14:01:18.35982	Y	Virus rules updated
2760	V	2016-01-08 18:01:20.693912	Y	Virus rules updated
2761	V	2016-01-09 02:01:38.928201	Y	Virus rules updated
2762	R	2016-01-09 03:05:00.659431	Y	0
2763	V	2016-01-09 06:01:18.340052	Y	Virus rules updated
2764	V	2016-01-09 14:01:51.560792	Y	Virus rules updated
2765	V	2016-01-09 18:01:19.033079	Y	Virus rules updated
2766	V	2016-01-10 02:01:18.974131	Y	Virus rules updated
2767	R	2016-01-10 03:05:00.489612	Y	0
2768	R	2016-01-11 03:05:00.436164	Y	0
2769	L	2016-01-11 08:10:33.409899	Y	admin
2770	V	2016-01-11 18:01:18.925	Y	Virus rules updated
2771	V	2016-01-12 02:01:17.365379	Y	Virus rules updated
2772	R	2016-01-12 03:05:01.004692	Y	0
2773	V	2016-01-12 06:01:19.184328	Y	Virus rules updated
2774	L	2016-01-12 08:05:39.251155	Y	admin
2775	V	2016-01-12 13:01:42.756527	Y	Virus rules updated
2776	V	2016-01-12 14:01:51.789926	Y	Virus rules updated
2777	V	2016-01-12 15:01:19.340234	Y	Virus rules updated
2778	V	2016-01-12 19:01:19.582129	Y	Virus rules updated
2779	V	2016-01-13 03:01:39.496725	Y	Virus rules updated
2780	R	2016-01-13 03:05:00.938735	Y	0
2781	V	2016-01-13 06:01:48.565607	Y	Virus rules updated
2782	L	2016-01-13 13:32:32.57107	Y	admin
2783	V	2016-01-13 14:06:26.772168	N	freshclam error:  58
2784	V	2016-01-13 15:06:25.902693	N	freshclam error:  58
2785	V	2016-01-13 16:06:26.222247	N	freshclam error:  58
2786	V	2016-01-13 17:06:26.197614	N	freshclam error:  58
2787	V	2016-01-13 18:13:16.757335	N	freshclam error:  52
2788	L	2016-01-13 18:25:32.644091	Y	admin
2789	V	2016-01-13 19:11:41.664312	Y	Virus rules updated
2790	L	2016-01-13 21:59:06.483255	N	mmora
2791	L	2016-01-13 22:03:24.221165	N	mmora
2792	R	2016-01-14 03:05:01.026094	Y	0
2793	L	2016-01-14 08:16:55.227382	N	varmijo@14demarzo.fin.ec
2794	L	2016-01-14 08:17:15.68079	N	varmijo
2795	L	2016-01-14 10:18:46.301179	N	wcacpata
2796	L	2016-01-14 10:18:57.9641	N	wcacpata
2797	L	2016-01-14 10:19:04.203607	N	wcacpata
2798	V	2016-01-14 14:02:09.085996	Y	Virus rules updated
2799	L	2016-01-14 19:52:08.076378	N	rvanessa@14demarzo.fin.ec
2800	L	2016-01-14 19:52:25.657522	N	rvanessa@14demarzo.fin.ec
2801	L	2016-01-14 19:52:50.656634	N	rvanessa@14demarzo.fin.ec
2802	L	2016-01-14 19:53:23.168884	N	vane1103
2803	L	2016-01-14 19:54:02.081475	N	rvanessa@14demarzo.fin.ec
2804	L	2016-01-14 20:58:07.485101	N	varmijo
2805	L	2016-01-14 20:58:39.024383	N	varmijo@14demarzo.fin.ec
2806	L	2016-01-14 23:28:29.217428	Y	admin
2807	V	2016-01-15 03:01:17.107963	Y	Virus rules updated
2808	R	2016-01-15 03:05:00.382886	Y	0
2809	V	2016-01-15 06:01:18.161739	Y	Virus rules updated
2810	V	2016-01-15 07:01:18.356939	Y	Virus rules updated
2811	V	2016-01-15 15:01:18.754157	Y	Virus rules updated
2812	V	2016-01-15 19:13:16.938281	N	freshclam error:  52
2813	V	2016-01-15 20:10:16.925109	N	freshclam error:  52
2814	V	2016-01-15 21:10:18.727886	N	freshclam error:  52
2815	V	2016-01-15 22:11:17.372683	N	freshclam error:  52
2816	V	2016-01-15 23:13:19.289237	N	freshclam error:  52
2817	V	2016-01-16 00:10:17.992599	N	freshclam error:  52
2818	V	2016-01-16 01:13:17.277828	N	freshclam error:  52
2819	V	2016-01-16 02:12:17.408221	N	freshclam error:  52
2820	S	2016-01-16 03:03:40.931395	N	Cannot contact server
2821	F	2016-01-16 03:04:56.441331	N	Cannot contact ANY update server
2822	R	2016-01-16 03:05:01.150167	Y	0
2823	V	2016-01-16 03:08:47.822965	N	freshclam error:  52
2824	V	2016-01-16 04:08:47.017463	N	freshclam error:  52
2825	V	2016-01-16 05:13:17.311198	N	freshclam error:  52
2826	V	2016-01-16 06:13:17.628924	N	freshclam error:  52
2827	V	2016-01-16 07:10:17.612607	N	freshclam error:  52
2828	V	2016-01-16 08:10:17.342809	N	freshclam error:  52
2829	V	2016-01-16 09:13:17.573891	N	freshclam error:  52
2830	V	2016-01-16 10:13:17.584164	N	freshclam error:  52
2831	V	2016-01-16 11:13:17.504165	N	freshclam error:  52
2832	V	2016-01-16 12:13:17.762148	N	freshclam error:  52
2833	V	2016-01-16 13:13:17.827566	N	freshclam error:  52
2834	V	2016-01-16 14:13:17.377288	N	freshclam error:  52
2835	V	2016-01-16 15:13:17.528442	N	freshclam error:  52
2836	V	2016-01-16 16:16:17.598605	N	freshclam error:  52
2837	V	2016-01-16 17:13:17.404148	N	freshclam error:  52
2838	V	2016-01-16 18:10:18.228437	N	freshclam error:  52
2839	V	2016-01-16 19:13:18.932759	N	freshclam error:  52
2840	V	2016-01-16 20:10:16.747604	N	freshclam error:  52
2841	V	2016-01-16 21:13:17.03792	N	freshclam error:  52
2842	V	2016-01-16 22:10:17.017627	N	freshclam error:  52
2843	V	2016-01-16 23:10:16.809858	N	freshclam error:  52
2844	V	2016-01-17 00:13:17.624266	N	freshclam error:  52
2845	V	2016-01-17 01:10:17.677598	N	freshclam error:  52
2846	V	2016-01-17 02:13:17.914214	N	freshclam error:  52
2847	R	2016-01-17 03:05:01.077389	Y	0
2848	S	2016-01-17 03:07:28.306094	N	Cannot contact server
2849	F	2016-01-17 03:08:43.822264	N	Cannot contact ANY update server
2850	V	2016-01-17 03:16:18.053171	N	freshclam error:  52
2851	V	2016-01-17 04:13:17.428306	N	freshclam error:  52
2852	V	2016-01-17 05:13:17.148424	N	freshclam error:  52
2853	V	2016-01-17 06:13:16.894421	N	freshclam error:  52
2854	V	2016-01-17 07:10:16.523106	N	freshclam error:  52
2855	V	2016-01-17 08:13:17.653867	N	freshclam error:  52
2856	V	2016-01-17 09:10:18.012683	N	freshclam error:  52
2857	V	2016-01-17 10:10:16.423528	N	freshclam error:  52
2858	V	2016-01-17 11:10:17.163009	N	freshclam error:  52
2859	V	2016-01-17 12:10:16.633315	N	freshclam error:  52
2860	V	2016-01-17 13:13:17.327504	N	freshclam error:  52
2861	V	2016-01-17 14:13:16.517455	N	freshclam error:  52
2862	V	2016-01-17 15:13:17.198285	N	freshclam error:  52
2863	V	2016-01-17 16:17:16.977907	N	freshclam error:  52
2864	V	2016-01-17 17:13:16.623869	N	freshclam error:  52
2865	V	2016-01-17 18:10:17.069673	N	freshclam error:  52
2866	V	2016-01-17 19:15:16.707725	N	freshclam error:  52
2867	V	2016-01-17 20:13:16.298422	N	freshclam error:  52
2868	V	2016-01-17 21:13:16.60819	N	freshclam error:  52
2869	V	2016-01-17 22:15:17.202658	N	freshclam error:  52
2870	V	2016-01-17 23:17:47.342765	N	freshclam error:  52
2871	V	2016-01-18 00:13:17.649552	N	freshclam error:  52
2872	V	2016-01-18 01:13:18.028549	N	freshclam error:  52
2873	V	2016-01-18 02:10:17.657598	N	freshclam error:  52
2874	R	2016-01-18 03:05:00.518595	Y	0
2875	S	2016-01-18 03:07:28.166226	N	Cannot contact server
2876	F	2016-01-18 03:08:43.665793	N	Cannot contact ANY update server
2877	V	2016-01-18 03:17:48.224497	N	freshclam error:  52
2878	V	2016-01-18 04:10:18.007857	N	freshclam error:  52
2879	V	2016-01-18 05:10:18.228181	N	freshclam error:  52
2880	V	2016-01-18 06:17:48.028584	N	freshclam error:  52
2881	V	2016-01-18 07:17:48.539677	N	freshclam error:  52
2882	V	2016-01-18 08:11:47.593726	N	freshclam error:  52
2883	V	2016-01-18 09:13:18.15298	N	freshclam error:  52
2884	V	2016-01-18 10:10:16.937539	N	freshclam error:  52
2885	V	2016-01-18 11:15:16.847474	N	freshclam error:  52
2886	V	2016-01-18 12:13:17.237527	N	freshclam error:  52
2887	V	2016-01-18 13:15:16.992301	N	freshclam error:  52
2888	V	2016-01-18 14:11:46.948452	N	freshclam error:  52
2889	V	2016-01-18 15:16:17.118165	N	freshclam error:  52
2890	V	2016-01-18 16:13:17.042657	N	freshclam error:  52
2891	V	2016-01-18 17:13:17.287423	N	freshclam error:  52
2892	V	2016-01-18 18:10:17.212677	N	freshclam error:  52
2893	V	2016-01-18 19:10:16.808352	N	freshclam error:  52
2894	V	2016-01-18 20:10:16.832674	N	freshclam error:  52
2895	V	2016-01-18 21:10:19.372814	N	freshclam error:  52
2896	V	2016-01-18 22:10:18.977488	N	freshclam error:  52
2897	V	2016-01-18 23:10:17.198057	N	freshclam error:  52
2898	V	2016-01-19 00:17:49.274367	N	freshclam error:  52
2899	V	2016-01-19 01:15:17.882489	N	freshclam error:  52
2900	V	2016-01-19 02:13:17.78251	N	freshclam error:  52
2901	R	2016-01-19 03:05:01.084983	Y	0
2902	S	2016-01-19 03:07:29.150982	N	Cannot contact server
2903	F	2016-01-19 03:08:44.670703	N	Cannot contact ANY update server
2904	V	2016-01-19 03:13:18.673244	N	freshclam error:  52
2905	V	2016-01-19 04:13:18.358205	N	freshclam error:  52
2906	V	2016-01-19 05:10:17.586886	N	freshclam error:  52
2907	V	2016-01-19 06:14:17.318588	N	freshclam error:  52
2908	V	2016-01-19 07:11:46.822529	N	freshclam error:  52
2909	V	2016-01-19 08:13:16.763469	N	freshclam error:  52
2910	V	2016-01-19 09:10:16.547871	N	freshclam error:  52
2911	V	2016-01-19 10:15:17.039329	N	freshclam error:  52
2912	V	2016-01-19 11:13:16.822689	N	freshclam error:  52
2913	V	2016-01-19 12:13:16.632349	N	freshclam error:  52
2914	V	2016-01-19 13:15:17.542654	N	freshclam error:  52
2915	V	2016-01-19 14:13:16.627707	N	freshclam error:  52
2916	V	2016-01-19 15:10:16.495463	N	freshclam error:  52
2917	V	2016-01-19 16:14:46.677365	N	freshclam error:  52
2918	V	2016-01-19 17:13:17.267359	N	freshclam error:  52
2919	V	2016-01-19 18:16:17.072835	N	freshclam error:  52
2920	V	2016-01-19 19:10:18.807337	N	freshclam error:  52
2921	V	2016-01-19 20:13:18.908043	N	freshclam error:  52
2922	V	2016-01-19 21:17:17.239418	N	freshclam error:  52
2923	V	2016-01-19 22:10:17.109655	N	freshclam error:  52
2924	V	2016-01-19 23:16:16.803001	N	freshclam error:  52
2925	V	2016-01-20 00:15:18.637554	N	freshclam error:  52
2926	V	2016-01-20 01:16:18.257612	N	freshclam error:  52
2927	V	2016-01-20 02:10:17.78235	N	freshclam error:  52
2928	R	2016-01-20 03:05:00.728375	Y	0
2929	S	2016-01-20 03:07:28.076212	N	Cannot contact server
2930	F	2016-01-20 03:08:43.585838	N	Cannot contact ANY update server
2931	V	2016-01-20 03:13:17.373429	N	freshclam error:  52
2932	V	2016-01-20 04:10:18.157653	N	freshclam error:  52
2933	V	2016-01-20 05:13:17.748021	N	freshclam error:  52
2934	V	2016-01-20 06:10:17.952459	N	freshclam error:  52
2935	V	2016-01-20 07:10:17.347695	N	freshclam error:  52
2936	V	2016-01-20 08:20:17.93287	N	freshclam error:  52
2937	V	2016-01-20 09:10:17.389309	N	freshclam error:  52
2938	V	2016-01-20 10:14:17.337492	N	freshclam error:  52
2939	V	2016-01-20 11:17:17.602736	N	freshclam error:  52
2940	V	2016-01-20 12:17:47.488828	N	freshclam error:  52
2941	V	2016-01-20 13:10:16.918357	N	freshclam error:  52
2942	V	2016-01-20 14:19:47.857751	N	freshclam error:  52
2943	V	2016-01-20 15:15:17.263949	N	freshclam error:  52
2944	V	2016-01-20 16:19:47.458065	N	freshclam error:  52
2945	V	2016-01-20 17:15:16.587305	N	freshclam error:  52
2946	V	2016-01-20 18:17:46.589183	N	freshclam error:  52
2947	V	2016-01-20 19:11:46.412664	N	freshclam error:  52
2948	V	2016-01-20 20:13:16.763358	N	freshclam error:  52
2949	V	2016-01-20 21:10:16.432759	N	freshclam error:  52
2950	V	2016-01-20 22:17:49.637542	N	freshclam error:  52
2951	V	2016-01-20 23:17:17.698066	N	freshclam error:  52
2952	V	2016-01-21 00:15:18.822586	N	freshclam error:  52
2953	V	2016-01-21 01:16:17.46768	N	freshclam error:  52
2954	V	2016-01-21 02:17:47.697828	N	freshclam error:  52
2955	R	2016-01-21 03:05:01.111362	Y	0
2956	V	2016-01-21 03:10:17.373309	N	freshclam error:  52
2957	S	2016-01-21 03:34:54.621496	N	Cannot contact server
2958	F	2016-01-21 03:36:10.120737	N	Cannot contact ANY update server
2959	V	2016-01-21 04:10:17.377454	N	freshclam error:  52
2960	V	2016-01-21 05:10:17.573002	N	freshclam error:  52
2961	V	2016-01-21 06:10:16.958433	N	freshclam error:  52
2962	V	2016-01-21 07:13:17.132406	N	freshclam error:  52
2963	V	2016-01-21 08:13:17.389486	N	freshclam error:  52
2964	V	2016-01-21 09:13:16.507749	N	freshclam error:  52
2965	V	2016-01-21 10:10:16.532538	N	freshclam error:  52
2966	V	2016-01-21 11:17:47.447767	N	freshclam error:  52
2967	V	2016-01-21 12:17:17.502912	N	freshclam error:  52
2968	V	2016-01-21 13:11:46.632577	N	freshclam error:  52
2969	V	2016-01-21 14:11:46.512774	N	freshclam error:  52
2970	V	2016-01-21 15:13:16.717605	N	freshclam error:  52
2971	V	2016-01-21 16:17:46.854139	N	freshclam error:  52
2972	V	2016-01-21 17:15:16.958967	N	freshclam error:  52
2973	V	2016-01-21 18:13:17.372214	N	freshclam error:  52
2974	V	2016-01-21 19:10:16.612925	N	freshclam error:  52
2975	V	2016-01-21 20:10:17.302853	N	freshclam error:  52
2976	V	2016-01-21 21:13:16.642833	N	freshclam error:  52
2977	V	2016-01-21 22:16:16.933114	N	freshclam error:  52
2978	V	2016-01-21 23:13:17.167663	N	freshclam error:  52
2979	V	2016-01-22 00:13:18.317689	N	freshclam error:  52
2980	V	2016-01-22 01:13:16.858595	N	freshclam error:  52
2981	V	2016-01-22 02:10:17.017562	N	freshclam error:  52
2982	R	2016-01-22 03:05:00.986583	Y	0
2983	S	2016-01-22 03:07:28.56137	N	Cannot contact server
2984	F	2016-01-22 03:08:44.091063	N	Cannot contact ANY update server
2985	V	2016-01-22 03:17:17.768115	N	freshclam error:  52
2986	V	2016-01-22 04:15:17.432654	N	freshclam error:  52
2987	V	2016-01-22 05:11:47.574033	N	freshclam error:  52
2988	V	2016-01-22 06:13:17.458047	N	freshclam error:  52
2989	V	2016-01-22 07:15:17.403754	N	freshclam error:  52
2990	V	2016-01-22 08:11:47.873198	N	freshclam error:  52
2991	V	2016-01-22 09:11:47.723502	N	freshclam error:  52
2992	V	2016-01-22 10:17:17.842932	N	freshclam error:  52
2993	V	2016-01-22 11:16:16.452454	N	freshclam error:  52
2994	V	2016-01-22 12:10:16.398163	N	freshclam error:  52
2995	V	2016-01-22 13:15:17.452675	N	freshclam error:  52
2996	V	2016-01-22 14:13:16.977909	N	freshclam error:  52
2997	V	2016-01-22 15:17:47.283516	N	freshclam error:  52
2998	V	2016-01-22 16:15:17.048109	N	freshclam error:  52
2999	V	2016-01-22 17:13:19.028097	N	freshclam error:  52
3000	V	2016-01-22 18:10:18.80859	N	freshclam error:  52
3001	V	2016-01-22 19:16:19.418331	N	freshclam error:  52
3002	V	2016-01-22 20:13:19.197461	N	freshclam error:  52
3003	V	2016-01-22 21:17:47.008099	N	freshclam error:  52
3004	V	2016-01-22 22:13:17.418659	N	freshclam error:  52
3005	V	2016-01-22 23:15:17.214842	N	freshclam error:  52
3006	V	2016-01-23 00:11:47.778763	N	freshclam error:  52
3007	V	2016-01-23 01:13:17.962577	N	freshclam error:  52
3008	V	2016-01-23 02:14:17.692588	N	freshclam error:  52
3009	R	2016-01-23 03:05:00.640092	Y	0
3010	S	2016-01-23 03:07:30.10123	N	Cannot contact server
3011	F	2016-01-23 03:08:45.596289	N	Cannot contact ANY update server
3012	V	2016-01-23 03:13:18.108051	N	freshclam error:  52
3013	V	2016-01-23 04:15:18.302571	N	freshclam error:  52
3014	V	2016-01-23 05:13:18.148392	N	freshclam error:  52
3015	V	2016-01-23 06:10:17.562875	N	freshclam error:  52
3016	V	2016-01-23 07:17:48.463578	N	freshclam error:  52
3017	V	2016-01-23 08:17:48.267709	N	freshclam error:  52
3018	V	2016-01-23 09:13:17.937861	N	freshclam error:  52
3019	V	2016-01-23 10:10:17.227736	N	freshclam error:  52
3020	V	2016-01-23 11:13:16.731802	N	freshclam error:  52
3021	V	2016-01-23 12:13:16.927646	N	freshclam error:  52
3022	V	2016-01-23 13:10:17.047667	N	freshclam error:  52
3023	V	2016-01-23 14:17:47.848717	N	freshclam error:  52
3024	V	2016-01-23 15:14:17.267857	N	freshclam error:  52
3025	V	2016-01-23 16:18:18.074733	N	freshclam error:  52
3026	V	2016-01-23 17:11:46.71398	N	freshclam error:  52
3027	V	2016-01-23 18:13:17.383471	N	freshclam error:  52
3028	V	2016-01-23 19:17:47.059796	N	freshclam error:  52
3029	V	2016-01-23 20:17:46.765194	N	freshclam error:  52
3030	V	2016-01-23 21:10:17.547694	N	freshclam error:  52
3031	V	2016-01-23 22:10:17.178111	N	freshclam error:  52
3032	V	2016-01-23 23:15:16.86429	N	freshclam error:  52
3033	V	2016-01-24 00:16:18.423086	N	freshclam error:  52
3034	V	2016-01-24 01:13:18.653045	N	freshclam error:  52
3035	V	2016-01-24 02:13:17.778044	N	freshclam error:  52
3036	R	2016-01-24 03:05:00.451031	Y	0
3037	S	2016-01-24 03:07:27.891095	N	Cannot contact server
3038	F	2016-01-24 03:08:43.380701	N	Cannot contact ANY update server
3039	V	2016-01-24 03:13:17.573148	N	freshclam error:  52
3040	V	2016-01-24 04:13:18.148354	N	freshclam error:  52
3041	V	2016-01-24 05:14:18.275336	N	freshclam error:  52
3042	V	2016-01-24 06:11:47.06882	N	freshclam error:  52
3043	V	2016-01-24 07:13:17.507842	N	freshclam error:  52
3044	V	2016-01-24 08:15:17.547895	N	freshclam error:  52
3045	V	2016-01-24 09:13:17.222976	N	freshclam error:  52
3046	V	2016-01-24 10:15:17.339555	N	freshclam error:  52
3047	V	2016-01-24 11:13:17.003594	N	freshclam error:  52
3048	V	2016-01-24 12:16:17.082783	N	freshclam error:  52
3049	V	2016-01-24 13:10:16.113018	N	freshclam error:  52
3050	V	2016-01-24 14:17:47.37971	N	freshclam error:  52
3051	V	2016-01-24 15:13:18.853231	N	freshclam error:  52
3052	V	2016-01-24 16:13:16.503432	N	freshclam error:  52
3053	V	2016-01-24 17:15:17.624189	N	freshclam error:  52
3054	V	2016-01-24 18:13:16.37252	N	freshclam error:  52
3055	V	2016-01-24 19:13:17.627995	N	freshclam error:  52
3056	V	2016-01-24 20:10:17.747596	N	freshclam error:  52
3057	V	2016-01-24 21:13:17.878248	N	freshclam error:  52
3058	V	2016-01-24 22:10:17.677854	N	freshclam error:  52
3059	V	2016-01-24 23:15:16.980393	N	freshclam error:  52
3060	V	2016-01-25 00:11:48.373464	N	freshclam error:  52
3061	V	2016-01-25 01:11:47.473902	N	freshclam error:  52
3062	V	2016-01-25 02:13:18.712988	N	freshclam error:  52
3063	R	2016-01-25 03:05:00.755837	Y	0
3064	S	2016-01-25 03:07:28.041081	N	Cannot contact server
3065	F	2016-01-25 03:08:43.545852	N	Cannot contact ANY update server
3066	V	2016-01-25 03:13:17.408219	N	freshclam error:  52
3067	V	2016-01-25 04:15:17.458968	N	freshclam error:  52
3068	V	2016-01-25 05:13:17.873597	N	freshclam error:  52
3069	V	2016-01-25 06:10:16.927776	N	freshclam error:  52
3070	V	2016-01-25 07:10:17.167436	N	freshclam error:  52
3071	V	2016-01-25 08:13:17.268168	N	freshclam error:  52
3072	V	2016-01-25 09:17:48.047594	N	freshclam error:  52
3073	V	2016-01-25 10:15:17.803802	N	freshclam error:  52
3074	V	2016-01-25 11:20:17.242742	N	freshclam error:  52
3075	V	2016-01-25 12:14:46.798172	N	freshclam error:  52
3076	V	2016-01-25 13:16:17.107502	N	freshclam error:  52
3077	V	2016-01-25 14:10:17.138856	N	freshclam error:  52
3078	V	2016-01-25 15:15:18.007309	N	freshclam error:  52
3079	V	2016-01-25 16:17:17.02529	N	freshclam error:  52
3080	V	2016-01-25 17:11:47.5226	N	freshclam error:  52
3081	V	2016-01-25 18:16:19.597761	N	freshclam error:  52
3082	V	2016-01-25 19:17:47.170998	N	freshclam error:  52
3083	V	2016-01-25 20:10:19.077871	N	freshclam error:  52
3084	V	2016-01-25 21:13:17.432922	N	freshclam error:  52
3085	V	2016-01-25 22:15:17.198402	N	freshclam error:  52
3086	V	2016-01-25 23:13:16.797445	N	freshclam error:  52
3087	V	2016-01-26 00:10:18.523246	N	freshclam error:  52
3088	V	2016-01-26 01:13:17.002664	N	freshclam error:  52
3089	V	2016-01-26 02:17:18.142636	N	freshclam error:  52
3090	R	2016-01-26 03:05:00.628065	Y	0
3091	S	2016-01-26 03:07:28.676205	N	Cannot contact server
3092	F	2016-01-26 03:08:44.165782	N	Cannot contact ANY update server
3093	V	2016-01-26 03:15:17.434835	N	freshclam error:  52
3094	V	2016-01-26 04:11:46.69836	N	freshclam error:  52
3095	V	2016-01-26 05:13:16.828155	N	freshclam error:  52
3096	V	2016-01-26 06:13:17.692469	N	freshclam error:  52
3097	V	2016-01-26 07:10:17.022579	N	freshclam error:  52
3098	V	2016-01-26 08:18:16.958781	N	freshclam error:  52
3099	V	2016-01-26 09:13:16.643239	N	freshclam error:  52
3100	V	2016-01-26 10:14:17.643365	N	freshclam error:  52
3101	V	2016-01-26 11:13:18.017644	N	freshclam error:  52
3102	V	2016-01-26 12:10:17.457596	N	freshclam error:  52
3103	V	2016-01-26 13:01:10.972612	N	freshclam error:  58
3104	V	2016-01-26 14:15:17.132843	N	freshclam error:  52
3105	V	2016-01-26 15:17:47.402575	N	freshclam error:  52
3106	V	2016-01-26 16:11:46.892522	N	freshclam error:  52
3107	V	2016-01-26 17:17:48.698272	N	freshclam error:  52
3108	V	2016-01-26 18:13:17.083073	N	freshclam error:  52
3109	V	2016-01-26 19:17:46.867548	N	freshclam error:  52
3110	V	2016-01-26 20:13:16.68801	N	freshclam error:  52
3111	V	2016-01-26 21:13:17.039614	N	freshclam error:  52
3112	V	2016-01-26 22:15:19.387687	N	freshclam error:  52
3113	V	2016-01-26 23:13:16.668236	N	freshclam error:  52
3114	V	2016-01-27 00:13:18.31318	N	freshclam error:  52
3115	V	2016-01-27 01:10:18.727803	N	freshclam error:  52
3116	V	2016-01-27 02:20:48.80282	N	freshclam error:  52
3117	R	2016-01-27 03:05:01.008797	Y	0
3118	S	2016-01-27 03:07:28.481674	N	Cannot contact server
3119	F	2016-01-27 03:08:43.965975	N	Cannot contact ANY update server
3120	V	2016-01-27 03:13:17.464709	N	freshclam error:  52
3121	V	2016-01-27 04:13:17.463179	N	freshclam error:  52
3122	V	2016-01-27 05:13:47.648545	N	freshclam error:  52
3123	V	2016-01-27 06:13:17.732512	N	freshclam error:  52
3124	V	2016-01-27 07:13:17.393176	N	freshclam error:  52
3125	V	2016-01-27 08:10:17.288531	N	freshclam error:  52
3126	V	2016-01-27 09:15:17.010033	N	freshclam error:  52
3127	V	2016-01-27 10:14:47.233109	N	freshclam error:  52
3128	V	2016-01-27 11:13:16.628156	N	freshclam error:  52
3129	V	2016-01-27 12:10:17.012455	N	freshclam error:  52
3130	V	2016-01-27 13:17:47.422796	N	freshclam error:  52
3131	V	2016-01-27 14:17:17.138909	N	freshclam error:  52
3132	V	2016-01-27 15:10:16.638225	N	freshclam error:  52
3133	V	2016-01-27 16:15:17.57754	N	freshclam error:  52
3134	V	2016-01-27 17:16:16.787631	N	freshclam error:  52
3135	V	2016-01-27 18:10:17.108649	N	freshclam error:  52
3136	V	2016-01-27 19:13:17.120942	N	freshclam error:  52
3137	V	2016-01-27 20:10:16.797872	N	freshclam error:  52
3138	V	2016-01-27 21:13:17.572196	N	freshclam error:  52
3139	V	2016-01-27 22:13:16.873399	N	freshclam error:  52
3140	V	2016-01-27 23:17:16.807716	N	freshclam error:  52
3141	V	2016-01-28 00:20:48.5677	N	freshclam error:  52
3142	V	2016-01-28 01:10:17.372532	N	freshclam error:  52
3143	V	2016-01-28 02:15:17.567412	N	freshclam error:  52
3144	R	2016-01-28 03:05:00.781427	Y	0
3145	S	2016-01-28 03:07:28.222214	N	Cannot contact server
3146	F	2016-01-28 03:08:43.736462	N	Cannot contact ANY update server
3147	V	2016-01-28 03:11:47.628966	N	freshclam error:  52
3148	V	2016-01-28 04:14:17.433513	N	freshclam error:  52
3149	V	2016-01-28 05:17:48.034014	N	freshclam error:  52
3150	V	2016-01-28 06:13:17.409395	N	freshclam error:  52
3151	V	2016-01-28 07:17:17.74774	N	freshclam error:  52
3152	V	2016-01-28 08:10:17.408384	N	freshclam error:  52
3153	V	2016-01-28 09:15:17.817676	N	freshclam error:  52
3154	V	2016-01-28 10:11:47.049068	N	freshclam error:  52
3155	V	2016-01-28 11:18:09.142273	N	freshclam error:  52
3156	V	2016-01-28 12:13:17.028144	N	freshclam error:  52
3157	V	2016-01-28 13:10:17.058036	N	freshclam error:  52
3158	V	2016-01-28 14:10:16.969302	N	freshclam error:  52
3159	V	2016-01-28 15:10:17.252465	N	freshclam error:  52
3160	V	2016-01-28 16:20:17.387423	N	freshclam error:  52
3161	V	2016-01-28 17:13:16.972491	N	freshclam error:  52
3162	V	2016-01-28 18:10:16.552464	N	freshclam error:  52
3163	V	2016-01-28 19:10:16.878218	N	freshclam error:  52
3164	V	2016-01-28 20:17:46.982753	N	freshclam error:  52
3165	V	2016-01-28 21:10:16.632632	N	freshclam error:  52
3166	V	2016-01-28 22:14:17.84276	N	freshclam error:  52
3167	V	2016-01-28 23:14:16.497967	N	freshclam error:  52
3168	V	2016-01-29 00:15:18.425267	N	freshclam error:  52
3169	V	2016-01-29 01:13:17.909209	N	freshclam error:  52
3170	V	2016-01-29 02:13:18.084992	N	freshclam error:  52
3171	R	2016-01-29 03:05:00.300955	Y	0
3172	V	2016-01-29 03:13:17.69757	N	freshclam error:  52
3173	S	2016-01-29 03:34:53.141478	N	Cannot contact server
3174	F	2016-01-29 03:36:08.650565	N	Cannot contact ANY update server
3175	V	2016-01-29 04:15:18.452664	N	freshclam error:  52
3176	V	2016-01-29 05:11:47.413276	N	freshclam error:  52
3177	V	2016-01-29 06:11:48.268234	N	freshclam error:  52
3178	V	2016-01-29 07:11:48.007821	N	freshclam error:  52
3179	V	2016-01-29 08:16:18.697831	N	freshclam error:  52
3180	L	2016-01-29 08:29:37.264615	Y	admin
3181	V	2016-01-29 09:17:48.453081	N	freshclam error:  52
3182	V	2016-01-29 10:16:18.20756	N	freshclam error:  52
3183	V	2016-01-29 11:13:17.447597	N	freshclam error:  52
3184	V	2016-01-29 12:17:46.837606	N	freshclam error:  52
3185	V	2016-01-29 13:20:47.558013	N	freshclam error:  52
3186	V	2016-01-29 14:10:16.799003	N	freshclam error:  52
3187	V	2016-01-29 15:10:16.612611	N	freshclam error:  52
3188	V	2016-01-29 16:15:17.062995	N	freshclam error:  52
3189	V	2016-01-29 17:11:49.02423	N	freshclam error:  52
3190	V	2016-01-29 18:11:46.787792	N	freshclam error:  52
3191	V	2016-01-29 19:11:46.753241	N	freshclam error:  52
3192	V	2016-01-29 20:13:16.977779	N	freshclam error:  52
3193	V	2016-01-29 21:17:17.013087	N	freshclam error:  52
3194	V	2016-01-29 22:17:47.572919	N	freshclam error:  52
3195	V	2016-01-29 23:13:18.099506	N	freshclam error:  52
3196	V	2016-01-30 00:13:19.019349	N	freshclam error:  52
3197	V	2016-01-30 01:13:47.904805	N	freshclam error:  52
3198	V	2016-01-30 02:10:17.929368	N	freshclam error:  52
3199	R	2016-01-30 03:05:00.443592	Y	0
3200	S	2016-01-30 03:07:39.13388	N	Cannot contact server
3201	F	2016-01-30 03:08:54.572641	N	Cannot contact ANY update server
3202	V	2016-01-30 03:17:48.395077	N	freshclam error:  52
3203	V	2016-01-30 04:15:18.289478	N	freshclam error:  52
3204	V	2016-01-30 05:13:17.735217	N	freshclam error:  52
3205	V	2016-01-30 06:10:17.635557	N	freshclam error:  52
3206	V	2016-01-30 07:17:17.960841	N	freshclam error:  52
3207	V	2016-01-30 08:15:17.804632	N	freshclam error:  52
3208	V	2016-01-30 09:17:48.326202	N	freshclam error:  52
3209	V	2016-01-30 10:11:47.325131	N	freshclam error:  52
3210	V	2016-01-30 11:11:47.959415	N	freshclam error:  52
3211	V	2016-01-30 12:13:17.859918	N	freshclam error:  52
3212	V	2016-01-30 13:10:18.001871	N	freshclam error:  52
3213	V	2016-01-30 14:10:18.064832	N	freshclam error:  52
3214	V	2016-01-30 15:16:18.079533	N	freshclam error:  52
3215	V	2016-01-30 16:15:18.334631	N	freshclam error:  52
3216	V	2016-01-30 17:04:11.410513	N	freshclam error:  58
3217	V	2016-01-30 18:16:17.164656	N	freshclam error:  52
3218	V	2016-01-30 19:18:16.580131	N	freshclam error:  52
3219	V	2016-01-30 20:11:46.505941	N	freshclam error:  52
3220	V	2016-01-30 21:13:17.174816	N	freshclam error:  52
3221	V	2016-01-30 22:13:16.664521	N	freshclam error:  52
3222	V	2016-01-30 23:13:16.455443	N	freshclam error:  52
3223	V	2016-01-31 00:10:18.394602	N	freshclam error:  52
3224	V	2016-01-31 01:17:48.689785	N	freshclam error:  52
3225	V	2016-01-31 02:13:17.869552	N	freshclam error:  52
3226	R	2016-01-31 03:05:00.755158	Y	0
3227	S	2016-01-31 03:07:28.348135	N	Cannot contact server
3228	F	2016-01-31 03:08:43.86286	N	Cannot contact ANY update server
3229	V	2016-01-31 03:15:17.445449	N	freshclam error:  52
3230	V	2016-01-31 04:11:46.86483	N	freshclam error:  52
3231	V	2016-01-31 05:11:47.424335	N	freshclam error:  52
3232	V	2016-01-31 06:13:17.719803	N	freshclam error:  52
3233	V	2016-01-31 07:13:17.266209	N	freshclam error:  52
3234	V	2016-01-31 08:14:16.880114	N	freshclam error:  52
3235	V	2016-01-31 09:11:46.354862	N	freshclam error:  52
3236	V	2016-01-31 10:11:46.72085	N	freshclam error:  52
3237	V	2016-01-31 11:14:16.884867	N	freshclam error:  52
3238	V	2016-01-31 12:13:16.990588	N	freshclam error:  52
3239	V	2016-01-31 13:17:17.430714	N	freshclam error:  52
3240	V	2016-01-31 14:14:17.520329	N	freshclam error:  52
3241	V	2016-01-31 15:13:16.419556	N	freshclam error:  52
3242	V	2016-01-31 16:10:16.514285	N	freshclam error:  52
3243	V	2016-01-31 17:24:18.050082	N	freshclam error:  52
3244	V	2016-01-31 18:13:16.810379	N	freshclam error:  52
3245	V	2016-01-31 19:10:17.054669	N	freshclam error:  52
3246	V	2016-01-31 20:10:16.384344	N	freshclam error:  52
3247	V	2016-01-31 21:13:16.439766	N	freshclam error:  52
3248	V	2016-01-31 22:13:17.479828	N	freshclam error:  52
3249	V	2016-01-31 23:10:17.075257	N	freshclam error:  52
3250	V	2016-02-01 00:14:48.02532	N	freshclam error:  52
3251	V	2016-02-01 01:13:17.670361	N	freshclam error:  52
3252	V	2016-02-01 02:13:17.795122	N	freshclam error:  52
3253	R	2016-02-01 03:05:00.722778	Y	0
3254	S	2016-02-01 03:07:28.033213	N	Cannot contact server
3255	F	2016-02-01 03:08:43.553722	N	Cannot contact ANY update server
3256	V	2016-02-01 03:13:16.847249	N	freshclam error:  52
3257	V	2016-02-01 04:13:46.574878	N	freshclam error:  52
3258	V	2016-02-01 05:10:16.660712	N	freshclam error:  52
3259	V	2016-02-01 06:10:16.515592	N	freshclam error:  52
3260	L	2016-02-01 07:07:59.403907	Y	admin
3261	V	2016-02-01 08:15:17.923608	N	freshclam error:  52
3262	V	2016-02-01 09:13:16.743153	N	freshclam error:  52
3263	V	2016-02-01 10:13:16.863033	N	freshclam error:  52
3264	V	2016-02-01 11:10:16.523647	N	freshclam error:  52
3265	V	2016-02-01 12:10:16.057479	N	freshclam error:  52
3266	V	2016-02-01 13:13:16.488814	N	freshclam error:  52
3267	V	2016-02-01 14:13:16.672795	N	freshclam error:  52
3268	V	2016-02-01 15:20:17.422998	N	freshclam error:  52
3269	V	2016-02-01 16:13:16.928004	N	freshclam error:  52
3270	L	2016-02-01 16:20:12.622972	Y	admin
3271	V	2016-02-01 17:13:16.939624	N	freshclam error:  52
3272	V	2016-02-01 18:15:17.332901	N	freshclam error:  52
3273	V	2016-02-01 19:16:47.354078	N	freshclam error:  52
3274	V	2016-02-01 20:13:16.583592	N	freshclam error:  52
3275	V	2016-02-01 21:17:17.673838	N	freshclam error:  52
3276	V	2016-02-01 22:13:16.778086	N	freshclam error:  52
3277	V	2016-02-01 23:17:46.703255	N	freshclam error:  52
3278	V	2016-02-02 00:13:18.00816	N	freshclam error:  52
3279	V	2016-02-02 01:13:17.339161	N	freshclam error:  52
3280	V	2016-02-02 02:10:17.298088	N	freshclam error:  52
3281	R	2016-02-02 03:05:00.438142	Y	0
3282	S	2016-02-02 03:07:39.116492	N	Cannot contact server
3283	F	2016-02-02 03:08:54.642788	N	Cannot contact ANY update server
3284	V	2016-02-02 03:10:17.393414	N	freshclam error:  52
3285	V	2016-02-02 04:17:47.80307	N	freshclam error:  52
3286	V	2016-02-02 05:10:17.67513	N	freshclam error:  52
3287	V	2016-02-02 06:10:17.577742	N	freshclam error:  52
3288	V	2016-02-02 07:10:17.163011	N	freshclam error:  52
3289	V	2016-02-02 08:13:17.393073	N	freshclam error:  52
3290	L	2016-02-02 08:23:19.80154	Y	admin
3291	V	2016-02-02 09:15:18.182835	N	freshclam error:  52
3292	V	2016-02-02 10:11:47.128003	N	freshclam error:  52
3293	V	2016-02-02 11:13:16.64027	N	freshclam error:  52
3294	V	2016-02-02 12:14:47.537924	N	freshclam error:  52
3295	V	2016-02-02 13:16:17.047981	N	freshclam error:  52
3296	V	2016-02-02 14:13:17.678562	N	freshclam error:  52
3297	V	2016-02-02 15:13:16.70844	N	freshclam error:  52
3298	V	2016-02-02 16:10:16.722938	N	freshclam error:  52
3299	V	2016-02-02 17:10:17.228137	N	freshclam error:  52
3300	V	2016-02-02 18:17:47.038217	N	freshclam error:  52
3301	V	2016-02-02 19:13:16.797963	N	freshclam error:  52
3302	V	2016-02-02 20:20:46.79316	N	freshclam error:  52
3303	V	2016-02-02 21:13:16.888442	N	freshclam error:  52
3304	V	2016-02-02 22:13:17.093549	N	freshclam error:  52
3305	V	2016-02-02 23:13:16.979378	N	freshclam error:  52
3306	V	2016-02-03 00:10:19.318177	N	freshclam error:  52
3307	V	2016-02-03 01:13:17.847986	N	freshclam error:  52
3308	V	2016-02-03 02:10:17.888402	N	freshclam error:  52
3309	R	2016-02-03 03:05:00.688603	Y	0
3310	S	2016-02-03 03:07:28.226792	N	Cannot contact server
3311	F	2016-02-03 03:08:43.756273	N	Cannot contact ANY update server
3312	V	2016-02-03 03:17:47.424228	N	freshclam error:  52
3313	V	2016-02-03 04:14:48.009344	N	freshclam error:  52
3314	V	2016-02-03 05:13:17.653526	N	freshclam error:  52
3315	V	2016-02-03 06:10:17.293456	N	freshclam error:  52
3316	V	2016-02-03 07:13:16.289121	N	freshclam error:  52
3317	V	2016-02-03 08:13:17.084174	N	freshclam error:  52
3318	V	2016-02-03 09:15:17.307957	N	freshclam error:  52
3319	V	2016-02-03 10:13:17.032481	N	freshclam error:  52
3320	V	2016-02-03 11:10:16.882915	N	freshclam error:  52
3321	V	2016-02-03 12:21:17.583431	N	freshclam error:  52
3322	V	2016-02-03 13:11:46.578377	N	freshclam error:  52
3323	V	2016-02-03 14:13:17.273451	N	freshclam error:  52
3324	V	2016-02-03 15:17:47.573525	N	freshclam error:  52
3325	V	2016-02-03 16:17:46.638918	N	freshclam error:  52
3326	V	2016-02-03 17:13:17.002985	N	freshclam error:  52
3327	V	2016-02-03 18:13:16.713268	N	freshclam error:  52
3328	V	2016-02-03 19:13:16.794247	N	freshclam error:  52
3329	V	2016-02-03 20:10:16.738564	N	freshclam error:  52
3330	V	2016-02-03 21:17:17.219503	N	freshclam error:  52
3331	V	2016-02-03 22:15:17.042715	N	freshclam error:  52
3332	V	2016-02-03 23:11:46.688913	N	freshclam error:  52
3333	V	2016-02-04 00:13:19.259192	N	freshclam error:  52
3334	V	2016-02-04 01:10:17.693087	N	freshclam error:  52
3335	V	2016-02-04 02:10:17.567836	N	freshclam error:  52
3336	R	2016-02-04 03:05:00.958891	Y	0
3337	S	2016-02-04 03:07:28.096981	N	Cannot contact server
3338	F	2016-02-04 03:08:43.591137	N	Cannot contact ANY update server
3339	V	2016-02-04 03:17:48.093103	N	freshclam error:  52
3340	V	2016-02-04 04:13:16.679319	N	freshclam error:  52
3341	V	2016-02-04 05:10:16.31836	N	freshclam error:  52
3342	V	2016-02-04 06:16:17.453465	N	freshclam error:  52
3343	V	2016-02-04 07:17:17.579588	N	freshclam error:  52
3344	V	2016-02-04 08:10:16.128203	N	freshclam error:  52
3345	V	2016-02-04 09:17:17.673514	N	freshclam error:  52
3346	V	2016-02-04 10:17:47.089191	N	freshclam error:  52
3347	V	2016-02-04 11:11:47.013892	N	freshclam error:  52
3348	V	2016-02-04 12:11:47.088374	N	freshclam error:  52
3349	V	2016-02-04 13:11:46.918021	N	freshclam error:  52
3350	V	2016-02-04 14:19:17.413207	N	freshclam error:  52
3351	L	2016-02-04 14:40:56.178304	Y	admin
3352	V	2016-02-04 15:13:16.293074	N	freshclam error:  52
3353	V	2016-02-04 16:13:17.707981	N	freshclam error:  52
3354	V	2016-02-04 17:13:16.543257	N	freshclam error:  52
3355	V	2016-02-04 18:13:17.483346	N	freshclam error:  52
3356	V	2016-02-04 19:17:16.624305	N	freshclam error:  52
3357	V	2016-02-04 20:17:46.938451	N	freshclam error:  52
3358	V	2016-02-04 21:14:46.67914	N	freshclam error:  52
3359	V	2016-02-04 22:13:16.663199	N	freshclam error:  52
3360	V	2016-02-04 23:17:17.503683	N	freshclam error:  52
3361	V	2016-02-05 00:17:48.223656	N	freshclam error:  52
3362	V	2016-02-05 01:10:18.273941	N	freshclam error:  52
3363	V	2016-02-05 02:13:17.213015	N	freshclam error:  52
3364	R	2016-02-05 03:05:00.237086	Y	0
3365	S	2016-02-05 03:07:27.661858	N	Cannot contact server
3366	F	2016-02-05 03:08:43.186604	N	Cannot contact ANY update server
3367	V	2016-02-05 03:15:16.863033	N	freshclam error:  52
3368	V	2016-02-05 04:16:47.378481	N	freshclam error:  52
3369	V	2016-02-05 05:10:16.769157	N	freshclam error:  52
3370	V	2016-02-05 06:13:17.024105	N	freshclam error:  52
3371	V	2016-02-05 07:14:16.758442	N	freshclam error:  52
3372	V	2016-02-05 08:20:17.743542	N	freshclam error:  52
3373	V	2016-02-05 09:16:17.358058	N	freshclam error:  52
3374	V	2016-02-05 10:17:47.418009	N	freshclam error:  52
3375	V	2016-02-05 11:17:47.66893	N	freshclam error:  52
3376	V	2016-02-05 12:15:17.408759	N	freshclam error:  52
3377	V	2016-02-05 13:11:46.513694	N	freshclam error:  52
3378	V	2016-02-05 14:13:16.437787	N	freshclam error:  52
3379	V	2016-02-05 15:10:16.97358	N	freshclam error:  52
3380	V	2016-02-05 16:15:16.992789	N	freshclam error:  52
3381	V	2016-02-05 17:13:16.663672	N	freshclam error:  52
3382	V	2016-02-05 18:17:46.813453	N	freshclam error:  52
3383	V	2016-02-05 19:10:16.359373	N	freshclam error:  52
3384	V	2016-02-05 20:17:16.983333	N	freshclam error:  52
3385	V	2016-02-05 21:13:17.208751	N	freshclam error:  52
3386	V	2016-02-05 22:15:17.018321	N	freshclam error:  52
3387	V	2016-02-05 23:11:47.368042	N	freshclam error:  52
3388	V	2016-02-06 00:13:18.653093	N	freshclam error:  52
3389	V	2016-02-06 01:10:17.583278	N	freshclam error:  52
3390	V	2016-02-06 02:13:17.803067	N	freshclam error:  52
3391	R	2016-02-06 03:05:00.325278	Y	0
3392	V	2016-02-06 03:15:17.017738	N	freshclam error:  52
3393	S	2016-02-06 03:34:52.501684	N	Cannot contact server
3394	F	2016-02-06 03:36:07.99624	N	Cannot contact ANY update server
3395	V	2016-02-06 04:13:16.513538	N	freshclam error:  52
3396	V	2016-02-06 05:13:17.173271	N	freshclam error:  52
3397	V	2016-02-06 06:18:17.433768	N	freshclam error:  52
3398	V	2016-02-06 07:13:16.98394	N	freshclam error:  52
3399	V	2016-02-06 08:16:17.273406	N	freshclam error:  52
3400	V	2016-02-06 09:17:17.8135	N	freshclam error:  52
3401	V	2016-02-06 10:13:19.26815	N	freshclam error:  52
3402	V	2016-02-06 11:17:17.433173	N	freshclam error:  52
3403	V	2016-02-06 12:11:47.028412	N	freshclam error:  52
3404	V	2016-02-06 13:13:17.029881	N	freshclam error:  52
3405	V	2016-02-06 14:18:17.598712	N	freshclam error:  52
3406	V	2016-02-06 15:13:16.504008	N	freshclam error:  52
3407	V	2016-02-06 16:10:16.318108	N	freshclam error:  52
3408	V	2016-02-06 17:19:16.999365	N	freshclam error:  52
3409	V	2016-02-06 18:15:17.543698	N	freshclam error:  52
3410	V	2016-02-06 19:11:47.283544	N	freshclam error:  52
3411	V	2016-02-06 20:13:17.563559	N	freshclam error:  52
3412	V	2016-02-06 21:10:16.318279	N	freshclam error:  52
3413	V	2016-02-06 22:13:16.84834	N	freshclam error:  52
3414	V	2016-02-07 00:10:18.015333	N	freshclam error:  52
3415	V	2016-02-07 01:13:17.995246	N	freshclam error:  52
3416	V	2016-02-07 02:17:17.430409	N	freshclam error:  52
3417	R	2016-02-07 03:05:00.968374	Y	0
3418	S	2016-02-07 03:07:39.709157	N	Cannot contact server
3419	F	2016-02-07 03:08:55.228511	N	Cannot contact ANY update server
3420	V	2016-02-07 03:18:18.171395	N	freshclam error:  52
3421	V	2016-02-07 04:17:47.930367	N	freshclam error:  52
3422	V	2016-02-07 05:13:17.250068	N	freshclam error:  52
3423	V	2016-02-07 06:19:17.980576	N	freshclam error:  52
3424	V	2016-02-07 07:10:16.945253	N	freshclam error:  52
3425	V	2016-02-07 08:10:17.870687	N	freshclam error:  52
3426	V	2016-02-07 09:14:17.972648	N	freshclam error:  52
3427	V	2016-02-07 10:11:47.535956	N	freshclam error:  52
3428	V	2016-02-07 11:11:47.006382	N	freshclam error:  52
3429	V	2016-02-07 12:13:17.295485	N	freshclam error:  52
3430	V	2016-02-07 13:13:16.876536	N	freshclam error:  52
3431	V	2016-02-07 14:10:16.441276	N	freshclam error:  52
3432	V	2016-02-07 15:15:16.870783	N	freshclam error:  52
3433	V	2016-02-07 16:11:47.285961	N	freshclam error:  52
3434	V	2016-02-07 17:13:16.590433	N	freshclam error:  52
3435	V	2016-02-07 18:10:16.780371	N	freshclam error:  52
3436	V	2016-02-07 19:17:47.160433	N	freshclam error:  52
3437	V	2016-02-07 20:10:17.251441	N	freshclam error:  52
3438	V	2016-02-07 21:13:16.685375	N	freshclam error:  52
3439	V	2016-02-07 22:15:16.875278	N	freshclam error:  52
3440	V	2016-02-07 23:11:47.476312	N	freshclam error:  52
3441	V	2016-02-08 00:13:16.540485	N	freshclam error:  52
3442	V	2016-02-08 01:15:16.985679	N	freshclam error:  52
3443	V	2016-02-08 02:13:18.131337	N	freshclam error:  52
3444	R	2016-02-08 03:05:00.705229	Y	0
3445	S	2016-02-08 03:07:28.209232	N	Cannot contact server
3446	F	2016-02-08 03:08:43.738693	N	Cannot contact ANY update server
3447	V	2016-02-08 03:10:17.160908	N	freshclam error:  52
3448	V	2016-02-08 04:15:16.775355	N	freshclam error:  52
3449	V	2016-02-08 05:11:47.566771	N	freshclam error:  52
3450	V	2016-02-08 06:13:16.84584	N	freshclam error:  52
3451	V	2016-02-08 07:13:48.000699	N	freshclam error:  52
3452	V	2016-02-08 08:15:18.235506	N	freshclam error:  52
3453	V	2016-02-08 09:11:47.495813	N	freshclam error:  52
3454	V	2016-02-08 10:16:17.190564	N	freshclam error:  52
3455	V	2016-02-08 11:17:47.321562	N	freshclam error:  52
3456	V	2016-02-08 12:15:17.140277	N	freshclam error:  52
3457	V	2016-02-08 13:13:17.525706	N	freshclam error:  52
3458	V	2016-02-08 14:15:16.922058	N	freshclam error:  52
3459	V	2016-02-08 15:13:17.105702	N	freshclam error:  52
3460	V	2016-02-08 16:13:16.990296	N	freshclam error:  52
3461	V	2016-02-08 17:13:17.22032	N	freshclam error:  52
3462	V	2016-02-08 18:13:17.071299	N	freshclam error:  52
3463	V	2016-02-08 19:13:17.172202	N	freshclam error:  52
3464	V	2016-02-08 20:10:16.665382	N	freshclam error:  52
3465	V	2016-02-08 21:10:17.07541	N	freshclam error:  52
3466	V	2016-02-08 22:13:16.775573	N	freshclam error:  52
3467	V	2016-02-08 23:13:16.716064	N	freshclam error:  52
3468	V	2016-02-09 00:10:18.725441	N	freshclam error:  52
3469	V	2016-02-09 01:13:17.486928	N	freshclam error:  52
3470	V	2016-02-09 02:18:17.720391	N	freshclam error:  52
3471	R	2016-02-09 03:05:00.34325	Y	0
3472	S	2016-02-09 03:07:27.514045	N	Cannot contact server
3473	F	2016-02-09 03:08:43.024131	N	Cannot contact ANY update server
3474	V	2016-02-09 03:13:16.805888	N	freshclam error:  52
3475	V	2016-02-09 04:13:16.61064	N	freshclam error:  52
3476	V	2016-02-09 05:10:16.930458	N	freshclam error:  52
3477	V	2016-02-09 06:13:17.931823	N	freshclam error:  52
3478	V	2016-02-09 07:15:17.000474	N	freshclam error:  52
3479	V	2016-02-09 08:13:17.125737	N	freshclam error:  52
3480	V	2016-02-09 09:10:16.900396	N	freshclam error:  52
3481	V	2016-02-09 10:17:47.135785	N	freshclam error:  52
3482	V	2016-02-09 11:13:16.921282	N	freshclam error:  52
3483	V	2016-02-09 12:17:46.76029	N	freshclam error:  52
3484	V	2016-02-09 13:13:17.130579	N	freshclam error:  52
3485	V	2016-02-09 14:10:17.020311	N	freshclam error:  52
3486	V	2016-02-09 15:13:17.250439	N	freshclam error:  52
3487	V	2016-02-09 16:13:17.020568	N	freshclam error:  52
3488	V	2016-02-09 17:10:16.830535	N	freshclam error:  52
3489	V	2016-02-09 18:10:16.205743	N	freshclam error:  52
3490	V	2016-02-09 19:17:17.095621	N	freshclam error:  52
3491	V	2016-02-09 20:10:17.280505	N	freshclam error:  52
3492	V	2016-02-09 21:10:16.860576	N	freshclam error:  52
3493	V	2016-02-09 22:17:46.895478	N	freshclam error:  52
3494	V	2016-02-09 23:17:16.63642	N	freshclam error:  52
3495	V	2016-02-10 00:15:18.066372	N	freshclam error:  52
3496	V	2016-02-10 01:13:17.620123	N	freshclam error:  52
3497	V	2016-02-10 02:17:47.645933	N	freshclam error:  52
3498	R	2016-02-10 03:05:00.991876	Y	0
3499	S	2016-02-10 03:07:28.493874	N	Cannot contact server
3500	F	2016-02-10 03:08:44.003622	N	Cannot contact ANY update server
3501	V	2016-02-10 03:10:17.195327	N	freshclam error:  52
3502	V	2016-02-10 04:13:16.631407	N	freshclam error:  52
3503	V	2016-02-10 05:13:17.58656	N	freshclam error:  52
3504	V	2016-02-10 06:19:18.510515	N	freshclam error:  52
3505	V	2016-02-10 07:15:17.630704	N	freshclam error:  52
3506	V	2016-02-10 08:13:16.785358	N	freshclam error:  52
3507	V	2016-02-10 09:13:17.300823	N	freshclam error:  52
3508	V	2016-02-10 10:10:16.896013	N	freshclam error:  52
3509	V	2016-02-10 11:13:16.371412	N	freshclam error:  52
3510	V	2016-02-10 12:15:16.880449	N	freshclam error:  52
3511	V	2016-02-10 13:13:17.30995	N	freshclam error:  52
3512	L	2016-02-10 14:02:23.490808	Y	admin
3513	V	2016-02-10 14:10:16.845191	N	freshclam error:  52
3514	V	2016-02-10 15:13:16.645478	N	freshclam error:  52
3515	V	2016-02-10 16:17:17.010184	N	freshclam error:  52
3516	V	2016-02-10 17:17:46.56596	N	freshclam error:  52
3517	V	2016-02-10 18:13:17.195555	N	freshclam error:  52
3518	V	2016-02-10 19:21:17.360598	N	freshclam error:  52
3519	V	2016-02-10 20:11:46.770434	N	freshclam error:  52
3520	V	2016-02-10 21:13:17.096589	N	freshclam error:  52
3521	V	2016-02-10 22:15:17.13602	N	freshclam error:  52
3522	V	2016-02-10 23:13:16.850312	N	freshclam error:  52
3523	V	2016-02-11 00:10:20.200503	N	freshclam error:  52
3524	V	2016-02-11 01:15:17.27056	N	freshclam error:  52
3525	V	2016-02-11 02:17:18.080921	N	freshclam error:  52
3526	R	2016-02-11 03:05:01.056156	Y	0
3527	S	2016-02-11 03:07:28.639068	N	Cannot contact server
3528	F	2016-02-11 03:08:44.078618	N	Cannot contact ANY update server
3529	V	2016-02-11 03:10:17.320722	N	freshclam error:  52
3530	V	2016-02-11 04:10:17.351149	N	freshclam error:  52
3531	V	2016-02-11 05:10:17.050491	N	freshclam error:  52
3532	V	2016-02-11 06:17:47.300464	N	freshclam error:  52
3533	V	2016-02-11 07:15:17.42051	N	freshclam error:  52
3534	V	2016-02-11 08:13:17.751175	N	freshclam error:  52
3535	V	2016-02-11 09:13:16.905673	N	freshclam error:  52
3536	V	2016-02-11 10:13:17.15517	N	freshclam error:  52
3537	V	2016-02-11 11:10:17.030959	N	freshclam error:  52
3538	V	2016-02-11 12:10:16.204533	N	freshclam error:  52
3539	V	2016-02-11 13:13:17.186383	N	freshclam error:  52
3540	V	2016-02-11 14:17:46.95561	N	freshclam error:  52
3541	V	2016-02-11 15:17:46.995416	N	freshclam error:  52
3542	V	2016-02-11 16:14:17.722939	N	freshclam error:  52
3543	V	2016-02-11 17:13:17.040116	N	freshclam error:  52
3544	V	2016-02-11 18:13:16.941657	N	freshclam error:  52
3545	V	2016-02-11 19:18:17.500789	N	freshclam error:  52
3546	V	2016-02-11 20:13:17.251157	N	freshclam error:  52
3547	V	2016-02-11 21:10:16.296034	N	freshclam error:  52
3548	V	2016-02-11 22:10:16.331135	N	freshclam error:  52
3549	V	2016-02-11 23:17:46.64672	N	freshclam error:  52
3550	V	2016-02-12 00:10:17.865569	N	freshclam error:  52
3551	V	2016-02-12 01:15:17.120968	N	freshclam error:  52
3552	V	2016-02-12 02:13:17.23563	N	freshclam error:  52
3553	R	2016-02-12 03:05:01.116606	Y	0
3554	S	2016-02-12 03:07:28.629239	N	Cannot contact server
3555	F	2016-02-12 03:08:44.123505	N	Cannot contact ANY update server
3556	V	2016-02-12 03:15:17.8472	N	freshclam error:  52
3557	V	2016-02-12 04:11:46.651296	N	freshclam error:  52
3558	V	2016-02-12 05:13:18.045529	N	freshclam error:  52
3559	V	2016-02-12 06:13:17.616196	N	freshclam error:  52
3560	V	2016-02-12 07:13:17.370275	N	freshclam error:  52
3561	V	2016-02-12 08:10:16.60037	N	freshclam error:  52
3562	L	2016-02-12 08:32:07.654517	Y	admin
3563	V	2016-02-12 09:17:17.060622	N	freshclam error:  52
3564	V	2016-02-12 10:13:17.141393	N	freshclam error:  52
3565	V	2016-02-12 11:13:16.866078	N	freshclam error:  52
3566	V	2016-02-12 12:10:16.95108	N	freshclam error:  52
3567	V	2016-02-12 13:18:16.985515	N	freshclam error:  52
3568	V	2016-02-12 14:13:17.055934	N	freshclam error:  52
3569	V	2016-02-12 15:10:16.530753	N	freshclam error:  52
3570	V	2016-02-12 16:17:46.885751	N	freshclam error:  52
3571	V	2016-02-12 17:15:16.580172	N	freshclam error:  52
3572	V	2016-02-12 18:13:17.085719	N	freshclam error:  52
3573	V	2016-02-12 19:18:17.76058	N	freshclam error:  52
3574	V	2016-02-12 20:13:16.81233	N	freshclam error:  52
3575	V	2016-02-12 21:10:16.690358	N	freshclam error:  52
3576	V	2016-02-12 22:13:17.286636	N	freshclam error:  52
3577	V	2016-02-12 23:10:17.320668	N	freshclam error:  52
3578	V	2016-02-13 00:10:17.790825	N	freshclam error:  52
3579	V	2016-02-13 01:17:47.550992	N	freshclam error:  52
3580	V	2016-02-13 02:13:16.740473	N	freshclam error:  52
3581	R	2016-02-13 03:05:00.868105	Y	0
3582	V	2016-02-13 03:18:17.411243	N	freshclam error:  52
3583	S	2016-02-13 03:34:53.614167	N	Cannot contact server
3584	F	2016-02-13 03:36:09.128602	N	Cannot contact ANY update server
3585	V	2016-02-13 04:13:17.305576	N	freshclam error:  52
3586	V	2016-02-13 05:13:17.786225	N	freshclam error:  52
3587	V	2016-02-13 06:10:17.305263	N	freshclam error:  52
3588	V	2016-02-13 07:10:17.171124	N	freshclam error:  52
3589	V	2016-02-13 08:10:17.227375	N	freshclam error:  52
3590	V	2016-02-13 09:13:17.156117	N	freshclam error:  52
3591	V	2016-02-13 10:13:16.925341	N	freshclam error:  52
3592	V	2016-02-13 11:10:18.015486	N	freshclam error:  52
3593	V	2016-02-13 12:10:17.355418	N	freshclam error:  52
3594	V	2016-02-13 13:14:17.282136	N	freshclam error:  52
3595	V	2016-02-13 14:13:16.871709	N	freshclam error:  52
3596	V	2016-02-13 15:13:16.776056	N	freshclam error:  52
3597	V	2016-02-13 16:15:17.200298	N	freshclam error:  52
3598	V	2016-02-13 17:17:17.316004	N	freshclam error:  52
3599	V	2016-02-13 18:13:17.201762	N	freshclam error:  52
3600	V	2016-02-13 19:10:16.205755	N	freshclam error:  52
3601	V	2016-02-13 20:17:50.596789	N	freshclam error:  52
3602	V	2016-02-13 21:13:18.045406	N	freshclam error:  52
3603	V	2016-02-13 22:17:49.770476	N	freshclam error:  52
3604	V	2016-02-13 23:13:17.235474	N	freshclam error:  52
3605	V	2016-02-14 00:13:17.510505	N	freshclam error:  52
3606	V	2016-02-14 01:13:18.418607	N	freshclam error:  52
3607	V	2016-02-14 02:13:17.83673	N	freshclam error:  52
3608	R	2016-02-14 03:05:01.160852	Y	0
3609	S	2016-02-14 03:07:28.68413	N	Cannot contact server
3610	F	2016-02-14 03:08:44.198811	N	Cannot contact ANY update server
3611	V	2016-02-14 03:10:18.100297	N	freshclam error:  52
3612	V	2016-02-14 04:17:17.665416	N	freshclam error:  52
3613	V	2016-02-14 05:13:17.491183	N	freshclam error:  52
3614	V	2016-02-14 06:13:18.386855	N	freshclam error:  52
3615	V	2016-02-14 07:10:16.901381	N	freshclam error:  52
3616	V	2016-02-14 08:17:47.492208	N	freshclam error:  52
3617	V	2016-02-14 09:16:47.380736	N	freshclam error:  52
3618	V	2016-02-14 10:13:17.18173	N	freshclam error:  52
3619	V	2016-02-14 11:10:16.886206	N	freshclam error:  52
3620	V	2016-02-14 12:15:16.780974	N	freshclam error:  52
3621	V	2016-02-14 13:14:16.735461	N	freshclam error:  52
3622	V	2016-02-14 14:13:17.431756	N	freshclam error:  52
3623	V	2016-02-14 15:18:17.346729	N	freshclam error:  52
3624	V	2016-02-14 16:16:18.061491	N	freshclam error:  52
3625	V	2016-02-14 17:17:17.166045	N	freshclam error:  52
3626	V	2016-02-14 18:13:17.020412	N	freshclam error:  52
3627	V	2016-02-14 19:15:16.930349	N	freshclam error:  52
3628	V	2016-02-14 20:11:47.000791	N	freshclam error:  52
3629	V	2016-02-14 21:13:16.600974	N	freshclam error:  52
3630	V	2016-02-14 22:10:16.801126	N	freshclam error:  52
3631	V	2016-02-14 23:13:16.491421	N	freshclam error:  52
3632	V	2016-02-15 00:10:17.61547	N	freshclam error:  52
3633	V	2016-02-15 01:15:18.440915	N	freshclam error:  52
3634	V	2016-02-15 02:11:46.960235	N	freshclam error:  52
3635	R	2016-02-15 03:05:01.118501	Y	0
3636	S	2016-02-15 03:07:28.68883	N	Cannot contact server
3637	F	2016-02-15 03:08:44.208859	N	Cannot contact ANY update server
3638	V	2016-02-15 03:11:48.185154	N	freshclam error:  52
3639	V	2016-02-15 04:16:18.13091	N	freshclam error:  52
3640	V	2016-02-15 05:13:17.951065	N	freshclam error:  52
3641	V	2016-02-15 06:13:17.836888	N	freshclam error:  52
3642	V	2016-02-15 07:17:18.26571	N	freshclam error:  52
3643	V	2016-02-15 08:16:48.286032	N	freshclam error:  52
3644	V	2016-02-15 09:15:18.486127	N	freshclam error:  52
3645	V	2016-02-15 10:11:46.880179	N	freshclam error:  52
3646	V	2016-02-15 11:11:46.885709	N	freshclam error:  52
3647	V	2016-02-15 12:13:17.140672	N	freshclam error:  52
3648	V	2016-02-15 13:17:47.022165	N	freshclam error:  52
3649	V	2016-02-15 14:13:17.155412	N	freshclam error:  52
3650	V	2016-02-15 15:13:16.881026	N	freshclam error:  52
3651	V	2016-02-15 16:10:17.071253	N	freshclam error:  52
3652	V	2016-02-15 17:13:17.215649	N	freshclam error:  52
3653	V	2016-02-15 18:13:16.755266	N	freshclam error:  52
3654	V	2016-02-15 19:14:47.096464	N	freshclam error:  52
3655	V	2016-02-15 20:13:16.830778	N	freshclam error:  52
3656	V	2016-02-15 21:10:16.840993	N	freshclam error:  52
3657	V	2016-02-15 22:13:16.907438	N	freshclam error:  52
3658	V	2016-02-15 23:13:16.730703	N	freshclam error:  52
3659	V	2016-02-16 00:13:19.270695	N	freshclam error:  52
3660	V	2016-02-16 01:15:18.035612	N	freshclam error:  52
3661	V	2016-02-16 02:13:17.560687	N	freshclam error:  52
3662	R	2016-02-16 03:05:00.769017	Y	0
3663	S	2016-02-16 03:07:28.33896	N	Cannot contact server
3664	F	2016-02-16 03:08:43.918879	N	Cannot contact ANY update server
3665	V	2016-02-16 03:10:17.92623	N	freshclam error:  52
3666	V	2016-02-16 04:13:18.676972	N	freshclam error:  52
3667	V	2016-02-16 05:10:17.725262	N	freshclam error:  52
3668	V	2016-02-16 06:10:18.175316	N	freshclam error:  52
3669	V	2016-02-16 07:10:17.825544	N	freshclam error:  52
3670	V	2016-02-16 08:13:16.820989	N	freshclam error:  52
3671	V	2016-02-16 09:13:16.582429	N	freshclam error:  52
3672	V	2016-02-16 10:13:17.231128	N	freshclam error:  52
3673	V	2016-02-16 11:15:16.670357	N	freshclam error:  52
3674	V	2016-02-16 12:13:16.675711	N	freshclam error:  52
3675	V	2016-02-16 13:13:16.635259	N	freshclam error:  52
3676	V	2016-02-16 14:13:16.851934	N	freshclam error:  52
3677	V	2016-02-16 15:10:16.82543	N	freshclam error:  52
3678	V	2016-02-16 16:16:47.470545	N	freshclam error:  52
3679	V	2016-02-16 17:10:17.30035	N	freshclam error:  52
3680	V	2016-02-16 18:10:17.605237	N	freshclam error:  52
3681	V	2016-02-16 19:10:17.1362	N	freshclam error:  52
3682	V	2016-02-16 20:10:17.191549	N	freshclam error:  52
3683	V	2016-02-16 21:15:17.35121	N	freshclam error:  52
3684	V	2016-02-16 22:11:46.44076	N	freshclam error:  52
3685	V	2016-02-16 23:11:47.146515	N	freshclam error:  52
3686	V	2016-02-17 00:16:20.521135	N	freshclam error:  52
3687	V	2016-02-17 01:10:18.245361	N	freshclam error:  52
3688	V	2016-02-17 02:13:18.496416	N	freshclam error:  52
3689	R	2016-02-17 03:05:00.706816	Y	0
3690	S	2016-02-17 03:07:28.010262	N	Cannot contact server
3691	F	2016-02-17 03:08:43.623883	N	Cannot contact ANY update server
3692	V	2016-02-17 03:13:18.270362	N	freshclam error:  52
3693	V	2016-02-17 04:17:18.121053	N	freshclam error:  52
3694	V	2016-02-17 05:18:02.105202	N	freshclam error:  52
3695	V	2016-02-17 06:10:17.995666	N	freshclam error:  52
3696	V	2016-02-17 07:13:17.555573	N	freshclam error:  52
3697	L	2016-02-17 08:05:46.090889	Y	admin
3698	V	2016-02-17 08:15:17.410988	N	freshclam error:  52
3699	V	2016-02-17 09:13:17.439388	N	freshclam error:  52
3700	V	2016-02-17 10:13:16.954376	N	freshclam error:  52
3701	V	2016-02-17 11:13:17.03806	N	freshclam error:  52
3702	V	2016-02-17 12:10:16.829331	N	freshclam error:  52
3703	V	2016-02-17 13:10:16.615615	N	freshclam error:  52
3704	V	2016-02-17 14:21:17.664475	N	freshclam error:  52
3705	V	2016-02-17 15:13:16.585114	N	freshclam error:  52
3706	V	2016-02-17 16:15:17.64959	N	freshclam error:  52
3707	V	2016-02-17 17:13:16.584808	N	freshclam error:  52
3708	V	2016-02-17 18:17:46.934565	N	freshclam error:  52
3709	V	2016-02-17 19:10:17.204852	N	freshclam error:  52
3710	V	2016-02-17 20:10:16.504165	N	freshclam error:  52
3711	V	2016-02-17 21:13:17.700066	N	freshclam error:  52
3712	V	2016-02-17 22:13:17.179753	N	freshclam error:  52
3713	V	2016-02-17 23:16:17.659486	N	freshclam error:  52
3714	V	2016-02-18 00:13:17.945167	N	freshclam error:  52
3715	V	2016-02-18 01:14:17.510127	N	freshclam error:  52
3716	V	2016-02-18 02:13:17.604734	N	freshclam error:  52
3717	R	2016-02-18 03:05:01.119112	Y	0
3718	S	2016-02-18 03:07:39.993164	N	Cannot contact server
3719	F	2016-02-18 03:08:55.527815	N	Cannot contact ANY update server
3720	V	2016-02-18 03:10:17.399522	N	freshclam error:  52
3721	V	2016-02-18 04:13:17.050712	N	freshclam error:  52
3722	V	2016-02-18 05:10:43.934438	N	freshclam error:  52
3723	V	2016-02-18 06:10:16.389707	N	freshclam error:  52
3724	V	2016-02-18 07:13:16.77724	N	freshclam error:  52
3725	V	2016-02-18 08:18:17.384677	N	freshclam error:  52
3726	V	2016-02-18 09:11:47.075423	N	freshclam error:  52
3727	V	2016-02-18 10:19:17.650126	N	freshclam error:  52
3728	V	2016-02-18 11:17:47.02486	N	freshclam error:  52
3729	V	2016-02-18 12:13:17.1208	N	freshclam error:  52
3730	V	2016-02-18 13:13:17.354967	N	freshclam error:  52
3731	V	2016-02-18 14:13:17.670317	N	freshclam error:  52
3732	V	2016-02-18 15:16:16.764601	N	freshclam error:  52
3733	V	2016-02-18 16:13:17.184821	N	freshclam error:  52
3734	V	2016-02-18 17:13:17.385328	N	freshclam error:  52
3735	V	2016-02-18 18:13:16.859681	N	freshclam error:  52
3736	V	2016-02-18 19:10:16.429588	N	freshclam error:  52
3737	V	2016-02-18 20:10:16.214846	N	freshclam error:  52
3738	V	2016-02-18 21:10:17.070561	N	freshclam error:  52
3739	V	2016-02-18 22:13:17.235464	N	freshclam error:  52
3740	V	2016-02-18 23:10:16.970939	N	freshclam error:  52
3741	V	2016-02-19 00:10:18.809769	N	freshclam error:  52
3742	V	2016-02-19 01:10:17.579722	N	freshclam error:  52
3743	V	2016-02-19 02:16:17.405229	N	freshclam error:  52
3744	R	2016-02-19 03:05:00.446506	Y	0
3745	S	2016-02-19 03:07:28.032955	N	Cannot contact server
3746	F	2016-02-19 03:08:43.552628	N	Cannot contact ANY update server
3747	V	2016-02-19 03:13:16.969931	N	freshclam error:  52
3748	V	2016-02-19 04:10:16.744735	N	freshclam error:  52
3749	V	2016-02-19 05:13:17.791122	N	freshclam error:  52
3750	V	2016-02-19 06:13:17.054944	N	freshclam error:  52
3751	V	2016-02-19 07:16:17.069907	N	freshclam error:  52
3752	L	2016-02-19 08:07:47.448922	Y	admin
3753	V	2016-02-19 08:10:16.844755	N	freshclam error:  52
3754	V	2016-02-19 09:13:17.239763	N	freshclam error:  52
3755	V	2016-02-19 10:13:17.210555	N	freshclam error:  52
3756	V	2016-02-19 11:10:16.440285	N	freshclam error:  52
3757	V	2016-02-19 12:16:16.784912	N	freshclam error:  52
3758	V	2016-02-19 13:13:16.649757	N	freshclam error:  52
3759	V	2016-02-19 14:10:16.894443	N	freshclam error:  52
3760	V	2016-02-19 15:13:17.339812	N	freshclam error:  52
3761	V	2016-02-19 16:13:17.069578	N	freshclam error:  52
3762	V	2016-02-19 17:13:17.339976	N	freshclam error:  52
3763	V	2016-02-19 18:13:16.954788	N	freshclam error:  52
3764	V	2016-02-19 19:10:17.279877	N	freshclam error:  52
3765	V	2016-02-19 20:13:16.985159	N	freshclam error:  52
3766	V	2016-02-19 21:13:16.850736	N	freshclam error:  52
3767	V	2016-02-19 22:13:17.350231	N	freshclam error:  52
3768	V	2016-02-19 23:10:16.569899	N	freshclam error:  52
3769	V	2016-02-20 00:13:19.390153	N	freshclam error:  52
3770	V	2016-02-20 01:13:17.205506	N	freshclam error:  52
3771	V	2016-02-20 02:10:17.459957	N	freshclam error:  52
3772	R	2016-02-20 03:05:00.244027	Y	0
3773	S	2016-02-20 03:07:28.023126	N	Cannot contact server
3774	F	2016-02-20 03:08:43.512742	N	Cannot contact ANY update server
3775	V	2016-02-20 03:10:16.724963	N	freshclam error:  52
3776	V	2016-02-20 04:10:17.425185	N	freshclam error:  52
3777	V	2016-02-20 05:13:17.780276	N	freshclam error:  52
3778	V	2016-02-20 06:13:17.589588	N	freshclam error:  52
3779	V	2016-02-20 07:16:17.440289	N	freshclam error:  52
3780	V	2016-02-20 08:10:17.079599	N	freshclam error:  52
3781	V	2016-02-20 09:13:17.080181	N	freshclam error:  52
3782	V	2016-02-20 10:13:16.879759	N	freshclam error:  52
3783	V	2016-02-20 11:13:17.195083	N	freshclam error:  52
3784	V	2016-02-20 12:13:17.264595	N	freshclam error:  52
3785	V	2016-02-20 13:13:17.165363	N	freshclam error:  52
3786	V	2016-02-20 14:10:17.285141	N	freshclam error:  52
3787	V	2016-02-20 15:10:17.074997	N	freshclam error:  52
3788	V	2016-02-20 20:13:18.591288	N	freshclam error:  52
3789	V	2016-02-20 21:13:17.176174	N	freshclam error:  52
3790	V	2016-02-20 22:13:17.160834	N	freshclam error:  52
3791	V	2016-02-20 23:10:16.781504	N	freshclam error:  52
3792	V	2016-02-21 00:16:18.892238	N	freshclam error:  52
3793	V	2016-02-21 01:19:18.356808	N	freshclam error:  52
3794	V	2016-02-21 02:13:17.856937	N	freshclam error:  52
3795	R	2016-02-21 03:05:00.869975	Y	0
3796	V	2016-02-21 03:16:17.886328	N	freshclam error:  52
3797	S	2016-02-21 03:35:04.709627	N	Cannot contact server
3798	F	2016-02-21 03:36:20.214072	N	Cannot contact ANY update server
3799	V	2016-02-21 04:13:17.556598	N	freshclam error:  52
3800	V	2016-02-21 05:16:18.646219	N	freshclam error:  52
3801	V	2016-02-21 06:13:17.576676	N	freshclam error:  52
3802	V	2016-02-21 07:13:16.790198	N	freshclam error:  52
3803	V	2016-02-21 08:10:17.021124	N	freshclam error:  52
3804	V	2016-02-21 09:10:17.421271	N	freshclam error:  52
3805	V	2016-02-21 10:13:16.876591	N	freshclam error:  52
3806	V	2016-02-21 11:10:16.936011	N	freshclam error:  52
3807	V	2016-02-21 12:16:17.596579	N	freshclam error:  52
3808	V	2016-02-21 13:13:16.646509	N	freshclam error:  52
3809	V	2016-02-21 14:10:16.701373	N	freshclam error:  52
3810	V	2016-02-21 15:10:16.421891	N	freshclam error:  52
3811	V	2016-02-21 16:13:17.431077	N	freshclam error:  52
3812	V	2016-02-21 17:10:16.586057	N	freshclam error:  52
3813	V	2016-02-21 18:16:17.883164	N	freshclam error:  52
3814	V	2016-02-21 19:13:17.96783	N	freshclam error:  52
3815	V	2016-02-21 20:10:16.361211	N	freshclam error:  52
3816	V	2016-02-21 21:10:16.826394	N	freshclam error:  52
3817	V	2016-02-21 22:16:16.836289	N	freshclam error:  52
3818	V	2016-02-21 23:10:16.946335	N	freshclam error:  52
3819	V	2016-02-22 00:13:17.191888	N	freshclam error:  52
3820	V	2016-02-22 01:13:17.407365	N	freshclam error:  52
3821	V	2016-02-22 02:13:16.946094	N	freshclam error:  52
3822	R	2016-02-22 03:05:00.166355	Y	0
3823	S	2016-02-22 03:07:28.699641	N	Cannot contact server
3824	F	2016-02-22 03:08:44.224465	N	Cannot contact ANY update server
3825	V	2016-02-22 03:13:17.382879	N	freshclam error:  52
3826	V	2016-02-22 04:10:17.226112	N	freshclam error:  52
3827	V	2016-02-22 05:13:17.05185	N	freshclam error:  52
3828	V	2016-02-22 06:10:16.954168	N	freshclam error:  52
3829	V	2016-02-22 07:16:16.757394	N	freshclam error:  52
3830	V	2016-02-22 08:13:16.411351	N	freshclam error:  52
3831	V	2016-02-22 09:16:16.99616	N	freshclam error:  52
3832	V	2016-02-22 10:13:17.391324	N	freshclam error:  52
3833	V	2016-02-22 11:13:17.630707	N	freshclam error:  52
3834	V	2016-02-22 12:13:16.937031	N	freshclam error:  52
3835	V	2016-02-22 13:16:16.960883	N	freshclam error:  52
3836	V	2016-02-22 14:10:16.68623	N	freshclam error:  52
3837	V	2016-02-22 15:13:17.2009	N	freshclam error:  52
3838	V	2016-02-22 16:10:16.84121	N	freshclam error:  52
3839	V	2016-02-22 17:13:17.041778	N	freshclam error:  52
3840	V	2016-02-22 18:16:18.021383	N	freshclam error:  52
3841	V	2016-02-22 19:10:16.565861	N	freshclam error:  52
3842	V	2016-02-22 20:13:17.196226	N	freshclam error:  52
3843	V	2016-02-22 21:13:16.567893	N	freshclam error:  52
3844	V	2016-02-22 22:16:17.73126	N	freshclam error:  52
3845	V	2016-02-22 23:13:17.006487	N	freshclam error:  52
3846	V	2016-02-23 00:13:19.218111	N	freshclam error:  52
3847	V	2016-02-23 01:10:16.825838	N	freshclam error:  52
3848	V	2016-02-23 02:13:17.751625	N	freshclam error:  52
3849	R	2016-02-23 03:05:00.207123	Y	0
3850	S	2016-02-23 03:07:27.659716	N	Cannot contact server
3851	F	2016-02-23 03:08:43.174093	N	Cannot contact ANY update server
3852	V	2016-02-23 03:16:16.836476	N	freshclam error:  52
3853	V	2016-02-23 04:13:16.826607	N	freshclam error:  52
3854	V	2016-02-23 05:10:16.562866	N	freshclam error:  52
3855	V	2016-02-23 06:13:16.906616	N	freshclam error:  52
3856	V	2016-02-23 07:13:17.416313	N	freshclam error:  52
3857	V	2016-02-23 08:10:17.201842	N	freshclam error:  52
3858	V	2016-02-23 09:13:17.266757	N	freshclam error:  52
3859	V	2016-02-23 10:10:16.58634	N	freshclam error:  52
3860	V	2016-02-23 11:16:17.251776	N	freshclam error:  52
3861	V	2016-02-23 12:13:16.825925	N	freshclam error:  52
3862	V	2016-02-23 13:13:17.236507	N	freshclam error:  52
3863	V	2016-02-23 14:10:17.166321	N	freshclam error:  52
3864	V	2016-02-23 15:13:17.386693	N	freshclam error:  52
3865	V	2016-02-23 16:10:16.202155	N	freshclam error:  52
3866	V	2016-02-23 17:13:17.102978	N	freshclam error:  52
3867	V	2016-02-23 18:13:17.470875	N	freshclam error:  52
3868	V	2016-02-23 19:13:17.166234	N	freshclam error:  52
3869	V	2016-02-23 20:10:16.591075	N	freshclam error:  52
3870	V	2016-02-23 21:13:17.521579	N	freshclam error:  52
3871	V	2016-02-23 22:16:16.801758	N	freshclam error:  52
3872	V	2016-02-23 23:13:16.611682	N	freshclam error:  52
3873	V	2016-02-24 00:10:19.531052	N	freshclam error:  52
3874	V	2016-02-24 01:13:17.3964	N	freshclam error:  52
3875	V	2016-02-24 02:13:16.856766	N	freshclam error:  52
3876	R	2016-02-24 03:05:00.651908	Y	0
3877	S	2016-02-24 03:07:28.504515	N	Cannot contact server
3878	F	2016-02-24 03:08:43.949305	N	Cannot contact ANY update server
3879	V	2016-02-24 03:13:16.92207	N	freshclam error:  52
3880	V	2016-02-24 04:10:16.587742	N	freshclam error:  52
3881	V	2016-02-24 05:13:16.517274	N	freshclam error:  52
3882	V	2016-02-24 06:13:16.48642	N	freshclam error:  52
3883	V	2016-02-24 07:10:16.41625	N	freshclam error:  52
3884	L	2016-02-24 07:51:16.531288	Y	admin
3885	V	2016-02-24 08:10:16.750608	N	freshclam error:  52
3886	V	2016-02-24 09:10:16.986717	N	freshclam error:  52
3887	V	2016-02-24 10:10:16.957203	N	freshclam error:  52
3888	V	2016-02-24 11:13:17.405592	N	freshclam error:  52
3889	V	2016-02-24 12:13:16.766175	N	freshclam error:  52
3890	V	2016-02-24 13:10:17.286369	N	freshclam error:  52
3891	V	2016-02-24 14:13:17.140949	N	freshclam error:  52
3892	V	2016-02-24 15:13:17.351076	N	freshclam error:  52
3893	V	2016-02-24 16:13:17.060971	N	freshclam error:  52
3894	V	2016-02-24 17:04:11.907082	N	freshclam error:  58
3895	V	2016-02-24 18:10:16.7561	N	freshclam error:  52
3896	V	2016-02-24 19:13:16.66143	N	freshclam error:  52
3897	V	2016-02-24 20:13:17.027582	N	freshclam error:  52
3898	V	2016-02-24 21:13:16.716554	N	freshclam error:  52
3899	V	2016-02-24 22:10:16.77574	N	freshclam error:  52
3900	V	2016-02-24 23:04:11.392152	N	freshclam error:  58
3901	V	2016-02-25 00:13:18.866199	N	freshclam error:  52
3902	V	2016-02-25 01:10:17.160988	N	freshclam error:  52
3903	V	2016-02-25 02:13:16.617167	N	freshclam error:  52
3904	R	2016-02-25 03:05:01.128317	Y	0
3905	S	2016-02-25 03:07:28.730087	N	Cannot contact server
3906	F	2016-02-25 03:08:44.239322	N	Cannot contact ANY update server
3907	V	2016-02-25 03:10:17.041044	N	freshclam error:  52
3908	V	2016-02-25 04:13:17.07195	N	freshclam error:  52
3909	V	2016-02-25 05:13:16.861224	N	freshclam error:  52
3910	V	2016-02-25 06:16:17.515943	N	freshclam error:  52
3911	V	2016-02-25 07:13:16.896459	N	freshclam error:  52
3912	V	2016-02-25 08:13:17.316536	N	freshclam error:  52
3913	V	2016-02-25 09:13:16.801114	N	freshclam error:  52
3914	V	2016-02-25 10:13:17.410928	N	freshclam error:  52
3915	V	2016-02-25 11:16:17.591091	N	freshclam error:  52
3916	V	2016-02-25 12:16:17.086006	N	freshclam error:  52
3917	V	2016-02-25 13:13:16.96693	N	freshclam error:  52
3918	V	2016-02-25 14:13:17.441531	N	freshclam error:  52
3919	V	2016-02-25 15:16:16.571081	N	freshclam error:  52
3920	V	2016-02-25 16:13:16.506248	N	freshclam error:  52
3921	V	2016-02-25 17:13:17.286881	N	freshclam error:  52
3922	V	2016-02-25 18:13:17.341931	N	freshclam error:  52
3923	V	2016-02-25 19:13:17.367942	N	freshclam error:  52
3924	V	2016-02-25 20:13:16.971147	N	freshclam error:  52
3925	V	2016-02-25 21:13:16.577665	N	freshclam error:  52
3926	V	2016-02-25 22:13:17.756009	N	freshclam error:  52
3927	V	2016-02-25 23:10:16.706355	N	freshclam error:  52
3928	V	2016-02-26 00:10:19.541097	N	freshclam error:  52
3929	V	2016-02-26 01:13:17.60592	N	freshclam error:  52
3930	V	2016-02-26 02:16:17.64631	N	freshclam error:  52
3931	R	2016-02-26 03:05:00.179696	Y	0
3932	S	2016-02-26 03:07:28.399691	N	Cannot contact server
3933	F	2016-02-26 03:08:43.910071	N	Cannot contact ANY update server
3934	V	2016-02-26 03:16:17.521458	N	freshclam error:  52
3935	V	2016-02-26 04:13:16.841486	N	freshclam error:  52
3936	V	2016-02-26 05:10:17.356	N	freshclam error:  52
3937	V	2016-02-26 06:13:17.443863	N	freshclam error:  52
3938	V	2016-02-26 07:13:16.822046	N	freshclam error:  52
3939	V	2016-02-26 08:10:16.345961	N	freshclam error:  52
3940	L	2016-02-26 09:07:57.824026	Y	admin
3941	V	2016-02-26 09:13:16.682898	N	freshclam error:  52
3942	V	2016-02-26 10:10:16.886042	N	freshclam error:  52
3943	V	2016-02-26 11:19:17.186163	N	freshclam error:  52
3944	V	2016-02-26 12:13:17.192075	N	freshclam error:  52
3945	L	2016-02-26 12:52:59.825521	Y	admin
3946	V	2016-02-26 13:13:17.181089	N	freshclam error:  52
3947	V	2016-02-26 14:13:17.210945	N	freshclam error:  52
3948	V	2016-02-26 15:10:16.651059	N	freshclam error:  52
3949	V	2016-02-26 16:10:16.66085	N	freshclam error:  52
3950	V	2016-02-26 17:13:17.326819	N	freshclam error:  52
3951	V	2016-02-26 18:13:16.480986	N	freshclam error:  52
3952	V	2016-02-26 19:10:16.680725	N	freshclam error:  52
3953	V	2016-02-26 20:10:16.470824	N	freshclam error:  52
3954	V	2016-02-26 21:10:16.561231	N	freshclam error:  52
3955	V	2016-02-26 22:19:17.001464	N	freshclam error:  52
3956	V	2016-02-26 23:19:17.272513	N	freshclam error:  52
3957	V	2016-02-27 00:13:22.6861	N	freshclam error:  52
3958	V	2016-02-27 01:13:17.326016	N	freshclam error:  52
3959	V	2016-02-27 02:13:16.446761	N	freshclam error:  52
3960	R	2016-02-27 03:05:00.503211	Y	0
3961	S	2016-02-27 03:07:27.560309	N	Cannot contact server
3962	F	2016-02-27 03:08:43.029164	N	Cannot contact ANY update server
3963	V	2016-02-27 03:13:16.74748	N	freshclam error:  52
3964	V	2016-02-27 04:13:17.017557	N	freshclam error:  52
3965	V	2016-02-27 05:16:17.227627	N	freshclam error:  52
3966	V	2016-02-27 06:10:16.661042	N	freshclam error:  52
3967	V	2016-02-27 07:10:16.636319	N	freshclam error:  52
3968	V	2016-02-27 08:10:16.301499	N	freshclam error:  52
3969	V	2016-02-27 09:13:16.679054	N	freshclam error:  52
3970	V	2016-02-27 10:13:16.648076	N	freshclam error:  52
3971	V	2016-02-27 11:10:16.861286	N	freshclam error:  52
3972	V	2016-02-27 12:16:16.071249	N	freshclam error:  52
3973	V	2016-02-27 13:13:17.101572	N	freshclam error:  52
3974	V	2016-02-27 14:10:16.780994	N	freshclam error:  52
3975	V	2016-02-27 15:13:16.927078	N	freshclam error:  52
3976	V	2016-02-27 16:10:17.052126	N	freshclam error:  52
3977	V	2016-02-27 17:10:17.201594	N	freshclam error:  52
3978	V	2016-02-27 18:13:16.830901	N	freshclam error:  52
3979	V	2016-02-27 19:13:16.30691	N	freshclam error:  52
3980	V	2016-02-27 20:10:17.306571	N	freshclam error:  52
3981	V	2016-02-27 21:16:16.716608	N	freshclam error:  52
3982	V	2016-02-27 22:13:17.482677	N	freshclam error:  52
3983	V	2016-02-27 23:13:17.407004	N	freshclam error:  52
3984	V	2016-02-28 00:16:18.737613	N	freshclam error:  52
3985	V	2016-02-28 01:10:17.521183	N	freshclam error:  52
3986	V	2016-02-28 02:13:16.911458	N	freshclam error:  52
3987	R	2016-02-28 03:05:01.108777	Y	0
3988	S	2016-02-28 03:07:28.469554	N	Cannot contact server
3989	F	2016-02-28 03:08:44.004338	N	Cannot contact ANY update server
3990	V	2016-02-28 03:13:17.916522	N	freshclam error:  52
3991	V	2016-02-28 04:13:16.657275	N	freshclam error:  52
3992	V	2016-02-28 05:13:16.606677	N	freshclam error:  52
3993	V	2016-02-28 06:19:17.141731	N	freshclam error:  52
3994	V	2016-02-28 07:10:16.506008	N	freshclam error:  52
3995	V	2016-02-28 08:19:17.067415	N	freshclam error:  52
3996	V	2016-02-28 09:13:16.981683	N	freshclam error:  52
3997	V	2016-02-28 10:16:16.426544	N	freshclam error:  52
3998	V	2016-02-28 11:13:16.691033	N	freshclam error:  52
3999	V	2016-02-28 12:13:17.351035	N	freshclam error:  52
4000	V	2016-02-28 13:10:16.996332	N	freshclam error:  52
4001	V	2016-02-28 14:10:17.001083	N	freshclam error:  52
4002	V	2016-02-28 15:10:16.863383	N	freshclam error:  52
4003	V	2016-02-28 16:13:16.736573	N	freshclam error:  52
4004	V	2016-02-28 17:13:16.932765	N	freshclam error:  52
4005	V	2016-02-28 18:10:16.606325	N	freshclam error:  52
4006	V	2016-02-28 19:10:16.42662	N	freshclam error:  52
4007	V	2016-02-28 20:13:16.531867	N	freshclam error:  52
4008	V	2016-02-28 21:13:17.007532	N	freshclam error:  52
4009	V	2016-02-28 22:10:16.251102	N	freshclam error:  52
4010	V	2016-02-28 23:16:16.901805	N	freshclam error:  52
4011	V	2016-02-29 00:10:17.651351	N	freshclam error:  52
4012	V	2016-02-29 01:10:17.615466	N	freshclam error:  52
4013	V	2016-02-29 02:16:17.838491	N	freshclam error:  52
4014	R	2016-02-29 03:05:01.096311	Y	0
4015	V	2016-02-29 03:16:18.166463	N	freshclam error:  52
4016	S	2016-02-29 03:34:53.750238	N	Cannot contact server
4017	F	2016-02-29 03:36:09.279445	N	Cannot contact ANY update server
4018	V	2016-02-29 04:13:17.126166	N	freshclam error:  52
4019	V	2016-02-29 05:13:17.927476	N	freshclam error:  52
4020	V	2016-02-29 06:10:17.481584	N	freshclam error:  52
4021	V	2016-02-29 07:16:17.218313	N	freshclam error:  52
4022	L	2016-02-29 07:54:12.619131	Y	admin
4023	V	2016-02-29 08:10:17.275973	N	freshclam error:  52
4024	V	2016-02-29 09:13:16.826656	N	freshclam error:  52
4025	V	2016-02-29 10:16:17.130919	N	freshclam error:  52
4026	V	2016-02-29 11:13:17.91148	N	freshclam error:  52
4027	V	2016-02-29 12:10:16.401142	N	freshclam error:  52
4028	V	2016-02-29 13:16:17.096141	N	freshclam error:  52
4029	V	2016-02-29 14:10:16.916153	N	freshclam error:  52
4030	V	2016-02-29 15:13:16.971578	N	freshclam error:  52
4031	V	2016-02-29 16:10:16.636071	N	freshclam error:  52
4032	V	2016-02-29 17:16:16.141202	N	freshclam error:  52
4033	V	2016-02-29 18:13:17.3684	N	freshclam error:  52
4034	V	2016-02-29 19:10:16.924693	N	freshclam error:  52
4035	V	2016-02-29 20:10:16.44081	N	freshclam error:  52
4036	V	2016-02-29 21:10:16.991479	N	freshclam error:  52
4037	V	2016-02-29 22:10:16.711088	N	freshclam error:  52
4038	V	2016-02-29 23:10:16.356315	N	freshclam error:  52
4039	V	2016-03-01 00:13:18.492859	N	freshclam error:  52
4040	V	2016-03-01 01:16:18.376451	N	freshclam error:  52
4041	V	2016-03-01 02:10:17.466078	N	freshclam error:  52
4042	R	2016-03-01 03:05:01.13758	Y	0
4043	S	2016-03-01 03:07:28.719771	N	Cannot contact server
4044	F	2016-03-01 03:08:44.230071	N	Cannot contact ANY update server
4045	V	2016-03-01 03:10:17.155881	N	freshclam error:  52
4046	V	2016-03-01 04:13:17.672166	N	freshclam error:  52
4047	V	2016-03-01 05:10:16.956142	N	freshclam error:  52
4048	V	2016-03-01 06:13:17.411366	N	freshclam error:  52
4049	V	2016-03-01 07:13:16.746661	N	freshclam error:  52
4050	V	2016-03-01 08:13:16.746133	N	freshclam error:  52
4051	V	2016-03-01 09:13:17.721133	N	freshclam error:  52
4052	V	2016-03-01 10:13:17.242569	N	freshclam error:  52
4053	V	2016-03-01 11:13:17.165991	N	freshclam error:  52
4054	V	2016-03-01 12:13:16.747035	N	freshclam error:  52
4055	V	2016-03-01 13:10:16.270933	N	freshclam error:  52
4056	V	2016-03-01 14:13:16.756118	N	freshclam error:  52
4057	V	2016-03-01 15:10:16.666479	N	freshclam error:  52
4058	V	2016-03-01 16:13:16.726097	N	freshclam error:  52
4059	V	2016-03-01 17:10:16.872713	N	freshclam error:  52
4060	V	2016-03-01 18:13:16.841394	N	freshclam error:  52
4061	V	2016-03-01 19:13:16.761781	N	freshclam error:  52
4062	V	2016-03-01 20:16:17.056971	N	freshclam error:  52
4063	V	2016-03-01 21:10:16.501185	N	freshclam error:  52
4064	V	2016-03-01 22:10:16.556393	N	freshclam error:  52
4065	V	2016-03-01 23:10:17.297275	N	freshclam error:  52
4066	V	2016-03-02 00:13:17.980993	N	freshclam error:  52
4067	V	2016-03-02 01:10:18.256223	N	freshclam error:  52
4068	V	2016-03-02 02:10:17.316283	N	freshclam error:  52
4069	R	2016-03-02 03:05:00.834595	Y	0
4070	S	2016-03-02 03:07:28.744948	N	Cannot contact server
4071	F	2016-03-02 03:08:44.275159	N	Cannot contact ANY update server
4072	V	2016-03-02 03:13:16.951532	N	freshclam error:  52
4073	V	2016-03-02 04:16:17.306648	N	freshclam error:  52
4074	V	2016-03-02 05:10:16.86171	N	freshclam error:  52
4075	V	2016-03-02 06:13:17.371514	N	freshclam error:  52
4076	V	2016-03-02 07:13:17.136428	N	freshclam error:  52
4077	V	2016-03-02 08:13:17.127067	N	freshclam error:  52
4078	V	2016-03-02 09:10:17.266163	N	freshclam error:  52
4079	V	2016-03-02 10:19:17.087478	N	freshclam error:  52
4080	V	2016-03-02 11:13:16.595808	N	freshclam error:  52
4081	V	2016-03-02 12:13:16.501241	N	freshclam error:  52
4082	V	2016-03-02 13:10:17.081045	N	freshclam error:  52
4083	V	2016-03-02 14:10:16.781447	N	freshclam error:  52
4084	V	2016-03-02 15:13:16.592882	N	freshclam error:  52
4085	V	2016-03-02 16:10:17.126179	N	freshclam error:  52
4086	V	2016-03-02 17:10:16.981043	N	freshclam error:  52
4087	V	2016-03-02 18:10:16.91135	N	freshclam error:  52
4088	V	2016-03-02 19:13:17.226383	N	freshclam error:  52
4089	V	2016-03-02 20:16:17.586431	N	freshclam error:  52
4090	V	2016-03-02 21:13:16.781689	N	freshclam error:  52
4091	V	2016-03-02 22:16:16.276553	N	freshclam error:  52
4092	V	2016-03-02 23:13:17.056064	N	freshclam error:  52
4093	V	2016-03-03 00:10:17.62064	N	freshclam error:  52
4094	V	2016-03-03 01:19:18.046997	N	freshclam error:  52
4095	V	2016-03-03 02:10:17.612089	N	freshclam error:  52
4096	R	2016-03-03 03:05:00.274635	Y	0
4097	S	2016-03-03 03:07:27.730411	N	Cannot contact server
4098	F	2016-03-03 03:08:43.274262	N	Cannot contact ANY update server
4099	V	2016-03-03 03:16:17.074321	N	freshclam error:  52
4100	V	2016-03-03 04:13:17.496588	N	freshclam error:  52
4101	V	2016-03-03 05:10:17.341285	N	freshclam error:  52
4102	V	2016-03-03 06:13:17.31178	N	freshclam error:  52
4103	V	2016-03-03 07:10:16.976042	N	freshclam error:  52
4104	V	2016-03-03 08:13:17.902071	N	freshclam error:  52
4105	V	2016-03-03 09:16:17.211274	N	freshclam error:  52
4106	V	2016-03-03 10:13:17.007062	N	freshclam error:  52
4107	V	2016-03-03 11:13:17.016683	N	freshclam error:  52
4108	V	2016-03-03 12:10:17.021378	N	freshclam error:  52
4109	V	2016-03-03 13:13:16.956461	N	freshclam error:  52
4110	V	2016-03-03 14:10:17.162975	N	freshclam error:  52
4111	V	2016-03-03 15:10:50.821256	N	freshclam error:  52
4112	V	2016-03-03 16:13:17.146285	N	freshclam error:  52
4113	V	2016-03-03 17:13:17.221413	N	freshclam error:  52
4114	L	2016-03-03 17:38:41.114485	Y	admin
4115	V	2016-03-03 18:10:16.331055	N	freshclam error:  52
4116	V	2016-03-03 19:10:17.237762	N	freshclam error:  52
4117	V	2016-03-03 20:13:17.251533	N	freshclam error:  52
4118	V	2016-03-03 21:10:17.261023	N	freshclam error:  52
4119	V	2016-03-03 22:13:17.101258	N	freshclam error:  52
4120	V	2016-03-03 23:16:16.791371	N	freshclam error:  52
4121	V	2016-03-04 00:13:18.958468	N	freshclam error:  52
4122	V	2016-03-04 01:16:17.431779	N	freshclam error:  52
4123	V	2016-03-04 02:16:17.576355	N	freshclam error:  52
4124	R	2016-03-04 03:05:01.090067	Y	0
4125	S	2016-03-04 03:07:28.909821	N	Cannot contact server
4126	F	2016-03-04 03:08:44.360228	N	Cannot contact ANY update server
4127	V	2016-03-04 03:13:17.421965	N	freshclam error:  52
4128	V	2016-03-04 04:10:16.83101	N	freshclam error:  52
4129	V	2016-03-04 05:10:16.730936	N	freshclam error:  52
4130	V	2016-03-04 06:13:16.522448	N	freshclam error:  52
4131	V	2016-03-04 07:13:16.621746	N	freshclam error:  52
4132	V	2016-03-04 08:10:16.656371	N	freshclam error:  52
4133	V	2016-03-04 09:13:16.551246	N	freshclam error:  52
4134	V	2016-03-04 10:10:16.191116	N	freshclam error:  52
4135	V	2016-03-04 11:13:17.363259	N	freshclam error:  52
4136	V	2016-03-04 12:13:16.987531	N	freshclam error:  52
4137	V	2016-03-04 13:19:16.566464	N	freshclam error:  52
4138	V	2016-03-04 14:19:17.45207	N	freshclam error:  52
4139	V	2016-03-04 15:10:17.160789	N	freshclam error:  52
4140	V	2016-03-04 16:13:16.76151	N	freshclam error:  52
4141	V	2016-03-04 17:13:16.82209	N	freshclam error:  52
4142	V	2016-03-04 18:13:16.716311	N	freshclam error:  52
4143	V	2016-03-04 19:13:16.806672	N	freshclam error:  52
4144	V	2016-03-04 20:10:16.810798	N	freshclam error:  52
4145	V	2016-03-04 21:10:16.573946	N	freshclam error:  52
4146	V	2016-03-04 22:10:16.461162	N	freshclam error:  52
4147	V	2016-03-04 23:16:17.524398	N	freshclam error:  52
4148	V	2016-03-05 00:10:18.451619	N	freshclam error:  52
4149	V	2016-03-05 01:13:17.656854	N	freshclam error:  52
4150	V	2016-03-05 02:13:17.616933	N	freshclam error:  52
4151	R	2016-03-05 03:05:01.081637	Y	0
4152	S	2016-03-05 03:07:28.314928	N	Cannot contact server
4153	F	2016-03-05 03:08:43.824379	N	Cannot contact ANY update server
4154	V	2016-03-05 03:13:17.436915	N	freshclam error:  52
4155	V	2016-03-05 04:13:16.887317	N	freshclam error:  52
4156	V	2016-03-05 05:13:17.157242	N	freshclam error:  52
4157	V	2016-03-05 06:10:17.306552	N	freshclam error:  52
4158	V	2016-03-05 07:16:17.121387	N	freshclam error:  52
4159	V	2016-03-05 08:13:17.198013	N	freshclam error:  52
4160	V	2016-03-05 09:13:17.431951	N	freshclam error:  52
4161	V	2016-03-05 10:13:17.158186	N	freshclam error:  52
4162	V	2016-03-05 11:13:16.543083	N	freshclam error:  52
4163	V	2016-03-05 12:13:17.261775	N	freshclam error:  52
4164	V	2016-03-05 13:13:16.810947	N	freshclam error:  52
4165	V	2016-03-05 14:13:16.876537	N	freshclam error:  52
4166	V	2016-03-05 15:10:17.286276	N	freshclam error:  52
4167	V	2016-03-05 16:10:17.007309	N	freshclam error:  52
4168	V	2016-03-05 17:13:16.946931	N	freshclam error:  52
4169	V	2016-03-05 18:10:16.286485	N	freshclam error:  52
4170	V	2016-03-05 19:10:16.511181	N	freshclam error:  52
4171	V	2016-03-05 20:16:17.156424	N	freshclam error:  52
4172	V	2016-03-05 21:13:17.146551	N	freshclam error:  52
4173	V	2016-03-05 22:10:16.577453	N	freshclam error:  52
4174	V	2016-03-05 23:10:17.19217	N	freshclam error:  52
4175	V	2016-03-06 00:16:18.05102	N	freshclam error:  52
4176	V	2016-03-06 01:16:17.196102	N	freshclam error:  52
4177	V	2016-03-06 02:10:17.326389	N	freshclam error:  52
4178	R	2016-03-06 03:05:00.255282	Y	0
4179	S	2016-03-06 03:07:27.564529	N	Cannot contact server
4180	F	2016-03-06 03:08:43.074436	N	Cannot contact ANY update server
4181	V	2016-03-06 03:10:16.456117	N	freshclam error:  52
4182	V	2016-03-06 04:13:17.38299	N	freshclam error:  52
4183	V	2016-03-06 05:13:17.206885	N	freshclam error:  52
4184	V	2016-03-06 06:16:17.451566	N	freshclam error:  52
4185	V	2016-03-06 07:10:17.616109	N	freshclam error:  52
4186	V	2016-03-06 08:13:17.587238	N	freshclam error:  52
4187	V	2016-03-06 09:13:16.313127	N	freshclam error:  52
4188	V	2016-03-06 10:19:17.546883	N	freshclam error:  52
4189	V	2016-03-06 11:16:16.796401	N	freshclam error:  52
4190	V	2016-03-06 12:13:16.546356	N	freshclam error:  52
4191	V	2016-03-06 13:13:17.131307	N	freshclam error:  52
4192	V	2016-03-06 14:10:16.486587	N	freshclam error:  52
4193	V	2016-03-06 15:16:16.592815	N	freshclam error:  52
4194	V	2016-03-06 16:16:17.410861	N	freshclam error:  52
4195	V	2016-03-06 17:16:16.686401	N	freshclam error:  52
4196	V	2016-03-06 18:19:17.176623	N	freshclam error:  52
4197	V	2016-03-06 19:16:16.801447	N	freshclam error:  52
4198	V	2016-03-06 20:10:16.491159	N	freshclam error:  52
4199	V	2016-03-06 21:10:16.492684	N	freshclam error:  52
4200	V	2016-03-06 22:10:16.855965	N	freshclam error:  52
4201	V	2016-03-06 23:13:17.076084	N	freshclam error:  52
4202	V	2016-03-07 00:10:17.406133	N	freshclam error:  52
4203	V	2016-03-07 01:16:17.682117	N	freshclam error:  52
4204	V	2016-03-07 02:13:17.867871	N	freshclam error:  52
4205	R	2016-03-07 03:05:00.356101	Y	0
4206	S	2016-03-07 03:07:28.260299	N	Cannot contact server
4207	F	2016-03-07 03:08:43.784339	N	Cannot contact ANY update server
4208	V	2016-03-07 03:16:17.716414	N	freshclam error:  52
4209	V	2016-03-07 04:10:17.546055	N	freshclam error:  52
4210	V	2016-03-07 05:10:17.376031	N	freshclam error:  52
4211	V	2016-03-07 06:13:18.256151	N	freshclam error:  52
4212	V	2016-03-07 07:13:17.892457	N	freshclam error:  52
4213	V	2016-03-07 08:16:18.276668	N	freshclam error:  52
4214	V	2016-03-07 09:13:17.736967	N	freshclam error:  52
4215	L	2016-03-07 10:02:26.106345	Y	admin
4216	V	2016-03-07 10:16:16.621306	N	freshclam error:  52
4217	L	2016-03-07 10:32:42.275345	Y	admin
4218	V	2016-03-07 11:16:17.501019	N	freshclam error:  52
4219	V	2016-03-07 12:13:16.536246	N	freshclam error:  52
4220	V	2016-03-07 13:13:16.636211	N	freshclam error:  52
4221	L	2016-03-07 13:32:09.484563	Y	admin
4222	V	2016-03-07 14:13:16.332574	N	freshclam error:  52
4223	V	2016-03-07 15:13:17.25251	N	freshclam error:  52
4224	V	2016-03-07 16:10:16.356639	N	freshclam error:  52
4225	V	2016-03-07 17:13:20.661561	N	freshclam error:  52
4226	V	2016-03-07 18:13:16.64648	N	freshclam error:  52
4227	V	2016-03-07 19:10:16.766189	N	freshclam error:  52
4228	V	2016-03-07 20:13:16.435153	N	freshclam error:  52
4229	V	2016-03-07 21:16:17.032285	N	freshclam error:  52
4230	V	2016-03-07 22:13:17.19165	N	freshclam error:  52
4231	V	2016-03-07 23:19:17.047004	N	freshclam error:  52
4232	V	2016-03-08 00:16:18.392233	N	freshclam error:  52
4233	V	2016-03-08 01:16:18.32711	N	freshclam error:  52
4234	V	2016-03-08 02:13:18.067046	N	freshclam error:  52
4235	R	2016-03-08 03:05:00.155727	Y	0
4236	V	2016-03-08 03:13:17.89912	N	freshclam error:  52
4237	S	2016-03-08 03:34:53.589665	N	Cannot contact server
4238	F	2016-03-08 03:36:09.104341	N	Cannot contact ANY update server
4239	V	2016-03-08 04:10:17.456518	N	freshclam error:  52
4240	V	2016-03-08 05:16:17.136497	N	freshclam error:  52
4241	V	2016-03-08 06:13:17.146384	N	freshclam error:  52
4242	V	2016-03-08 07:13:16.866636	N	freshclam error:  52
4243	V	2016-03-08 08:13:16.751652	N	freshclam error:  52
4244	V	2016-03-08 09:16:17.222997	N	freshclam error:  52
4245	V	2016-03-08 10:13:16.606452	N	freshclam error:  52
4246	V	2016-03-08 11:10:16.361134	N	freshclam error:  52
4247	V	2016-03-08 12:10:16.33185	N	freshclam error:  52
4248	V	2016-03-08 13:13:17.136098	N	freshclam error:  52
4249	V	2016-03-08 14:10:15.906447	N	freshclam error:  52
4250	V	2016-03-08 15:13:16.670722	N	freshclam error:  52
4251	V	2016-03-08 16:13:16.241112	N	freshclam error:  52
4252	V	2016-03-08 17:10:16.091254	N	freshclam error:  52
4253	V	2016-03-08 18:10:16.730989	N	freshclam error:  52
4254	V	2016-03-08 19:13:17.276333	N	freshclam error:  52
4255	V	2016-03-08 20:16:16.814403	N	freshclam error:  52
4256	V	2016-03-08 21:16:16.786356	N	freshclam error:  52
4257	V	2016-03-08 22:13:17.151514	N	freshclam error:  52
4258	V	2016-03-08 23:13:16.336146	N	freshclam error:  52
4259	V	2016-03-09 00:13:18.781954	N	freshclam error:  52
4260	V	2016-03-09 01:10:16.751703	N	freshclam error:  52
4261	V	2016-03-09 02:16:17.031992	N	freshclam error:  52
4262	R	2016-03-09 03:05:00.772759	Y	0
4263	S	2016-03-09 03:07:28.420956	N	Cannot contact server
4264	F	2016-03-09 03:08:43.954388	N	Cannot contact ANY update server
4265	V	2016-03-09 03:13:16.921716	N	freshclam error:  52
4266	V	2016-03-09 04:13:17.336659	N	freshclam error:  52
4267	V	2016-03-09 05:10:17.011132	N	freshclam error:  52
4268	V	2016-03-09 06:13:17.227802	N	freshclam error:  52
4269	V	2016-03-09 07:13:16.397125	N	freshclam error:  52
4270	V	2016-03-09 08:10:16.916142	N	freshclam error:  52
4271	V	2016-03-09 09:16:17.390848	N	freshclam error:  52
4272	V	2016-03-09 10:10:17.15126	N	freshclam error:  52
4273	V	2016-03-09 11:10:16.785947	N	freshclam error:  52
4274	V	2016-03-09 12:10:16.746485	N	freshclam error:  52
4275	V	2016-03-09 13:16:16.608365	N	freshclam error:  52
4276	V	2016-03-09 14:13:17.186232	N	freshclam error:  52
4277	V	2016-03-09 15:10:17.070963	N	freshclam error:  52
4278	V	2016-03-09 16:13:16.95653	N	freshclam error:  52
4279	V	2016-03-09 17:16:16.436729	N	freshclam error:  52
4280	V	2016-03-09 18:10:18.335734	N	freshclam error:  52
4281	V	2016-03-09 19:10:16.150138	N	freshclam error:  52
4282	V	2016-03-09 20:13:17.625245	N	freshclam error:  52
4283	V	2016-03-09 21:13:16.126225	N	freshclam error:  52
4284	V	2016-03-09 22:10:17.635267	N	freshclam error:  52
4285	V	2016-03-09 23:13:16.615685	N	freshclam error:  52
4286	V	2016-03-10 00:10:19.380434	N	freshclam error:  52
4287	V	2016-03-10 01:13:17.035297	N	freshclam error:  52
4288	V	2016-03-10 02:13:18.260686	N	freshclam error:  52
4289	R	2016-03-10 03:05:00.463353	Y	0
4290	S	2016-03-10 03:07:38.928816	N	Cannot contact server
4291	F	2016-03-10 03:08:54.429362	N	Cannot contact ANY update server
4292	V	2016-03-10 03:13:17.070681	N	freshclam error:  52
4293	V	2016-03-10 04:10:16.996034	N	freshclam error:  52
4294	V	2016-03-10 05:13:17.721043	N	freshclam error:  52
4295	V	2016-03-10 06:10:17.350448	N	freshclam error:  52
4296	V	2016-03-10 07:13:16.825512	N	freshclam error:  52
4297	V	2016-03-10 08:10:16.15523	N	freshclam error:  52
4298	V	2016-03-10 09:13:16.670095	N	freshclam error:  52
4299	V	2016-03-10 10:10:16.045238	N	freshclam error:  52
4300	V	2016-03-10 11:10:16.511863	N	freshclam error:  52
4301	V	2016-03-10 12:10:17.230112	N	freshclam error:  52
4302	V	2016-03-10 13:13:17.155345	N	freshclam error:  52
4303	V	2016-03-10 14:13:16.735663	N	freshclam error:  52
4304	V	2016-03-10 15:13:16.845495	N	freshclam error:  52
4305	V	2016-03-10 16:16:17.270253	N	freshclam error:  52
4306	V	2016-03-10 17:13:16.715844	N	freshclam error:  52
4307	V	2016-03-10 18:13:17.00026	N	freshclam error:  52
4308	V	2016-03-10 19:10:16.375225	N	freshclam error:  52
4309	V	2016-03-10 20:16:17.325381	N	freshclam error:  52
4310	V	2016-03-10 21:10:16.905415	N	freshclam error:  52
4311	V	2016-03-10 22:10:17.066312	N	freshclam error:  52
4312	V	2016-03-10 23:13:16.585747	N	freshclam error:  52
4313	V	2016-03-11 00:13:18.716381	N	freshclam error:  52
4314	V	2016-03-11 01:10:17.400849	N	freshclam error:  52
4315	V	2016-03-11 02:10:17.380336	N	freshclam error:  52
4316	R	2016-03-11 03:05:00.443159	Y	0
4317	S	2016-03-11 03:07:28.193973	N	Cannot contact server
4318	F	2016-03-11 03:08:43.713428	N	Cannot contact ANY update server
4319	V	2016-03-11 03:13:16.556213	N	freshclam error:  52
4320	V	2016-03-11 04:13:17.25088	N	freshclam error:  52
4321	V	2016-03-11 05:13:17.836584	N	freshclam error:  52
4322	V	2016-03-11 06:16:17.155678	N	freshclam error:  52
4323	V	2016-03-11 07:16:17.150568	N	freshclam error:  52
4324	V	2016-03-11 08:13:16.19596	N	freshclam error:  52
4325	V	2016-03-11 09:13:17.250929	N	freshclam error:  52
4326	V	2016-03-11 10:10:16.45732	N	freshclam error:  52
4327	V	2016-03-11 11:16:17.220282	N	freshclam error:  52
4328	V	2016-03-11 12:10:16.880126	N	freshclam error:  52
4329	V	2016-03-11 13:13:17.110647	N	freshclam error:  52
4330	V	2016-03-11 14:13:16.650474	N	freshclam error:  52
4331	V	2016-03-11 15:13:16.920551	N	freshclam error:  52
4332	V	2016-03-11 16:13:16.770724	N	freshclam error:  52
4333	V	2016-03-11 17:13:16.825006	N	freshclam error:  52
4334	V	2016-03-11 18:13:16.95	N	freshclam error:  52
4335	V	2016-03-11 19:10:17.110857	N	freshclam error:  52
4336	V	2016-03-11 20:13:17.055964	N	freshclam error:  52
4337	V	2016-03-11 21:10:16.69181	N	freshclam error:  52
4338	V	2016-03-11 22:16:17.500846	N	freshclam error:  52
4339	V	2016-03-11 23:13:17.270627	N	freshclam error:  52
4340	V	2016-03-12 00:13:17.861018	N	freshclam error:  52
4341	V	2016-03-12 01:13:17.57044	N	freshclam error:  52
4342	V	2016-03-12 02:13:17.600736	N	freshclam error:  52
4343	R	2016-03-12 03:05:00.187336	Y	0
4344	S	2016-03-12 03:07:28.424087	N	Cannot contact server
4345	F	2016-03-12 03:08:43.933704	N	Cannot contact ANY update server
4346	V	2016-03-12 03:13:17.74578	N	freshclam error:  52
4347	V	2016-03-12 04:13:17.165791	N	freshclam error:  52
4348	V	2016-03-12 05:13:17.071873	N	freshclam error:  52
4349	V	2016-03-12 06:16:17.691076	N	freshclam error:  52
4350	V	2016-03-12 07:10:17.520499	N	freshclam error:  52
4351	V	2016-03-12 08:13:17.906482	N	freshclam error:  52
4352	V	2016-03-12 09:13:17.031195	N	freshclam error:  52
4353	V	2016-03-12 10:13:17.166118	N	freshclam error:  52
4354	V	2016-03-12 11:16:16.870485	N	freshclam error:  52
4355	V	2016-03-12 12:10:16.49498	N	freshclam error:  52
4356	V	2016-03-12 13:16:17.096289	N	freshclam error:  52
4357	V	2016-03-12 14:10:17.160901	N	freshclam error:  52
4358	V	2016-03-12 15:10:16.290721	N	freshclam error:  52
4359	V	2016-03-12 16:10:17.095407	N	freshclam error:  52
4360	V	2016-03-12 17:13:17.065405	N	freshclam error:  52
4361	V	2016-03-12 18:16:16.546332	N	freshclam error:  52
4362	V	2016-03-12 19:16:16.385616	N	freshclam error:  52
4363	V	2016-03-12 20:13:16.535461	N	freshclam error:  52
4364	V	2016-03-12 21:10:16.291954	N	freshclam error:  52
4365	V	2016-03-12 22:13:16.441096	N	freshclam error:  52
4366	V	2016-03-12 23:13:17.140617	N	freshclam error:  52
4367	V	2016-03-13 00:13:17.946096	N	freshclam error:  52
4368	V	2016-03-13 01:10:17.425774	N	freshclam error:  52
4369	V	2016-03-13 02:13:18.015968	N	freshclam error:  52
4370	R	2016-03-13 03:05:00.639926	Y	0
4371	R	2016-03-14 03:05:00.647418	Y	0
4372	L	2016-03-14 14:20:31.229659	Y	admin
4373	R	2016-03-15 03:05:00.288746	Y	0
4374	L	2016-03-15 09:28:54.893638	Y	admin
4375	R	2016-03-16 03:05:00.934608	Y	0
4376	L	2016-03-16 12:20:14.546399	Y	admin
4377	L	2016-03-16 15:49:09.528578	Y	admin
\.


--
-- Data for Name: tls; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY tls (id, domain, comment, lastmodified, policy) FROM stdin;
\.


--
-- Data for Name: transport; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY transport (id, domain, transport, ldap_server, ldap_port, ldap_anon, ldap_username, ldap_password, ldap_filter, ldap_attribute, ldap_sb, vrfy_action, vrfy_host, vrfy_alias, regex_rcpt, destination, realm_id, reverse_domain, rbl_checks) FROM stdin;
1	14demarzo.fin.ec	relay:[192.0.0.3]	\N	379	N	\N	\N	\N	\N	\N	DUNNO		N	f		\N	ec.fin.14demarzo	rbl_checks
\.


--
-- Data for Name: user_roles; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY user_roles (user_id, role_id) FROM stdin;
2	1
5	7
6	7
7	7
8	7
9	7
10	7
11	7
12	7
13	7
\.


--
-- Data for Name: userrules; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY userrules (id, pattern, comment, type, lastmodified, score, active) FROM stdin;
2	/(To):.greis_maybe@.*\\.hotmail\\.com/	Hotmail II	2	2014-12-19 16:33:55	100	t
1	/greis_maybe/	BLOQUE DE SALIDA	5	2015-07-28 18:26:50	100	f
\.


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY users (id, mailbox_id, priority, policy_id, email, fullname, user_name, user_level, report_date, password, domain) FROM stdin;
1	0	1	1	@.	Global Match	default	S	2008-01-01 00:00:00	\N	\N
2	2	0	1	admin	Administrator	admin	S	2008-01-01 00:00:00	f3c4576f0eb4a89c1d3a53472f118dfd	\N
4	0	4	2	@14demarzo.fin.ec		14demarzo.fin.ec	U	1969-12-31 19:00:00	d41d8cd98f00b204e9800998ecf8427e	\N
5	0	14	3	vsuquillo@14demarzo.fin.ec		vsuquillo@14demarzo.fin.ec	U	1969-12-31 19:00:00	b8f3cfa09accbdfd2439a72206c11f82	14demarzo.fin.ec
6	0	14	4	coactextil@14demarzo.fin.ec		coactextil@14demarzo.fin.ec	U	1969-12-31 19:00:00	799fb139c081d9ec87d7aecaa3c7b6d8	14demarzo.fin.ec
7	0	14	5	jllumiquinga@14demarzo.fin.ec		jllumiquinga@14demarzo.fin.ec	U	1969-12-31 19:00:00	d8029cf05d62aac18886206ddfdd2d26	14demarzo.fin.ec
8	0	14	6	dcorrea@14demarzo.fin.ec		dcorrea@14demarzo.fin.ec	U	1969-12-31 19:00:00	5345d1b2aaba5c1250e24251485d8db4	14demarzo.fin.ec
9	0	14	7	ecarrera@14demarzo.fin.ec		ecarrera@14demarzo.fin.ec	U	1969-12-31 19:00:00	45c7541411fb29affd3548c02ca61378	14demarzo.fin.ec
11	0	14	9	respin@14demarzo.fin.ec		respin@14demarzo.fin.ec	U	1969-12-31 19:00:00	07b8e0df76c242a22b51c3a3c3798acf	14demarzo.fin.ec
10	0	14	8	mandrade@14demarzo.fin.ec		mandrade@14demarzo.fin.ec	U	1969-12-31 19:00:00	e334bb9247e8802f5400bb852830b843	14demarzo.fin.ec
12	0	14	10	hgongora@14demarzo.fin.ec		hgongora@14demarzo.fin.ec	U	1969-12-31 19:00:00	767b0866de342b0a4f0f45c451359730	14demarzo.fin.ec
13	0	14	11	jespinosa@14demarzo.fin.ec		jespinosa@14demarzo.fin.ec	U	1969-12-31 19:00:00	b89c3960886c4f12e21abefd30224021	14demarzo.fin.ec
\.


--
-- Data for Name: virus_scanners; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY virus_scanners (id, name, shortname) FROM stdin;
1	Clam AntiVirus	C
2	Kaspersky AntiVirus	K
4	NAI McAfee VirusScan	M
3	Clam AntiVirus/Kaspersky AntiVirus	CK
5	Clam AntiVirus/NAI McAfee VirusScan	CN
6	Kaspersky AntiVirus/NAI McAfee VirusScan	KN
7	Clam AntiVirus/Kaspersky AntiVirus/NAI McAfee VirusScan	CKN
8	BitDefender	B
9	Clam AntiVirus/BitDefender	CB
\.


--
-- Data for Name: viruses; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY viruses (id, virus_name) FROM stdin;
1	UDS:DangerousObject.Multi.Generic
2	Backdoor.Win32.NetWiredRC.aeq
3	Backdoor.Java.Adwind.y
4	Trojan.Win32.Agent.netnrg
5	Trojan.Win32.Agent.netndw
6	Trojan.Win32.Agent.ihpl
7	Trojan.Win32.Agent.netpod
8	Trojan.Win32.Tinba.aeqg
9	Trojan.Win32.Tinba.ahbi
10	Trojan.Win32.Tinba.afsh
11	Trojan.Win32.Tinba.aduo
12	Trojan.Win32.Bayrob.cgh
13	Trojan.Win32.Agent.netrie
14	Trojan.Win32.Bayrob.etz
15	Trojan.Win32.Bayrob.olo
16	Trojan.Win32.Bayrob.nhm
17	Trojan.Win32.Bayrob.jst
18	Trojan.Win32.Bayrob.qjh
19	HEUR:Trojan.Win32.Generic
20	not-a-virus:HEUR:AdWare.Win32.Generic
\.


--
-- Data for Name: wblist; Type: TABLE DATA; Schema: public; Owner: pgsql
--

COPY wblist (rid, sid, wb, comment, lastmodified, id) FROM stdin;
5	1	W		2014-12-08 10:57:01	1
6	1	W		2014-12-08 10:57:02	2
7	1	W		2014-12-08 10:57:02	3
8	1	W		2014-12-08 10:57:03	4
9	1	W		2014-12-08 10:57:03	5
1	2	W	Banco Central	2014-12-08 10:58:55	6
1	3	W	Aero Seguros	2014-12-12 12:18:48	7
1	4	B	cuenta jespinosa	2014-12-15 15:54:23	8
1	5	B	vromero	2014-12-19 14:52:59	9
1	6	B	vromero	2014-12-19 14:54:17	10
1	7	W	Facilito	2014-12-23 14:05:39	11
1	10	W	Cooperativa	2015-03-27 09:41:57	15
11	9	W		2015-02-24 18:14:56	13
5	9	W		2015-02-24 18:14:56	14
7	9	W		2015-04-06 12:38:37	16
1	11	W	CONSEP	2015-04-08 11:58:37	17
1	12	W	Cosede	2015-04-14 07:44:04	18
1	13	W	UAF	2015-05-14 09:46:57	19
1	14	W	PERSONAL HGONGORA	2015-05-19 12:30:07	20
1	15	B	web master	2015-05-19 12:51:49	21
12	16	W		2015-05-19 13:05:48	22
1	22	W	El Comercio solciita PHUACHO	2015-06-12 15:57:08	30
13	9	W		2015-06-01 12:10:44	24
1	17	W	correo que es enviado como spam	2015-06-11 07:59:05	25
1	18	B	Oferta millonaria	2015-06-11 08:01:15	26
1	19	B	webmaster	2015-06-11 08:06:04	27
1	20	B	webmaster	2015-06-11 08:06:17	28
1	21	B	wpaucar	2015-06-11 08:07:00	29
1	23	B	publicidad	2015-06-30 16:17:06	31
1	24	W	correo Talento Humano	2015-07-02 11:51:34	32
1	25	W	Polygraph	2015-07-02 11:53:09	33
1	26	B	SPAM	2015-07-08 07:17:34	34
1	27	B	Oferta Spam	2015-07-08 07:18:12	35
5	28	W		2015-08-04 10:31:36	36
1	29	B	publicidad	2015-09-03 16:22:31	37
1	30	B	Publicidad	2015-09-03 16:22:48	38
1	31	B	cuenta spam	2015-09-08 13:37:46	39
1	32	B	cuenta spam	2015-09-08 13:38:04	40
1	33	B	mail spam	2015-09-08 13:39:13	41
1	34	B	mail spam	2015-09-08 13:39:22	42
1	35	B	spam	2015-09-30 18:17:47	43
1	36	B	spam	2015-09-30 18:18:04	44
1	37	B	publicidad	2015-10-01 09:48:38	45
1	38	B	publicidad	2015-10-01 09:48:49	46
1	39	B	publicidad	2015-10-01 09:49:58	47
1	40	B	publicidad	2015-10-01 09:50:09	48
1	41	B	publicidad	2015-10-05 08:49:49	49
1	42	B	publicidad	2015-10-05 08:50:01	50
1	43	B	publicidad	2015-10-05 08:50:52	51
1	44	B	publicidad	2015-10-05 08:51:00	52
1	45	B	publicidad	2015-10-07 10:57:40	53
1	46	B	spam	2015-10-14 08:59:55	54
1	47	B	spam	2015-10-14 09:00:09	55
1	48	B	spam	2015-11-19 14:54:22	56
1	49	B	spam	2015-11-19 14:54:35	57
1	50	B	spam	2015-11-30 12:26:14	58
1	51	B	spam	2015-11-30 12:26:33	59
1	52	B	publicidad	2016-01-11 08:12:43	60
1	53	B	spam	2016-01-12 08:06:00	61
1	54	B	spam	2016-01-12 08:06:43	62
1	55	B	publicidad	2016-01-29 08:30:33	63
1	56	B	publicidad	2016-01-29 08:30:46	64
1	57	B	mails publicidad	2016-02-02 08:24:16	65
1	58	B	mail  publicidad	2016-02-02 08:24:32	66
1	59	B	publicidad	2016-02-04 14:41:19	67
1	60	B	publicidad	2016-02-04 14:41:33	68
1	61	B	spam	2016-02-12 08:32:51	69
1	62	B	spam	2016-02-17 08:06:21	70
1	63	B	spam	2016-02-17 08:06:33	71
1	64	B	spam	2016-02-19 08:08:08	72
1	65	B	publicidad	2016-02-24 07:51:37	73
1	66	B	publicidad	2016-02-24 07:52:12	74
1	67	B	spam	2016-02-26 09:08:15	75
1	68	B	spam	2016-02-26 12:53:23	76
1	69	B	publicidad	2016-02-29 07:55:10	77
1	70	B	publicidad	2016-02-29 07:56:00	78
1	71	B	publicidad	2016-02-29 07:56:47	79
1	72	B	spam	2016-03-03 17:38:56	80
1	73	B	publicidad	2016-03-07 10:02:40	81
1	74	B	spam	2016-03-07 10:07:02	82
1	75	B	spam	2016-03-07 13:32:24	83
\.


--
-- Name: attachment_filters_name_type_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY attachment_filters
    ADD CONSTRAINT attachment_filters_name_type_key UNIQUE (name, type);


--
-- Name: auth_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY auth
    ADD CONSTRAINT auth_pkey PRIMARY KEY (domain);


--
-- Name: contentfilters_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY contentfilters
    ADD CONSTRAINT contentfilters_name_key UNIQUE (name);


--
-- Name: domain_admins_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY domain_admins
    ADD CONSTRAINT domain_admins_pkey PRIMARY KEY (domain_id, admin_id);


--
-- Name: domain_stats_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY domain_stats
    ADD CONSTRAINT domain_stats_pkey PRIMARY KEY (id);


--
-- Name: helo_access_hostname_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY helo_access
    ADD CONSTRAINT helo_access_hostname_key UNIQUE (hostname);


--
-- Name: ipaliases_ipnetwork_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY ipaliases
    ADD CONSTRAINT ipaliases_ipnetwork_key UNIQUE (ipnetwork);


--
-- Name: ippool_members_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY ippool_members
    ADD CONSTRAINT ippool_members_pkey PRIMARY KEY (id);


--
-- Name: ippools_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY ippools
    ADD CONSTRAINT ippools_name_key UNIQUE (name);


--
-- Name: ippools_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY ippools
    ADD CONSTRAINT ippools_pkey PRIMARY KEY (id);


--
-- Name: mailaddr_email_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY mailaddr
    ADD CONSTRAINT mailaddr_email_key UNIQUE (email);


--
-- Name: mailaddr_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY mailaddr
    ADD CONSTRAINT mailaddr_pkey PRIMARY KEY (id);


--
-- Name: mynetworks_cidr_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY mynetworks
    ADD CONSTRAINT mynetworks_cidr_key UNIQUE (cidr);


--
-- Name: netip_cidr_section_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY netip
    ADD CONSTRAINT netip_cidr_section_key UNIQUE (cidr, section);


--
-- Name: permissions_menu_url_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY permissions
    ADD CONSTRAINT permissions_menu_url_key UNIQUE (menu, url);


--
-- Name: permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY permissions
    ADD CONSTRAINT permissions_pkey PRIMARY KEY (id);


--
-- Name: policy_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policy
    ADD CONSTRAINT policy_pkey PRIMARY KEY (id);


--
-- Name: policy_policy_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY policy
    ADD CONSTRAINT policy_policy_name_key UNIQUE (policy_name);


--
-- Name: rbls_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY rbls
    ADD CONSTRAINT rbls_pkey PRIMARY KEY (id);


--
-- Name: realm_admins_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY realm_admins
    ADD CONSTRAINT realm_admins_pkey PRIMARY KEY (user_id, realm_id);


--
-- Name: realms_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY realms
    ADD CONSTRAINT realms_name_key UNIQUE (name);


--
-- Name: realms_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY realms
    ADD CONSTRAINT realms_pkey PRIMARY KEY (id);


--
-- Name: recipients_email_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY recipients
    ADD CONSTRAINT recipients_email_key UNIQUE (email);


--
-- Name: reports_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY reports
    ADD CONSTRAINT reports_pkey PRIMARY KEY (id);


--
-- Name: role_perms_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY role_perms
    ADD CONSTRAINT role_perms_pkey PRIMARY KEY (role_id, perm_id);


--
-- Name: roles_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY roles
    ADD CONSTRAINT roles_name_key UNIQUE (name);


--
-- Name: roles_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- Name: rulesets_name_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY rulesets
    ADD CONSTRAINT rulesets_name_key UNIQUE (name);


--
-- Name: rulesets_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY rulesets
    ADD CONSTRAINT rulesets_pkey PRIMARY KEY (id);


--
-- Name: scrubber_config_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY scrubber_config
    ADD CONSTRAINT scrubber_config_pkey PRIMARY KEY (id);


--
-- Name: sender_transport_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY sender_transport
    ADD CONSTRAINT sender_transport_pkey PRIMARY KEY (id);


--
-- Name: smarthosts_sender_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY smarthosts
    ADD CONSTRAINT smarthosts_sender_key UNIQUE (sender);


--
-- Name: spamstats_node_id_logdate_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY spamstats
    ADD CONSTRAINT spamstats_node_id_logdate_key UNIQUE (node_id, logdate);


--
-- Name: spamstats_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY spamstats
    ADD CONSTRAINT spamstats_pkey PRIMARY KEY (id);


--
-- Name: staticroutes_ipnetwork_gateway_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY staticroutes
    ADD CONSTRAINT staticroutes_ipnetwork_gateway_key UNIQUE (ipnetwork, gateway);


--
-- Name: stats_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY stats
    ADD CONSTRAINT stats_pkey PRIMARY KEY (id);


--
-- Name: tls_domain_key; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY tls
    ADD CONSTRAINT tls_domain_key UNIQUE (domain);


--
-- Name: transport_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY transport
    ADD CONSTRAINT transport_pkey PRIMARY KEY (id);


--
-- Name: user_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY user_roles
    ADD CONSTRAINT user_roles_pkey PRIMARY KEY (user_id, role_id);


--
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: virus_scanners_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY virus_scanners
    ADD CONSTRAINT virus_scanners_pkey PRIMARY KEY (id);


--
-- Name: viruses_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY viruses
    ADD CONSTRAINT viruses_pkey PRIMARY KEY (id);


--
-- Name: wblist_pkey; Type: CONSTRAINT; Schema: public; Owner: pgsql; Tablespace: 
--

ALTER TABLE ONLY wblist
    ADD CONSTRAINT wblist_pkey PRIMARY KEY (rid, sid);


--
-- Name: email; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX email ON mailaddr USING btree (email);


--
-- Name: id; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX id ON stats USING btree (id);


--
-- Name: logdate_idx; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX logdate_idx ON domain_stats USING btree (logdate);


--
-- Name: policy_name; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX policy_name ON policy USING btree (policy_name);


--
-- Name: rbl_name; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX rbl_name ON rbls USING btree (rbl_name);


--
-- Name: recipients_idx_domain; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX recipients_idx_domain ON recipients USING btree (domain);


--
-- Name: reverse_domain_idx; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX reverse_domain_idx ON transport USING btree (reverse_domain);


--
-- Name: roles_type_idx; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX roles_type_idx ON roles USING btree (type);


--
-- Name: sender_transport_domain_idx; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX sender_transport_domain_idx ON sender_transport USING btree (domain);


--
-- Name: transport_idx_domain; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE UNIQUE INDEX transport_idx_domain ON transport USING btree (domain);


--
-- Name: users_domain_idx; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX users_domain_idx ON users USING btree (domain);


--
-- Name: users_idx_email; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE UNIQUE INDEX users_idx_email ON users USING btree (email);


--
-- Name: virus_name; Type: INDEX; Schema: public; Owner: pgsql; Tablespace: 
--

CREATE INDEX virus_name ON viruses USING btree (virus_name);


--
-- Name: domain_admins_admin_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY domain_admins
    ADD CONSTRAINT domain_admins_admin_id_fkey FOREIGN KEY (admin_id) REFERENCES users(id) ON DELETE CASCADE;


--
-- Name: domain_admins_domain_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY domain_admins
    ADD CONSTRAINT domain_admins_domain_id_fkey FOREIGN KEY (domain_id) REFERENCES transport(id) ON DELETE CASCADE;


--
-- Name: domain_admins_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY domain_admins
    ADD CONSTRAINT domain_admins_role_id_fkey FOREIGN KEY (role_id) REFERENCES roles(id);


--
-- Name: ippool_members_poolname_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY ippool_members
    ADD CONSTRAINT ippool_members_poolname_fkey FOREIGN KEY (poolname) REFERENCES ippools(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: realm_admins_realm_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY realm_admins
    ADD CONSTRAINT realm_admins_realm_id_fkey FOREIGN KEY (realm_id) REFERENCES realms(id) ON DELETE CASCADE;


--
-- Name: realm_admins_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY realm_admins
    ADD CONSTRAINT realm_admins_role_id_fkey FOREIGN KEY (role_id) REFERENCES roles(id);


--
-- Name: realm_admins_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY realm_admins
    ADD CONSTRAINT realm_admins_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE;


--
-- Name: role_perms_perm_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY role_perms
    ADD CONSTRAINT role_perms_perm_id_fkey FOREIGN KEY (perm_id) REFERENCES permissions(id) ON DELETE CASCADE;


--
-- Name: role_perms_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY role_perms
    ADD CONSTRAINT role_perms_role_id_fkey FOREIGN KEY (role_id) REFERENCES roles(id) ON DELETE CASCADE;


--
-- Name: roles_owner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY roles
    ADD CONSTRAINT roles_owner_id_fkey FOREIGN KEY (owner_id) REFERENCES users(id) ON DELETE SET NULL;


--
-- Name: sender_transport_poolid_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY sender_transport
    ADD CONSTRAINT sender_transport_poolid_fkey FOREIGN KEY (poolid) REFERENCES ippools(id) ON DELETE CASCADE;


--
-- Name: transport_realm_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY transport
    ADD CONSTRAINT transport_realm_id_fkey FOREIGN KEY (realm_id) REFERENCES realms(id) ON DELETE SET NULL;


--
-- Name: user_roles_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY user_roles
    ADD CONSTRAINT user_roles_role_id_fkey FOREIGN KEY (role_id) REFERENCES roles(id);


--
-- Name: user_roles_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY user_roles
    ADD CONSTRAINT user_roles_user_id_fkey FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE;


--
-- Name: users_policy_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: pgsql
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_policy_id_fkey FOREIGN KEY (policy_id) REFERENCES policy(id);


--
-- Name: attachment_filters; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE attachment_filters FROM PUBLIC;
REVOKE ALL ON TABLE attachment_filters FROM pgsql;
GRANT ALL ON TABLE attachment_filters TO pgsql;
GRANT ALL ON TABLE attachment_filters TO amavisd;


--
-- Name: attachment_filters_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE attachment_filters_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE attachment_filters_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE attachment_filters_id_seq TO pgsql;
GRANT ALL ON SEQUENCE attachment_filters_id_seq TO amavisd;


--
-- Name: auth; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE auth FROM PUBLIC;
REVOKE ALL ON TABLE auth FROM pgsql;
GRANT ALL ON TABLE auth TO pgsql;
GRANT ALL ON TABLE auth TO amavisd;


--
-- Name: contentfilters; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE contentfilters FROM PUBLIC;
REVOKE ALL ON TABLE contentfilters FROM pgsql;
GRANT ALL ON TABLE contentfilters TO pgsql;
GRANT ALL ON TABLE contentfilters TO amavisd;


--
-- Name: contentfilters_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE contentfilters_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE contentfilters_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE contentfilters_id_seq TO pgsql;
GRANT ALL ON SEQUENCE contentfilters_id_seq TO amavisd;


--
-- Name: domain_admins; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE domain_admins FROM PUBLIC;
REVOKE ALL ON TABLE domain_admins FROM pgsql;
GRANT ALL ON TABLE domain_admins TO pgsql;
GRANT ALL ON TABLE domain_admins TO amavisd;


--
-- Name: domain_stats; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE domain_stats FROM PUBLIC;
REVOKE ALL ON TABLE domain_stats FROM pgsql;
GRANT ALL ON TABLE domain_stats TO pgsql;
GRANT ALL ON TABLE domain_stats TO amavisd;


--
-- Name: domain_stats_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE domain_stats_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE domain_stats_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE domain_stats_id_seq TO pgsql;
GRANT ALL ON SEQUENCE domain_stats_id_seq TO amavisd;


--
-- Name: helo_access; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE helo_access FROM PUBLIC;
REVOKE ALL ON TABLE helo_access FROM pgsql;
GRANT ALL ON TABLE helo_access TO pgsql;
GRANT ALL ON TABLE helo_access TO amavisd;


--
-- Name: helo_access_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE helo_access_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE helo_access_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE helo_access_id_seq TO pgsql;
GRANT ALL ON SEQUENCE helo_access_id_seq TO amavisd;


--
-- Name: ipaliases; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE ipaliases FROM PUBLIC;
REVOKE ALL ON TABLE ipaliases FROM pgsql;
GRANT ALL ON TABLE ipaliases TO pgsql;
GRANT ALL ON TABLE ipaliases TO amavisd;


--
-- Name: ipaliases_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE ipaliases_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ipaliases_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE ipaliases_id_seq TO pgsql;
GRANT ALL ON SEQUENCE ipaliases_id_seq TO amavisd;


--
-- Name: ippool_members; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE ippool_members FROM PUBLIC;
REVOKE ALL ON TABLE ippool_members FROM pgsql;
GRANT ALL ON TABLE ippool_members TO pgsql;
GRANT ALL ON TABLE ippool_members TO amavisd;


--
-- Name: ippool_members_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE ippool_members_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ippool_members_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE ippool_members_id_seq TO pgsql;
GRANT ALL ON SEQUENCE ippool_members_id_seq TO amavisd;


--
-- Name: ippools; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE ippools FROM PUBLIC;
REVOKE ALL ON TABLE ippools FROM pgsql;
GRANT ALL ON TABLE ippools TO pgsql;
GRANT ALL ON TABLE ippools TO amavisd;


--
-- Name: ippools_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE ippools_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ippools_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE ippools_id_seq TO pgsql;
GRANT ALL ON SEQUENCE ippools_id_seq TO amavisd;


--
-- Name: mailaddr; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE mailaddr FROM PUBLIC;
REVOKE ALL ON TABLE mailaddr FROM pgsql;
GRANT ALL ON TABLE mailaddr TO pgsql;
GRANT ALL ON TABLE mailaddr TO amavisd;


--
-- Name: mailaddr_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE mailaddr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE mailaddr_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE mailaddr_id_seq TO pgsql;
GRANT ALL ON SEQUENCE mailaddr_id_seq TO amavisd;


--
-- Name: mynetworks; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE mynetworks FROM PUBLIC;
REVOKE ALL ON TABLE mynetworks FROM pgsql;
GRANT ALL ON TABLE mynetworks TO pgsql;
GRANT ALL ON TABLE mynetworks TO amavisd;


--
-- Name: mynetworks_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE mynetworks_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE mynetworks_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE mynetworks_id_seq TO pgsql;
GRANT ALL ON SEQUENCE mynetworks_id_seq TO amavisd;


--
-- Name: netip; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE netip FROM PUBLIC;
REVOKE ALL ON TABLE netip FROM pgsql;
GRANT ALL ON TABLE netip TO pgsql;
GRANT ALL ON TABLE netip TO amavisd;


--
-- Name: netip_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE netip_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE netip_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE netip_id_seq TO pgsql;
GRANT ALL ON SEQUENCE netip_id_seq TO amavisd;


--
-- Name: permissions; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE permissions FROM PUBLIC;
REVOKE ALL ON TABLE permissions FROM pgsql;
GRANT ALL ON TABLE permissions TO pgsql;
GRANT ALL ON TABLE permissions TO amavisd;


--
-- Name: permissions_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE permissions_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE permissions_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE permissions_id_seq TO pgsql;
GRANT ALL ON SEQUENCE permissions_id_seq TO amavisd;


--
-- Name: policy; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE policy FROM PUBLIC;
REVOKE ALL ON TABLE policy FROM pgsql;
GRANT ALL ON TABLE policy TO pgsql;
GRANT ALL ON TABLE policy TO amavisd;


--
-- Name: policy_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE policy_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE policy_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE policy_id_seq TO pgsql;
GRANT ALL ON SEQUENCE policy_id_seq TO amavisd;


--
-- Name: rbls; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE rbls FROM PUBLIC;
REVOKE ALL ON TABLE rbls FROM pgsql;
GRANT ALL ON TABLE rbls TO pgsql;
GRANT ALL ON TABLE rbls TO amavisd;


--
-- Name: rbls_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE rbls_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rbls_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE rbls_id_seq TO pgsql;
GRANT ALL ON SEQUENCE rbls_id_seq TO amavisd;


--
-- Name: realm_admins; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE realm_admins FROM PUBLIC;
REVOKE ALL ON TABLE realm_admins FROM pgsql;
GRANT ALL ON TABLE realm_admins TO pgsql;
GRANT ALL ON TABLE realm_admins TO amavisd;


--
-- Name: realms; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE realms FROM PUBLIC;
REVOKE ALL ON TABLE realms FROM pgsql;
GRANT ALL ON TABLE realms TO pgsql;
GRANT ALL ON TABLE realms TO amavisd;


--
-- Name: realms_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE realms_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE realms_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE realms_id_seq TO pgsql;
GRANT ALL ON SEQUENCE realms_id_seq TO amavisd;


--
-- Name: recipients; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE recipients FROM PUBLIC;
REVOKE ALL ON TABLE recipients FROM pgsql;
GRANT ALL ON TABLE recipients TO pgsql;
GRANT ALL ON TABLE recipients TO amavisd;


--
-- Name: reports; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE reports FROM PUBLIC;
REVOKE ALL ON TABLE reports FROM pgsql;
GRANT ALL ON TABLE reports TO pgsql;
GRANT ALL ON TABLE reports TO amavisd;


--
-- Name: reports_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE reports_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE reports_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE reports_id_seq TO pgsql;
GRANT ALL ON SEQUENCE reports_id_seq TO amavisd;


--
-- Name: role_perms; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE role_perms FROM PUBLIC;
REVOKE ALL ON TABLE role_perms FROM pgsql;
GRANT ALL ON TABLE role_perms TO pgsql;
GRANT ALL ON TABLE role_perms TO amavisd;


--
-- Name: roles; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE roles FROM PUBLIC;
REVOKE ALL ON TABLE roles FROM pgsql;
GRANT ALL ON TABLE roles TO pgsql;
GRANT ALL ON TABLE roles TO amavisd;


--
-- Name: roles_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE roles_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE roles_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE roles_id_seq TO pgsql;
GRANT ALL ON SEQUENCE roles_id_seq TO amavisd;


--
-- Name: rulesets; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE rulesets FROM PUBLIC;
REVOKE ALL ON TABLE rulesets FROM pgsql;
GRANT ALL ON TABLE rulesets TO pgsql;
GRANT ALL ON TABLE rulesets TO amavisd;


--
-- Name: rulesets_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE rulesets_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rulesets_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE rulesets_id_seq TO pgsql;
GRANT ALL ON SEQUENCE rulesets_id_seq TO amavisd;


--
-- Name: saslauth; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE saslauth FROM PUBLIC;
REVOKE ALL ON TABLE saslauth FROM pgsql;
GRANT ALL ON TABLE saslauth TO pgsql;
GRANT ALL ON TABLE saslauth TO amavisd;


--
-- Name: scrubber_config; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE scrubber_config FROM PUBLIC;
REVOKE ALL ON TABLE scrubber_config FROM pgsql;
GRANT ALL ON TABLE scrubber_config TO pgsql;
GRANT ALL ON TABLE scrubber_config TO amavisd;


--
-- Name: scrubber_config_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE scrubber_config_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE scrubber_config_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE scrubber_config_id_seq TO pgsql;
GRANT ALL ON SEQUENCE scrubber_config_id_seq TO amavisd;


--
-- Name: sender_transport; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE sender_transport FROM PUBLIC;
REVOKE ALL ON TABLE sender_transport FROM pgsql;
GRANT ALL ON TABLE sender_transport TO pgsql;
GRANT ALL ON TABLE sender_transport TO amavisd;


--
-- Name: sender_transport_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE sender_transport_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE sender_transport_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE sender_transport_id_seq TO pgsql;
GRANT ALL ON SEQUENCE sender_transport_id_seq TO amavisd;


--
-- Name: smarthosts; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE smarthosts FROM PUBLIC;
REVOKE ALL ON TABLE smarthosts FROM pgsql;
GRANT ALL ON TABLE smarthosts TO pgsql;
GRANT ALL ON TABLE smarthosts TO amavisd;


--
-- Name: smarthosts_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE smarthosts_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE smarthosts_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE smarthosts_id_seq TO pgsql;
GRANT ALL ON SEQUENCE smarthosts_id_seq TO amavisd;


--
-- Name: spamstats; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE spamstats FROM PUBLIC;
REVOKE ALL ON TABLE spamstats FROM pgsql;
GRANT ALL ON TABLE spamstats TO pgsql;
GRANT ALL ON TABLE spamstats TO amavisd;


--
-- Name: spamstats_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE spamstats_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE spamstats_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE spamstats_id_seq TO pgsql;
GRANT ALL ON SEQUENCE spamstats_id_seq TO amavisd;


--
-- Name: staticroutes; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE staticroutes FROM PUBLIC;
REVOKE ALL ON TABLE staticroutes FROM pgsql;
GRANT ALL ON TABLE staticroutes TO pgsql;
GRANT ALL ON TABLE staticroutes TO amavisd;


--
-- Name: staticroutes_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE staticroutes_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE staticroutes_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE staticroutes_id_seq TO pgsql;
GRANT ALL ON SEQUENCE staticroutes_id_seq TO amavisd;


--
-- Name: stats; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE stats FROM PUBLIC;
REVOKE ALL ON TABLE stats FROM pgsql;
GRANT ALL ON TABLE stats TO pgsql;
GRANT ALL ON TABLE stats TO amavisd;


--
-- Name: stats_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE stats_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE stats_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE stats_id_seq TO pgsql;
GRANT ALL ON SEQUENCE stats_id_seq TO amavisd;


--
-- Name: tls; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE tls FROM PUBLIC;
REVOKE ALL ON TABLE tls FROM pgsql;
GRANT ALL ON TABLE tls TO pgsql;
GRANT ALL ON TABLE tls TO amavisd;


--
-- Name: tls_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE tls_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tls_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE tls_id_seq TO pgsql;
GRANT ALL ON SEQUENCE tls_id_seq TO amavisd;


--
-- Name: transport; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE transport FROM PUBLIC;
REVOKE ALL ON TABLE transport FROM pgsql;
GRANT ALL ON TABLE transport TO pgsql;
GRANT ALL ON TABLE transport TO amavisd;


--
-- Name: transport_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE transport_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE transport_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE transport_id_seq TO pgsql;
GRANT ALL ON SEQUENCE transport_id_seq TO amavisd;


--
-- Name: user_roles; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE user_roles FROM PUBLIC;
REVOKE ALL ON TABLE user_roles FROM pgsql;
GRANT ALL ON TABLE user_roles TO pgsql;
GRANT ALL ON TABLE user_roles TO amavisd;


--
-- Name: userrules; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE userrules FROM PUBLIC;
REVOKE ALL ON TABLE userrules FROM pgsql;
GRANT ALL ON TABLE userrules TO pgsql;
GRANT ALL ON TABLE userrules TO amavisd;


--
-- Name: userrules_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE userrules_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE userrules_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE userrules_id_seq TO pgsql;
GRANT ALL ON SEQUENCE userrules_id_seq TO amavisd;


--
-- Name: users; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE users FROM PUBLIC;
REVOKE ALL ON TABLE users FROM pgsql;
GRANT ALL ON TABLE users TO pgsql;
GRANT ALL ON TABLE users TO amavisd;


--
-- Name: users_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE users_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE users_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE users_id_seq TO pgsql;
GRANT ALL ON SEQUENCE users_id_seq TO amavisd;


--
-- Name: virus_scanners; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE virus_scanners FROM PUBLIC;
REVOKE ALL ON TABLE virus_scanners FROM pgsql;
GRANT ALL ON TABLE virus_scanners TO pgsql;
GRANT ALL ON TABLE virus_scanners TO amavisd;


--
-- Name: viruses; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE viruses FROM PUBLIC;
REVOKE ALL ON TABLE viruses FROM pgsql;
GRANT ALL ON TABLE viruses TO pgsql;
GRANT ALL ON TABLE viruses TO amavisd;


--
-- Name: viruses_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE viruses_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE viruses_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE viruses_id_seq TO pgsql;
GRANT ALL ON SEQUENCE viruses_id_seq TO amavisd;


--
-- Name: wblist; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON TABLE wblist FROM PUBLIC;
REVOKE ALL ON TABLE wblist FROM pgsql;
GRANT ALL ON TABLE wblist TO pgsql;
GRANT ALL ON TABLE wblist TO amavisd;


--
-- Name: wblist_id_seq; Type: ACL; Schema: public; Owner: pgsql
--

REVOKE ALL ON SEQUENCE wblist_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE wblist_id_seq FROM pgsql;
GRANT ALL ON SEQUENCE wblist_id_seq TO pgsql;
GRANT ALL ON SEQUENCE wblist_id_seq TO amavisd;


--
-- PostgreSQL database dump complete
--

TRUNCATE ippool_members;
