# $Id: amavisd.prolog 8965 2014-02-07 17:28:25Z sean $
#
# This file is automatically maintained by SpamTitan
#
# DO NOT MODIFY THIS FILE BY HAND.
#
use strict;

$MYHOME = '/var/amavis';
$TEMPBASE = "$MYHOME/tmp";

$daemon_user  = 'amavisd';
$daemon_group = 'amavisd';

$enable_db = 0;              # enable use of BerkeleyDB/libdb (SNMP and nanny)
$enable_global_cache = 0;    # enable use of libdb-based cache if $enable_db=1

$enable_dkim_verification = 1;  # enable DKIM signatures verification
$enable_dkim_signing = 0;    # load DKIM signing code, needs keys in dkim_key()

$allowed_added_header_fields{lc('Received')} = 0;

$log_level = 0;
#$log_templ = '[? %#V |[? %#F |[?%#D|Not-Delivered|Passed]|BANNED name/type (%F)]|INFECTED (%V) (%W)], #
#<%o> -> [<%R>|,][? %i ||, quarantine %i], Message-ID: %m, Hits: %c';
$DO_SYSLOG = 1;
$syslog_facility = 'mail';
$ENV{TMPDIR} = $TEMPBASE;
$QUARANTINEDIR = "$MYHOME/quarantine";

$inet_socket_port = [10018,10019,10020,10024,10026,10027,10028,10029,9998];
$interface_policy{'9998'} = 'AM.PDP';
$interface_policy{'10018'} = 'CF.REJECT';
$interface_policy{'10019'} = 'CF.DISCARD';
$interface_policy{'10020'} = 'CF.BYPASS';
$interface_policy{'10026'} = 'OUTBOUND';
$interface_policy{'10027'} = 'BYPASS';
$interface_policy{'10028'} = 'QUARANTINE.IN';
$interface_policy{'10029'} = 'QUARANTINE.OUT';
$policy_bank{'AM.PDP'} = { protocol => 'AM.PDP' };
$unix_socketname = "$MYHOME/amavisd.sock";

$sa_tag_level_deflt  = -999.0;
$sa_tag2_level_deflt = 5.0;
$sa_kill_level_deflt = 5.0;
$sa_timeout = 30;

$viruses_that_fake_sender_re = new_RE(
  qr'nimda|hybris|klez|bugbear|yaha|braid|sobig|fizzer|palyh|peido|holar'i,
  qr'tanatos|lentin|bridex|mimail|trojan\.dropper|dumaru|parite|spaces'i,
  qr'dloader|galil|gibe|swen|netwatch|bics|sbrowse|sober|rox|val(hal)?la'i,
  qr'frethem|sircam|be?agle|tanx|mydoom|novarg|shimg|netsky|somefool|moodown'i,
  qr'@mm|@MM',    # mass mailing viruses as labeled by f-prot and uvscan
  qr'Worm'i,      # worms as labeled by ClamAV, Kaspersky, etc
  [qr'^(EICAR|Joke\.|Junk\.)'i         => 0],
  [qr'^(WM97|OF97|W95/CIH-|JS/Fort)'i  => 0],
  [qr/.*/ => 1],  # true by default  (remove or comment-out if undesired)
);

# $mailfrom_to_quarantine = '';

$keep_decoded_original_re = new_RE(
  qr'^MAIL-UNDECIPHERABLE$',  # retain full mail if it contains undecipherables
  qr'^(ASCII(?! cpio)|text|uuencoded|xxencoded|binhex)'i,
);

read_hash(\%blacklist_sender, '/var/amavis/blacklist_sender');
read_hash(\%whitelist_sender, '/var/amavis/whitelist_sender');
read_hash(\%spam_lovers, '/var/amavis/spam_lovers');

$MAXLEVELS = 14;
$MAXFILES = 1500;
$MIN_EXPANSION_QUOTA =      100*1024;  # bytes  (default undef, not enforced)
$MAX_EXPANSION_QUOTA = 300*1024*1024;  # bytes  (default undef, not enforced)
$MIN_EXPANSION_FACTOR =   5;  # times original mail size  (must be specified)
$MAX_EXPANSION_FACTOR = 500;  # times original mail size  (must be specified)

$path = '/usr/local/sbin:/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin';
$file   = '/usr/local/bin/file';   # file(1) utility; use 3.41 or later to avoid vulnerability
$gzip   = 'gzip';
$bzip2  = 'bzip2';
$lzop   = 'lzop';
$uncompress = ['uncompress', 'gzip -d', 'zcat'];
$unfreeze   = ['unfreeze', 'freeze -d', 'melt', 'fcat'];
$arc        = ['nomarch', 'arc'];
$unarj      = ['arj', 'unarj'];  # both can extract, arj is recommended
$unrar      = ['rar', 'unrar'];  # both can extract, same options
$zoo    = 'zoo';
$lha    = 'lha';
$cpio   = ['gcpio','cpio'];
$pax    = 'pax';

$warnvirussender  = undef;
$warnspamsender   = undef;
$warnbannedsender = undef;
$warnbadhsender   = undef;

$banned_namepath_re = undef;  # disable the new one

$bounce_killer_score = 0;

